/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RepositoryRevision {
    private ISVNLogMessage message;
    private SVNUrl repositoryRootUrl;
    private final List<Event> events = new ArrayList<Event>(1);

    public RepositoryRevision(ISVNLogMessage iSVNLogMessage, SVNUrl sVNUrl) {
        this.message = iSVNLogMessage;
        this.repositoryRootUrl = sVNUrl;
        this.initEvents();
    }

    public SVNUrl getRepositoryRootUrl() {
        return this.repositoryRootUrl;
    }

    private void initEvents() {
        ISVNLogMessageChangePath[] iSVNLogMessageChangePathArray = this.message.getChangedPaths();
        if (iSVNLogMessageChangePathArray == null) {
            return;
        }
        for (ISVNLogMessageChangePath iSVNLogMessageChangePath : iSVNLogMessageChangePathArray) {
            this.events.add(new Event(iSVNLogMessageChangePath));
        }
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public ISVNLogMessage getLog() {
        return this.message;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getLog().getRevision().getNumber());
        stringBuffer.append("\t");
        stringBuffer.append(this.getLog().getDate());
        stringBuffer.append("\t");
        stringBuffer.append(this.getLog().getAuthor());
        stringBuffer.append("\n");
        stringBuffer.append(this.getLog().getMessage());
        return stringBuffer.toString();
    }

    public class Event {
        private File file;
        private ISVNLogMessageChangePath changedPath;
        private String name;
        private String path;

        public Event(ISVNLogMessageChangePath iSVNLogMessageChangePath) {
            this.changedPath = iSVNLogMessageChangePath;
            this.name = iSVNLogMessageChangePath.getPath().substring(iSVNLogMessageChangePath.getPath().lastIndexOf(47) + 1);
            this.path = iSVNLogMessageChangePath.getPath().substring(0, iSVNLogMessageChangePath.getPath().lastIndexOf(47));
        }

        public RepositoryRevision getLogInfoHeader() {
            return RepositoryRevision.this;
        }

        public ISVNLogMessageChangePath getChangedPath() {
            return this.changedPath;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\t");
            stringBuffer.append(this.getPath());
            return stringBuffer.toString();
        }
    }
}

