/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.cli.CommandNotificationListener;
import org.netbeans.modules.subversion.client.cli.CommandlineClient;
import org.netbeans.modules.subversion.client.cli.Parser;
import org.tigris.subversion.svnclientadapter.SVNBaseDir;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SvnCommand
implements CommandNotificationListener {
    private final List<String> cmdError = new ArrayList<String>(10);
    private Exception thrownException;
    private boolean hasFailed;
    private boolean commandExecuted;
    private Arguments arguments = new Arguments();
    private CommandlineClient.NotificationHandler notificationHandler;
    private File configDir;
    private String username;
    private String password;

    protected SvnCommand() {
    }

    public void setConfigDir(File file) {
        this.configDir = file;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    CommandlineClient.NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    void setNotificationHandler(CommandlineClient.NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    void prepareCommand() throws IOException {
        assert (this.notificationHandler != null);
        this.prepareCommand(this.arguments);
        this.config(this.configDir, this.username, this.password, this.arguments);
    }

    public abstract void prepareCommand(Arguments var1) throws IOException;

    protected abstract int getCommand();

    public void setCommandWorkingDirectory(File ... fileArray) {
        this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File[])fileArray));
    }

    protected boolean hasBinaryOutput() {
        return false;
    }

    protected boolean notifyOutput() {
        return true;
    }

    @Override
    public void commandStarted() {
        assert (!this.commandExecuted) : "Command re-use is not supported";
        this.commandExecuted = true;
        String string = SvnCommand.toString(this.arguments, true).toString();
        this.notificationHandler.logCommandLine(string);
    }

    @Override
    public void outputText(String string) {
        Subversion.LOG.fine("outputText [" + string + "]");
        if (!this.notifyOutput()) {
            return;
        }
        Parser.Line line = Parser.getInstance().parse(string);
        if (line != null) {
            if (this.notificationHandler != null && line.getPath() != null) {
                Subversion.LOG.fine("outputText [" + line.getPath() + "]");
                this.notificationHandler.notifyListenersOfChange(line.getPath());
            }
            this.notify(line);
            this.notificationHandler.logMessage(string);
        }
    }

    public void output(byte[] byArray) {
    }

    @Override
    public void errorText(String string) {
        this.cmdError.add(string);
        if (this.isErrorMessage(string)) {
            this.hasFailed = true;
        }
        this.notificationHandler.logError(string);
    }

    @Override
    public void commandFinished() {
        this.notificationHandler.logCompleted("");
    }

    public boolean hasFailed() {
        return this.hasFailed;
    }

    public List<String> getCmdError() {
        return this.cmdError;
    }

    public void setException(Exception exception) {
        this.thrownException = exception;
    }

    public Exception getThrownException() {
        return this.thrownException;
    }

    protected void notify(Parser.Line line) {
    }

    protected boolean isErrorMessage(String string) {
        return true;
    }

    public String getStringCommand() {
        return SvnCommand.toString(this.arguments, false).toString();
    }

    String[] getCliArguments(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(this.arguments.size() + 1);
        arrayList.add(string);
        for (String string2 : this.arguments.toArray()) {
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static StringBuilder toString(Arguments arguments, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(100);
        boolean bl2 = false;
        for (String string : arguments) {
            stringBuilder.append(bl2 && bl ? "******" : string);
            stringBuilder.append(' ');
            if (!bl) continue;
            bl2 = string.equals("--password");
        }
        stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        return stringBuilder;
    }

    protected static String createTempCommandFile(String string) throws IOException {
        return SvnCommand.createTempCommandFile(new String[]{string});
    }

    protected static String createTempCommandFile(File[] fileArray) throws IOException {
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = fileArray[i].getAbsolutePath();
        }
        return SvnCommand.createTempCommandFile(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String createTempCommandFile(String[] stringArray) throws IOException {
        String string = System.getProperty("java.io.tmpdir");
        File file = File.createTempFile("svn_", "", new File(string));
        file.deleteOnExit();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file)));
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.print(i < stringArray.length - 1 ? stringArray[i] + "\n" : stringArray[i]);
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
        return file.getAbsolutePath();
    }

    protected void config(File file, String string, String string2, Arguments arguments) {
        arguments.addConfigDir(file);
        arguments.add("--non-interactive");
        arguments.addCredentials(string, string2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Arguments
    implements Iterable<String> {
        private final List<String> args = new ArrayList<String>(5);

        public void add(String string) {
            this.args.add(string);
        }

        public void add(File ... fileArray) {
            for (File file : fileArray) {
                this.add(file.getAbsolutePath());
            }
        }

        public void add(File file) {
            this.add(file.getAbsolutePath());
        }

        public void add(SVNUrl sVNUrl) {
            if (sVNUrl != null) {
                this.add(sVNUrl.toString());
            }
        }

        public void add(SVNRevision sVNRevision, SVNRevision sVNRevision2) {
            this.add("-r");
            this.add((sVNRevision == null || sVNRevision.toString().trim().equals("") ? "HEAD" : sVNRevision.toString()) + ":" + (sVNRevision2 == null || sVNRevision2.toString().trim().equals("") ? "HEAD" : sVNRevision2.toString()));
        }

        public void add(SVNUrl sVNUrl, SVNRevision sVNRevision) {
            if (sVNUrl != null) {
                this.add(sVNUrl.toString() + "@" + (sVNRevision == null ? "HEAD" : sVNRevision));
            }
        }

        public void add(SVNRevision sVNRevision) {
            this.add("-r");
            this.add(sVNRevision == null || sVNRevision.toString().trim().equals("") ? "HEAD" : sVNRevision.toString());
        }

        public void addPathArguments(String ... stringArray) throws IOException {
            this.add("--targets");
            this.add(SvnCommand.createTempCommandFile(stringArray));
        }

        public void addFileArguments(File ... fileArray) throws IOException {
            this.add("--targets");
            this.add(SvnCommand.createTempCommandFile(fileArray));
        }

        public void addUrlArguments(SVNUrl ... sVNUrlArray) throws IOException {
            String[] stringArray = new String[sVNUrlArray.length];
            for (int i = 0; i < sVNUrlArray.length; ++i) {
                stringArray[i] = sVNUrlArray[i].toString();
            }
            this.add("--targets");
            this.add(SvnCommand.createTempCommandFile(stringArray));
        }

        public void addMessage(String string) throws IOException {
            if (string == null) {
                return;
            }
            this.add("--force-log");
            this.add("-F");
            String string2 = SvnCommand.createTempCommandFile(string != null ? string : "");
            this.add(string2);
        }

        public void addConfigDir(File file) {
            if (file != null) {
                SvnCommand.this.arguments.add("--config-dir");
                SvnCommand.this.arguments.add(file);
            }
        }

        public void addCredentials(String string, String string2) {
            if (string == null || string.trim().equals("")) {
                return;
            }
            this.add("--username");
            this.add(string);
            this.add("--password");
            this.add(string2);
        }

        @Override
        public Iterator<String> iterator() {
            return this.args.iterator();
        }

        String[] toArray() {
            return this.args.toArray(new String[this.args.size()]);
        }

        int size() {
            return this.args.size();
        }
    }
}

