/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.Utils;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilesystemHandler
extends VCSInterceptor {
    private final FileStatusCache cache;
    private Set<File> movedFiles = new HashSet<File>();
    private final Set<File> invalidMetadata = new HashSet<File>(5);

    public FilesystemHandler(Subversion subversion) {
        this.cache = subversion.getStatusCache();
    }

    public boolean beforeDelete(File file) {
        Subversion.LOG.fine("beforeDelete " + file);
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return true;
        }
        return this.hasMetadata(file.getParentFile());
    }

    public void doDelete(File file) throws IOException {
        Subversion.LOG.fine("doDelete " + file);
        if (!SvnUtils.isPartOfSubversionMetadata(file)) {
            try {
                SvnClient svnClient = Subversion.getInstance().getClient(false);
                svnClient.remove(new File[]{file}, true);
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                return;
            }
        }
    }

    public void afterDelete(File file) {
        Subversion.LOG.fine("afterDelete " + file);
        if (file == null) {
            return;
        }
        if (!SvnUtils.isPartOfSubversionMetadata(file)) {
            this.cache.refreshAsync(file);
        }
    }

    public boolean beforeMove(File file, File file2) {
        Subversion.LOG.fine("beforeMove " + file + " -> " + file2);
        File file3 = file2.getParentFile();
        if (file != null && file3 != null && this.isVersioned(file)) {
            return SvnUtils.isManaged(file2);
        }
        return false;
    }

    public void doMove(final File file, final File file2) throws IOException {
        Subversion.LOG.fine("doMove " + file + " -> " + file2);
        if (SwingUtilities.isEventDispatchThread()) {
            Subversion.LOG.log(Level.INFO, "Warning: launching external process in AWT", new Exception().fillInStackTrace());
            final Throwable[] throwableArray = new Throwable[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        FilesystemHandler.this.svnMoveImplementation(file, file2);
                    }
                    catch (Throwable throwable) {
                        throwableArray[0] = throwable;
                    }
                }
            };
            Subversion.getInstance().getRequestProcessor().post(runnable).waitFinished();
            if (throwableArray[0] != null) {
                if (throwableArray[0] instanceof IOException) {
                    throw (IOException)throwableArray[0];
                }
                if (throwableArray[0] instanceof RuntimeException) {
                    throw (RuntimeException)throwableArray[0];
                }
                if (throwableArray[0] instanceof Error) {
                    throw (Error)throwableArray[0];
                }
                throw new IllegalStateException("Unexpected exception class: " + throwableArray[0]);
            }
        } else {
            this.svnMoveImplementation(file, file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterMove(File file, File file2) {
        File[] fileArray;
        Subversion.LOG.fine("afterMove " + file + " -> " + file2);
        Object object = this.movedFiles;
        synchronized (object) {
            this.movedFiles.add(file);
            fileArray = this.movedFiles.toArray(new File[this.movedFiles.size()]);
            this.movedFiles.clear();
        }
        this.cache.refreshAsync(true, file2);
        this.cache.refreshAsync(fileArray);
        object = file2.getParentFile();
        if (object != null && file.equals(file2)) {
            Subversion.LOG.warning("Wrong (identity) rename event for " + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeCreate(File file, boolean bl) {
        Subversion.LOG.fine("beforeCreate " + file);
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            Set<File> set = this.invalidMetadata;
            synchronized (set) {
                File file2 = file;
                while (!SvnUtils.isAdministrative(file2.getName())) {
                    file2 = file2.getParentFile();
                    assert (file2 != null) : "file " + file + " doesn't have a .svn parent";
                }
                this.invalidMetadata.add(file2);
            }
            return false;
        }
        if (!file.exists()) {
            try {
                SvnClient svnClient = Subversion.getInstance().getClient(false);
                this.revertDeleted(svnClient, file, true);
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            }
        }
        return false;
    }

    public void doCreate(File file, boolean bl) throws IOException {
    }

    public void afterCreate(final File file) {
        Subversion.LOG.fine("afterCreate " + file);
        Utils.post((Runnable)new Runnable(){

            public void run() {
                if (file == null) {
                    return;
                }
                int n = FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN).getStatus();
                if ((n & 0xFFFFFFFE) == 0) {
                    return;
                }
                if (file.isDirectory()) {
                    FilesystemHandler.this.cache.directoryContentChanged(file);
                }
            }
        });
    }

    public void afterChange(final File file) {
        Subversion.LOG.fine("afterChange " + file);
        Utils.post((Runnable)new Runnable(){

            public void run() {
                if ((FilesystemHandler.this.cache.getStatus(file).getStatus() & 0xFFFFFFFE) != 0) {
                    FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInvalidMetadata() {
        Set<File> set = this.invalidMetadata;
        synchronized (set) {
            for (File file : this.invalidMetadata) {
                Utils.deleteRecursively((File)file);
            }
            this.invalidMetadata.clear();
        }
    }

    private boolean hasMetadata(File file) {
        return new File(file, SvnUtils.SVN_ENTRIES_DIR).canRead();
    }

    private boolean isVersioned(File file) {
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return false;
        }
        return !file.isFile() && this.hasMetadata(file) || file.isFile() && this.hasMetadata(file.getParentFile());
    }

    private static List<File> getDeletedParents(File file, SvnClient svnClient) throws SVNClientException {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
            ISVNStatus iSVNStatus = FilesystemHandler.getStatus(svnClient, file2);
            if (iSVNStatus == null || !iSVNStatus.getTextStatus().equals((Object)SVNStatusKind.DELETED)) {
                return arrayList;
            }
            arrayList.add(file2);
        }
        return arrayList;
    }

    private void revertDeleted(SvnClient svnClient, File file, boolean bl) {
        try {
            ISVNStatus iSVNStatus = FilesystemHandler.getStatus(svnClient, file);
            if (this.equals(iSVNStatus, SVNStatusKind.DELETED)) {
                if (bl) {
                    List<File> list = FilesystemHandler.getDeletedParents(file, svnClient);
                    for (File file2 : list) {
                        svnClient.revert(file2, false);
                    }
                }
                svnClient.revert(file, false);
                file.delete();
            }
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void svnMoveImplementation(File file, File file2) throws IOException {
        try {
            boolean bl = true;
            SvnClient svnClient = Subversion.getInstance().getClient(false);
            File file3 = null;
            try {
                this.removeInvalidMetadata();
                File file4 = file2.isDirectory() ? file2 : file2.getParentFile();
                if (file4 != null) {
                    assert (SvnUtils.isManaged(file4));
                    if (!this.hasMetadata(file4)) {
                        this.addDirectories(file4);
                    }
                }
                int n = 6;
                while (true) {
                    try {
                        this.revertDeleted(svnClient, file2, false);
                        ISVNStatus iSVNStatus = FilesystemHandler.getStatus(svnClient, file);
                        List<File> list = null;
                        try {
                            list = SvnUtils.listRecursively(file);
                            if (iSVNStatus != null && iSVNStatus.getTextStatus().equals((Object)SVNStatusKind.ADDED)) {
                                svnClient.revert(file, true);
                                file.renameTo(file2);
                            } else if (iSVNStatus != null && iSVNStatus.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) {
                                file.renameTo(file2);
                            } else {
                                svnClient.move(file, file2, bl);
                            }
                        }
                        finally {
                            Set<File> set = this.movedFiles;
                            synchronized (set) {
                                if (list != null) {
                                    this.movedFiles.addAll(list);
                                }
                            }
                        }
                    }
                    catch (SVNClientException sVNClientException) {
                        if (sVNClientException.getMessage().endsWith("' locked") && n > 0) {
                            try {
                                Thread.sleep(107L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            --n;
                            continue;
                        }
                        IOException iOException = new IOException("Subversion failed to rename " + file.getAbsolutePath() + " to: " + file2.getAbsolutePath());
                        iOException.initCause(sVNClientException);
                        throw iOException;
                    }
                    break;
                }
            }
            finally {
                if (file3 != null) {
                    FileUtils.deleteRecursively(file3);
                }
            }
        }
        catch (SVNClientException sVNClientException) {
            IOException iOException = new IOException("Subversion failed to rename " + file.getAbsolutePath() + " to: " + file2.getAbsolutePath());
            iOException.initCause(sVNClientException);
            throw iOException;
        }
    }

    private boolean addDirectories(File file) throws SVNClientException {
        File file2 = file.getParentFile();
        SvnClient svnClient = Subversion.getInstance().getClient(false);
        if (file2 != null) {
            ISVNStatus iSVNStatus = FilesystemHandler.getStatus(svnClient, file2);
            if (iSVNStatus.getTextStatus().equals((Object)SVNStatusKind.IGNORED)) {
                return false;
            }
            if (SvnUtils.isManaged(file2) && !this.hasMetadata(file2) && !this.addDirectories(file2)) {
                return false;
            }
            svnClient.addDirectory(file, false);
            this.cache.refreshAsync(file);
            return true;
        }
        throw new SVNClientException("Reached FS root, but it's still not Subversion versioned!");
    }

    private static ISVNStatus getStatus(SvnClient svnClient, File file) throws SVNClientException {
        return svnClient.getSingleStatus(file);
    }

    private boolean equals(ISVNStatus iSVNStatus, SVNStatusKind sVNStatusKind) {
        return iSVNStatus != null && iSVNStatus.getTextStatus().equals((Object)sVNStatusKind);
    }
}

