/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ui.NewProjectWizard;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class NewProject
extends BasicAction {
    private static final Icon ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/newProject.png"));
    private static final String NAME = NbBundle.getMessage(NewProject.class, (String)"LBL_NewProjectAction_Name");
    private static final String _SHORT_DESCRIPTION = NbBundle.getMessage(NewProject.class, (String)"LBL_NewProjectAction_Tooltip");
    private boolean isPreselect = false;
    private RequestProcessor.Task bodyTask;

    public NewProject() {
        super(NAME, ICON);
        this.putValue("iconBase", "org/netbeans/modules/project/ui/resources/newProject.png");
        this.putValue("ShortDescription", _SHORT_DESCRIPTION);
        this.bodyTask = new RequestProcessor("NewProjectBody").create(new Runnable(){

            public void run() {
                NewProject.this.doPerform();
            }
        });
    }

    public static NewProject newSample() {
        NewProject newProject = new NewProject();
        newProject.setDisplayName("New Sample");
        newProject.isPreselect = true;
        return newProject;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.bodyTask.schedule(0);
        if ("waitFinished".equals(actionEvent.getActionCommand())) {
            this.bodyTask.waitFinished();
        }
    }

    NewProjectWizard prepareWizardDescriptor(FileObject fileObject) {
        NewProjectWizard newProjectWizard = new NewProjectWizard(fileObject);
        if (this.isPreselect) {
            newProjectWizard.putProperty("PRESELECT_CATEGORY", this.getValue("PRESELECT_CATEGORY"));
            newProjectWizard.putProperty("PRESELECT_TEMPLATE", this.getValue("PRESELECT_TEMPLATE"));
        } else {
            newProjectWizard.putProperty("PRESELECT_CATEGORY", null);
            newProjectWizard.putProperty("PRESELECT_TEMPLATE", null);
        }
        FileObject fileObject2 = (FileObject)this.getValue("existingSourcesFolder");
        if (fileObject2 != null) {
            newProjectWizard.putProperty("existingSourcesFolder", fileObject2);
        }
        return newProjectWizard;
    }

    private void doPerform() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Project");
        final NewProjectWizard newProjectWizard = this.prepareWizardDescriptor(fileObject);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Object object;
                    Set set = newProjectWizard.instantiate();
                    Preferences preferences = NbPreferences.forModule(OpenProjectListSettings.class);
                    String string = preferences.get("createdProjectsFolderInWizard", null);
                    preferences.remove("createdProjectsFolderInWizard");
                    if (string != null && ((File)(object = new File(string))).exists() && ((File)object).isDirectory() && ((File)object).listFiles() != null && ((File)object).listFiles().length == 0) {
                        ((File)object).delete();
                    }
                    object = newProjectWizard.getProperty("setAsMain");
                    boolean bl = true;
                    if (object instanceof Boolean) {
                        bl = (Boolean)object;
                    }
                    boolean bl2 = bl;
                    ProjectManager.getDefault().clearNonProjectCache();
                    ProjectUtilities.WaitCursor.show();
                    if (set != null && !set.isEmpty()) {
                        Object object2;
                        Object object32;
                        LinkedList<DataObject> linkedList = new LinkedList<DataObject>();
                        LinkedList<Project> linkedList2 = new LinkedList<Project>();
                        for (Object object32 : set) {
                            DataObject dataObject;
                            block19: {
                                if (object32 instanceof DataObject) {
                                    dataObject = (DataObject)object32;
                                    object2 = dataObject.getPrimaryFile();
                                } else {
                                    if (object32 instanceof FileObject) {
                                        object2 = (FileObject)object32;
                                        try {
                                            dataObject = DataObject.find((FileObject)object2);
                                            break block19;
                                        }
                                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                                            ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
                                            continue;
                                        }
                                    }
                                    ErrorManager.getDefault().log(16, "Found unrecognized object " + object32 + " in result set from instantiate()");
                                    continue;
                                }
                            }
                            if (object2.isFolder()) {
                                try {
                                    Project project = ProjectManager.getDefault().findProject((FileObject)object2);
                                    if (project != null) {
                                        linkedList2.add(project);
                                        continue;
                                    }
                                    linkedList.add(dataObject);
                                }
                                catch (IOException iOException) {
                                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                                }
                                continue;
                            }
                            linkedList.add(dataObject);
                        }
                        Iterator iterator = linkedList2.size() > 0 ? (Project)linkedList2.get(0) : null;
                        object32 = null;
                        if (bl2 && iterator != null) {
                            object32 = iterator;
                        }
                        OpenProjectList.getDefault().open(linkedList2.toArray(new Project[0]), false, true, (Project)object32);
                        if (!Boolean.getBoolean("project.tab.no.selection")) {
                            ProjectUtilities.makeProjectTabVisible(true);
                        }
                        if (iterator != null) {
                            ProjectUtilities.selectAndExpandProject(iterator);
                        }
                        object2 = linkedList.iterator();
                        while (object2.hasNext()) {
                            ProjectUtilities.openAndSelectNewObject((DataObject)object2.next());
                        }
                    }
                    ProjectUtilities.WaitCursor.hide();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        });
    }
}

