/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.ListView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class TemplatesPanelGUI
extends JPanel
implements PropertyChangeListener {
    public static final String TEMPLATES_FOLDER = "templatesFolder";
    public static final String TARGET_TEMPLATE = "targetTemplate";
    private static final String ATTR_INSTANTIATING_DESC = "instantiatingWizardURL";
    private static final Image PLEASE_WAIT_ICON = Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/wait.gif");
    private Builder firer;
    private static final RequestProcessor RP = new RequestProcessor();
    private String presetTemplateName = null;
    private Node pleaseWait;
    private JPanel categoriesPanel;
    private JEditorPane description;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JPanel projectsPanel;

    public TemplatesPanelGUI(Builder builder) {
        assert (builder != null) : "Builder can not be null";
        this.firer = builder;
        this.initComponents();
        this.postInitComponents();
        this.setName(NbBundle.getMessage(TemplatesPanelGUI.class, (String)"TXT_SelectTemplate"));
    }

    public void setTemplatesFolder(FileObject fileObject) {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        ((ExplorerProviderPanel)this.categoriesPanel).setRootNode((Node)new FilterNode(dataFolder.getNodeDelegate(), this.firer.createCategoriesChildren(dataFolder)));
    }

    public void setSelectedCategoryByName(String string) {
        if (string != null) {
            try {
                ((ExplorerProviderPanel)this.categoriesPanel).setSelectedNode(string);
            }
            catch (NodeNotFoundException nodeNotFoundException) {
                ((CategoriesPanel)this.categoriesPanel).selectFirstCategory();
            }
        } else {
            ((CategoriesPanel)this.categoriesPanel).selectFirstCategory();
        }
    }

    public String getSelectedCategoryName() {
        return ((ExplorerProviderPanel)this.categoriesPanel).getSelectionPath();
    }

    public void setSelectedTemplateByName(final String string) {
        this.presetTemplateName = string;
        final TemplatesPanel templatesPanel = (TemplatesPanel)this.projectsPanel;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (string != null) {
                    try {
                        templatesPanel.setSelectedNode(string);
                    }
                    catch (NodeNotFoundException nodeNotFoundException) {
                        // empty catch block
                    }
                    if (templatesPanel.getSelectionPath() == null) {
                        TemplatesPanelGUI.this.presetTemplateName = null;
                        templatesPanel.selectFirstTemplate();
                    }
                } else {
                    templatesPanel.selectFirstTemplate();
                }
            }
        });
    }

    public String getSelectedTemplateName() {
        return ((TemplatesPanel)this.projectsPanel).getSelectionPath();
    }

    public FileObject getSelectedTemplate() {
        DataObject dataObject;
        Node[] nodeArray = ((ExplorerProviderPanel)this.projectsPanel).getSelectedNodes();
        if (nodeArray != null && nodeArray.length == 1 && (dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class)) != null) {
            while (dataObject instanceof DataShadow) {
                dataObject = ((DataShadow)dataObject).getOriginal();
            }
            return dataObject.getPrimaryFile();
        }
        return null;
    }

    public void addNotify() {
        super.addNotify();
        this.jScrollPane1.setViewportView(this.description);
        this.jLabel3.setLabelFor(this.description);
    }

    public void removeNotify() {
        super.removeNotify();
        this.jScrollPane1.setViewportView(null);
        this.jLabel3.setLabelFor(null);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.categoriesPanel) {
            Node[] nodeArray;
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = (Node[])propertyChangeEvent.getNewValue()) != null && nodeArray.length == 1) {
                assert (this.pleaseWait == null || !this.pleaseWait.equals((Object)nodeArray[0])) : "Cannot be fired a propertyChange with PleaseWaitNode, but was " + nodeArray[0];
                try {
                    ((ExplorerProviderPanel)this.projectsPanel).setSelectedNodes(new Node[0]);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                DataObject dataObject = (DataObject)nodeArray[0].getCookie(DataFolder.class);
                if (dataObject != null) {
                    FileObject fileObject = dataObject.getPrimaryFile();
                    ((ExplorerProviderPanel)this.projectsPanel).setRootNode((Node)new FilterNode(nodeArray[0], this.firer.createTemplatesChildren((DataFolder)dataObject)));
                    this.setSelectedTemplateByName(this.presetTemplateName);
                }
            }
        } else if (propertyChangeEvent.getSource() == this.projectsPanel && "selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            if (nodeArray != null && nodeArray.length == 1) {
                DataObject dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
                if (dataObject != null) {
                    FileObject fileObject = dataObject.getPrimaryFile();
                    URL uRL = this.getDescription(dataObject);
                    if (uRL != null) {
                        try {
                            String string = TemplatesPanelGUI.findEncodingFromURL(uRL.openStream());
                            ErrorManager.getDefault().log(1, "Url " + uRL + " has charset " + string);
                            if (string != null) {
                                this.description.putClientProperty("charset", string);
                            }
                            this.description.read(uRL.openStream(), (Object)uRL);
                        }
                        catch (ChangedCharSetException changedCharSetException) {
                            Document document = this.description.getEditorKit().createDefaultDocument();
                            document.putProperty("IgnoreCharsetDirective", true);
                            try {
                                this.description.read(uRL.openStream(), (Object)document);
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                                this.description.setText(NbBundle.getBundle(TemplatesPanelGUI.class).getString("TXT_NoDescription"));
                            }
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                            this.description.setText(NbBundle.getBundle(TemplatesPanelGUI.class).getString("TXT_NoDescription"));
                        }
                    } else {
                        this.description.setText(NbBundle.getBundle(TemplatesPanelGUI.class).getString("TXT_NoDescription"));
                    }
                }
            } else {
                this.description.setText(NbBundle.getBundle(TemplatesPanelGUI.class).getString("TXT_NoDescription"));
            }
            this.firer.fireChange();
        }
    }

    private void postInitComponents() {
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)this.firer.getCategoriesName());
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)this.firer.getTemplatesName());
        this.description.setEditorKit(new HTMLEditorKit());
        this.pleaseWait = new AbstractNode(Children.LEAF){

            public Image getIcon(int n) {
                return PLEASE_WAIT_ICON;
            }
        };
        this.pleaseWait.setName(NbBundle.getBundle(TemplatesPanelGUI.class).getString("LBL_TemplatesPanel_PleaseWait"));
        Children.Array array = new Children.Array();
        array.add(new Node[]{this.pleaseWait});
        AbstractNode abstractNode = new AbstractNode((Children)array);
        SwingUtilities.invokeLater(new Runnable((Node)abstractNode){
            final /* synthetic */ Node val$root;
            {
                this.val$root = node;
            }

            public void run() {
                ((ExplorerProviderPanel)TemplatesPanelGUI.this.categoriesPanel).setRootNode(this.val$root);
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.categoriesPanel = new CategoriesPanel();
        this.projectsPanel = new TemplatesPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.description = new JEditorPane();
        this.setPreferredSize(new Dimension(500, 230));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.categoriesPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(TemplatesPanelGUI.class).getString("CTL_Categories"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.projectsPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getBundle(TemplatesPanelGUI.class).getString("CTL_Templates"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.insets = new Insets(2, 0, 6, 6);
        this.add((Component)this.categoriesPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.insets = new Insets(2, 6, 6, 0);
        this.add((Component)this.projectsPanel, gridBagConstraints);
        this.jLabel3.setLabelFor(this.description);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getBundle(TemplatesPanelGUI.class).getString("CTL_Description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.description.setEditable(false);
        this.description.setText(NbBundle.getBundle(TemplatesPanelGUI.class).getString("TXT_NoDescription"));
        this.description.setPreferredSize(new Dimension(100, 66));
        this.jScrollPane1.setViewportView(this.description);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private URL getDescription(DataObject dataObject) {
        FileObject fileObject = dataObject.getPrimaryFile();
        URL uRL = (URL)fileObject.getAttribute(ATTR_INSTANTIATING_DESC);
        if (uRL != null) {
            return uRL;
        }
        uRL = TemplateWizard.getDescription((DataObject)dataObject);
        return uRL;
    }

    void warmUp(FileObject fileObject) {
        DataFolder dataFolder;
        if (fileObject != null && (dataFolder = DataFolder.findFolder((FileObject)fileObject)) != null) {
            dataFolder.getChildren();
        }
    }

    void doFinished(FileObject fileObject, String string, String string2) {
        assert (fileObject != null);
        this.categoriesPanel.addPropertyChangeListener(this);
        this.projectsPanel.addPropertyChangeListener(this);
        this.setTemplatesFolder(fileObject);
        this.setSelectedCategoryByName(string);
        this.setSelectedTemplateByName(string2);
        this.categoriesPanel.requestFocus();
        if (this.description.getEditorKit() instanceof HTMLEditorKit) {
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.description.getEditorKit();
            StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
            if (styleSheet.getStyleSheets() != null) {
                return;
            }
            StyleSheet styleSheet2 = new StyleSheet();
            Font font = this.jLabel1.getFont();
            styleSheet2.addRule(new StringBuffer("body { font-size: ").append(font.getSize()).append("; font-family: ").append(font.getName()).append("; }").toString());
            styleSheet2.addStyleSheet(styleSheet);
            hTMLEditorKit.setStyleSheet(styleSheet2);
        }
    }

    private static String findEncodingFromURL(InputStream inputStream) {
        try {
            byte[] byArray = new byte[4096];
            int n = inputStream.read(byArray, 0, byArray.length);
            String string = new String(byArray, 0, n >= 0 ? n : 0).toUpperCase();
            return TemplatesPanelGUI.findEncoding(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String findEncoding(String string) {
        int n;
        int n2 = string.indexOf("</HEAD>");
        if (n2 == -1) {
            n2 = string.length();
        }
        if ((n = string.indexOf("CONTENT-TYPE")) == -1 || n > n2) {
            return null;
        }
        int n3 = string.indexOf("CHARSET=", n);
        if (n3 == -1) {
            return null;
        }
        int n4 = string.indexOf(34, n3);
        int n5 = string.indexOf(39, n3);
        if (n4 == -1 && n5 == -1) {
            return null;
        }
        if (n5 != -1 && (n4 == -1 || n4 > n5)) {
            n4 = n5;
        }
        return string.substring(n3 + "CHARSET=".length(), n4);
    }

    private static final class TemplatesPanel
    extends ExplorerProviderPanel {
        private ListView list;

        private TemplatesPanel() {
        }

        protected synchronized JComponent createComponent() {
            if (this.list == null) {
                this.list = new TemplatesListView();
                this.list.setPopupAllowed(false);
                this.list.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TemplatesPanelGUI.class, (String)"ACSN_TemplatesPanel"));
                this.list.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanelGUI.class, (String)"ACSD_TemplatesPanel"));
                Border border = (Border)UIManager.get("Nb.ScrollPane.border");
                if (border != null) {
                    this.list.setBorder(border);
                }
            }
            return this.list;
        }

        public void selectFirstTemplate() {
            try {
                Children children = this.getExplorerManager().getRootContext().getChildren();
                if (children.getNodesCount() > 0) {
                    this.getExplorerManager().setSelectedNodes(new Node[]{children.getNodes()[0]});
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private static class TemplatesListView
    extends ListView
    implements ActionListener {
        public TemplatesListView() {
            this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
            this.getAccessibleContext().setAccessibleName("OUTER LIST");
            this.getAccessibleContext().setAccessibleDescription("DESC OUTER LIST");
            this.setDefaultProcessor(this);
            ToolTipManager.sharedInstance().unregisterComponent(this.list);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private static final class CategoriesPanel
    extends ExplorerProviderPanel {
        private CategoriesBeanTreeView btv;

        private CategoriesPanel() {
        }

        protected synchronized JComponent createComponent() {
            if (this.btv == null) {
                this.btv = new CategoriesBeanTreeView();
                this.btv.setRootVisible(false);
                this.btv.setPopupAllowed(false);
                this.btv.setFocusable(false);
                this.btv.setDefaultActionAllowed(false);
                this.btv.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TemplatesPanelGUI.class, (String)"ACSN_CategoriesPanel"));
                this.btv.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanelGUI.class, (String)"ACSD_CategoriesPanel"));
                Border border = (Border)UIManager.get("Nb.ScrollPane.border");
                if (border != null) {
                    this.btv.setBorder(border);
                }
            }
            return this.btv;
        }

        public void selectFirstCategory() {
            this.btv.selectFirstCategory();
        }
    }

    private static class CategoriesBeanTreeView
    extends BeanTreeView {
        public CategoriesBeanTreeView() {
            this.tree.setEditable(false);
        }

        public void selectFirstCategory() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CategoriesBeanTreeView.this.tree.setSelectionRow(0);
                }
            });
        }
    }

    private static abstract class ExplorerProviderPanel
    extends JPanel
    implements ExplorerManager.Provider,
    PropertyChangeListener,
    VetoableChangeListener {
        private ExplorerManager manager = new ExplorerManager();

        protected ExplorerProviderPanel() {
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.manager.addVetoableChangeListener((VetoableChangeListener)this);
            this.initGUI();
        }

        public void setRootNode(Node node) {
            this.manager.setRootContext(node);
        }

        public Node getRootNode() {
            return this.manager.getRootContext();
        }

        public Node[] getSelectedNodes() {
            return this.manager.getSelectedNodes();
        }

        public void setSelectedNodes(Node[] nodeArray) throws PropertyVetoException {
            this.manager.setSelectedNodes(nodeArray);
        }

        public void setSelectedNode(String string) throws NodeNotFoundException {
            if (string == null) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            try {
                Node node = NodeOp.findPath((Node)this.manager.getRootContext(), (String[])stringArray);
                if (node != null) {
                    this.manager.setSelectedNodes(new Node[]{node});
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public String getSelectionPath() {
            Node[] nodeArray = this.manager.getSelectedNodes();
            if (nodeArray == null || nodeArray.length != 1) {
                return null;
            }
            Node node = this.manager.getRootContext();
            String[] stringArray = NodeOp.createPath((Node)nodeArray[0], (Node)node);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append('/');
                stringBuffer.append(stringArray[i]);
            }
            return stringBuffer.substring(1);
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ExplorerProviderPanel.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
            });
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Node[] nodeArray;
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && ((nodeArray = (Node[])propertyChangeEvent.getNewValue()) == null || nodeArray.length != 1 && nodeArray.length != 0)) {
                throw new PropertyVetoException("Invalid length", propertyChangeEvent);
            }
        }

        public void requestFocus() {
            this.createComponent().requestFocus();
        }

        protected abstract JComponent createComponent();

        private void initGUI() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            JComponent jComponent = this.createComponent();
            ((GridBagLayout)this.getLayout()).setConstraints(jComponent, gridBagConstraints);
            this.add(jComponent);
        }
    }

    public static interface Builder {
        public Children createCategoriesChildren(DataFolder var1);

        public Children createTemplatesChildren(DataFolder var1);

        public String getCategoriesName();

        public String getTemplatesName();

        public void fireChange();
    }
}

