/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.quicksearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.netbeans.modules.jumpto.type.TypeProviderAccessor;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoToTypeWorker
implements Runnable {
    private volatile boolean isCanceled = false;
    private final String text;
    private Logger LOGGER = Logger.getLogger(GoToTypeWorker.class.getName());
    private final long createTime;
    private List<? extends TypeDescriptor> types;

    public GoToTypeWorker(String string) {
        this.text = string;
        this.createTime = System.currentTimeMillis();
    }

    public List<? extends TypeDescriptor> getTypes() {
        return this.types;
    }

    @Override
    public void run() {
        this.LOGGER.fine("Worker for " + this.text + " - started " + (System.currentTimeMillis() - this.createTime) + " ms.");
        this.types = this.getTypeNames(this.text);
        if (this.isCanceled) {
            this.LOGGER.fine("Worker for " + this.text + " exited after cancel " + (System.currentTimeMillis() - this.createTime) + " ms.");
            return;
        }
        if (this.isCanceled) {
            this.LOGGER.fine("Worker for " + this.text + " exited after cancel " + (System.currentTimeMillis() - this.createTime) + " ms.");
            return;
        }
    }

    public void cancel() {
        this.isCanceled = true;
    }

    private List<? extends TypeDescriptor> getTypeNames(String string) {
        ArrayList arrayList = new ArrayList(128);
        ArrayList arrayList2 = new ArrayList(128);
        String[] stringArray = new String[1];
        TypeProvider.Context context = TypeProviderAccessor.DEFAULT.createContext(null, string, SearchType.CASE_INSENSITIVE_PREFIX);
        TypeProvider.Result result = TypeProviderAccessor.DEFAULT.createResult(arrayList, stringArray);
        TypeProvider.Context context2 = TypeProviderAccessor.DEFAULT.createContext(null, string, SearchType.CAMEL_CASE);
        TypeProvider.Result result2 = TypeProviderAccessor.DEFAULT.createResult(arrayList2, stringArray);
        for (TypeProvider typeProvider : Lookup.getDefault().lookupAll(TypeProvider.class).toArray(new TypeProvider[0])) {
            if (this.isCanceled) {
                return null;
            }
            typeProvider.computeTypeNames(context, result);
        }
        for (TypeProvider typeProvider : Lookup.getDefault().lookupAll(TypeProvider.class).toArray(new TypeProvider[0])) {
            if (this.isCanceled) {
                return null;
            }
            typeProvider.computeTypeNames(context2, result2);
        }
        if (!this.isCanceled) {
            TreeSet<TypeDescriptor> treeSet = new TreeSet<TypeDescriptor>(new TypeComparatorFO());
            treeSet.addAll(arrayList2);
            treeSet.addAll(arrayList);
            arrayList.clear();
            arrayList.addAll(treeSet);
            Collections.sort(arrayList, new TypeComparator());
            return arrayList;
        }
        return null;
    }

    private int compareStrings(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return string.compareTo(string2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeComparatorFO
    implements Comparator<TypeDescriptor> {
        private TypeComparatorFO() {
        }

        @Override
        public int compare(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
            int n = GoToTypeWorker.this.compareStrings(typeDescriptor.getTypeName(), typeDescriptor2.getTypeName());
            if (n != 0) {
                return n;
            }
            n = GoToTypeWorker.this.compareStrings(typeDescriptor.getOuterName(), typeDescriptor2.getOuterName());
            if (n != 0) {
                return n;
            }
            if (!typeDescriptor.getFileObject().equals(typeDescriptor2.getFileObject())) {
                return -1;
            }
            return GoToTypeWorker.this.compareStrings(typeDescriptor.getContextName(), typeDescriptor2.getContextName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeComparator
    implements Comparator<TypeDescriptor> {
        private TypeComparator() {
        }

        @Override
        public int compare(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
            int n = GoToTypeWorker.this.compareStrings(typeDescriptor.getTypeName(), typeDescriptor2.getTypeName());
            if (n != 0) {
                return n;
            }
            n = GoToTypeWorker.this.compareStrings(typeDescriptor.getOuterName(), typeDescriptor2.getOuterName());
            if (n != 0) {
                return n;
            }
            return GoToTypeWorker.this.compareStrings(typeDescriptor.getContextName(), typeDescriptor2.getContextName());
        }
    }
}

