/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.file;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.jumpto.file.FileSearchOptions;
import org.netbeans.modules.jumpto.file.FileSearchPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class FileSearchAction
extends AbstractAction {
    private Dialog dialog;
    private JButton openBtn;
    private FileSearchPanel panel;

    public FileSearchAction() {
        super(NbBundle.getMessage(FileSearchAction.class, (String)"CTL_FileSearchAction"));
        this.putValue("PopupMenuText", NbBundle.getBundle(FileSearchAction.class).getString("editor-popup-CTL_FileSearchAction"));
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public boolean isEnabled() {
        return OpenProjects.getDefault().getOpenProjects().length > 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.openBtn = new JButton();
        this.openBtn.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.openBtn, (String)NbBundle.getMessage(FileSearchAction.class, (String)"CTL_Open"));
        Object var2_2 = null;
        Object[] objectArray = new Object[]{this.openBtn, DialogDescriptor.CANCEL_OPTION};
        String string = NbBundle.getMessage(FileSearchAction.class, (String)"MSG_FileSearchDlgTitle");
        this.panel = new FileSearchPanel(this);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, string, true, objectArray, (Object)this.openBtn, 0, null, (ActionListener)new DialogButtonListener(this.panel));
        dialogDescriptor.setClosingOptions(new Object[]{this.openBtn, DialogDescriptor.CANCEL_OPTION});
        this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        this.dialog.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileSearchAction.class, (String)"AN_FileSearchDialog"));
        this.dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSearchAction.class, (String)"AD_FileSearchDialog"));
        this.dialog.setPreferredSize(new Dimension(FileSearchOptions.getWidth(), FileSearchOptions.getHeight()));
        Rectangle rectangle = Utilities.getUsableScreenBounds();
        int n = rectangle.width * 9 / 10;
        int n2 = rectangle.height * 9 / 10;
        Dimension dimension = this.dialog.getPreferredSize();
        dimension.width = Math.min(dimension.width, n);
        dimension.height = Math.min(dimension.height, n2);
        this.dialog.setBounds(Utilities.findCenterBounds((Dimension)dimension));
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                FileSearchAction.this.cleanup();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileSearchAction.this.dialog.setVisible(true);
            }
        });
    }

    public static Project findCurrentProject() {
        Lookup lookup = Utilities.actionsGlobalContext();
        Iterator iterator = lookup.lookupAll(Project.class).iterator();
        if (iterator.hasNext()) {
            Project project = (Project)iterator.next();
            return project;
        }
        for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
            FileObject fileObject = dataObject.getPrimaryFile();
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null) continue;
            return project;
        }
        return null;
    }

    public void closeDialog() {
        this.dialog.setVisible(false);
        this.cleanup();
    }

    JButton getOpenButton() {
        return this.openBtn;
    }

    private void cleanup() {
        FileSearchOptions.flush();
        if (this.panel != null) {
            this.panel.cleanup();
            this.panel = null;
        }
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    private class DialogButtonListener
    implements ActionListener {
        private FileSearchPanel panel;

        public DialogButtonListener(FileSearchPanel fileSearchPanel) {
            this.panel = fileSearchPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == FileSearchAction.this.openBtn) {
                this.panel.openSelectedItems();
            }
        }
    }
}

