/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.file;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import org.netbeans.modules.jumpto.file.FileDescription;
import org.netbeans.modules.jumpto.file.FileSearchPanel;
import org.netbeans.modules.jumpto.file.LazyListModel;
import org.netbeans.modules.jumpto.file.ListListModel;
import org.netbeans.modules.jumpto.file.RegexpFileFilter;
import org.netbeans.modules.jumpto.file.SearchWorker;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSearch {
    private static final ListModel EMPTY_MODEL = new DefaultListModel();
    private FileSearchPanel panel;
    private SearchWorker worker;
    private String prefix;
    private String currentPrefix;
    private List<FileDescription> files;
    private static final RequestProcessor RP = new RequestProcessor("Jump To File Request Processor", 1);
    private RequestProcessor.Task searchTask;
    private boolean isSearchWorker;

    public FileSearch(FileSearchPanel fileSearchPanel) {
        this.panel = fileSearchPanel;
    }

    public synchronized void search(String string, boolean bl) {
        this.cancel(true);
        this.worker = new SearchWorker(this.panel, string);
        this.searchTask = RP.post((Runnable)this.worker, 300);
        this.isSearchWorker = true;
        this.prefix = string;
    }

    public synchronized void workerFinished() {
        this.worker = null;
        this.searchTask = null;
    }

    boolean cancel(boolean bl) {
        if (this.searchTask != null && this.searchTask.cancel()) {
            this.searchTask = null;
            if (this.worker != null) {
                this.worker.cancel();
            }
            this.worker = null;
            return true;
        }
        if (bl && this.worker != null) {
            this.worker.cancel();
            this.worker = null;
            this.searchTask = null;
        }
        return false;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public synchronized void setCurrentPrefix(String string) {
        this.currentPrefix = string;
        if (string != null && this.worker == null) {
            this.isSearchWorker = false;
            this.searchTask = RP.post(new Runnable(){

                public void run() {
                    FileSearch.this.panel.setModel(false, false);
                }
            }, 100);
        }
    }

    public synchronized boolean isNewSearchNeeded(String string) {
        if (this.cancel(false)) {
            return this.isSearchWorker;
        }
        return this.prefix == null || !string.startsWith(this.prefix.toLowerCase());
    }

    public void newSearchResults(List<FileDescription> list) {
        this.files = list;
        if (list == null) {
            this.cancel(true);
            this.currentPrefix = null;
            this.prefix = null;
        }
    }

    public ListModel createModel(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        ArrayList<Object> arrayList;
        if (this.files == null || this.files.isEmpty()) {
            return EMPTY_MODEL;
        }
        if (bl || this.currentPrefix != null) {
            arrayList = new ArrayList(this.files.size());
            object = new RegexpFileFilter(this.currentPrefix == null ? this.prefix : this.currentPrefix, bl);
            for (FileDescription fileDescription : this.files) {
                if (!object.accept(null, fileDescription.getName())) continue;
                arrayList.add(fileDescription);
            }
        } else {
            arrayList = new ArrayList<FileDescription>(this.files);
        }
        if (arrayList != null) {
            Collections.sort(arrayList, new FileDescription.FDComarator(bl2, bl));
        }
        object = new ListListModel(arrayList, bl4 ? FileDescription.SEARCH_IN_PROGRES : null);
        if (!bl3) {
            object = LazyListModel.create((ListModel)object, this.panel, 0.1, "Not computed yet.");
        }
        return object.getSize() == 0 ? EMPTY_MODEL : object;
    }
}

