/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class GaugeDisplayPresenterElement {
    private static final int BAR_WIDTH = 8;
    private static final int BAR_GAP = 5;
    private static final BasicStroke GAUGE_STROKE = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{3.0f, 2.0f}, 0.0f);
    private JPanel panel;
    private Dimension size;
    private int value;
    private int maxValue;
    private boolean interactive;

    public void setPanel(JPanel jPanel) {
        if (jPanel == null) {
            throw new IllegalArgumentException();
        }
        this.panel = jPanel;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException();
        }
        this.size = dimension;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public void setMaxValue(int n) {
        this.maxValue = n;
    }

    public void setInteractive(boolean bl) {
        this.interactive = bl;
    }

    public void paintGauge(Graphics graphics) {
        if (this.panel == null) {
            throw new IllegalArgumentException();
        }
        this.size = this.panel.getSize();
        if (this.size == null) {
            return;
        }
        int n = this.size.width;
        int n2 = this.size.height - 5;
        int n3 = n / 13 + 1;
        int n4 = 0;
        if (this.value > 0) {
            n4 = n3 * this.value / this.maxValue;
        }
        int n5 = 0;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.GRAY);
        graphics2D.setStroke(GAUGE_STROKE);
        float f = n2;
        float f2 = 0.0f;
        if (this.interactive) {
            f = 1.0f;
            f2 = (float)n2 / (float)n3;
        }
        for (int i = 0; i < n3; ++i) {
            if (i < n4) {
                graphics2D.fillRect(n5, (int)((float)n2 - f), 8, (int)f);
            } else {
                graphics2D.drawRect(n5, (int)((float)n2 - f), 8, (int)f);
            }
            n5 += 13;
            if (!this.interactive || !(f < (float)n2) || !((f += f2) > (float)n2)) continue;
            f = n2;
        }
    }
}

