/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.date;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.databinding.MidpDatabindingSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.DatabindingElement;
import org.netbeans.modules.vmd.midp.propertyeditors.DatabindingElementUI;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorDate
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private static final DateFormat FORMAT_DATE_TIME = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final DateFormat FORMAT_DATE = new SimpleDateFormat("dd.MM.yyyy");
    private static final DateFormat FORMAT_TIME = new SimpleDateFormat("HH:mm:ss");
    private static final String NON_DATE_TIME_TEXT = NbBundle.getMessage(PropertyEditorDate.class, (String)"MSG_NON_DATE_TIME");
    private static final String NON_DATE_TEXT = NbBundle.getMessage(PropertyEditorDate.class, (String)"MSG_NON_DATE");
    private static final String NON_TIME_TEXT = NbBundle.getMessage(PropertyEditorDate.class, (String)"MSG_NON_TIME");
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private DatabindingElement databindingElement;

    private PropertyEditorDate(boolean bl) {
        super(NbBundle.getMessage(PropertyEditorDate.class, (String)"LBL_DATE_UCLABEL"));
        this.initComponents();
        if (bl) {
            ArrayList<PropertyEditorElement> arrayList = new ArrayList<PropertyEditorElement>(2);
            this.databindingElement = new DatabindingElement(this);
            arrayList.add(this);
            arrayList.add(this.databindingElement);
            this.initElements(arrayList);
        } else {
            this.initElements(Collections.singleton(this));
        }
    }

    public static final DesignPropertyEditor createInstance() {
        return new PropertyEditorDate(false);
    }

    public static final DesignPropertyEditor createInstanceWithDatabinding() {
        return new PropertyEditorDate(true);
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorDate.class, (String)"LBL_DATE_STR"));
        this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorDate.class, (String)"ACSN_Date"));
        this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorDate.class, (String)"ACSD_Date"));
        this.customEditor = new CustomEditor();
        this.radioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PropertyEditorDate.this.radioButton.isSelected()) {
                    PropertyEditorDate.this.customEditor.textField.requestFocus();
                }
            }
        });
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return false;
    }

    public boolean isVerticallyResizable() {
        return false;
    }

    public String getAsText() {
        String string = super.getAsText();
        if (string != null) {
            return string;
        }
        String string2 = MidpDatabindingSupport.getDatabaindingAsText((DesignComponent)this.component.get(), (String)this.getPropertyNames().get(0));
        if (string2 != null) {
            return string2;
        }
        return this.getValueAsText((PropertyValue)super.getValue());
    }

    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public Boolean canEditAsText() {
        if (MidpDatabindingSupport.getDatabaindingAsText((DesignComponent)this.component.get(), (String)this.getPropertyNames().get(0)) != null) {
            return false;
        }
        return super.canEditAsText();
    }

    public void updateState(PropertyValue propertyValue) {
        DesignComponent designComponent = (DesignComponent)this.component.get();
        if (this.databindingElement != null) {
            this.databindingElement.updateDesignComponent(designComponent);
        }
        if (this.isCurrentValueANull() || propertyValue == null) {
            this.customEditor.setText(null);
        } else if (MidpDatabindingSupport.getDatabaindingAsText((DesignComponent)this.component.get(), (String)this.getPropertyNames().get(0)) != null) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).updateComponent(designComponent);
        } else {
            this.customEditor.setText(this.getValueAsText(propertyValue));
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String string) {
        int n = this.getInputMode();
        try {
            Date date = this.getFormatter(n).parse(string);
            super.setValue((Object)MidpTypes.createLongValue(date.getTime()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void customEditorOKButtonPressed() {
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
        DesignComponent designComponent = (DesignComponent)this.component.get();
        if (this.databindingElement != null && this.databindingElement.getRadioButton().isSelected()) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).saveToModel(designComponent);
            return;
        }
        if (this.databindingElement != null) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).resetValuesInModel(designComponent);
        }
        super.customEditorOKButtonPressed();
    }

    private String getValueAsText(PropertyValue propertyValue) {
        Date date = new Date();
        Object object = propertyValue.getPrimitiveValue();
        date.setTime((Long)object);
        int n = this.getInputMode();
        return this.getFormatter(n).format(date);
    }

    private DateFormat getFormatter(int n) {
        if (n == 1) {
            return FORMAT_DATE;
        }
        if (n == 2) {
            return FORMAT_TIME;
        }
        return FORMAT_DATE_TIME;
    }

    private int getInputMode() {
        final int[] nArray = new int[]{3};
        if (this.component != null && this.component.get() != null) {
            final DesignComponent designComponent = (DesignComponent)this.component.get();
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    PropertyValue propertyValue = designComponent.readProperty("inputMode");
                    if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                        nArray[0] = MidpTypes.getInteger(propertyValue);
                    }
                }
            });
        }
        return nArray[0];
    }

    private class CustomEditor
    extends JPanel
    implements DocumentListener,
    FocusListener {
        private JTextField textField;

        public CustomEditor() {
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.textField = new JTextField();
            this.textField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorDate.class, (String)"ACSN_DateField"));
            this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorDate.class, (String)"ACSD_DateField"));
            this.textField.getDocument().addDocumentListener(this);
            this.textField.addFocusListener(this);
            this.add((Component)this.textField, "Center");
        }

        public void setText(String string) {
            this.textField.setText(string);
        }

        public String getText() {
            return this.textField.getText();
        }

        public void checkDateStatus() {
            int n = PropertyEditorDate.this.getInputMode();
            try {
                this.parseDate(n, this.textField.getText());
                PropertyEditorDate.this.clearErrorStatus();
            }
            catch (ParseException parseException) {
                PropertyEditorDate.this.displayWarning(this.getMessage(n));
            }
        }

        private Date parseDate(int n, String string) throws ParseException {
            Date date = null;
            DateFormat dateFormat = PropertyEditorDate.this.getFormatter(n);
            dateFormat.setLenient(false);
            ParsePosition parsePosition = new ParsePosition(0);
            date = dateFormat.parse(string, parsePosition);
            if (date == null || parsePosition.getIndex() != string.length()) {
                throw new ParseException(null, parsePosition.getIndex());
            }
            return date;
        }

        private String getMessage(int n) {
            if (n == 1) {
                return NON_DATE_TEXT;
            }
            if (n == 2) {
                return NON_TIME_TEXT;
            }
            return NON_DATE_TIME_TEXT;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.textField.hasFocus()) {
                PropertyEditorDate.this.radioButton.setSelected(true);
                this.checkDateStatus();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.textField.hasFocus()) {
                PropertyEditorDate.this.radioButton.setSelected(true);
                this.checkDateStatus();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
            boolean bl = PropertyEditorDate.this.radioButton.isSelected();
            if (!bl) {
                PropertyEditorDate.this.radioButton.setSelected(true);
            }
            this.checkDateStatus();
        }

        public void focusLost(FocusEvent focusEvent) {
            PropertyEditorDate.this.clearErrorStatus();
        }
    }
}

