/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.api.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptSupport;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeleteSupport;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.netbeans.modules.vmd.midp.components.categories.ResourcesCategoryCD;
import org.netbeans.modules.vmd.midp.components.databinding.MidpDatabindingSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.DatabindingElement;
import org.netbeans.modules.vmd.midp.propertyeditors.DatabindingElementUI;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.ResourceEditorPanel;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.netbeans.modules.vmd.midp.propertyeditors.resource.elements.FontEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.resource.elements.ImageEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.resource.elements.TickerEditorElement;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEditorResource
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private Map<String, DesignComponent> createdComponents;
    private final TypeID componentTypeID;
    private String noneComponentAsText;
    private String newComponentAsText;
    private ResourceEditorPanel rePanel;
    private JRadioButton radioButton;
    private PropertyEditorResourceElement perElement;
    private DatabindingElement databindingElement;

    private PropertyEditorResource(PropertyEditorResourceElement propertyEditorResourceElement, String string, String string2, String string3, boolean bl) {
        super(string3);
        if (string == null || string2 == null) {
            throw Debug.illegalArgument((Object[])new Object[]{"Argument can not be null"});
        }
        if (string.equals(string2)) {
            throw Debug.illegalArgument((Object[])new Object[]{"Arguments can not be equal"});
        }
        this.componentTypeID = propertyEditorResourceElement.getTypeID();
        this.newComponentAsText = string;
        this.noneComponentAsText = string2;
        this.perElement = propertyEditorResourceElement;
        propertyEditorResourceElement.setPropertyEditorMessageAwareness(this);
        this.createdComponents = new HashMap<String, DesignComponent>();
        this.radioButton = new JRadioButton();
        this.rePanel = new ResourceEditorPanel(propertyEditorResourceElement, string2, this.radioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorResource.class, (String)"LBL_RB_RESOURCE"));
        this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorResource.class, (String)"ACSN_RB_RESOURCE"));
        this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorResource.class, (String)"ACSD_RB_RESOURCE"));
        if (bl) {
            ArrayList<PropertyEditorElement> arrayList = new ArrayList<PropertyEditorElement>(2);
            this.databindingElement = new DatabindingElement(this);
            arrayList.add(this);
            arrayList.add(this.databindingElement);
            this.initElements(arrayList);
        } else {
            this.initElements(Collections.singleton(this));
        }
    }

    public static final PropertyEditorResource createInstance(PropertyEditorResourceElement propertyEditorResourceElement, String string, String string2, String string3) {
        return new PropertyEditorResource(propertyEditorResourceElement, string, string2, string3, false);
    }

    public static final DesignPropertyEditor createFontPropertyEditor() {
        return new PropertyEditorResource(new FontEditorElement(), NbBundle.getMessage(PropertyEditorResource.class, (String)"LBL_FONTRESOURCEPE_NEW"), NbBundle.getMessage(PropertyEditorResource.class, (String)"LBL_FONTRESOURCEPE_NONE"), NbBundle.getMessage(PropertyEditorResource.class, (String)"LBL_FONTRESOURCEPE_UCLABEL"), false);
    }

    public static final DesignPropertyEditor createTickerPropertyEditor() {
        return new PropertyEditorResource(new TickerEditorElement(), NbBundle.getMessage(PropertyEditorResource.class, (String)"LBL_TICKERRESOURCEPE_NEW"), NbBundle.getMessage(PropertyEditorResource.class, (String)"LBL_TICKERRESOURCEPE_NONE"), NbBundle.getMessage(PropertyEditorResource.class, (String)"LBL_TICKERRESOURCEPE_UCLABEL"), false);
    }

    public static final DesignPropertyEditor createImagePropertyEditor() {
        return new PropertyEditorResource(new ImageEditorElement(), NbBundle.getMessage(PropertyEditorResource.class, (String)"LBL_IMAGERESOURCEPE_NEW"), NbBundle.getMessage(PropertyEditorResource.class, (String)"LBL_IMAGERESOURCEPE_NONE"), NbBundle.getMessage(PropertyEditorResource.class, (String)"LBL_IMAGERESOURCEPE_UCLABEL"), false);
    }

    public static final DesignPropertyEditor createImagePropertyEditorWithDatabinding() {
        return new PropertyEditorResource(new ImageEditorElement(), NbBundle.getMessage(PropertyEditorResource.class, (String)"LBL_IMAGERESOURCEPE_NEW"), NbBundle.getMessage(PropertyEditorResource.class, (String)"LBL_IMAGERESOURCEPE_NONE"), NbBundle.getMessage(PropertyEditorResource.class, (String)"LBL_IMAGERESOURCEPE_UCLABEL"), true);
    }

    private Map<String, DesignComponent> getComponentsMap() {
        final TreeMap<String, DesignComponent> treeMap = new TreeMap<String, DesignComponent>();
        if (this.component == null || this.component.get() == null) {
            return treeMap;
        }
        final DesignDocument designDocument = ((DesignComponent)this.component.get()).getDocument();
        designDocument.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                Collection collection = MidpDocumentSupport.getCategoryComponent(designDocument, ResourcesCategoryCD.TYPEID).getComponents();
                for (DesignComponent designComponent : collection) {
                    if (!designComponent.getType().equals((Object)PropertyEditorResource.this.componentTypeID)) continue;
                    treeMap.put(PropertyEditorResource.this.getComponentDisplayName(designComponent), designComponent);
                }
            }
        });
        return treeMap;
    }

    private String getComponentDisplayName(DesignComponent designComponent) {
        if (designComponent == null) {
            return this.noneComponentAsText;
        }
        if (designComponent.getParentComponent() == null && designComponent.getDocument().getRootComponent() != designComponent) {
            return this.noneComponentAsText;
        }
        return MidpValueSupport.getHumanReadableString(designComponent);
    }

    @Override
    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        String string = MidpDatabindingSupport.getDatabaindingAsText((DesignComponent)this.component.get(), (String)this.getPropertyNames().get(0));
        if (string != null) {
            return string;
        }
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        return this.getDecodeValue(propertyValue);
    }

    private void saveValue(String string) {
        if (string == null || string.length() <= 0) {
            return;
        }
        if (this.component == null || this.component.get() == null) {
            return;
        }
        final DesignDocument designDocument = ((DesignComponent)this.component.get()).getDocument();
        Map<String, DesignComponent> map = this.getComponentsMap();
        if (map.get(string) != null) {
            this.setValue(PropertyValue.createComponentReference((DesignComponent)map.get(string)));
        } else if (string.equals(this.noneComponentAsText)) {
            this.setValue(NULL_VALUE);
        } else if (string.equals(this.newComponentAsText)) {
            designDocument.getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    DesignComponent designComponent;
                    ComponentProducer componentProducer = DocumentSupport.getComponentProducer((DesignDocument)designDocument, (String)PropertyEditorResource.this.componentTypeID.toString());
                    if (componentProducer == null) {
                        throw new IllegalStateException("No producer for TypeID : " + PropertyEditorResource.this.componentTypeID.toString());
                    }
                    DesignComponent designComponent2 = MidpDocumentSupport.getCategoryComponent(designDocument, ResourcesCategoryCD.TYPEID);
                    ComponentProducer.Result result = AcceptSupport.accept((DesignComponent)designComponent2, (ComponentProducer)componentProducer, null);
                    DesignComponent designComponent3 = designComponent = result != null ? result.getMainComponent() : null;
                    if (designComponent != null) {
                        PropertyEditorResource.this.initInstanceNameForComponent(designComponent);
                        PropertyEditorResource.this.setValue(PropertyValue.createComponentReference((DesignComponent)designComponent));
                    }
                }
            });
        } else {
            Map<String, PropertyEditorResourceElement.DesignComponentWrapper> map2 = this.rePanel.getWrappersMap();
            for (String string2 : map2.keySet()) {
                if (!string2.equals(string)) continue;
                DesignComponent designComponent = this.createdComponents.get(string);
                this.setValue(PropertyValue.createComponentReference((DesignComponent)designComponent));
                this.createdComponents.clear();
                break;
            }
        }
    }

    private void setValue(PropertyValue propertyValue) {
        super.setValue((Object)propertyValue);
        DesignComponent designComponent = (DesignComponent)this.component.get();
        if (!NULL_VALUE.equals(propertyValue) && this.perElement.isPostSetValueSupported(designComponent)) {
            this.perElement.postSetValue(designComponent, propertyValue.getComponent());
        } else if (NULL_VALUE.equals(propertyValue)) {
            this.perElement.nullValueSet(designComponent);
        }
    }

    private void initInstanceNameForComponent(DesignComponent designComponent) {
        String string = this.perElement.getResourceNameSuggestion();
        PropertyValue propertyValue = InstanceNameResolver.createFromSuggested(designComponent, string);
        designComponent.writeProperty("instanceName", propertyValue);
    }

    private String getDecodeValue(final PropertyValue propertyValue) {
        if (propertyValue == null || propertyValue.getKind() == PropertyValue.Kind.NULL) {
            return this.noneComponentAsText;
        }
        if (this.component == null || this.component.get() == null) {
            return this.noneComponentAsText;
        }
        final String[] stringArray = new String[1];
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                DesignComponent designComponent = propertyValue.getComponent();
                stringArray[0] = PropertyEditorResource.this.getComponentDisplayName(designComponent);
            }
        });
        return stringArray[0] != null ? stringArray[0] : "n/a";
    }

    public String[] getTags() {
        Set<String> set = this.getComponentsMap().keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set.size() + 2);
        if (this.isCurrentValueAUserCodeType()) {
            arrayList.add(PropertyEditorUserCode.USER_CODE_TEXT);
        } else {
            arrayList.add(this.noneComponentAsText);
            arrayList.addAll(set);
            arrayList.add(this.newComponentAsText);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public Boolean canEditAsText() {
        return null;
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.getRadioButton().isSelected()) {
            this.saveChanges();
            this.saveValue(this.getTextForPropertyValue());
        }
        DesignComponent designComponent = (DesignComponent)this.component.get();
        if (this.databindingElement != null && this.databindingElement.getRadioButton().isSelected()) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).saveToModel(designComponent);
        } else if (this.databindingElement != null) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).resetValuesInModel(designComponent);
        }
    }

    @Override
    public String getTextForPropertyValue() {
        return this.rePanel.getTextForPropertyValue();
    }

    private void saveChanges() {
        if (this.rePanel.wasAnyDesignComponentChanged()) {
            Map<String, DesignComponent> map = this.getComponentsMap();
            Map<String, PropertyEditorResourceElement.DesignComponentWrapper> map2 = this.rePanel.getWrappersMap();
            final ArrayList arrayList = new ArrayList();
            for (final String string : map2.keySet()) {
                DesignComponent designComponent;
                final PropertyEditorResourceElement.DesignComponentWrapper designComponentWrapper = map2.get(string);
                if (designComponentWrapper.hasChanges()) {
                    designComponent = map.get(string);
                    if (designComponent != null) {
                        designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                            public void run() {
                                if (designComponentWrapper.getComponent() != null) {
                                    Map<String, PropertyValue> map = designComponentWrapper.getChanges();
                                    for (String string : map.keySet()) {
                                        PropertyValue propertyValue = map.get(string);
                                        designComponent.writeProperty(string, propertyValue);
                                    }
                                } else {
                                    arrayList.add(designComponent);
                                }
                            }
                        });
                    } else {
                        if (designComponentWrapper.isDeleted()) continue;
                        if (this.component != null && this.component.get() != null) {
                            final DesignDocument designDocument = ((DesignComponent)this.component.get()).getDocument();
                            designDocument.getTransactionManager().writeAccess(new Runnable(){

                                public void run() {
                                    DesignComponent designComponent;
                                    ComponentProducer componentProducer = DocumentSupport.getComponentProducer((DesignDocument)designDocument, (String)PropertyEditorResource.this.componentTypeID.toString());
                                    if (componentProducer == null) {
                                        throw new IllegalStateException("No producer for TypeID : " + PropertyEditorResource.this.componentTypeID.toString());
                                    }
                                    DesignComponent designComponent2 = MidpDocumentSupport.getCategoryComponent(designDocument, ResourcesCategoryCD.TYPEID);
                                    ComponentProducer.Result result = AcceptSupport.accept((DesignComponent)designComponent2, (ComponentProducer)componentProducer, null);
                                    DesignComponent designComponent3 = designComponent = result != null ? result.getMainComponent() : null;
                                    if (designComponent != null) {
                                        designComponent.writeProperty("instanceName", MidpTypes.createStringValue(string));
                                        Map<String, PropertyValue> map = designComponentWrapper.getChanges();
                                        for (String string2 : map.keySet()) {
                                            PropertyValue propertyValue = map.get(string2);
                                            designComponent.writeProperty(string2, propertyValue);
                                        }
                                        PropertyEditorResource.this.createdComponents.put(string, designComponent);
                                    }
                                }
                            });
                        }
                    }
                }
                if (arrayList.isEmpty() || this.component == null || this.component.get() == null) continue;
                designComponent = ((DesignComponent)this.component.get()).getDocument();
                designComponent.getTransactionManager().writeAccess(new Runnable((DesignDocument)designComponent, arrayList){
                    final /* synthetic */ DesignDocument val$document;
                    final /* synthetic */ Collection val$toBeDeleted;
                    {
                        this.val$document = designDocument;
                        this.val$toBeDeleted = collection;
                    }

                    public void run() {
                        DeleteSupport.invokeDirectUserDeletion((DesignDocument)this.val$document, (Collection)this.val$toBeDeleted, (boolean)false);
                    }
                });
            }
            DesignComponent designComponent = (DesignComponent)this.component.get();
            this.perElement.postSaveValue(designComponent);
        }
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.rePanel;
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return true;
    }

    @Override
    public boolean isVerticallyResizable() {
        return true;
    }

    @Override
    public void updateState(PropertyValue propertyValue) {
        DesignComponent designComponent = (DesignComponent)this.component.get();
        if (this.databindingElement != null) {
            this.databindingElement.updateDesignComponent(designComponent);
        }
        if (MidpDatabindingSupport.getDatabaindingAsText((DesignComponent)this.component.get(), (String)this.getPropertyNames().get(0)) != null) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).updateComponent(designComponent);
        } else if (this.rePanel.needsUpdate()) {
            this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
            this.rePanel.update(this.getComponentsMap(), this.getDecodeValue(propertyValue));
        }
    }

    @Override
    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }
}

