/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.general;

import java.awt.Image;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public class ClassSupport {
    private static final InfoPresenter.Resolver INFO_RESOLVER = new ClassInfoResolver();

    public static boolean isLazyInitialized(DesignComponent designComponent) {
        return MidpTypes.getBoolean(designComponent.readProperty("lazyInit"));
    }

    public static Presenter createInfoPresenter() {
        return InfoPresenter.create((InfoPresenter.Resolver)INFO_RESOLVER);
    }

    public static String resolveDisplayName(DesignComponent designComponent) {
        PropertyValue propertyValue = designComponent.readProperty("instanceName");
        if (propertyValue.getKind() == PropertyValue.Kind.VALUE && MidpTypes.TYPEID_JAVA_LANG_STRING.equals((Object)propertyValue.getType())) {
            return (String)propertyValue.getPrimitiveValue();
        }
        Debug.warning((Object[])new Object[]{"Invalid instance name ", propertyValue, "for component", designComponent});
        return null;
    }

    private static class ClassInfoResolver
    implements InfoPresenter.Resolver {
        private ClassInfoResolver() {
        }

        public String getDisplayName(DesignComponent designComponent, InfoPresenter.NameType nameType) {
            switch (nameType) {
                case PRIMARY: {
                    return ClassSupport.resolveDisplayName(designComponent);
                }
                case SECONDARY: {
                    return MidpTypes.getSimpleClassName(designComponent.getType());
                }
                case TERTIARY: {
                    return null;
                }
            }
            throw new IllegalStateException();
        }

        public DesignEventFilter getEventFilter(DesignComponent designComponent) {
            return new DesignEventFilter(new DesignEventFilter[0]).addComponentFilter(designComponent, false);
        }

        public boolean isEditable(DesignComponent designComponent) {
            return true;
        }

        public String getEditableName(DesignComponent designComponent) {
            if (designComponent == null) {
                throw new IllegalArgumentException("Component cannot be null");
            }
            return (String)designComponent.readProperty("instanceName").getPrimitiveValue();
        }

        public void setEditableName(DesignComponent designComponent, String string) {
            if (designComponent == null || string == null) {
                throw new IllegalArgumentException("Component or name cannot be null");
            }
            designComponent.writeProperty("instanceName", InstanceNameResolver.createFromSuggested(designComponent, string));
        }

        public Image getIcon(DesignComponent designComponent, InfoPresenter.IconType iconType) {
            if (InfoPresenter.IconType.COLOR_16x16.equals((Object)iconType)) {
                for (ComponentDescriptor componentDescriptor = designComponent.getComponentDescriptor(); componentDescriptor != null; componentDescriptor = componentDescriptor.getSuperDescriptor()) {
                    Image image = MidpTypes.getRegisteredIcon(componentDescriptor.getTypeDescriptor().getThisType());
                    if (image == null) continue;
                    return image;
                }
            }
            return null;
        }
    }
}

