/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.actions;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.midp.actions.GoToSourcePresenter;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;

public final class GoToSourceSupport {
    private GoToSourceSupport() {
    }

    public static void goToSourceOfComponent(final DesignComponent designComponent) {
        if (designComponent == null) {
            return;
        }
        final DataObjectContext dataObjectContext = ProjectUtils.getDataObjectContextForDocument((DesignDocument)designComponent.getDocument());
        if (dataObjectContext == null) {
            return;
        }
        final CloneableEditorSupport[] cloneableEditorSupportArray = new CloneableEditorSupport[1];
        final GoToSourcePresenter[] goToSourcePresenterArray = new GoToSourcePresenter[1];
        designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                goToSourcePresenterArray[0] = (GoToSourcePresenter)designComponent.getPresenter(GoToSourcePresenter.class);
                if (goToSourcePresenterArray[0] != null) {
                    cloneableEditorSupportArray[0] = dataObjectContext.getCloneableEditorSupport();
                }
            }
        });
        if (cloneableEditorSupportArray[0] == null) {
            return;
        }
        IOSupport.forceUpdateCode((DataObject)dataObjectContext.getDataObject());
        cloneableEditorSupportArray[0].edit();
        designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                StyledDocument styledDocument = null;
                try {
                    styledDocument = cloneableEditorSupportArray[0].openDocument();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                if (styledDocument != null) {
                    ProjectUtils.requestVisibility((DataObjectContext)ActiveViewSupport.getDefault().getActiveView().getContext(), (String)ProjectUtils.getSourceEditorViewDisplayName());
                    JEditorPane[] jEditorPaneArray = cloneableEditorSupportArray[0].getOpenedPanes();
                    if (jEditorPaneArray != null && jEditorPaneArray.length >= 1) {
                        JEditorPane jEditorPane = jEditorPaneArray[0];
                        jEditorPane.setVisible(true);
                        Iterable iterable = GuardedSectionManager.getInstance((StyledDocument)styledDocument).getGuardedSections();
                        for (GuardedSection guardedSection : iterable) {
                            if (!goToSourcePresenterArray[0].matches(guardedSection)) continue;
                            jEditorPane.setCaretPosition(guardedSection.getCaretPosition().getOffset());
                            break;
                        }
                    }
                }
            }
        });
    }
}

