/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.PHPRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PHPVerificationVisitor
extends DefaultTreePathVisitor {
    private PHPRuleContext context;
    private Collection<PHPRule> rules;
    private List<Hint> result = new LinkedList<Hint>();
    private VariableStack varStack = new VariableStack();
    private boolean maintainVarStack;

    public PHPVerificationVisitor(PHPRuleContext pHPRuleContext, Collection collection, boolean bl) {
        this.maintainVarStack = bl;
        this.context = pHPRuleContext;
        if (bl) {
            pHPRuleContext.variableStack = this.varStack;
        }
        pHPRuleContext.path = this.getPath();
        pHPRuleContext.index = PHPIndex.get(pHPRuleContext.compilationInfo.getIndex("text/x-php5"));
        this.rules = collection;
    }

    public List<Hint> getResult() {
        return this.result;
    }

    @Override
    public void visit(Program program) {
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(program);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(program);
    }

    @Override
    public void visit(StaticFieldAccess staticFieldAccess) {
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(staticFieldAccess);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(staticFieldAccess);
    }

    @Override
    public void visit(ClassDeclaration classDeclaration) {
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(classDeclaration);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(classDeclaration);
        for (PHPRule pHPRule : this.rules) {
            pHPRule.leavingClassDeclaration(classDeclaration);
        }
    }

    @Override
    public void visit(ClassInstanceCreation classInstanceCreation) {
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(classInstanceCreation);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(classInstanceCreation);
    }

    @Override
    public void visit(IfStatement ifStatement) {
        IsSetFinder isSetFinder = new IsSetFinder();
        ifStatement.getCondition().accept(isSetFinder);
        for (Expression object : isSetFinder.checkedVars) {
            this.varStack.addVariableDefinition(object);
        }
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(ifStatement);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(ifStatement);
    }

    @Override
    public void visit(DoStatement doStatement) {
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(doStatement);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(doStatement);
    }

    @Override
    public void visit(InfixExpression infixExpression) {
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(infixExpression);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(infixExpression);
    }

    @Override
    public void visit(FieldAccess fieldAccess) {
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(fieldAccess);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(fieldAccess);
    }

    @Override
    public void visit(FieldsDeclaration fieldsDeclaration) {
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(fieldsDeclaration);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(fieldsDeclaration);
    }

    @Override
    public void visit(ForStatement forStatement) {
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(forStatement);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(forStatement);
    }

    @Override
    public void visit(WhileStatement whileStatement) {
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(whileStatement);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(whileStatement);
    }

    @Override
    public void visit(MethodInvocation methodInvocation) {
        if (this.maintainVarStack) {
            String string;
            VariableWrapper variableWrapper;
            Object object;
            String string2;
            Object object2 = null;
            Object object3 = null;
            if (methodInvocation.getDispatcher() instanceof Variable && (string2 = CodeUtils.extractVariableName((Variable)(object = (Variable)methodInvocation.getDispatcher()))).startsWith("$") && (variableWrapper = this.context.variableStack.getVariableWraper(string2.substring(1))) != null) {
                object2 = variableWrapper.type;
            }
            if ((string = CodeUtils.extractFunctionName(methodInvocation.getMethod())) != null && object2 != null) {
                object = this.context.index.getAllMethods((PHPParseResult)this.context.parserResult, (String)object2, string, NameKind.EXACT_NAME, 1);
                this.assumeParamsPassedByRefInitialized((Collection<IndexedFunction>)object, methodInvocation.getMethod());
            }
        }
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(methodInvocation);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(methodInvocation);
    }

    @Override
    public void visit(StaticMethodInvocation staticMethodInvocation) {
        if (this.maintainVarStack) {
            String string = staticMethodInvocation.getClassName().getName();
            String object = CodeUtils.extractFunctionName(staticMethodInvocation.getMethod());
            if (object != null && string != null) {
                Collection<IndexedFunction> collection = this.context.index.getAllMethods((PHPParseResult)this.context.parserResult, string, object, NameKind.EXACT_NAME, 9);
                this.assumeParamsPassedByRefInitialized(collection, staticMethodInvocation.getMethod());
            }
        }
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(staticMethodInvocation);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(staticMethodInvocation);
    }

    @Override
    public void visit(FunctionInvocation functionInvocation) {
        Object object;
        if (this.maintainVarStack && (object = CodeUtils.extractFunctionName(functionInvocation)) != null) {
            Collection<IndexedFunction> object2 = this.context.index.getFunctions((PHPParseResult)this.context.parserResult, (String)object, NameKind.EXACT_NAME);
            this.assumeParamsPassedByRefInitialized(object2, functionInvocation);
        }
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(functionInvocation);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(functionInvocation);
    }

    @Override
    public void visit(FunctionDeclaration functionDeclaration) {
        this.varStack.blockStart(VariableStack.BlockType.FUNCTION);
        for (FormalParameter object : functionDeclaration.getFormalParameters()) {
            this.varStack.addVariableDefinition(object);
        }
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(functionDeclaration);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(functionDeclaration);
        this.varStack.blockEnd();
    }

    @Override
    public void visit(Variable variable) {
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(variable);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(variable);
    }

    @Override
    public void visit(MethodDeclaration methodDeclaration) {
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(methodDeclaration);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(methodDeclaration);
    }

    @Override
    public void visit(GlobalStatement globalStatement) {
        for (Variable variable : globalStatement.getVariables()) {
            this.varStack.addVariableDefinition(variable);
        }
        super.visit(globalStatement);
    }

    @Override
    public void visit(Block block) {
        this.varStack.blockStart(VariableStack.BlockType.BLOCK);
        super.visit(block);
        this.varStack.blockEnd();
    }

    @Override
    public void visit(Assignment assignment) {
        if (assignment.getLeftHandSide() instanceof Variable) {
            Variable variable = (Variable)assignment.getLeftHandSide();
            String object = CodeUtils.extractVariableTypeFromAssignment(assignment);
            this.varStack.addVariableDefinition(variable, object);
        }
        for (PHPRule pHPRule : this.rules) {
            pHPRule.setContext(this.context);
            pHPRule.visit(assignment);
            this.result.addAll(pHPRule.getResult());
            pHPRule.resetResult();
        }
        super.visit(assignment);
    }

    @Override
    public void visit(ForEachStatement forEachStatement) {
        Variable variable;
        if (forEachStatement.getKey() instanceof Variable) {
            variable = (Variable)forEachStatement.getKey();
            this.varStack.addVariableDefinition(variable);
        }
        if (forEachStatement.getValue() instanceof Variable) {
            variable = (Variable)forEachStatement.getValue();
            this.varStack.addVariableDefinition(variable);
        }
        super.visit(forEachStatement);
    }

    private void assumeParamsPassedByRefInitialized(Collection<IndexedFunction> collection, FunctionInvocation functionInvocation) {
        boolean[] blArray = new boolean[functionInvocation.getParameters().size()];
        for (IndexedFunction object : collection) {
            for (int i = 0; i < object.getParameters().size() && i < blArray.length; ++i) {
                String string = object.getParameters().get(i);
                if (!string.startsWith("&")) continue;
                blArray[i] = true;
            }
        }
        for (int i = 0; i < functionInvocation.getParameters().size(); ++i) {
            if (!blArray[i]) continue;
            Expression expression = functionInvocation.getParameters().get(i);
            this.varStack.addVariableDefinition(expression);
        }
    }

    private class IsSetFinder
    extends DefaultVisitor {
        private List<Expression> checkedVars = new ArrayList<Expression>();

        private IsSetFinder() {
        }

        public void visit(FunctionInvocation functionInvocation) {
            String string = CodeUtils.extractFunctionName(functionInvocation);
            if (string == null || !"isset".equalsIgnoreCase(string)) {
                return;
            }
            this.checkedVars.addAll(functionInvocation.getParameters());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VariableStack {
        private LinkedList<LinkedHashMap<VariableWrapper, String>> vars = new LinkedList();
        private LinkedList<BlockType> blockTypes = new LinkedList();
        private LinkedList<ASTNode> unreferencesVars = new LinkedList();

        VariableStack() {
            this.blockStart(BlockType.BLOCK);
        }

        void blockStart(BlockType blockType) {
            this.vars.add(new LinkedHashMap());
            this.blockTypes.add(blockType);
        }

        void blockEnd() {
            for (VariableWrapper variableWrapper : this.vars.getLast().keySet()) {
                if (variableWrapper.referenced) continue;
                this.unreferencesVars.add(variableWrapper.var);
            }
            this.vars.removeLast();
            this.blockTypes.removeLast();
        }

        void addVariableDefinition(ASTNode aSTNode) {
            this.addVariableDefinition(aSTNode, null);
        }

        void addVariableDefinition(ASTNode aSTNode, String string) {
            Object object;
            ASTNode aSTNode2;
            Variable variable = null;
            if (aSTNode instanceof Variable) {
                variable = (Variable)aSTNode;
            } else if (aSTNode instanceof FormalParameter) {
                aSTNode2 = (FormalParameter)aSTNode;
                if (((FormalParameter)aSTNode2).getParameterName() instanceof Variable) {
                    variable = (Variable)((FormalParameter)aSTNode2).getParameterName();
                } else if (((FormalParameter)aSTNode2).getParameterName() instanceof Reference && ((Reference)(object = (Reference)((FormalParameter)aSTNode2).getParameterName())).getExpression() instanceof Variable) {
                    variable = (Variable)((Reference)object).getExpression();
                }
            }
            if (variable != null && variable.getName() instanceof Identifier) {
                aSTNode2 = (Identifier)variable.getName();
                object = ((Identifier)aSTNode2).getName();
                VariableWrapper variableWrapper = this.getVariableWraper((String)object);
                if (variableWrapper == null) {
                    variableWrapper = new VariableWrapper(aSTNode);
                    this.vars.getLast().put(variableWrapper, (String)object);
                }
                if (string != null) {
                    variableWrapper.type = string;
                }
            }
        }

        public boolean isVariableDefined(String string) {
            if (PredefinedSymbols.isSuperGlobalName(string) || "this".equals(string)) {
                return true;
            }
            return this.getVariableWraper(string) != null;
        }

        public VariableWrapper getVariableWraper(String string) {
            for (int i = this.vars.size() - 1; i >= 0; --i) {
                LinkedHashMap<VariableWrapper, String> linkedHashMap = this.vars.get(i);
                VariableWrapper[] variableWrapperArray = linkedHashMap.keySet().toArray(new VariableWrapper[linkedHashMap.size()]);
                for (int j = variableWrapperArray.length - 1; j >= 0; --j) {
                    VariableWrapper variableWrapper = variableWrapperArray[j];
                    String string2 = linkedHashMap.get(variableWrapper);
                    if (!string.equals(string2)) continue;
                    variableWrapper.referenced = true;
                    return variableWrapper;
                }
                if (this.blockTypes.get(i) == BlockType.FUNCTION) break;
            }
            return null;
        }

        public List<ASTNode> getUnreferencedVars() {
            return this.unreferencesVars;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum BlockType {
            BLOCK,
            FUNCTION;

        }
    }

    static class VariableWrapper {
        ASTNode var;
        boolean referenced = false;
        String type;

        public VariableWrapper(ASTNode aSTNode) {
            this.var = aSTNode;
        }
    }
}

