/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.verification.PHPRule;
import org.netbeans.modules.php.editor.verification.VarStackReadingRule;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImproperFieldAccessRule
extends PHPRule
implements VarStackReadingRule {
    private String insideClsName = "";

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public String getId() {
        return "improper.field.access";
    }

    @Override
    public void visit(ClassDeclaration classDeclaration) {
        this.insideClsName = classDeclaration.getName().getName();
        super.visit(classDeclaration);
    }

    @Override
    public void leavingClassDeclaration(ClassDeclaration classDeclaration) {
        super.leavingClassDeclaration(classDeclaration);
        this.insideClsName = "";
    }

    @Override
    public void visit(InfixExpression infixExpression) {
        Variable variable;
        Expression expression;
        InfixExpression.OperatorType operatorType = infixExpression.getOperator();
        if ((operatorType.equals((Object)InfixExpression.OperatorType.MINUS) || operatorType.equals((Object)InfixExpression.OperatorType.LGREATER)) && (expression = infixExpression.getLeft()) instanceof Variable && (variable = (Variable)expression).isDollared() && "this".equals(ImproperFieldAccessRule.extractVariableName(variable))) {
            this.addHint(variable);
        }
        super.visit(infixExpression);
    }

    @Override
    public void visit(Program program) {
        this.insideClsName = "";
        super.visit(program);
    }

    @Override
    public void visit(StaticFieldAccess staticFieldAccess) {
        IndexedClass indexedClass;
        Variable variable = staticFieldAccess.getField();
        String string = staticFieldAccess.getClassName().getName();
        if (string.equals("self")) {
            string = this.insideClsName;
        }
        int n = this.insideClsName.equals(string) ? -1 : 1;
        ArrayList arrayList = new ArrayList();
        Index index = this.context.compilationInfo.getIndex("text/x-php5");
        PHPIndex pHPIndex = PHPIndex.get(index);
        LinkedList linkedList = new LinkedList();
        Collection<IndexedConstant> collection = null;
        Iterator<IndexedClass> iterator = pHPIndex.getClassInheritanceLine(null, string).iterator();
        while (iterator.hasNext() && (collection = this.getFields(pHPIndex, (indexedClass = iterator.next()).getName(), variable, n)).isEmpty()) {
            if (this.insideClsName.equals(indexedClass.getName())) {
                n = 5;
                continue;
            }
            n = 1;
        }
        if (collection == null || collection.isEmpty()) {
            this.addHint(variable);
        }
        super.visit(staticFieldAccess);
    }

    @Override
    public void visit(FieldAccess fieldAccess) {
        super.visit(fieldAccess);
        Variable variable = fieldAccess.getField();
        if (variable.isDollared() && !this.context.variableStack.isVariableDefined(ImproperFieldAccessRule.extractVariableName(variable))) {
            this.addHint(variable);
        }
        super.visit(fieldAccess);
    }

    private static String extractVariableName(Variable variable) {
        if (variable.getName() instanceof Identifier) {
            Identifier identifier = (Identifier)variable.getName();
            return identifier.getName();
        }
        if (variable.getName() instanceof Variable) {
            Variable variable2 = (Variable)variable.getName();
            return ImproperFieldAccessRule.extractVariableName(variable2);
        }
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(ImproperFieldAccessRule.class, (String)"ImproperFieldAccessDesc");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ImproperFieldAccessRule.class, (String)"ImproperFieldAccessDispName");
    }

    private void addHint(Variable variable) {
        OffsetRange offsetRange = new OffsetRange(variable.getStartOffset(), variable.getEndOffset());
        Hint hint = new Hint((Rule)this, this.getDisplayName(), this.context.compilationInfo.getFileObject(), offsetRange, null, 500);
        this.addResult(hint);
    }

    private Collection<IndexedConstant> getFields(PHPIndex pHPIndex, String string, Variable variable, int n) {
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        String string2 = ImproperFieldAccessRule.extractVariableName(variable);
        Collection<IndexedConstant> collection = pHPIndex.getProperties(null, string, string2, NameKind.PREFIX, n);
        for (IndexedConstant indexedConstant : collection) {
            String string3 = indexedConstant.getName();
            string3 = string3.charAt(0) == '$' ? string3.substring(1) : string3;
            if (!string2.equals(string3)) continue;
            arrayList.add(indexedConstant);
        }
        return arrayList;
    }

    @Override
    public boolean getDefaultEnabled() {
        return false;
    }
}

