/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.verification.PHPRule;
import org.openide.util.NbBundle;

public class AccidentalAssignmentRule
extends PHPRule {
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public String getId() {
        return "accidental.assignment";
    }

    public String getDescription() {
        return NbBundle.getMessage(AccidentalAssignmentRule.class, (String)"AccidentalAssignmentDesc");
    }

    public void visit(IfStatement ifStatement) {
        this.check(ifStatement.getCondition());
        super.visit(ifStatement);
    }

    public void visit(DoStatement doStatement) {
        this.check(doStatement.getCondition());
        super.visit(doStatement);
    }

    public void visit(ForStatement forStatement) {
        for (Expression expression : forStatement.getConditions()) {
            this.check(expression);
        }
        super.visit(forStatement);
    }

    public void visit(WhileStatement whileStatement) {
        this.check(whileStatement.getCondition());
        super.visit(whileStatement);
    }

    private void check(Expression expression) {
        if (!(expression instanceof Assignment)) {
            return;
        }
        OffsetRange offsetRange = new OffsetRange(expression.getStartOffset(), expression.getEndOffset());
        Hint hint = new Hint((Rule)this, this.getDisplayName(), this.context.compilationInfo.getFileObject(), offsetRange, null, 500);
        this.addResult(hint);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AccidentalAssignmentRule.class, (String)"AccidentalAssignmentDispName");
    }
}

