/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.api;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static Comment getCommentForNode(Program program, ASTNode aSTNode) {
        List<Comment> list = program.getComments();
        ASTNode aSTNode2 = null;
        if (aSTNode.getEndOffset() <= program.getEndOffset()) {
            Comment comment;
            Object object = list.iterator();
            while (object.hasNext() && (comment = object.next()).getEndOffset() < aSTNode.getStartOffset()) {
                aSTNode2 = comment;
            }
            if (aSTNode2 != null && aSTNode2.getEndOffset() + 1 < aSTNode.getStartOffset() && (object = new NodeRangeLocator().locate(program, new OffsetRange(aSTNode2.getEndOffset() + 1, aSTNode.getStartOffset() - 1))).size() != 0) {
                aSTNode2 = null;
            }
        }
        return aSTNode2;
    }

    public static Program getRoot(CompilationInfo compilationInfo) {
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/x-php5", 0);
        if (parserResult == null) {
            return null;
        }
        if (parserResult instanceof PHPParseResult) {
            return ((PHPParseResult)parserResult).getProgram();
        }
        return null;
    }

    public static ASTNode getNodeAtOffset(CompilationInfo compilationInfo, int n) {
        Program program = Utils.getRoot(compilationInfo);
        return Utils.getNodeAtOffset(program, n);
    }

    public static ASTNode getNodeAtOffset(ASTNode aSTNode, int n) {
        if (aSTNode.getStartOffset() > n || aSTNode.getEndOffset() < n) {
            return null;
        }
        return new NodeLocator().locate(aSTNode, n);
    }

    public static ASTNode getNodeAtOffset(ASTNode aSTNode, int n, Class<? extends ASTNode> clazz) {
        if (aSTNode.getStartOffset() > n || aSTNode.getEndOffset() < n) {
            return null;
        }
        return new SpecificClassNodeLocator(clazz).locate(aSTNode, n);
    }

    public static String resolveVariableName(Variable variable) {
        String string = null;
        if (variable.getName() instanceof Identifier) {
            string = ((Identifier)variable.getName()).getName();
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeRangeLocator
    extends DefaultVisitor {
        private OffsetRange range;
        private List<ASTNode> nodes = new ArrayList<ASTNode>();

        private NodeRangeLocator() {
        }

        public List<ASTNode> locate(ASTNode aSTNode, OffsetRange offsetRange) {
            this.range = offsetRange;
            this.scan(aSTNode);
            return this.nodes;
        }

        @Override
        public void scan(ASTNode aSTNode) {
            if (aSTNode != null) {
                if (this.range.getStart() <= aSTNode.getStartOffset() && aSTNode.getEndOffset() <= this.range.getEnd()) {
                    this.nodes.add(aSTNode);
                } else if (aSTNode.getStartOffset() < this.range.getStart() && this.range.getStart() < aSTNode.getEndOffset() || aSTNode.getStartOffset() < this.range.getEnd() && this.range.getEnd() < aSTNode.getEndOffset()) {
                    aSTNode.accept(this);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpecificClassNodeLocator
    extends NodeLocator {
        private Class<? extends ASTNode> terminus;

        public SpecificClassNodeLocator(Class<? extends ASTNode> clazz) {
            this.terminus = clazz;
        }

        @Override
        public void scan(ASTNode aSTNode) {
            if (this.terminus.isInstance(aSTNode)) {
                if (aSTNode.getStartOffset() <= this.offset && this.offset <= aSTNode.getEndOffset()) {
                    this.node = aSTNode;
                }
            } else {
                super.scan(aSTNode);
            }
        }
    }

    private static class NodeLocator
    extends DefaultVisitor {
        protected int offset = 0;
        protected ASTNode node = null;

        private NodeLocator() {
        }

        public ASTNode locate(ASTNode aSTNode, int n) {
            this.offset = n;
            this.scan(aSTNode);
            return this.node;
        }

        public void scan(ASTNode aSTNode) {
            if (aSTNode != null && aSTNode.getStartOffset() <= this.offset && this.offset <= aSTNode.getEndOffset()) {
                this.node = aSTNode;
                aSTNode.accept(this);
            }
        }
    }
}

