/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.spi.DefaultParserFile;
import org.netbeans.modules.php.editor.index.AstElement;
import org.netbeans.modules.php.editor.index.NbUtilities;
import org.netbeans.modules.php.editor.index.PHPElement;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexedElement
extends PHPElement {
    protected ElementKind kind;
    protected String name;
    protected String in;
    protected PHPIndex index;
    private String fileUrl;
    protected Document document;
    protected FileObject fileObject;
    protected int flags;
    protected String textSignature;
    protected boolean smart;
    protected boolean inherited = true;
    protected boolean resolved = true;
    protected int offset;

    IndexedElement(String string, String string2, PHPIndex pHPIndex, String string3, int n, int n2, ElementKind elementKind) {
        this.name = string;
        this.in = string2;
        this.index = pHPIndex;
        this.fileUrl = string3;
        this.offset = n;
        this.flags = n2;
        this.kind = elementKind;
        if (string3 != null && string3.contains(" ")) {
            throw new IllegalArgumentException("fileURL may not contain spaces!");
        }
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean bl) {
        this.resolved = bl;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getSignature() {
        if (this.textSignature == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.in != null) {
                stringBuilder.append(this.in);
                stringBuilder.append('.');
            }
            stringBuilder.append(this.name);
            this.textSignature = stringBuilder.toString();
        }
        return this.textSignature;
    }

    public PHPIndex getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        String string = this.getModifiersString();
        return string.length() == 0 ? this.getName() : string + " " + this.getName();
    }

    public String getModifiersString() {
        return BodyDeclaration.Modifier.toString(this.flags);
    }

    @Override
    public String getIn() {
        return this.in;
    }

    @Override
    public ElementKind getKind() {
        return this.kind;
    }

    @Override
    public Set<Modifier> getModifiers() {
        if (this.isStatic()) {
            return AstElement.STATIC;
        }
        return Collections.emptySet();
    }

    public String getFilenameUrl() {
        return this.fileUrl;
    }

    public Document getDocument() throws IOException {
        if (this.document == null) {
            FileObject fileObject = this.getFileObject();
            if (fileObject == null) {
                return null;
            }
            this.document = NbUtilities.getBaseDocument(this.fileObject, true);
        }
        return this.document;
    }

    public ParserFile getFile() {
        FileObject fileObject = this.getFileObject();
        boolean bl = false;
        if (fileObject != null) {
            PhpSourcePath.FileType fileType = PhpSourcePath.getFileType((FileObject)this.fileObject);
            bl = fileType == PhpSourcePath.FileType.INTERNAL;
        }
        return new DefaultParserFile(fileObject, null, bl);
    }

    @Override
    public FileObject getFileObject() {
        if (this.fileObject == null && this.fileUrl != null) {
            this.fileObject = PHPIndex.getFileObject(this.fileUrl);
            if (this.fileObject == null) {
                this.fileUrl = null;
            }
        }
        return this.fileObject;
    }

    public void setSmart(boolean bl) {
        this.smart = bl;
    }

    public boolean isSmart() {
        return this.smart;
    }

    public void setInherited(boolean bl) {
        this.inherited = bl;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public static String encode(int n) {
        return Integer.toString(n, 16);
    }

    public static int decode(String string, int n, int n2) {
        int n3 = 0;
        int n4 = string.length();
        for (int i = n; i < n4; ++i) {
            char c = string.charAt(i);
            if (c == ';') {
                if (i != n) break;
                return n2;
            }
            n3 <<= 4;
            if (c > '9') {
                n3 += c - 97 + 10;
                continue;
            }
            n3 += c - 48;
        }
        return n3;
    }

    public boolean isPublic() {
        return (this.flags & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.flags & 2) != 0;
    }

    public boolean isStatic() {
        return (this.flags & 8) != 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IndexedElement indexedElement = (IndexedElement)object;
        if (!this.getSignature().equals(indexedElement.getSignature())) {
            return false;
        }
        return this.getKind().equals((Object)indexedElement.getKind());
    }

    public int hashCode() {
        int n = 7;
        n = 53 * n + this.getSignature().hashCode();
        n = 53 * n + this.getKind().hashCode();
        return n;
    }
}

