/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Formatter;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPFormatter
implements Formatter {
    private static final Logger LOG = Logger.getLogger(PHPFormatter.class.getName());
    private final DocSyncedCodeStyle codeStyle;

    public PHPFormatter() {
        LOG.fine("PHP Formatter: " + this);
        this.codeStyle = new DocSyncedCodeStyle();
    }

    public boolean needsParserResult() {
        return false;
    }

    public void reindent(Document document, int n, int n2) {
        this.reindent(document, n, n2, null, true);
    }

    public void reformat(Document document, int n, int n2, CompilationInfo compilationInfo) {
        this.reindent(document, n, n2, compilationInfo, false);
    }

    public int indentSize() {
        return this.codeStyle.getIndentSize();
    }

    public int hangingIndentSize() {
        return this.codeStyle.getContinuationIndentSize();
    }

    private int getFormatStableStart(BaseDocument baseDocument, int n) {
        TokenSequence<? extends PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
        if (tokenSequence == null) {
            return 0;
        }
        tokenSequence.move(n);
        if (!tokenSequence.movePrevious()) {
            return 0;
        }
        do {
            Token token;
            TokenId tokenId;
            if ((tokenId = (token = tokenSequence.token()).id()) != PHPTokenId.PHP_OPENTAG && tokenId != PHPTokenId.PHP_CLASS && tokenId != PHPTokenId.PHP_FUNCTION) continue;
            return tokenSequence.offset();
        } while (tokenSequence.movePrevious());
        return tokenSequence.offset();
    }

    public static int getTokenBalanceDelta(Token<? extends PHPTokenId> token, TokenSequence<? extends PHPTokenId> tokenSequence, boolean bl) {
        if (token.id() == PHPTokenId.PHP_VARIABLE) {
            if (token.length() == 1) {
                char c = token.text().charAt(0);
                if (c == '[') {
                    return 1;
                }
                if (c == ']') {
                    return -1;
                }
            }
        } else {
            if (token.id() == PHPTokenId.PHP_CURLY_OPEN) {
                return 1;
            }
            if (token.id() == PHPTokenId.PHP_CURLY_CLOSE) {
                return -1;
            }
            if (token.id() == PHPTokenId.PHP_TOKEN) {
                if (LexUtilities.textEquals(token.text(), '(') || LexUtilities.textEquals(token.text(), '[')) {
                    return 1;
                }
                if (LexUtilities.textEquals(token.text(), ')') || LexUtilities.textEquals(token.text(), ']')) {
                    return -1;
                }
            } else if (bl) {
                if (LexUtilities.isIndentBeginToken((PHPTokenId)token.id())) {
                    return 1;
                }
                if (LexUtilities.isIndentEndToken((PHPTokenId)token.id())) {
                    return -1;
                }
            }
        }
        return 0;
    }

    public static int getTokenBalance(BaseDocument baseDocument, int n, int n2, boolean bl) {
        int n3 = 0;
        TokenSequence<? extends PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
        if (tokenSequence == null) {
            return 0;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return 0;
        }
        do {
            Token token = tokenSequence.token();
            n3 += PHPFormatter.getTokenBalanceDelta((Token<? extends PHPTokenId>)token, tokenSequence, bl);
        } while (tokenSequence.moveNext() && tokenSequence.offset() < n2);
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInLiteral(BaseDocument baseDocument, int n) throws BadLocationException {
        TokenId tokenId;
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 != -1) {
            Token<? extends PHPTokenId> token = LexUtilities.getToken(baseDocument, n2);
            if (token == null) return true;
            TokenId tokenId2 = token.id();
            if (tokenId2 != PHPTokenId.PHP_COMMENT && tokenId2 != PHPTokenId.PHP_COMMENT_START && tokenId2 != PHPTokenId.PHP_COMMENT_END && tokenId2 != PHPTokenId.PHPDOC_COMMENT && tokenId2 != PHPTokenId.PHPDOC_COMMENT_START && tokenId2 != PHPTokenId.PHPDOC_COMMENT_END && tokenId2 != PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING && tokenId2 != PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE && tokenId2 != PHPTokenId.PHP_HEREDOC_TAG) return false;
            return true;
        }
        Token<? extends PHPTokenId> token = LexUtilities.getToken(baseDocument, n);
        if (token == null || (tokenId = token.id()) != PHPTokenId.PHP_COMMENT && tokenId != PHPTokenId.PHP_COMMENT_START && tokenId != PHPTokenId.PHP_COMMENT_END && tokenId != PHPTokenId.PHPDOC_COMMENT && tokenId != PHPTokenId.PHPDOC_COMMENT_START && tokenId != PHPTokenId.PHPDOC_COMMENT_END && tokenId != PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING && tokenId != PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE && tokenId != PHPTokenId.PHP_HEREDOC_TAG) return false;
        return true;
    }

    private Token<? extends PHPTokenId> getFirstToken(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 != -1) {
            return LexUtilities.getToken(baseDocument, n2);
        }
        return null;
    }

    private boolean isEndIndent(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 != -1) {
            Token<? extends PHPTokenId> token = this.getFirstToken(baseDocument, n);
            if (token == null) {
                return false;
            }
            return LexUtilities.isIndentEndToken((PHPTokenId)token.id()) || LexUtilities.textEquals(token.text(), ')') || LexUtilities.textEquals(token.text(), ']') || token.id() == PHPTokenId.PHP_CURLY_CLOSE;
        }
        return false;
    }

    private boolean isLineContinued(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        if ((n = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n)) == -1) {
            return false;
        }
        TokenSequence<? extends PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return false;
        }
        Token token = tokenSequence.token();
        if (token != null) {
            TokenId tokenId = token.id();
            if (tokenSequence.offset() == n && token.length() > 1 && ((Object)token.text()).toString().startsWith("\\")) {
                return true;
            }
            if (token.length() == 1 && tokenId == PHPTokenId.PHP_TOKEN && ((Object)token.text()).toString().equals(",") && n2 == 0) {
                return true;
            }
            if (tokenId == PHPTokenId.PHP_TOKEN && (CharSequenceUtilities.textEquals((CharSequence)token.text(), (CharSequence)"or") || CharSequenceUtilities.textEquals((CharSequence)token.text(), (CharSequence)"and"))) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindent(Document document, int n, int n2, CompilationInfo compilationInfo, boolean bl) {
        document.putProperty("HTML_FORMATTER_ACTS_ON_TOP_LEVEL", Boolean.TRUE);
        try {
            BaseDocument baseDocument = (BaseDocument)document;
            if (n2 > baseDocument.getLength()) {
                n2 = baseDocument.getLength();
            }
            int n3 = n = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n4 = 0;
            int n5 = 0;
            if (n > 0) {
                int n6 = Utilities.getRowStart((BaseDocument)baseDocument, (int)(n - 1));
                n4 = this.getFormatStableStart(baseDocument, n6);
                n5 = LexUtilities.getLineIndent(baseDocument, n4);
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            boolean bl2 = n != 0 || n2 != baseDocument.getLength();
            boolean bl3 = n2 == baseDocument.getLength() || bl;
            this.computeIndents(baseDocument, n5, n4, n2, compilationInfo, arrayList, arrayList2, bl2, bl3, bl);
            try {
                baseDocument.atomicLock();
                assert (arrayList2.size() == arrayList.size());
                org.netbeans.editor.Formatter formatter = baseDocument.getFormatter();
                for (int i = arrayList2.size() - 1; i >= 0; --i) {
                    int n7;
                    int n8 = (Integer)arrayList2.get(i);
                    int n9 = (Integer)arrayList.get(i);
                    if (n9 < n3) {
                        break;
                    }
                    if (n9 == n3 && i > 0) {
                        n7 = (Integer)arrayList.get(i - 1);
                        int n10 = (Integer)arrayList2.get(i - 1);
                        int n11 = LexUtilities.getLineIndent(baseDocument, n7);
                        if (n11 != n10 && !Utilities.isRowEmpty((BaseDocument)baseDocument, (int)n7) && !Utilities.isRowWhite((BaseDocument)baseDocument, (int)n7)) {
                            n8 = n11 + (n8 - n10);
                        }
                    }
                    if ((n7 = LexUtilities.getLineIndent(baseDocument, n9)) == n8) continue;
                    formatter.changeRowIndent(baseDocument, n9, n8);
                }
            }
            finally {
                baseDocument.atomicUnlock();
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    public void computeIndents(BaseDocument baseDocument, int n, int n2, int n3, CompilationInfo compilationInfo, List<Integer> list, List<Integer> list2, boolean bl, boolean bl2, boolean bl3) {
        try {
            int n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2);
            int n5 = n3;
            int n6 = this.codeStyle.getIndentSize();
            int n7 = this.codeStyle.getContinuationIndentSize();
            int n8 = 0;
            int n9 = 0;
            boolean bl4 = false;
            boolean bl5 = false;
            while (!bl2 && n4 < n5 || bl2 && n4 <= n5) {
                int n10;
                int n11;
                int n12 = n11 = bl4 ? n7 : 0;
                int n13 = this.isInLiteral(baseDocument, n4) ? LexUtilities.getLineIndent(baseDocument, n4) : (this.isEndIndent(baseDocument, n4) ? (n8 - 1) * n6 + n11 + n : n8 * n6 + n11 + n);
                if (n13 < 0) {
                    n13 = 0;
                }
                if ((n10 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n4)) != -1 || bl) {
                    list2.add(n13);
                    list.add(n4);
                }
                int n14 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n4) + 1;
                if (n10 != -1) {
                    n8 += PHPFormatter.getTokenBalance(baseDocument, n10, n14, true);
                    bl4 = this.isLineContinued(baseDocument, n4, n9 += PHPFormatter.getTokenBalance(baseDocument, n10, n14, false));
                }
                n4 = n14;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private static final class DocSyncedCodeStyle
    extends CodeStyle {
        private int rightMargin = 80;
        private Class kitClass;

        private DocSyncedCodeStyle() {
            super(null);
        }

        private Class getEditorKitClass() {
            if (this.kitClass == null) {
                EditorKit editorKit = (EditorKit)MimeLookup.getLookup((MimePath)MimePath.parse((String)"text/xml")).lookup(EditorKit.class);
                this.kitClass = editorKit != null ? editorKit.getClass() : BaseKit.class;
            }
            return this.kitClass;
        }

        private int getSpacesPerTab() {
            Integer n = (Integer)Settings.getValue((Class)this.getEditorKitClass(), (String)"spaces-per-tab");
            int n2 = 4;
            if (n != null && n >= 0) {
                n2 = n;
            }
            return n2;
        }

        public int getIndentSize() {
            return this.getSpacesPerTab();
        }

        public int getContinuationIndentSize() {
            return this.getSpacesPerTab();
        }

        public boolean reformatComments() {
            return false;
        }

        public boolean indentHtml() {
            return false;
        }

        public int getRightMargin() {
            return this.rightMargin;
        }
    }
}

