/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.EditorOptions;
import org.netbeans.modules.gsf.api.KeystrokeHandler;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.php.editor.indent.GeneratingBracketCompleter;
import org.netbeans.modules.php.editor.index.NbUtilities;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPBracketCompleter
implements KeystrokeHandler {
    static final boolean CONTINUE_COMMENTS = Boolean.getBoolean("php.cont.comment");
    private static final PHPTokenId[] STRING_TOKENS = new PHPTokenId[]{PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING, PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE};
    private int previousAdjustmentOffset = -1;
    private boolean isAfter;
    private int previousAdjustmentIndent;

    public boolean isInsertMatchingEnabled(BaseDocument baseDocument) {
        EditorOptions editorOptions = EditorOptions.get((String)"text/x-php5");
        if (editorOptions != null) {
            return editorOptions.getMatchBrackets();
        }
        return true;
    }

    public int beforeBreak(Document document, int n, JTextComponent jTextComponent) throws BadLocationException {
        int n2;
        int n3;
        boolean bl;
        this.isAfter = false;
        Caret caret = jTextComponent.getCaret();
        final BaseDocument baseDocument = (BaseDocument)document;
        boolean bl2 = this.isInsertMatchingEnabled(baseDocument);
        int n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        int n5 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        if (n4 == n && n5 == n) {
            return -1;
        }
        TokenSequence<? extends PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
        if (tokenSequence == null) {
            return -1;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return -1;
        }
        Token token = tokenSequence.token();
        TokenId tokenId = token.id();
        boolean[] blArray = new boolean[1];
        boolean[] blArray2 = new boolean[1];
        int[] nArray = new int[1];
        boolean bl3 = bl = bl2 && PHPBracketCompleter.isEndMissing(baseDocument, n, false, blArray, blArray2, null, nArray);
        if (bl) {
            boolean bl4 = blArray[0];
            boolean bl5 = blArray2[0];
            int n6 = nArray[0];
            int n7 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n);
            StringBuilder stringBuilder = new StringBuilder();
            if (n > n7) {
                stringBuilder.append("\n");
                LexUtilities.indent(stringBuilder, n6);
            } else {
                String string = baseDocument.getText(n, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n7) - n);
                stringBuilder.append(string);
                stringBuilder.append("\n");
                LexUtilities.indent(stringBuilder, n6);
                baseDocument.remove(n, string.length());
            }
            if (bl4) {
                stringBuilder.append("end");
            } else {
                assert (bl5);
                stringBuilder.append("}");
            }
            int n8 = n;
            baseDocument.insertString(n8, stringBuilder.toString(), null);
            caret.setDot(n8);
            return -1;
        }
        if ((tokenId == PHPTokenId.PHP_CURLY_CLOSE || LexUtilities.textEquals(token.text(), ']')) && Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n) == n) {
            n3 = LexUtilities.getLineIndent(baseDocument, n);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n");
            LexUtilities.indent(stringBuilder, n3);
            n2 = n;
            baseDocument.insertString(n2, stringBuilder.toString(), null);
            caret.setDot(n2);
        }
        if (tokenId == PHPTokenId.WHITESPACE && (n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n)) != -1 && n < n3) {
            tokenSequence.move(n3);
            if (tokenSequence.moveNext() && (tokenId = tokenSequence.token().id()) == PHPTokenId.PHP_LINE_COMMENT) {
                n = n3;
            }
        }
        if (tokenId == PHPTokenId.PHP_LINE_COMMENT) {
            Token<? extends PHPTokenId> token2;
            int n9;
            n3 = 0;
            int n10 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
            n2 = 0;
            int n11 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            if (n11 > 0 && (n9 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)(n11 - 1))) != -1 && (token2 = LexUtilities.getToken(baseDocument, n9)) != null && token2.id() == PHPTokenId.PHP_LINE_COMMENT) {
                n2 = 1;
            }
            if (n2 != 0 || n > n10) {
                Token<? extends PHPTokenId> token3;
                int n12;
                int n13;
                Token<? extends PHPTokenId> token4;
                if (tokenSequence.offset() + token.length() > n + 1) {
                    String string = baseDocument.getText(n, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) - n);
                    if (string.trim().length() != 0) {
                        n3 = 1;
                    }
                } else if (CONTINUE_COMMENTS && (token4 = LexUtilities.getToken(baseDocument, n10)) != null && token4.id() == PHPTokenId.PHP_LINE_COMMENT) {
                    n3 = 1;
                }
                if (n3 == 0 && (n13 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) + 1) < baseDocument.getLength() && (n12 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n13)) != -1 && (token3 = LexUtilities.getToken(baseDocument, n12)) != null && token3.id() == PHPTokenId.PHP_LINE_COMMENT) {
                    n3 = 1;
                }
            }
            if (n3 != 0) {
                int n14;
                int n15;
                int n16 = LexUtilities.getLineIndent(baseDocument, n);
                StringBuilder stringBuilder = new StringBuilder();
                LexUtilities.indent(stringBuilder, n16);
                stringBuilder.append("//");
                int n17 = n10 + 1;
                String string = baseDocument.getText(n17, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n17) - n17);
                for (n15 = 0; n15 < string.length() && ((n14 = string.charAt(n15)) == 32 || n14 == 9); ++n15) {
                    stringBuilder.append((char)n14);
                }
                n15 = n;
                if (n == n10 && n15 > 0) {
                    n15 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                    n14 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n) + stringBuilder.length();
                    baseDocument.insertString(n15, stringBuilder.toString(), null);
                    caret.setDot(n14);
                    return n14;
                }
                baseDocument.insertString(n15, stringBuilder.toString(), null);
                caret.setDot(n15);
                return n15 + stringBuilder.length() + 1;
            }
        }
        if (tokenId == PHPTokenId.PHPDOC_COMMENT || tokenId == PHPTokenId.PHPDOC_COMMENT_START || tokenId == PHPTokenId.PHPDOC_COMMENT_END) {
            final Object[] objectArray = PHPBracketCompleter.beforeBreakInComments(baseDocument, tokenSequence, n, caret, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END);
            boolean bl6 = (Boolean)objectArray[1];
            if (bl6) {
                n2 = LexUtilities.getLineIndent(baseDocument, tokenSequence.offset());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GeneratingBracketCompleter.generateDocTags(baseDocument, (Integer)objectArray[0], n2);
                    }
                });
            }
            return (Integer)objectArray[0];
        }
        if (tokenId == PHPTokenId.PHP_COMMENT || tokenId == PHPTokenId.PHP_COMMENT_START || tokenId == PHPTokenId.PHP_COMMENT_END) {
            Object[] objectArray = PHPBracketCompleter.beforeBreakInComments(baseDocument, tokenSequence, n, caret, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END);
            return (Integer)objectArray[0];
        }
        return -1;
    }

    private static Object[] beforeBreakInComments(BaseDocument baseDocument, TokenSequence<? extends PHPTokenId> tokenSequence, int n, Caret caret, PHPTokenId pHPTokenId, PHPTokenId pHPTokenId2, PHPTokenId pHPTokenId3) throws BadLocationException {
        PHPTokenId pHPTokenId4 = (PHPTokenId)tokenSequence.token().id();
        if (pHPTokenId4 == pHPTokenId2 || pHPTokenId4 == pHPTokenId) {
            int n2;
            int n3 = pHPTokenId4 == pHPTokenId ? tokenSequence.offset() + tokenSequence.token().length() : n;
            int n4 = LexUtilities.getLineIndent(baseDocument, tokenSequence.offset());
            int n5 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n3);
            boolean bl = !PHPBracketCompleter.isClosedComment(DocumentUtilities.getText((Document)baseDocument), n3);
            StringBuilder stringBuilder = new StringBuilder();
            if (n > n5) {
                LexUtilities.indent(stringBuilder, n4);
                stringBuilder.append(" * ");
                n2 = n3 + stringBuilder.length() + 1;
            } else {
                String string = baseDocument.getText(n3, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n5) - n3);
                LexUtilities.indent(stringBuilder, n4);
                stringBuilder.append(" * ");
                n2 = n3 + stringBuilder.length() + 1;
                stringBuilder.append(string);
                baseDocument.remove(n3, string.length());
            }
            if (bl) {
                stringBuilder.append("\n");
                LexUtilities.indent(stringBuilder, n4);
                stringBuilder.append(" */");
            }
            baseDocument.insertString(n3, stringBuilder.toString(), null);
            caret.setDot(n3);
            return new Object[]{n2, bl};
        }
        if (pHPTokenId4 == pHPTokenId3) {
            int n6 = tokenSequence.offset();
            if (tokenSequence.movePrevious()) {
                assert (tokenSequence.token().id() == pHPTokenId2 || tokenSequence.token().id() == pHPTokenId) : "PHP_COMMENT_END should not be preceeded by " + ((PHPTokenId)tokenSequence.token().id()).name();
            } else assert (false) : "PHP_COMMENT_END without PHP_COMMENT or PHP_COMMENT_START";
            int n7 = LexUtilities.getLineIndent(baseDocument, tokenSequence.offset());
            int n8 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n6);
            int n9 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n6);
            int n10 = n6;
            StringBuilder stringBuilder = new StringBuilder();
            if (n8 >= n6) {
                LexUtilities.indent(stringBuilder, n7);
                stringBuilder.append(" * ");
                n10 = n9 + stringBuilder.length();
                LexUtilities.indent(stringBuilder, n7);
                stringBuilder.append(" ");
                baseDocument.remove(n9, n6 - n9);
                n6 = n9;
            } else {
                LexUtilities.indent(stringBuilder, n7);
                stringBuilder.append(" ");
            }
            baseDocument.insertString(n6, stringBuilder.toString(), null);
            caret.setDot(n10);
            return new Object[]{n10, false};
        }
        return new Object[]{-1, false};
    }

    private static boolean isClosedComment(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c == '*' && i < n2 - 1 && charSequence.charAt(i + 1) == '/') {
                char c2;
                if (n3 == 0 || i < n2 - 2) {
                    return true;
                }
                boolean bl = true;
                for (int j = i + 2; j < n2 && (c2 = charSequence.charAt(j)) != '\n'; ++j) {
                    if (c2 != '\"' || j >= n2 - 1 || charSequence.charAt(j + 1) == '\'') continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return true;
            }
            if (c == '/' && i < n2 - 1 && charSequence.charAt(i + 1) == '*') {
                return false;
            }
            if (c == '\n') {
                n3 = 0;
                continue;
            }
            if (c != '\"' || i >= n2 - 1 || charSequence.charAt(i + 1) == '\'') continue;
            ++n3;
            n3 %= 2;
        }
        return false;
    }

    static boolean isEndMissing(BaseDocument baseDocument, int n, boolean bl, boolean[] blArray, boolean[] blArray2, int[] nArray, int[] nArray2) throws BadLocationException {
        int n2 = baseDocument.getLength();
        if (nArray != null) {
            nArray[0] = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        }
        int n3 = LexUtilities.getBeginEndLineBalance(baseDocument, n, true);
        int n4 = LexUtilities.getLineBalance(baseDocument, n, PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.PHP_CURLY_CLOSE);
        if (n3 == 1 || n4 == 1) {
            int n5 = LexUtilities.getLineIndent(baseDocument, n);
            boolean bl2 = n3 > 0;
            boolean bl3 = n4 > 0;
            int n6 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) + 1;
            while (n6 < n2) {
                if (!(Utilities.isRowEmpty((BaseDocument)baseDocument, (int)n6) || Utilities.isRowWhite((BaseDocument)baseDocument, (int)n6) || LexUtilities.isCommentOnlyLine(baseDocument, n6))) {
                    int n7 = LexUtilities.getLineIndent(baseDocument, n6);
                    if (n7 > n5) {
                        bl2 = false;
                        bl3 = false;
                        break;
                    }
                    if (n7 != n5) break;
                    if (bl2) {
                        if (LexUtilities.getBeginEndLineBalance(baseDocument, n6, false) < 0) {
                            bl2 = false;
                            break;
                        }
                        int n8 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n6);
                        Token<? extends PHPTokenId> token = LexUtilities.getToken(baseDocument, n8);
                        if (token == null || !LexUtilities.isIndentEndToken((PHPTokenId)token.id())) break;
                        bl2 = false;
                        break;
                    }
                    if (!bl3 || LexUtilities.getLineBalance(baseDocument, n6, PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.PHP_CURLY_CLOSE) >= 0) break;
                    bl3 = false;
                    break;
                }
                n6 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n6) + 1;
            }
            if (blArray != null) {
                blArray[0] = bl2;
            }
            if (blArray2 != null) {
                blArray2[0] = bl3;
            }
            if (nArray2 != null) {
                nArray2[0] = n5;
            }
            return bl2 || bl3;
        }
        return false;
    }

    public boolean beforeCharInserted(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        String string;
        TokenSequence<? extends PHPTokenId> tokenSequence;
        Object object;
        this.isAfter = false;
        Caret caret = jTextComponent.getCaret();
        BaseDocument baseDocument = (BaseDocument)document;
        if (!this.isInsertMatchingEnabled(baseDocument)) {
            return false;
        }
        if (n == 0) {
            return false;
        }
        if (jTextComponent.getSelectionStart() != -1) {
            String string2;
            char c2;
            if (NbUtilities.isCodeTemplateEditing((Document)baseDocument)) {
                int n2 = jTextComponent.getSelectionStart();
                if (n2 < (c2 = jTextComponent.getSelectionEnd())) {
                    jTextComponent.setSelectionStart(n2);
                    jTextComponent.setSelectionEnd(n2);
                    n = n2;
                    caret.setDot(n);
                    baseDocument.remove(n2, c2 - n2);
                }
            } else if ((c == '\"' || c == '\'' || c == '(' || c == '{' || c == '[' || c == '/') && (string2 = jTextComponent.getSelectedText()) != null && string2.length() > 0 && (c2 = (char)string2.charAt(0)) != c) {
                int n3 = jTextComponent.getSelectionStart();
                int n4 = jTextComponent.getSelectionEnd();
                object = LexUtilities.getPositionedSequence(baseDocument, n3);
                if (!(object == null || PHPBracketCompleter.isStringToken((Token<? extends PHPTokenId>)object.token()) && c2 != '\"' && c2 != '\'')) {
                    char c3 = string2.charAt(string2.length() - 1);
                    if (string2.length() > 1 && (c2 == '\"' || c2 == '\'' || c2 == '(' || c2 == '{' || c2 == '[' || c2 == '/') && c3 == this.matching(c2)) {
                        baseDocument.remove(n4 - 1, 1);
                        baseDocument.insertString(n4 - 1, Character.toString(this.matching(c)), null);
                        baseDocument.remove(n3, 1);
                        baseDocument.insertString(n3, Character.toString(c), null);
                        jTextComponent.getCaret().setDot(n4);
                    } else {
                        baseDocument.remove(n3, n4 - n3);
                        baseDocument.insertString(n3, c + string2 + this.matching(c), null);
                        jTextComponent.getCaret().setDot(n3 + string2.length() + 2);
                    }
                    return true;
                }
            }
        }
        if ((tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n)) == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return false;
        }
        Token token = tokenSequence.token();
        TokenId tokenId = token.id();
        PHPTokenId[] pHPTokenIdArray = null;
        object = null;
        if (tokenId == PHPTokenId.PHP_LINE_COMMENT && jTextComponent.getSelectionStart() != -1 && (c == '*' || c == '+' || c == '_') && (string = jTextComponent.getSelectedText()) != null && string.length() > 0 && string.charAt(0) != c && string.indexOf(32) == -1) {
            int n5 = jTextComponent.getSelectionStart();
            baseDocument.remove(n5, jTextComponent.getSelectionEnd() - n5);
            baseDocument.insertString(n5, c + string + this.matching(c), null);
            jTextComponent.getCaret().setDot(n5 + string.length() + 2);
            return true;
        }
        if (c == '\"') {
            pHPTokenIdArray = STRING_TOKENS;
            object = PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING;
        } else if (c == '\'') {
            pHPTokenIdArray = STRING_TOKENS;
            object = PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING;
        }
        if (pHPTokenIdArray != null) {
            boolean bl = this.completeQuote(baseDocument, n, c);
            if (bl) {
                caret.setDot(n + 1);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean afterCharInserted(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        TokenSequence<? extends PHPTokenId> tokenSequence;
        this.isAfter = true;
        Caret caret = jTextComponent.getCaret();
        BaseDocument baseDocument = (BaseDocument)document;
        if (this.previousAdjustmentOffset != -1) {
            if (n == this.previousAdjustmentOffset && (tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n)) != null) {
                tokenSequence.move(n);
                if (tokenSequence.moveNext() && tokenSequence.offset() < n) {
                    LexUtilities.setLineIndentation(baseDocument, n, this.previousAdjustmentIndent);
                }
            }
            this.previousAdjustmentOffset = -1;
        }
        switch (c) {
            case '(': 
            case ')': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                if (!this.isInsertMatchingEnabled(baseDocument)) {
                    return false;
                }
                tokenSequence = LexUtilities.getToken(baseDocument, n);
                if (tokenSequence == null) {
                    return true;
                }
                TokenId tokenId = tokenSequence.id();
                if (tokenId == PHPTokenId.PHP_VARIABLE && tokenSequence.length() == 1 || LexUtilities.textEquals(tokenSequence.text(), '[') || LexUtilities.textEquals(tokenSequence.text(), ']') || LexUtilities.textEquals(tokenSequence.text(), '(') || LexUtilities.textEquals(tokenSequence.text(), ')')) {
                    if (c == ']' || c == ')') {
                        this.skipClosingBracket(baseDocument, caret, c);
                    } else if (c == '[' || c == '(') {
                        this.completeOpeningBracket(baseDocument, n, caret, c);
                    }
                }
                if (c != '}') break;
                this.reindent(baseDocument, n, PHPTokenId.PHP_CURLY_CLOSE, caret);
            }
        }
        return true;
    }

    private boolean isBlockDefinition(BaseDocument baseDocument, int n) throws BadLocationException {
        TokenSequence<? extends PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
        int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        tokenSequence.move(n + 1);
        while (tokenSequence.movePrevious() && tokenSequence.offset() >= n2) {
            TokenId tokenId = tokenSequence.token().id();
            if (tokenId == PHPTokenId.PHP_DO || tokenId == PHPTokenId.PHP_CURLY_OPEN) {
                return true;
            }
            if (tokenId != PHPTokenId.PHP_CURLY_CLOSE) continue;
            break;
        }
        return false;
    }

    private void reindent(BaseDocument baseDocument, int n, TokenId tokenId, Caret caret) throws BadLocationException {
        TokenSequence<? extends PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
        if (tokenSequence != null) {
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return;
            }
            Token token = tokenSequence.token();
            if (token.id() == tokenId) {
                int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                if (tokenSequence.offset() > n2) {
                    return;
                }
                OffsetRange offsetRange = tokenId == PHPTokenId.PHP_CURLY_CLOSE ? LexUtilities.findBwd(baseDocument, tokenSequence, '{', '}') : LexUtilities.findBegin(baseDocument, tokenSequence);
                if (offsetRange != OffsetRange.NONE) {
                    int n3 = offsetRange.getStart();
                    int n4 = LexUtilities.getLineIndent(baseDocument, n3);
                    this.previousAdjustmentIndent = LexUtilities.getLineIndent(baseDocument, n);
                    LexUtilities.setLineIndentation(baseDocument, n, n4);
                    this.previousAdjustmentOffset = caret.getDot();
                }
            }
        }
    }

    public OffsetRange findMatching(Document document, int n) {
        BaseDocument baseDocument = (BaseDocument)document;
        TokenSequence<? extends PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
        if (tokenSequence != null) {
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) {
                return OffsetRange.NONE;
            }
            Token token = tokenSequence.token();
            if (token == null) {
                return OffsetRange.NONE;
            }
            TokenId tokenId = token.id();
            if (tokenId == PHPTokenId.WHITESPACE) {
                tokenSequence.move(++n);
                if (tokenSequence.moveNext() && tokenSequence.offset() <= n) {
                    token = tokenSequence.token();
                    tokenId = token.id();
                }
            }
            if (LexUtilities.textEquals(token.text(), '(')) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, '(', ')');
            }
            if (LexUtilities.textEquals(token.text(), ')')) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, '(', ')');
            }
            if (tokenId == PHPTokenId.PHP_CURLY_OPEN) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, '{', '}');
            }
            if (tokenId == PHPTokenId.PHP_CURLY_CLOSE) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, '{', '}');
            }
            if (LexUtilities.textEquals(token.text(), '[')) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, '[', ']');
            }
            if (LexUtilities.textEquals(token.text(), ']')) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, '[', ']');
            }
        }
        return OffsetRange.NONE;
    }

    public boolean charBackspaced(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)document;
        switch (c) {
            case ' ': {
                TokenSequence<? extends PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious() || tokenSequence.offset() != n - 1 || tokenSequence.token().id() != PHPTokenId.PHP_LINE_COMMENT) break;
                baseDocument.remove(n - 1, 1);
                jTextComponent.getCaret().setDot(n - 1);
                return true;
            }
            case '(': 
            case '[': 
            case '{': {
                char c2 = LexUtilities.getTokenChar(baseDocument, n);
                if (!(c2 == ']' && LexUtilities.getTokenBalance(baseDocument, '[', ']', n) != 0 || c2 == ')' && LexUtilities.getTokenBalance(baseDocument, '(', ')', n) != 0) && (c2 != '}' || LexUtilities.getTokenBalance(baseDocument, '{', '}', n) == 0)) break;
                baseDocument.remove(n, 1);
                break;
            }
            case '\"': 
            case '\'': {
                char[] cArray = baseDocument.getChars(n, 1);
                if (cArray == null || cArray[0] != c) break;
                baseDocument.remove(n, 1);
            }
        }
        return true;
    }

    private void skipClosingBracket(BaseDocument baseDocument, Caret caret, char c) throws BadLocationException {
        int n = caret.getDot();
        if (this.isSkipClosingBracket(baseDocument, n, c)) {
            baseDocument.remove(n - 1, 1);
            caret.setDot(n);
        }
    }

    private boolean isSkipClosingBracket(BaseDocument baseDocument, int n, char c) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return false;
        }
        boolean bl = false;
        TokenSequence<? extends PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return false;
        }
        Token token = tokenSequence.token();
        if (token != null && LexUtilities.textEquals(token.text(), c)) {
            char c2 = c == ')' ? (char)'(' : (c == ']' ? (char)'[' : '{');
            tokenSequence.moveNext();
            Token token2 = tokenSequence.token();
            while (token2 != null && LexUtilities.textEquals(token2.text(), c)) {
                token = token2;
                if (!tokenSequence.moveNext()) break;
                token2 = tokenSequence.token();
            }
            int n2 = 0;
            int n3 = -1;
            Token token3 = token;
            tokenSequence.movePrevious();
            token = tokenSequence.token();
            boolean bl2 = false;
            while (!bl2 && token != null) {
                if (LexUtilities.textEquals(token.text(), '(') || LexUtilities.textEquals(token.text(), '[')) {
                    if (LexUtilities.textEquals(token.text(), c2) && ++n3 == 0) {
                        if (n2 != 0) {
                            n3 = 1;
                        }
                        bl2 = true;
                    }
                } else if (LexUtilities.textEquals(token.text(), ']') || LexUtilities.textEquals(token.text(), ']')) {
                    if (LexUtilities.textEquals(token.text(), c)) {
                        --n3;
                    }
                } else if (token.id() == PHPTokenId.PHP_CURLY_OPEN) {
                    if (++n2 > 0) {
                        bl2 = true;
                    }
                } else if (token.id() == PHPTokenId.PHP_CURLY_CLOSE) {
                    --n2;
                }
                if (!tokenSequence.movePrevious()) break;
                token = tokenSequence.token();
            }
            if (n3 != 0) {
                bl = true;
            } else {
                n2 = 0;
                n3 = 1;
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                int n4 = token3.offset(tokenHierarchy);
                tokenSequence.move(n4);
                tokenSequence.moveNext();
                token = tokenSequence.token();
                bl2 = false;
                while (!bl2 && token != null) {
                    if (LexUtilities.textEquals(token.text(), '(') || LexUtilities.textEquals(token.text(), '[')) {
                        if (LexUtilities.textEquals(token.text(), c2)) {
                            ++n3;
                        }
                    } else if (LexUtilities.textEquals(token.text(), ')') || LexUtilities.textEquals(token.text(), ']')) {
                        if (LexUtilities.textEquals(token.text(), c) && --n3 == 0) {
                            if (n2 != 0) {
                                n3 = -1;
                            }
                            bl2 = true;
                        }
                    } else if (token.id() == PHPTokenId.PHP_CURLY_OPEN) {
                        ++n2;
                    } else if (token.id() == PHPTokenId.PHP_CURLY_CLOSE && --n2 < 0) {
                        bl2 = true;
                    }
                    if (!tokenSequence.movePrevious()) break;
                    token = tokenSequence.token();
                }
                bl = n3 == 0;
            }
        }
        return bl;
    }

    private void completeOpeningBracket(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (this.isCompletablePosition(baseDocument, n + 1)) {
            String string = "" + this.matching(c);
            baseDocument.insertString(n + 1, string, null);
            caret.setDot(n + 1);
        }
    }

    private boolean isEscapeSequence(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n <= 0) {
            return false;
        }
        char c = baseDocument.getChars(n - 1, 1)[0];
        return c == '\\';
    }

    private boolean completeQuote(BaseDocument baseDocument, int n, char c) throws BadLocationException {
        Token token;
        if (this.isEscapeSequence(baseDocument, n)) {
            return false;
        }
        Object[] objectArray = PHPBracketCompleter.findPhpSectionBoundaries(baseDocument, n, true);
        if (objectArray == null) {
            return false;
        }
        TokenSequence tokenSequence = (TokenSequence)objectArray[0];
        int n2 = (Integer)objectArray[1];
        int n3 = (Integer)objectArray[2];
        boolean bl = (Boolean)objectArray[3];
        boolean bl2 = (Boolean)objectArray[4];
        Token token2 = tokenSequence.token();
        Token token3 = token = tokenSequence.movePrevious() ? tokenSequence.token() : null;
        if (token2.id() == PHPTokenId.PHP_COMMENT || token2.id() == PHPTokenId.PHP_LINE_COMMENT || token2.id() == PHPTokenId.PHPDOC_COMMENT || token2.id() == PHPTokenId.T_INLINE_HTML) {
            return false;
        }
        if (bl2 && token != null && token.id() == PHPTokenId.PHP_LINE_COMMENT) {
            return false;
        }
        boolean bl3 = PHPBracketCompleter.isStringToken((Token<? extends PHPTokenId>)token2);
        if (!bl3 && bl2 && token != null && PHPBracketCompleter.isStringToken((Token<? extends PHPTokenId>)token)) {
            bl3 = true;
        }
        if (bl3) {
            if (bl2) {
                return false;
            }
            char c2 = baseDocument.getChars(n, 1)[0];
            if (c2 == c) {
                if (!this.isAfter) {
                    baseDocument.insertString(n, "" + c, null);
                } else if (n >= baseDocument.getLength() - 1 || baseDocument.getText(n + 1, 1).charAt(0) != c) {
                    return true;
                }
                baseDocument.remove(n, 1);
                return true;
            }
        } else {
            int n4;
            boolean bl4 = bl2;
            if (!bl4 && (n4 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n, (int)n3)) != -1) {
                char c3 = baseDocument.getChars(n4, 1)[0];
                boolean bl5 = bl4 = c3 == ')' || c3 == ',' || c3 == '+' || c3 == '}' || c3 == ';' || c3 == ']' || c3 == '/' || c3 == '.';
            }
            if (bl4) {
                baseDocument.insertString(n, "" + c + (this.isAfter ? "" : Character.valueOf(this.matching(c))), null);
                return true;
            }
        }
        return false;
    }

    private static Object[] findPhpSectionBoundaries(BaseDocument baseDocument, int n, boolean bl) {
        TokenSequence<? extends PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return null;
        }
        int n2 = 0;
        int n3 = baseDocument.getLength();
        if (bl) {
            n2 = baseDocument.getParagraphElement(n).getStartOffset();
            n3 = Math.max(baseDocument.getParagraphElement(n).getEndOffset() - 1, n2);
        }
        int n4 = n3;
        boolean bl2 = true;
        while (n3 >= tokenSequence.offset()) {
            if (tokenSequence.token().id() == PHPTokenId.PHP_CLOSETAG) {
                n4 = tokenSequence.offset();
                break;
            }
            if (tokenSequence.token().id() != PHPTokenId.WHITESPACE) {
                bl2 = false;
            }
            if (tokenSequence.moveNext()) continue;
        }
        int n5 = n2;
        boolean bl3 = true;
        while (tokenSequence.movePrevious() && n2 <= tokenSequence.offset()) {
            if (tokenSequence.token().id() == PHPTokenId.PHP_OPENTAG) {
                n5 = tokenSequence.offset();
                break;
            }
            if (tokenSequence.token().id() == PHPTokenId.WHITESPACE) continue;
            bl3 = false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) assert (tokenSequence.movePrevious());
        assert (n5 != -1 && n4 != -1) : "sectionStart=" + n5 + ", sectionEnd=" + n4;
        return new Object[]{tokenSequence, n5, n4, bl3, bl2};
    }

    private static boolean isStringToken(Token<? extends PHPTokenId> token) {
        for (PHPTokenId pHPTokenId : STRING_TOKENS) {
            if (token.id() != pHPTokenId) continue;
            return true;
        }
        return false;
    }

    private boolean isCompletablePosition(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return true;
        }
        char c = baseDocument.getChars(n, 1)[0];
        return c == ')' || c == ',' || c == '\"' || c == '\'' || c == ' ' || c == ']' || c == '}' || c == '\n' || c == '\t' || c == ';';
    }

    private char matching(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case '/': {
                return '/';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
        }
        return c;
    }

    public List<OffsetRange> findLogicalRanges(CompilationInfo compilationInfo, int n) {
        return Collections.emptyList();
    }

    public int getNextWordOffset(Document document, int n, boolean bl) {
        BaseDocument baseDocument = (BaseDocument)document;
        TokenSequence<? extends PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
        if (tokenSequence == null) {
            return -1;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return -1;
        }
        if (bl && tokenSequence.offset() == n && !tokenSequence.movePrevious()) {
            return -1;
        }
        Token token = tokenSequence.token();
        TokenId tokenId = token.id();
        if (tokenId == PHPTokenId.WHITESPACE) {
            int n2;
            if (bl && tokenSequence.offset() < n || !bl && tokenSequence.offset() > n) {
                return tokenSequence.offset();
            }
            while (tokenId == PHPTokenId.WHITESPACE) {
                if (bl && !tokenSequence.movePrevious()) {
                    return -1;
                }
                if (!bl && !tokenSequence.moveNext()) {
                    return -1;
                }
                token = tokenSequence.token();
                tokenId = token.id();
            }
            if (bl ? (n2 = tokenSequence.offset() + token.length()) < n : (n2 = tokenSequence.offset()) > n) {
                return n2;
            }
        }
        if (tokenId == PHPTokenId.PHP_VARIABLE) {
            char c;
            int n3;
            String string = ((Object)token.text()).toString();
            int n4 = string.length();
            int n5 = n - tokenSequence.offset();
            if (bl) {
                int n6 = n - 1 - tokenSequence.offset();
                if (n6 < 0) {
                    return -1;
                }
                if (n6 < n4 && Character.isUpperCase(string.charAt(n6))) {
                    for (int i = n6 - 1; i >= 0; --i) {
                        char c2 = string.charAt(i);
                        if (c2 == '_') {
                            return tokenSequence.offset() + i + 1;
                        }
                        if (Character.isUpperCase(c2)) continue;
                        return tokenSequence.offset() + i + 1;
                    }
                    return tokenSequence.offset();
                }
                for (int i = n6 - 1; i >= 0; --i) {
                    char c3 = string.charAt(i);
                    if (c3 == '_') {
                        return tokenSequence.offset() + i + 1;
                    }
                    if (!Character.isUpperCase(c3)) continue;
                    for (int j = i; j >= 0; --j) {
                        char c4 = string.charAt(j);
                        if (c4 == '_') {
                            return tokenSequence.offset() + j + 1;
                        }
                        if (Character.isUpperCase(c4)) continue;
                        return tokenSequence.offset() + j + 1;
                    }
                    return tokenSequence.offset();
                }
                return tokenSequence.offset();
            }
            int n7 = n5 + 1;
            if (n5 < 0 || n5 >= string.length()) {
                return -1;
            }
            if (Character.isUpperCase(string.charAt(n5))) {
                for (n3 = n7; n3 < n4 && Character.isUpperCase(c = string.charAt(n3)); ++n3) {
                    if (string.charAt(n3) == '_') {
                        return tokenSequence.offset() + n3;
                    }
                    ++n7;
                }
            }
            for (n3 = n7; n3 < n4; ++n3) {
                c = string.charAt(n3);
                if (c != '_' && !Character.isUpperCase(c)) continue;
                return tokenSequence.offset() + n3;
            }
        }
        return -1;
    }
}

