/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.SourceModelFactory;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSCompletion
implements CompletionProvider {
    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        return new AsyncCompletionTask(new AsyncCompletionQuery(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void query(final CompletionResultSet completionResultSet, Document document, final int n) {
                try {
                    FileObject fileObject = NavUtils.getFile(document);
                    if (fileObject == null) {
                        return;
                    }
                    final List list = PhpSourcePath.getIncludePath((FileObject)fileObject);
                    SourceModelFactory.getInstance().getModel(fileObject).runUserActionTask((CancellableTask)new CancellableTask<CompilationInfo>(){

                        public void cancel() {
                        }

                        public void run(CompilationInfo compilationInfo) throws Exception {
                            List<ASTNode> list2 = NavUtils.underCaret(compilationInfo, n);
                            if (list2.size() < 2) {
                                return;
                            }
                            ASTNode aSTNode = list2.get(list2.size() - 1);
                            ASTNode aSTNode2 = list2.get(list2.size() - 2);
                            if (aSTNode2 instanceof ParenthesisExpression) {
                                if (list2.size() < 3) {
                                    return;
                                }
                                aSTNode2 = list2.get(list2.size() - 3);
                            }
                            if (!(aSTNode instanceof Scalar) || !(aSTNode2 instanceof Include)) {
                                return;
                            }
                            Scalar scalar = (Scalar)aSTNode;
                            if (scalar.getScalarType() != Scalar.Type.STRING || !NavUtils.isQuoted(scalar.getStringValue())) {
                                return;
                            }
                            int n2 = scalar.getStartOffset() + 1;
                            String string = compilationInfo.getText().substring(n2, n);
                            LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
                            linkedList.addAll(list);
                            linkedList.add(compilationInfo.getFileObject().getParent());
                            completionResultSet.addAllItems((Collection)FSCompletion.computeRelativeItems(linkedList, string, n2, new PHPIncludesFilter()));
                        }
                    }, true);
                }
                catch (IOException iOException) {
                    Logger.getLogger(FSCompletion.class.getName()).log(Level.WARNING, null, iOException);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                finally {
                    completionResultSet.finish();
                }
            }
        }, jTextComponent);
    }

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private static List<? extends CompletionItem> computeRelativeItems(Collection<? extends FileObject> collection, String string, int n, FileObjectFilter fileObjectFilter) throws IOException {
        String string2;
        String string3;
        assert (collection != null);
        LinkedList<FSCompletionItem> linkedList = new LinkedList<FSCompletionItem>();
        int n2 = string.lastIndexOf(47);
        if (n2 != -1) {
            string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
        } else {
            string3 = null;
            string2 = string;
        }
        HashSet<void> hashSet = new HashSet<void>();
        for (FileObject fileObject : collection) {
            void fileObject2;
            if (string3 != null) {
                FileObject fileObject3 = fileObject.getFileObject(string3);
            }
            if (fileObject2 == null) continue;
            hashSet.add(fileObject2);
        }
        for (FileObject fileObject : hashSet) {
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject4 = fileObjectArray[i];
                if (!VisibilityQuery.getDefault().isVisible(fileObject4) || !fileObject4.getNameExt().startsWith(string2) || !fileObjectFilter.accept(fileObject4)) continue;
                linkedList.add(new FSCompletionItem(fileObject4, string3 != null ? string3 + "/" : "", n));
            }
        }
        return linkedList;
    }

    static interface FileObjectFilter {
        public boolean accept(FileObject var1);
    }

    static final class FSCompletionItem
    implements CompletionItem {
        private FileObject file;
        private ImageIcon icon;
        private int anchor;
        private String toAdd;
        private String prefix;

        public FSCompletionItem(FileObject fileObject, String string, int n) throws IOException {
            this.file = fileObject;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            this.icon = new ImageIcon(dataObject.getNodeDelegate().getIcon(1));
            this.anchor = n;
            this.prefix = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doSubstitute(JTextComponent jTextComponent, String string, int n) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            int n2 = jTextComponent.getCaretPosition();
            String string2 = this.getText();
            if (string != null) {
                string2 = string2 + string;
            }
            baseDocument.atomicLock();
            try {
                String string3 = baseDocument.getText(this.anchor, n2 - this.anchor);
                baseDocument.remove(n2 - string3.length(), string3.length());
                baseDocument.insertString(n2 - string3.length(), string2, null);
                jTextComponent.setCaretPosition(jTextComponent.getCaretPosition() - n);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            finally {
                baseDocument.atomicUnlock();
            }
        }

        public void defaultAction(JTextComponent jTextComponent) {
            this.doSubstitute(jTextComponent, null, 0);
            if (!this.file.isFolder()) {
                Completion.get().hideAll();
            }
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 400) {
                String string = null;
                switch (keyEvent.getKeyChar()) {
                    case '/': {
                        if (string == null) {
                            string = "/";
                        }
                        this.doSubstitute((JTextComponent)keyEvent.getSource(), string, string.length() - 1);
                        keyEvent.consume();
                    }
                }
            }
        }

        public int getPreferredWidth(Graphics graphics, Font font) {
            return CompletionUtilities.getPreferredWidth((String)this.file.getNameExt(), null, (Graphics)graphics, (Font)font);
        }

        public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
            CompletionUtilities.renderHtml((ImageIcon)this.icon, (String)this.file.getNameExt(), null, (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
        }

        public CompletionTask createDocumentationTask() {
            return null;
        }

        public CompletionTask createToolTipTask() {
            return null;
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return false;
        }

        public int getSortPriority() {
            return -1000;
        }

        public CharSequence getSortText() {
            return this.getText();
        }

        public CharSequence getInsertPrefix() {
            return this.getText();
        }

        private String getText() {
            return this.prefix + this.file.getNameExt() + (this.file.isFolder() ? "/" : "");
        }

        public int hashCode() {
            return this.getText().hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof FSCompletionItem)) {
                return false;
            }
            FSCompletionItem fSCompletionItem = (FSCompletionItem)object;
            return this.getText().equals(fSCompletionItem.getText());
        }
    }

    private static class PHPIncludesFilter
    implements FileObjectFilter {
        private PHPIncludesFilter() {
        }

        public boolean accept(FileObject fileObject) {
            if (fileObject.isFolder()) {
                return true;
            }
            String string = FileUtil.getMIMEType((FileObject)fileObject);
            return string != null && string.startsWith("text/");
        }
    }
}

