/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.settings;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;

public class CppSettings
extends SharedClassObject {
    static final long serialVersionUID = -2942467713237077336L;
    public static final int DEFAULT_PARSING_DELAY = 2000;
    private static final boolean DEFAULT_FORTRAN_ENABLED = true;
    public static final String PROP_PARSING_DELAY = "parsingDelay";
    public static final String PROP_REPLACEABLE_STRINGS_TABLE = "replaceableStringsTable";
    public static final String PROP_FREE_FORMAT_FORTRAN = "freeFormatFortran";
    public static final String PROP_FORTRAN_ENABLED = "fortranEnabled";
    public static final String PROP_MAKE_NAME = "makeName";
    public static final String PROP_MAKE_PATH = "makePath";
    public static final String PROP_GDB_NAME = "gdbName";
    public static final String PROP_GDB_PATH = "gdbPath";
    public static final String PROP_COMPILER_SET_NAME = "compilerSetName";
    public static final String PROP_COMPILER_SET_DIRECTORIES = "compilerSetDirectories";
    public static final String PROP_C_COMPILER_NAME = "cCompilerName";
    public static final String PROP_CPP_COMPILER_NAME = "cppCompilerName";
    public static final String PROP_FORTRAN_COMPILER_NAME = "fortranCompilerName";
    public static final String PROP_GDB_REQUIRED = "gdbRequired";
    public static final String PROP_C_REQUIRED = "cRequired";
    public static final String PROP_CPP_REQUIRED = "cppRequired";
    public static final String PROP_FORTRAN_REQUIRED = "fortranRequired";
    public static final String PROP_ARRAY_REPEAT_THRESHOLD = "arrayRepeatThreshold";
    public static ResourceBundle bundle;
    private static CppSettings cppSettings;

    protected void initialize() {
        super.initialize();
    }

    public static CppSettings getDefault() {
        if (cppSettings == null) {
            cppSettings = (CppSettings)CppSettings.findObject(CppSettings.class, (boolean)true);
        }
        return cppSettings;
    }

    public String getCompilerSetName() {
        String string = this.getPreferences().get(PROP_COMPILER_SET_NAME, null);
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setCompilerSetName(String string) {
        String string2 = this.getCompilerSetName();
        if (string2 == null || !string2.equals(string)) {
            this.getPreferences().put(PROP_COMPILER_SET_NAME, string);
            this.firePropertyChange(PROP_COMPILER_SET_NAME, string2, string);
        }
    }

    public String getGdbName() {
        String string = this.getPreferences().get(PROP_GDB_NAME, null);
        if (string == null) {
            return "gdb";
        }
        return string;
    }

    public void setGdbName(String string) {
        String string2 = this.getGdbName();
        if (!string2.equals(string)) {
            this.getPreferences().put(PROP_GDB_NAME, string);
            this.firePropertyChange(PROP_GDB_NAME, string2, string);
        }
    }

    public String getGdbPath() {
        String string = this.getPreferences().get(PROP_GDB_PATH, null);
        if (string == null) {
            if (Utilities.isWindows()) {
                return "C:\\Cygwin\\bin\\gdb.exe";
            }
            return "/usr/bin/gdb";
        }
        return string;
    }

    public void setGdbPath(String string) {
        String string2 = this.getGdbPath();
        if (!string2.equals(string)) {
            this.getPreferences().put(PROP_GDB_PATH, string);
            this.firePropertyChange(PROP_GDB_PATH, string2, string);
        }
    }

    public int getParsingDelay() {
        int n = this.getPreferences().getInt(PROP_PARSING_DELAY, 2000);
        return n;
    }

    public void setParsingDelay(int n) {
        if (n != 0 && n < 1000) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, CppSettings.getString("INVALID_AUTO_PARSING_DELAY"));
            throw illegalArgumentException;
        }
        int n2 = this.getParsingDelay();
        this.getPreferences().putInt(PROP_PARSING_DELAY, n);
        this.firePropertyChange(PROP_PARSING_DELAY, new Integer(n2), new Integer(n));
    }

    public void setReplaceableStringsTable(String string) {
        String string2 = this.getReplaceableStringsTable();
        if (string2.equals(string)) {
            return;
        }
        this.getPreferences().put(PROP_REPLACEABLE_STRINGS_TABLE, string);
        this.firePropertyChange(PROP_REPLACEABLE_STRINGS_TABLE, string2, string);
    }

    public String getReplaceableStringsTable() {
        String string = this.getPreferences().get(PROP_REPLACEABLE_STRINGS_TABLE, null);
        if (string == null) {
            return "USER=" + System.getProperty("user.name");
        }
        return string;
    }

    public Properties getReplaceableStringsProps() {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(this.getReplaceableStringsTable().getBytes()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public boolean isFortranEnabled() {
        boolean bl = this.getPreferences().getBoolean(PROP_FORTRAN_ENABLED, true);
        return bl;
    }

    public void setFortranEnabled(boolean bl) {
        boolean bl2 = this.isFortranEnabled();
        this.getPreferences().putBoolean(PROP_FORTRAN_ENABLED, bl);
        this.firePropertyChange(PROP_FORTRAN_ENABLED, new Boolean(bl2), new Boolean(bl));
    }

    public boolean isFreeFormatFortran() {
        boolean bl = this.getPreferences().getBoolean(PROP_FREE_FORMAT_FORTRAN, true);
        return bl;
    }

    public void setFreeFormatFortran(boolean bl) {
        boolean bl2 = this.isFreeFormatFortran();
        this.getPreferences().putBoolean(PROP_FREE_FORMAT_FORTRAN, bl);
        this.firePropertyChange(PROP_FREE_FORMAT_FORTRAN, new Boolean(bl2), new Boolean(bl));
    }

    public boolean isGdbRequired() {
        return this.getPreferences().getBoolean(PROP_GDB_REQUIRED, false);
    }

    public void setGdbRequired(boolean bl) {
        boolean bl2 = this.isGdbRequired();
        this.getPreferences().putBoolean(PROP_GDB_REQUIRED, bl);
        this.firePropertyChange(PROP_GDB_REQUIRED, new Boolean(bl2), new Boolean(bl));
    }

    public int getArrayRepeatThreshold() {
        return this.getPreferences().getInt(PROP_ARRAY_REPEAT_THRESHOLD, 10);
    }

    public void setArrayRepeatThreshold(int n) {
        int n2 = this.getArrayRepeatThreshold();
        if (n2 != n) {
            this.getPreferences().putInt(PROP_ARRAY_REPEAT_THRESHOLD, n);
            this.firePropertyChange(PROP_ARRAY_REPEAT_THRESHOLD, n2, n);
        }
    }

    public String displayName() {
        return CppSettings.getString("OPTION_CPP_SETTINGS_NAME");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Welcome_opt_editing_sources");
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(CppSettings.class);
    }

    public ResourceBundle getBundle() {
        return bundle;
    }

    static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(CppSettings.class);
        }
        return bundle.getString(string);
    }

    static {
        cppSettings = null;
    }
}

