/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.makewizard.TargetData;

public class CreateTargetsPanel
extends MakefileWizardPanel
implements FocusListener {
    static final long serialVersionUID = -8649616207466524363L;
    private JLabel nameLabel;
    private JTextField nameText;
    private JButton nameChooser;
    private JRadioButton executable;
    private JRadioButton archive;
    private JRadioButton sharedLib;
    private JRadioButton recursiveMake;
    private JRadioButton customTarget;
    private ButtonGroup typeBG;
    private JButton addBtn;
    private JButton removeBtn;
    private JButton changeBtn;
    private JLabel listLabel;
    private JScrollPane listSP;
    private JList list;
    private boolean initialized;
    private JButton nextButton;
    private int newKey;
    private MakefileWizard wiz;
    protected JFileChooser fc;
    private Component inFocus = null;

    CreateTargetsPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        this.wiz = makefileWizard;
        String string = this.getString("LBL_CreateTargetsPanel");
        this.setSubTitle(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.nextButton = null;
        this.initialized = false;
    }

    private void create() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        Insets insets = gridBagConstraints.insets;
        this.nextButton = MakefileWizard.getMakefileWizard().getNextButton();
        this.nameLabel = new JLabel(this.getString("LBL_TargetName"));
        this.nameLabel.setDisplayedMnemonic(this.getString("MNEM_TargetName").charAt(0));
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameText = new JTextField();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 11, 0, 5);
        this.add((Component)this.nameText, gridBagConstraints);
        this.nameLabel.setLabelFor(this.nameText);
        this.nameChooser = new JButton(this.getString("BTN_Chooser"));
        this.nameChooser.setMnemonic(this.getString("MNEM_Chooser").charAt(0));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.nameChooser, gridBagConstraints);
        this.createChooser(this.nameChooser);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.executable = new JRadioButton(this.getString("RB_Executable"));
        this.executable.setSelected(true);
        this.executable.setMnemonic(this.getString("MNEM_Executable").charAt(0));
        this.add((Component)this.executable, gridBagConstraints);
        gridBagConstraints.insets = insets;
        this.archive = new JRadioButton(this.getString("RB_StaticLibrary"));
        this.archive.setMnemonic(this.getString("MNEM_StaticLibrary").charAt(0));
        this.add((Component)this.archive, gridBagConstraints);
        this.sharedLib = new JRadioButton(this.getString("RB_SharedLibrary"));
        this.sharedLib.setMnemonic(this.getString("MNEM_SharedLibrary").charAt(0));
        this.add((Component)this.sharedLib, gridBagConstraints);
        this.recursiveMake = new JRadioButton(this.getString("RB_RecursiveMake"));
        this.recursiveMake.setMnemonic(this.getString("MNEM_RecursiveMake").charAt(0));
        this.add((Component)this.recursiveMake, gridBagConstraints);
        this.customTarget = new JRadioButton(this.getString("RB_CustomTarget"));
        this.customTarget.setMnemonic(this.getString("MNEM_CustomTarget").charAt(0));
        this.add((Component)this.customTarget, gridBagConstraints);
        this.typeBG = new ButtonGroup();
        this.typeBG.add(this.executable);
        this.typeBG.add(this.archive);
        this.typeBG.add(this.sharedLib);
        this.typeBG.add(this.recursiveMake);
        this.typeBG.add(this.customTarget);
        JPanel jPanel = this.createButtonPanel();
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        this.listLabel = new JLabel(this.getString("LBL_List"));
        this.listLabel.setDisplayedMnemonic(this.getString("MNEM_List").charAt(0));
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.listLabel, gridBagConstraints);
        this.list = new JList(new DefaultListModel());
        this.listSP = new JScrollPane(this.list);
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = insets;
        this.add((Component)this.listSP, gridBagConstraints);
        this.listLabel.setLabelFor(this.list);
        this.setupListeners();
        this.newKey = 0;
        this.list.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_List"));
        this.nameText.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_TargetNameTF"));
        this.addBtn.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_CreateTargetsPanelAddBtn"));
        this.removeBtn.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_CreateTargetsPanelRemoveBtn"));
        this.changeBtn.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_CreateTargetsPanelChangeBtn"));
        this.nameChooser.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_CreateTargetsPanelBrowseBtn"));
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3, 6, 0));
        this.addBtn = new JButton(this.getString("BTN_Add"));
        this.addBtn.setMnemonic(this.getString("MNEM_Add").charAt(0));
        this.addBtn.setEnabled(false);
        jPanel.add(this.addBtn);
        this.removeBtn = new JButton(this.getString("BTN_Remove"));
        this.removeBtn.setMnemonic(this.getString("MNEM_Remove").charAt(0));
        this.removeBtn.setEnabled(false);
        jPanel.add(this.removeBtn);
        this.changeBtn = new JButton(this.getString("BTN_Change"));
        this.changeBtn.setMnemonic(this.getString("MNEM_Change").charAt(0));
        this.changeBtn.setEnabled(false);
        jPanel.add(this.changeBtn);
        return jPanel;
    }

    protected void createChooser(JButton jButton) {
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CreateTargetsPanel.this.fc == null) {
                    CreateTargetsPanel.this.fc = new JFileChooser();
                    CreateTargetsPanel.this.fc.setApproveButtonText(CreateTargetsPanel.this.getString("BTN_Approve"));
                    CreateTargetsPanel.this.fc.setDialogTitle(CreateTargetsPanel.this.getString("DLG_FILE_CHOOSER_TITLE"));
                }
                File file = null;
                String string = CreateTargetsPanel.this.nameText.getText();
                if (string.length() > 0) {
                    file = new File(string);
                }
                if (file != null && file.isDirectory()) {
                    CreateTargetsPanel.this.fc.setCurrentDirectory(file);
                } else {
                    CreateTargetsPanel.this.fc.setCurrentDirectory(new File(CreateTargetsPanel.this.getMakefileData().getBaseDirectory(true)));
                }
                int n = CreateTargetsPanel.this.fc.showDialog(CreateTargetsPanel.this, null);
                if (n == 0) {
                    File file2 = CreateTargetsPanel.this.fc.getSelectedFile();
                    CreateTargetsPanel.this.nameText.setText(file2.getName());
                    CreateTargetsPanel.this.setupButtons();
                }
            }
        });
    }

    public boolean isPanelValid() {
        return this.initialized && ((DefaultListModel)this.list.getModel()).size() != 0;
    }

    public void updatePanels() {
        this.wiz.updatePanels(4);
    }

    private int getCurrentType() {
        if (this.executable.isSelected()) {
            return 5;
        }
        if (this.archive.isSelected()) {
            return 6;
        }
        if (this.sharedLib.isSelected()) {
            return 7;
        }
        if (this.recursiveMake.isSelected()) {
            return 8;
        }
        if (this.customTarget.isSelected()) {
            return 9;
        }
        return 0;
    }

    private void addTarget(String string) {
        ArrayList arrayList = this.getMakefileData().getTargetList();
        int n = this.getCurrentType();
        String string2 = arrayList.isEmpty() ? this.getMakefileData().defaultOutputDirectory() : ((TargetData)arrayList.get(arrayList.size() - 1)).getOutputDirectory();
        if (string == null) {
            string = this.nameText.getText().trim();
        }
        if (!((DefaultListModel)this.list.getModel()).contains(string)) {
            TargetData targetData = new TargetData(n, string, string2, this.newKey);
            arrayList.add(targetData);
            ((DefaultListModel)this.list.getModel()).addElement(string);
            this.list.clearSelection();
            this.wiz.addTarget(n, string, this.newKey++);
        }
    }

    private void deleteTargets(int[] nArray) {
        ArrayList arrayList = this.getMakefileData().getTargetList();
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        while (nArray.length > 0) {
            int n = nArray[0];
            this.wiz.deleteTarget(((TargetData)arrayList.get(n)).getKey());
            arrayList.remove(n);
            defaultListModel.removeElementAt(n);
            nArray = this.list.getSelectedIndices();
        }
    }

    private void changeTarget(int n, String string) {
        ArrayList arrayList = this.getMakefileData().getTargetList();
        TargetData targetData = (TargetData)arrayList.get(n);
        if (string.charAt(string.length() - 1) == File.separatorChar) {
            string = IpeUtils.trimpath(string);
            this.nameText.setText(string);
            ((DefaultListModel)this.list.getModel()).set(n, string);
        }
        this.wiz.changeTarget(((TargetData)arrayList.get(n)).getKey(), string, this.getCurrentType());
        int n2 = this.getCurrentType();
        if (n2 != targetData.getTargetType()) {
            targetData = new TargetData(n2, string, targetData.getOutputDirectory(), targetData.getKey());
            arrayList.remove(n);
            arrayList.add(n, targetData);
        } else {
            targetData.setName(string);
        }
    }

    private void setupListeners() {
        final DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        this.nameText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                CreateTargetsPanel.this.setupButtons();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                CreateTargetsPanel.this.setupButtons();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                CreateTargetsPanel.this.setupButtons();
            }
        });
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = CreateTargetsPanel.this.nameText.getText().trim();
                if (CreateTargetsPanel.this.getMakefileData().validateTargetName(string, CreateTargetsPanel.this.getCurrentType())) {
                    CreateTargetsPanel.this.addTarget(string);
                    CreateTargetsPanel.this.nameText.setText(null);
                    CreateTargetsPanel.this.setupButtons();
                }
            }
        });
        this.changeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                defaultListModel.set(CreateTargetsPanel.this.list.getMinSelectionIndex(), CreateTargetsPanel.this.nameText.getText());
                CreateTargetsPanel.this.changeTarget(CreateTargetsPanel.this.list.getMinSelectionIndex(), CreateTargetsPanel.this.nameText.getText());
            }
        });
        this.removeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = CreateTargetsPanel.this.list.getMinSelectionIndex();
                int n2 = CreateTargetsPanel.this.list.getMaxSelectionIndex();
                int[] nArray = CreateTargetsPanel.this.list.getSelectedIndices();
                CreateTargetsPanel.this.deleteTargets(nArray);
                if (defaultListModel.isEmpty()) {
                    CreateTargetsPanel.this.nextButton.setEnabled(false);
                } else if (n >= 0 && n < defaultListModel.getSize()) {
                    CreateTargetsPanel.this.list.setSelectedIndex(n);
                } else {
                    int n3 = n;
                    if (n >= defaultListModel.getSize()) {
                        n3 = defaultListModel.getSize() - 1;
                    }
                    CreateTargetsPanel.this.list.setSelectedIndex(n3);
                }
                CreateTargetsPanel.this.setupButtons();
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = CreateTargetsPanel.this.list.getMinSelectionIndex();
                    int n2 = CreateTargetsPanel.this.list.getMaxSelectionIndex();
                    if (n >= 0 && n2 >= 0 && CreateTargetsPanel.this.list.getModel().getSize() > 0 && n == n2) {
                        CreateTargetsPanel.this.nameText.setText(defaultListModel.get(n).toString());
                        CreateTargetsPanel.this.setTargetType(defaultListModel.get(n).toString());
                    }
                    CreateTargetsPanel.this.setupButtons();
                }
            }
        });
        this.list.addFocusListener(this);
    }

    private void setupButtons() {
        int n = this.list.getMinSelectionIndex();
        int n2 = this.list.getMaxSelectionIndex();
        String string = this.nameText.getText().trim();
        this.addBtn.setEnabled(string.length() > 0);
        if (n < 0) {
            this.changeBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
        } else if (n == n2) {
            this.changeBtn.setEnabled(string.length() > 0);
            this.removeBtn.setEnabled(true);
        } else {
            this.changeBtn.setEnabled(false);
            this.removeBtn.setEnabled(true);
        }
        if (this.inFocus == this.list || string.length() == 0) {
            this.getRootPane().setDefaultButton(this.nextButton);
        } else {
            this.getRootPane().setDefaultButton(this.addBtn);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        DefaultListModel defaultListModel;
        Component component;
        this.inFocus = component = focusEvent.getComponent();
        if (this.inFocus == this.list && !(defaultListModel = (DefaultListModel)this.list.getModel()).isEmpty() && this.list.getLeadSelectionIndex() < 0) {
            this.list.setSelectedIndex(0);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.inFocus = null;
    }

    private void setTargetType(String string) {
        ArrayList arrayList = this.getMakefileData().getTargetList();
        for (int i = 0; i < arrayList.size(); ++i) {
            TargetData targetData = (TargetData)arrayList.get(i);
            if (!string.equals(targetData.getName())) continue;
            this.setTargetType(targetData.getTargetType());
            return;
        }
    }

    private void setTargetType(int n) {
        switch (n) {
            case 5: {
                this.typeBG.setSelected(this.executable.getModel(), true);
                break;
            }
            case 6: {
                this.typeBG.setSelected(this.archive.getModel(), true);
                break;
            }
            case 7: {
                this.typeBG.setSelected(this.sharedLib.getModel(), true);
                break;
            }
            case 8: {
                this.typeBG.setSelected(this.recursiveMake.getModel(), true);
                break;
            }
            case 9: {
                this.typeBG.setSelected(this.customTarget.getModel(), true);
            }
        }
        this.repaint();
    }

    public void addNotify() {
        TargetData targetData;
        ArrayList arrayList = this.getMakefileData().getTargetList();
        if (!this.initialized) {
            this.create();
            if (arrayList.size() > 0) {
                targetData = (TargetData)arrayList.get(arrayList.size() - 1);
                this.setTargetType(targetData.getTargetType());
                DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
                for (int i = 0; i < arrayList.size(); ++i) {
                    defaultListModel.addElement(((TargetData)arrayList.get(i)).getName());
                }
            } else {
                this.executable.setEnabled(true);
            }
            this.initialized = true;
        }
        if (arrayList.size() > 0 && (targetData = (TargetData)arrayList.get(0)).getTargetType() < 4) {
            targetData.convert();
            if (this.newKey == 0) {
                ++this.newKey;
            }
            if (!this.wiz.targetExists(targetData.getKey())) {
                this.wiz.addTarget(targetData.getTargetType(), targetData.getName(), targetData.getKey());
            }
        }
        super.addNotify();
        this.nameText.selectAll();
        IpeUtils.requestFocus(this.nameText);
    }

    public void removeNotify() {
        Container container;
        super.removeNotify();
        if (this.fc != null && this.fc.isShowing() && (container = this.fc.getTopLevelAncestor()) != null && container instanceof JDialog) {
            ((JDialog)container).dispose();
        }
    }
}

