/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.editor.filecreation.BrowseFolders;
import org.netbeans.modules.cnd.editor.filecreation.CndPanelGUI;
import org.netbeans.modules.cnd.editor.filecreation.ExtensionsSettings;
import org.netbeans.modules.cnd.loaders.CCDataLoader;
import org.netbeans.modules.cnd.loaders.HDataLoader;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

class NewCndClassPanelGUI
extends CndPanelGUI
implements ActionListener {
    private String sourceExt;
    private String headerExt;
    private JPanel bottomPanelContainer;
    private JButton browseButton;
    private JLabel classNameLbl;
    private JTextField classNameTextField;
    private JTextField fileTextField;
    private JTextField folderTextField;
    private JTextField headerTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JTextField projectTextField;
    private JSeparator targetSeparator;

    NewCndClassPanelGUI(Project project, SourceGroup[] sourceGroupArray, Component component) {
        super(project, sourceGroupArray);
        this.initComponents();
        this.initMnemonics();
        this.locationComboBox.setRenderer(this.CELL_RENDERER);
        if (component != null) {
            this.bottomPanelContainer.add(component, "Center");
        }
        this.initValues(null, null, null);
        this.browseButton.addActionListener(this);
        this.locationComboBox.addActionListener(this);
        this.classNameTextField.getDocument().addDocumentListener(this);
        this.folderTextField.getDocument().addDocumentListener(this);
        this.setName(NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_SimpleTargetChooserPanel_Name"));
    }

    public void initValues(FileObject fileObject, FileObject fileObject2, String string) {
        Object object;
        assert (this.project != null);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        Sources sources = ProjectUtils.getSources((Project)this.project);
        this.folders = sources.getSourceGroups("generic");
        if (this.folders.length < 2) {
            this.locationLabel.setVisible(false);
            this.locationComboBox.setVisible(false);
        } else {
            this.locationLabel.setVisible(true);
            this.locationComboBox.setVisible(true);
        }
        this.locationComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.folders));
        SourceGroup sourceGroup = NewCndClassPanelGUI.getPreselectedGroup(this.folders, fileObject2);
        this.locationComboBox.setSelectedItem(sourceGroup);
        this.folderTextField.setText(NewCndClassPanelGUI.getRelativeNativeName(sourceGroup.getRootFolder(), fileObject2));
        String string2 = null;
        try {
            if (fileObject != null) {
                object = DataObject.find((FileObject)fileObject);
                string2 = object.getNodeDelegate().getDisplayName();
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            string2 = fileObject.getName();
        }
        this.putClientProperty("NewFileWizard_Title", string2);
        this.sourceExt = ExtensionsSettings.getInstance(CCDataLoader.getInstance()).getDefaultExtension();
        this.headerExt = ExtensionsSettings.getInstance(HDataLoader.getInstance()).getDefaultExtension();
        if (fileObject != null) {
            if (string == null) {
                FileObject fileObject3;
                object = NewCndClassPanelGUI.getMessage("NewClassSuggestedName");
                string = object;
                FileObject fileObject4 = fileObject3 = fileObject2 != null ? fileObject2 : ((SourceGroup)this.locationComboBox.getSelectedItem()).getRootFolder();
                if (fileObject3 != null) {
                    int n = 0;
                    while (true) {
                        FileObject fileObject5 = fileObject3.getFileObject(NewCndClassPanelGUI.getFileName(string), this.sourceExt);
                        FileObject fileObject6 = fileObject3.getFileObject(NewCndClassPanelGUI.getFileName(string), this.headerExt);
                        if (fileObject5 == null && fileObject6 == null) break;
                        string = (String)object + ++n;
                    }
                }
            }
            this.classNameTextField.setText(string);
            this.classNameTextField.selectAll();
        }
    }

    public SourceGroup getTargetGroup() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getTargetFolder() {
        String string = this.folderTextField.getText().trim();
        if (string.length() == 0) {
            return "";
        }
        return string.replace(File.separatorChar, '/');
    }

    public String getTargetName() {
        String string = this.getSourceFileName();
        if (string.length() == 0 || string.charAt(string.length() - 1) == '.') {
            return null;
        }
        return string;
    }

    protected void updateCreatedFile() {
        FileObject fileObject = ((SourceGroup)this.locationComboBox.getSelectedItem()).getRootFolder();
        String string = this.folderTextField.getText().trim();
        String string2 = FileUtil.getFileDisplayName((FileObject)fileObject) + (string.startsWith("/") || string.startsWith(File.separator) ? "" : "/") + string + (string.endsWith("/") || string.endsWith(File.separator) || string.length() == 0 ? "" : "/");
        String string3 = (string2 = string2.replace('/', File.separatorChar)) + this.getSourceFileName();
        if (!string3.equals(this.fileTextField.getText())) {
            this.fileTextField.setText(string3);
            String string4 = string2 + this.getHeaderFileName();
            this.headerTextField.setText(string4);
            this.changeSupport.fireChange();
        }
    }

    public String getSourceFileName() {
        return NewCndClassPanelGUI.getFileName(this.getClassName()) + "." + this.sourceExt;
    }

    public String getHeaderFileName() {
        return NewCndClassPanelGUI.getFileName(this.getClassName()) + "." + this.headerExt;
    }

    private static String getFileName(String string) {
        return string.toLowerCase();
    }

    public String getClassName() {
        return this.classNameTextField.getText().trim();
    }

    public String getHeaderExt() {
        return this.headerExt;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.classNameLbl = new JLabel();
        this.classNameTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.jLabel4 = new JLabel();
        this.fileTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.headerTextField = new JTextField();
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.classNameLbl.setLabelFor(this.classNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.classNameLbl, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_FileName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.classNameLbl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.classNameTextField, gridBagConstraints);
        this.classNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_documentNameTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_Project_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_projectTextField"));
        this.locationLabel.setLabelFor(this.locationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_Location_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 4, 0);
        this.add((Component)this.locationComboBox, gridBagConstraints);
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_locationComboBox"));
        this.jLabel2.setLabelFor(this.folderTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_Folder_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.folderTextField, gridBagConstraints);
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_folderTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_Browse_Button"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName("");
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_browseButton"));
        this.jLabel4.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_CreatedFile_Label_Mnemonic").charAt(0));
        this.jLabel4.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_CreatedFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_fileTextField"));
        this.jLabel6.setLabelFor(this.headerTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)"Header File:");
        this.jLabel6.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.headerTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.headerTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_SimpleTargetChooserPanelGUI_1"));
    }

    private void initMnemonics() {
        this.classNameLbl.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_FileName_Label_Mnemonic").charAt(0));
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_Project_Label_Mnemonic").charAt(0));
        this.locationLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_Location_Label_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_Folder_Label_Mnemonic").charAt(0));
        this.browseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_Browse_Button_Mnemonic").charAt(0));
        this.jLabel4.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_CreatedFile_Label_Mnemonic").charAt(0));
        this.jLabel6.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_CreatedHeader_Label_Mnemonic").charAt(0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.browseButton == actionEvent.getSource()) {
            FileObject fileObject = null;
            SourceGroup sourceGroup = (SourceGroup)this.locationComboBox.getSelectedItem();
            fileObject = BrowseFolders.showDialog(new SourceGroup[]{sourceGroup}, this.project, this.folderTextField.getText().replace(File.separatorChar, '/'));
            if (fileObject != null && fileObject.isFolder()) {
                String string = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject);
                this.folderTextField.setText(string.replace('/', File.separatorChar));
            }
        } else if (this.locationComboBox == actionEvent.getSource()) {
            this.updateCreatedFile();
        }
    }
}

