/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.utils.RemoteUtils;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlatformInfo {
    private ArrayList<String> list = new ArrayList();
    private String pathName = null;
    private final String hkey;
    private final int platform;
    private static int defaultPlatform = -1;
    private static Map<String, PlatformInfo> map = new HashMap<String, PlatformInfo>();

    private PlatformInfo(String string, int n) {
        this.hkey = string;
        this.platform = n;
        if ("localhost".equals(string) && 6 == n) {
            n = PlatformInfo.getDefaultPlatform();
        }
        String string2 = this.getEnv().get("PATH");
        if (Boolean.getBoolean("cnd.debug.use_altpath")) {
            string2 = System.getProperty("cnd.debug.altpath", string2);
        }
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                this.list.add(string3);
            }
        } else if (this.isUnix()) {
            this.list.add("/bin");
            this.list.add("/usr/bin");
            this.list.add("/sbin");
            this.list.add("/usr/sbin");
        } else if (this.isWindows()) {
            this.list.add("C:/WINDOWS/System32");
            this.list.add("C:/WINDOWS");
            this.list.add("C:/WINDOWS/System32/WBem");
        } else {
            System.err.println("PlatformInfo: Path is empty for host " + string);
        }
    }

    public String getHkey() {
        return this.hkey;
    }

    public void setPath(ArrayList<String> arrayList) {
        this.list = arrayList;
    }

    public ArrayList<String> getPath() {
        return this.list;
    }

    public String getPathAsString() {
        if (this.list.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.list) {
            stringBuffer.append(string);
            stringBuffer.append(File.pathSeparator);
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    public String getPathAsStringWith(String string) {
        return this.getPathName() + '=' + this.getPathAsString() + this.pathSeparator() + string;
    }

    public void add(int n, String string) throws IndexOutOfBoundsException {
        this.list.add(n, string);
    }

    public void remove(int n) throws IndexOutOfBoundsException {
        this.list.remove(n);
    }

    public String getPathName() {
        if (this.pathName == null) {
            if (this.isWindows()) {
                for (String string : this.getEnv().keySet()) {
                    if (!string.toLowerCase().equals("path")) continue;
                    this.pathName = string.substring(0, 4);
                    return this.pathName;
                }
            }
            this.pathName = "PATH";
        }
        return this.pathName;
    }

    public String findCommand(String string) {
        if (string != null && string.length() > 0) {
            String string2 = null;
            ArrayList<String> arrayList = this.getPath();
            if (this.isWindows() && !string.endsWith(".exe")) {
                string2 = string + ".exe";
            }
            for (String string3 : arrayList) {
                String string4 = string3 + this.separator() + string;
                if (this.fileExists(string4)) {
                    return string4;
                }
                if (string2 == null || !this.fileExists(string4 = string3 + this.separator() + string)) continue;
                return string4;
            }
        }
        return null;
    }

    public String separator() {
        return this.isWindows() ? "\\" : "/";
    }

    public String pathSeparator() {
        return this.isWindows() ? ";" : ":";
    }

    public int getPlatform() {
        return this.platform;
    }

    public boolean isWindows() {
        return this.platform == 3;
    }

    public boolean isUnix() {
        return this.platform == 1 || this.platform == 0 || this.platform == 2 || this.platform == 4;
    }

    public boolean isLocalhost() {
        return RemoteUtils.isLocalhost(this.hkey);
    }

    public Map<String, String> getEnv() {
        return HostInfoProvider.getDefault().getEnv(this.hkey);
    }

    public boolean fileExists(String string) {
        return HostInfoProvider.getDefault().fileExists(this.hkey, string);
    }

    private static int getDefaultPlatform() {
        if (defaultPlatform <= 0) {
            defaultPlatform = Utilities.isWindows() ? 3 : (Utilities.getOperatingSystem() == 16 ? 2 : (Utilities.getOperatingSystem() == 8 && System.getProperty("os.arch").indexOf("86") >= 0 ? 1 : (Utilities.getOperatingSystem() == 8 ? 0 : (Utilities.getOperatingSystem() == 4096 ? 4 : 5))));
        }
        return defaultPlatform;
    }

    public static synchronized PlatformInfo getDefault(String string) {
        PlatformInfo platformInfo = map.get(string);
        if (platformInfo == null) {
            int n = CompilerSetManager.getDefault(string).getPlatform();
            platformInfo = new PlatformInfo(string, n);
        }
        return platformInfo;
    }
}

