/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.compilers;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.compilers.CompilerProvider;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.PlatformTypes;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.compilers.DefaultCompilerProvider;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerSet {
    public static final String None = "None";
    private CompilerFlavor flavor;
    private String name;
    private String displayName;
    private boolean autoGenerated;
    private boolean isDefault;
    private StringBuilder directory = new StringBuilder(256);
    private final ArrayList<Tool> tools = new ArrayList();
    private String librarySearchOption;
    private String dynamicLibrarySearchOption;
    private String libraryOption;
    private CompilerProvider compilerProvider;
    private String driveLetterPrefix = "/";

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(boolean bl) {
        this.autoGenerated = bl;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setAsDefault(boolean bl) {
        this.isDefault = bl;
    }

    protected CompilerSet(CompilerFlavor compilerFlavor, String string, String string2) {
        this.addDirectory(string);
        this.compilerProvider = (CompilerProvider)Lookup.getDefault().lookup(CompilerProvider.class);
        if (this.compilerProvider == null) {
            this.compilerProvider = new DefaultCompilerProvider();
        }
        this.driveLetterPrefix = compilerFlavor.getToolchainDescriptor().getDriveLetterPrefix();
        this.name = string2 != null ? string2 : compilerFlavor.toString();
        this.displayName = compilerFlavor.getToolchainDescriptor().getDisplayName();
        this.librarySearchOption = compilerFlavor.getToolchainDescriptor().getLinker().getLibrarySearchFlag();
        this.dynamicLibrarySearchOption = compilerFlavor.getToolchainDescriptor().getLinker().getDynamicLibrarySearchFlag();
        this.libraryOption = compilerFlavor.getToolchainDescriptor().getLinker().getLibraryFlag();
        this.flavor = compilerFlavor;
        this.setAutoGenerated(true);
        this.setAsDefault(false);
    }

    protected CompilerSet(int n) {
        this.name = None;
        this.flavor = CompilerFlavor.getUnknown(n);
        this.displayName = NbBundle.getMessage(CompilerSet.class, (String)"LBL_EmptyCompilerSetDisplayName");
        this.compilerProvider = (CompilerProvider)Lookup.getDefault().lookup(CompilerProvider.class);
        if (this.compilerProvider == null) {
            this.compilerProvider = new DefaultCompilerProvider();
        }
        this.setAutoGenerated(true);
        this.setAsDefault(false);
    }

    public CompilerSet createCopy() {
        CompilerSet compilerSet = new CompilerSet(this.flavor, this.getDirectory(), this.name);
        compilerSet.setAutoGenerated(this.isAutoGenerated());
        compilerSet.setAsDefault(this.isDefault());
        for (Tool tool : this.getTools()) {
            compilerSet.addTool(tool.createCopy());
        }
        return compilerSet;
    }

    public static CompilerSet getCompilerSet(String string, String string2, int n) {
        CompilerSet compilerSet = CompilerSetManager.getDefault(string).getCompilerSet(CompilerFlavor.toFlavor(string2, n));
        if (compilerSet == null) {
            CompilerFlavor compilerFlavor = CompilerFlavor.toFlavor(string2, n);
            compilerFlavor = compilerFlavor == null ? CompilerFlavor.getUnknown(n) : compilerFlavor;
            compilerSet = new CompilerSet(compilerFlavor, "", null);
        }
        return compilerSet;
    }

    public static List<CompilerFlavor> getCompilerSetFlavor(String string, int n) {
        ArrayList<CompilerFlavor> arrayList = new ArrayList<CompilerFlavor>();
        for (ToolchainManager.ToolchainDescriptor toolchainDescriptor : ToolchainManager.getInstance().getToolchains(n)) {
            CompilerFlavor compilerFlavor;
            if (!ToolchainManager.getInstance().isMyFolder(string, toolchainDescriptor, n) || (compilerFlavor = CompilerFlavor.toFlavor(toolchainDescriptor.getName(), n)) == null) continue;
            arrayList.add(compilerFlavor);
        }
        return arrayList;
    }

    public static CompilerSet getCustomCompilerSet(String string, CompilerFlavor compilerFlavor, String string2) {
        CompilerSet compilerSet = new CompilerSet(compilerFlavor, string, string2);
        compilerSet.setAutoGenerated(false);
        return compilerSet;
    }

    public static CompilerSet getCompilerSet(String string, int n) {
        List<CompilerFlavor> list = CompilerSet.getCompilerSetFlavor(string, n);
        if (list.size() > 0) {
            return new CompilerSet(list.get(0), string, null);
        }
        return new CompilerSet(CompilerFlavor.getUnknown(n), string, null);
    }

    protected static CompilerSet createEmptyCompilerSet(int n) {
        return new CompilerSet(n);
    }

    public boolean isGnuCompiler() {
        return this.flavor.isGnuCompiler();
    }

    public boolean isSunCompiler() {
        return this.flavor.isSunStudioCompiler();
    }

    public CompilerFlavor getCompilerFlavor() {
        return this.flavor;
    }

    public void setFlavor(CompilerFlavor compilerFlavor) {
        this.flavor = compilerFlavor;
    }

    public void addDirectory(String string) {
        if (this.directory.length() == 0) {
            this.directory.append(string);
        } else {
            this.directory.append(File.pathSeparator);
            this.directory.append(string);
        }
    }

    public String getDirectory() {
        return this.directory.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Tool addTool(String string, String string2, String string3, int n) {
        if (this.findTool(n) != null) {
            return null;
        }
        Tool tool = this.compilerProvider.createCompiler(string, this.flavor, n, string2, Tool.getToolDisplayName(n), string3);
        if (!this.tools.contains(tool)) {
            this.tools.add(tool);
        }
        tool.setCompilerSet(this);
        return tool;
    }

    public void addTool(Tool tool) {
        this.tools.add(tool);
        tool.setCompilerSet(this);
    }

    public Tool addNewTool(String string, String string2, String string3, int n) {
        Tool tool = this.compilerProvider.createCompiler(string, this.flavor, n, string2, Tool.getToolDisplayName(n), string3);
        this.tools.add(tool);
        tool.setCompilerSet(this);
        return tool;
    }

    public void removeTool(String string, String string2, int n) {
        for (Tool tool : this.tools) {
            if (!tool.getName().equals(string) || !tool.getPath().equals(string2) || tool.getKind() != n) continue;
            this.tools.remove(tool);
            tool.setCompilerSet(null);
            return;
        }
    }

    public void reparent(String string) {
        this.directory = new StringBuilder(256);
        this.addDirectory(string);
        this.tools.clear();
    }

    public Tool getTool(String string) {
        String string2 = null;
        if (Utilities.isWindows()) {
            string2 = string + ".exe";
        }
        for (Tool tool : this.tools) {
            if (!tool.getDisplayName().equals(string) && !tool.getName().equals(string) && (string2 == null || !tool.getName().equals(string2))) continue;
            return tool;
        }
        return null;
    }

    public Tool getTool(String string, int n) {
        String string2 = null;
        if (Utilities.isWindows()) {
            string2 = string + ".exe";
        }
        for (Tool tool : this.tools) {
            if (!tool.getDisplayName().equals(string) && !tool.getName().equals(string) && (string2 == null || !tool.getName().equals(string2)) || n != tool.getKind()) continue;
            return tool;
        }
        return this.compilerProvider.createCompiler("localhost", CompilerFlavor.getUnknown(PlatformTypes.getDefaultPlatform()), n, "", Tool.getToolDisplayName(n), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tool getTool(int n) {
        for (Tool object2 : this.tools) {
            if (object2.getKind() != n) continue;
            return object2;
        }
        Tool tool = this.compilerProvider.createCompiler("localhost", this.getCompilerFlavor(), n, "", Tool.getToolDisplayName(n), "");
        tool.setCompilerSet(this);
        ArrayList<Tool> arrayList = this.tools;
        synchronized (arrayList) {
            this.tools.add(tool);
        }
        return tool;
    }

    public Tool findTool(int n) {
        for (Tool tool : this.tools) {
            if (tool.getKind() != n) continue;
            return tool;
        }
        return null;
    }

    public boolean isValid() {
        Tool tool = this.getTool(0);
        Tool tool2 = this.getTool(1);
        Tool tool3 = this.getTool(2);
        return tool != null && tool2 != null && (!CppSettings.getDefault().isFortranEnabled() || tool3 != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tool> getTools() {
        ArrayList<Tool> arrayList = this.tools;
        synchronized (arrayList) {
            return (List)this.tools.clone();
        }
    }

    public String getDynamicLibrarySearchOption() {
        return this.dynamicLibrarySearchOption;
    }

    public void setDynamicLibrarySearchOption(String string) {
        this.dynamicLibrarySearchOption = string;
    }

    public String getLibrarySearchOption() {
        return this.librarySearchOption;
    }

    public void setLibrarySearchOption(String string) {
        this.librarySearchOption = string;
    }

    public String getLibraryOption() {
        return this.libraryOption;
    }

    public void setLibraryOption(String string) {
        this.libraryOption = string;
    }

    public String getDriveLetterPrefix() {
        return this.driveLetterPrefix;
    }

    public String normalizeDriveLetter(String string) {
        if (string.length() > 1 && string.charAt(1) == ':') {
            return this.getDriveLetterPrefix() + string.charAt(0) + string.substring(2);
        }
        return string;
    }

    public String toString() {
        return this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CompilerFlavor {
        private static final List<CompilerFlavor> flavors = new ArrayList<CompilerFlavor>();
        private static Map<Integer, CompilerFlavor> unknown = new HashMap<Integer, CompilerFlavor>();
        private String sval;
        private ToolchainManager.ToolchainDescriptor descriptor;

        CompilerFlavor(String string, ToolchainManager.ToolchainDescriptor toolchainDescriptor) {
            this.sval = string;
            this.descriptor = toolchainDescriptor;
        }

        public ToolchainManager.ToolchainDescriptor getToolchainDescriptor() {
            return this.descriptor;
        }

        public boolean isGnuCompiler() {
            ToolchainManager.ToolchainDescriptor toolchainDescriptor = this.getToolchainDescriptor();
            if (toolchainDescriptor != null) {
                for (String string : toolchainDescriptor.getFamily()) {
                    if (!"GNU".equals(string)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isSunStudioCompiler() {
            ToolchainManager.ToolchainDescriptor toolchainDescriptor = this.getToolchainDescriptor();
            if (toolchainDescriptor != null) {
                for (String string : toolchainDescriptor.getFamily()) {
                    if (!"SunStudio".equals(string)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isMinGWCompiler() {
            return "MinGW".equals(this.sval);
        }

        public String getCommandFolder(int n) {
            ToolchainManager.ToolchainDescriptor toolchainDescriptor = this.getToolchainDescriptor();
            if (toolchainDescriptor != null) {
                return ToolchainManager.getInstance().getCommandFolder(toolchainDescriptor, n);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CompilerFlavor getUnknown(int n) {
            CompilerFlavor compilerFlavor = unknown.get(n);
            if (compilerFlavor == null) {
                Map<Integer, CompilerFlavor> map = unknown;
                synchronized (map) {
                    compilerFlavor = unknown.get(n);
                    if (compilerFlavor == null) {
                        List<ToolchainManager.ToolchainDescriptor> list;
                        ToolchainManager.ToolchainDescriptor toolchainDescriptor = ToolchainManager.getInstance().getToolchain("GNU", n);
                        if (toolchainDescriptor == null && (list = ToolchainManager.getInstance().getToolchains(n)).size() > 0) {
                            toolchainDescriptor = list.get(0);
                        }
                        compilerFlavor = new CompilerFlavor("Unknown", toolchainDescriptor);
                        unknown.put(n, compilerFlavor);
                    }
                }
            }
            return compilerFlavor;
        }

        public static CompilerFlavor toFlavor(String string, int n) {
            for (CompilerFlavor compilerFlavor : flavors) {
                if (!string.equals(compilerFlavor.sval) || !ToolchainManager.getInstance().isPlatforSupported(n, compilerFlavor.getToolchainDescriptor())) continue;
                return compilerFlavor;
            }
            return null;
        }

        public static String mapOldToNew(String string, int n) {
            if (n <= 43) {
                if (string.equals("Sun")) {
                    return "SunStudio";
                }
                if (string.equals("Sun12")) {
                    return "SunStudio_12";
                }
                if (string.equals("Sun11")) {
                    return "SunStudio_11";
                }
                if (string.equals("Sun10")) {
                    return "SunStudio_10";
                }
                if (string.equals("Sun9")) {
                    return "SunStudio_9";
                }
                if (string.equals("Sun8")) {
                    return "SunStudio_8";
                }
                if (string.equals("DJGPP")) {
                    return "GNU";
                }
                if (string.equals("Interix")) {
                    return "GNU";
                }
                if (string.equals("Unknown")) {
                    return "GNU";
                }
            }
            return string;
        }

        private static boolean isPlatforSupported(CompilerFlavor compilerFlavor, int n) {
            ToolchainManager.ToolchainDescriptor toolchainDescriptor = compilerFlavor.getToolchainDescriptor();
            if (toolchainDescriptor != null) {
                return ToolchainManager.getInstance().isPlatforSupported(n, toolchainDescriptor);
            }
            return true;
        }

        public static List<CompilerFlavor> getFlavors(int n) {
            ArrayList<CompilerFlavor> arrayList = new ArrayList<CompilerFlavor>();
            for (CompilerFlavor compilerFlavor : flavors) {
                if (!CompilerFlavor.isPlatforSupported(compilerFlavor, n)) continue;
                arrayList.add(compilerFlavor);
            }
            return arrayList;
        }

        public String toString() {
            return this.sval;
        }

        static {
            for (ToolchainManager.ToolchainDescriptor toolchainDescriptor : ToolchainManager.getInstance().getAllToolchains()) {
                flavors.add(new CompilerFlavor(toolchainDescriptor.getName(), toolchainDescriptor));
            }
        }
    }
}

