/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DataSerializer;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.io.serialization.ComponentElement;
import org.netbeans.modules.vmd.api.io.serialization.DocumentErrorHandler;
import org.netbeans.modules.vmd.api.io.serialization.DocumentErrorHandlerSupport;
import org.netbeans.modules.vmd.api.io.serialization.DocumentSerializationController;
import org.netbeans.modules.vmd.api.io.serialization.PropertyElement;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.io.DocumentSave;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentLoad {
    private static final String XML_ERROR = NbBundle.getMessage(DocumentLoad.class, (String)"MSG_BrokenXML_Error");
    private static final String WRONG_VERSION_ERROR = NbBundle.getMessage(DocumentLoad.class, (String)"MSG_Wrong_VMD_Version_Error");
    private static final String DESERIALIZATION_ERROR = NbBundle.getMessage(DocumentLoad.class, (String)"MSG_Deserialization_Error");
    private static final String DESCRIPTOR_MISSING_ERROR = NbBundle.getMessage(DocumentLoad.class, (String)"MSG_MissingDescriptor_Error");

    private static Collection<? extends DocumentSerializationController> getDocumentSerializationControllers() {
        return Lookup.getDefault().lookupAll(DocumentSerializationController.class);
    }

    public static boolean load(DataObjectContext dataObjectContext, DesignDocument designDocument, DocumentErrorHandler documentErrorHandler) {
        Node node;
        try {
            node = DocumentLoad.getRootNode(IOSupport.getDesignFile(dataObjectContext));
        }
        catch (IOException iOException) {
            throw Debug.error((Object[])new Object[]{iOException});
        }
        if (!"1".equals(DocumentLoad.getAttributeValue(node, "version"))) {
            Debug.warning((Object[])new Object[]{"Invalid version of VisualDesign"});
            documentErrorHandler.addWarning(WRONG_VERSION_ERROR);
            return false;
        }
        return DocumentLoad.loadVersion1(dataObjectContext, designDocument, node, documentErrorHandler);
    }

    private static boolean loadVersion1(DataObjectContext dataObjectContext, DesignDocument designDocument, Node node, DocumentErrorHandler documentErrorHandler) {
        Node node2 = DocumentLoad.findDocumentNode(node);
        DocumentLoad.loadDocumentVersion1(dataObjectContext, designDocument, node2, documentErrorHandler);
        if (!documentErrorHandler.getErrors().isEmpty()) {
            return false;
        }
        Collection collection = DocumentSave.customDataSerializers.allInstances();
        for (Node node3 : DocumentLoad.getChildNode(node)) {
            DataSerializer dataSerializer;
            if (DocumentLoad.isDocumentNode(node3)) continue;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext() && !(dataSerializer = (DataSerializer)iterator.next()).deserializeData(dataObjectContext, designDocument, node3)) {
            }
        }
        return true;
    }

    private static void loadDocumentVersion1(final DataObjectContext dataObjectContext, final DesignDocument designDocument, Node node, final DocumentErrorHandler documentErrorHandler) {
        final String string = DocumentLoad.getAttributeValue(node, "version");
        ArrayList<ComponentElement> arrayList = new ArrayList<ComponentElement>();
        if (node != null) {
            for (Node object : DocumentLoad.getChildNode(node)) {
                if (!DocumentLoad.isComponentNode(object)) continue;
                DocumentLoad.collectStructure(arrayList, object, Long.MIN_VALUE, documentErrorHandler);
            }
        }
        for (DocumentSerializationController documentSerializationController : DocumentLoad.getDocumentSerializationControllers()) {
            documentSerializationController.approveComponents(dataObjectContext, designDocument, string, arrayList, documentErrorHandler);
            if (documentErrorHandler.getErrors().isEmpty()) continue;
            return;
        }
        final HashMap hashMap = new HashMap();
        HashSet<TypeID> hashSet = new HashSet<TypeID>();
        for (ComponentElement componentElement : arrayList) {
            hashMap.put(componentElement.getUID(), componentElement);
            hashSet.add(componentElement.getTypeID());
        }
        designDocument.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                DocumentLoad.loadDocumentCore(dataObjectContext, designDocument, string, hashMap, documentErrorHandler);
                for (DocumentSerializationController documentSerializationController : DocumentLoad.getDocumentSerializationControllers()) {
                    documentSerializationController.postValidateDocument(dataObjectContext, designDocument, string, documentErrorHandler);
                    if (documentErrorHandler.getErrors().isEmpty()) continue;
                    return;
                }
            }
        });
    }

    private static void loadDocumentCore(DataObjectContext dataObjectContext, DesignDocument designDocument, String string, HashMap<Long, ComponentElement> hashMap, DocumentErrorHandler documentErrorHandler) {
        Object object;
        Node[] nodeArray;
        long l;
        ArrayList<ComponentElement> arrayList = new ArrayList<ComponentElement>(hashMap.values());
        Collections.sort(arrayList, new Comparator<ComponentElement>(){

            @Override
            public int compare(ComponentElement componentElement, ComponentElement componentElement2) {
                return (int)(componentElement.getUID() - componentElement2.getUID());
            }
        });
        for (ComponentElement componentElement : arrayList) {
            l = componentElement.getUID();
            designDocument.setPreferredComponentID(l);
            if (designDocument.getDescriptorRegistry().getComponentDescriptor(componentElement.getTypeID()) == null) {
                if (componentElement.getUID() == 0L) {
                    Debug.warning((Object[])new Object[]{"Missing ComponentDescriptor in registry ", componentElement.getTypeID()});
                    documentErrorHandler.addError("{0} {1}", DESCRIPTOR_MISSING_ERROR, componentElement.getTypeID().toString());
                    continue;
                }
                Debug.warning((Object[])new Object[]{"Missing ComponentDescriptor in registry ", componentElement.getTypeID()});
                documentErrorHandler.addWarning("{0} {1}", DESCRIPTOR_MISSING_ERROR, componentElement.getTypeID().toString());
                continue;
            }
            if (!documentErrorHandler.getErrors().isEmpty()) {
                return;
            }
            nodeArray = designDocument.createRawComponent(componentElement.getTypeID());
            assert (nodeArray.getComponentID() == l);
            assert (nodeArray.getComponentDescriptor() != null);
        }
        for (ComponentElement componentElement : hashMap.values()) {
            l = componentElement.getParentUID();
            nodeArray = designDocument.getComponentByUID(l);
            object = designDocument.getComponentByUID(componentElement.getUID());
            if (object == null || l == Long.MIN_VALUE || nodeArray == null) continue;
            nodeArray.addComponent((DesignComponent)object);
        }
        for (ComponentElement componentElement : hashMap.values()) {
            ComponentDescriptor componentDescriptor;
            DesignComponent designComponent = designDocument.getComponentByUID(componentElement.getUID());
            if (designComponent == null || (componentDescriptor = designComponent.getComponentDescriptor()) == null) continue;
            nodeArray = DocumentLoad.getChildNode(componentElement.getNode());
            object = new ArrayList();
            for (Node node : nodeArray) {
                if (!DocumentLoad.isPropertyNode(node)) continue;
                String string2 = DocumentLoad.getAttributeValue(node, "name");
                TypeID typeID = TypeID.createFrom((String)DocumentLoad.getAttributeValue(node, "typeID"));
                String string3 = DocumentLoad.getAttributeValue(node, "value");
                ((ArrayList)object).add(PropertyElement.create(string2, typeID, string3));
            }
            for (DocumentSerializationController documentSerializationController : DocumentLoad.getDocumentSerializationControllers()) {
                documentSerializationController.approveProperties(dataObjectContext, designDocument, string, designComponent, (Collection<PropertyElement>)object, documentErrorHandler);
            }
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                Node node;
                PropertyElement propertyElement = (PropertyElement)iterator.next();
                String string4 = propertyElement.getPropertyName();
                if (string4 == null || componentDescriptor.getPropertyDescriptor(string4) == null) {
                    Debug.warning((Object[])new Object[]{"Missing property descriptor", designComponent, string4});
                    documentErrorHandler.addWarning("{0} {1} - {2}", NbBundle.getMessage(DocumentLoad.class, (String)"MSG_MissingProperty_Error"), designComponent, string4);
                    continue;
                }
                try {
                    node = PropertyValue.deserialize((String)propertyElement.getSerialized(), (DesignDocument)designDocument, (TypeID)propertyElement.getTypeID());
                }
                catch (Exception exception) {
                    Debug.warning((Object[])new Object[]{"Error while deserializing property value", designComponent, string4});
                    documentErrorHandler.addWarning("{0} {1} {2} {3}", DESERIALIZATION_ERROR, designComponent, string4, propertyElement.getSerialized());
                    node = PropertyValue.createNull();
                }
                designComponent.writeProperty(string4, (PropertyValue)node);
            }
        }
        DesignComponent designComponent = designDocument.getComponentByUID(0L);
        if (designComponent != null) {
            designDocument.setRootComponent(designComponent);
        }
    }

    private static void collectStructure(Collection<ComponentElement> collection, Node node, long l, DocumentErrorHandler documentErrorHandler) {
        Node[] nodeArray;
        String string = DocumentLoad.getAttributeValue(node, "componentID");
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < node.getAttributes().getLength(); ++i) {
                stringBuffer.append(" ");
                stringBuffer.append(node.getAttributes().item(i));
            }
            documentErrorHandler.addError(NbBundle.getMessage(DocumentLoad.class, (String)"MSG_Wrong_argument") + stringBuffer.toString());
            return;
        }
        long l2 = -1L;
        try {
            l2 = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            documentErrorHandler.addError("{0} {1}", NbBundle.getMessage(DocumentLoad.class, (String)"MSG_Wrong_argument_value"), string);
            return;
        }
        TypeID typeID = TypeID.createFrom((String)DocumentLoad.getAttributeValue(node, "typeID"));
        collection.add(ComponentElement.create(l, l2, typeID, node));
        for (Node node2 : nodeArray = DocumentLoad.getChildNode(node)) {
            if (!DocumentLoad.isComponentNode(node2)) continue;
            DocumentLoad.collectStructure(collection, node2, l2, documentErrorHandler);
        }
    }

    private static boolean isDocumentNode(Node node) {
        return "Document".equals(node.getNodeName());
    }

    private static boolean isComponentNode(Node node) {
        return "Component".equals(node.getNodeName());
    }

    private static boolean isPropertyNode(Node node) {
        return "Property".equals(node.getNodeName());
    }

    private static Node[] getChildNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        Node[] nodeArray = new Node[nodeList != null ? nodeList.getLength() : 0];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i] = nodeList.item(i);
        }
        return nodeArray;
    }

    private static Node findDocumentNode(Node node) {
        for (Node node2 : DocumentLoad.getChildNode(node)) {
            if (!DocumentLoad.isDocumentNode(node2)) continue;
            return node2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node getRootNode(final FileObject fileObject) throws IOException {
        Object object = DocumentSave.sync;
        synchronized (object) {
            final Node[] nodeArray = new Node[1];
            fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    Node node = null;
                    if (fileObject != null) {
                        FileLock fileLock = null;
                        try {
                            fileLock = fileObject.lock();
                            node = DocumentLoad.getXMLDocument(fileObject);
                        }
                        finally {
                            if (fileLock != null) {
                                fileLock.releaseLock();
                            }
                        }
                    }
                    nodeArray[0] = node != null ? node.getFirstChild() : null;
                }
            });
            return nodeArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document getXMLDocument(FileObject fileObject) throws IOException {
        Document document = null;
        InputStream inputStream = fileObject.getInputStream();
        final DocumentErrorHandler documentErrorHandler = new DocumentErrorHandler();
        try {
            document = XMLUtil.parse((InputSource)new InputSource(inputStream), (boolean)false, (boolean)false, (ErrorHandler)new ErrorHandler(){

                public void error(SAXParseException sAXParseException) throws SAXException {
                    documentErrorHandler.addError(XML_ERROR + sAXParseException.getMessage());
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    documentErrorHandler.addError(XML_ERROR + sAXParseException.getMessage());
                }

                public void warning(SAXParseException sAXParseException) {
                    documentErrorHandler.addWarning(XML_ERROR + sAXParseException.getMessage());
                }
            }, null);
        }
        catch (SAXException sAXException) {
            documentErrorHandler.addError(XML_ERROR + sAXException.getMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                documentErrorHandler.addError(XML_ERROR + iOException.getMessage());
            }
        }
        DocumentErrorHandlerSupport.showDocumentErrorHandlerDialog(documentErrorHandler, fileObject);
        return document;
    }

    private static String getAttributeValue(Node node, String string) {
        try {
            NamedNodeMap namedNodeMap;
            if (node != null && (namedNodeMap = node.getAttributes()) != null && (node = namedNodeMap.getNamedItem(string)) != null) {
                return node.getNodeValue();
            }
        }
        catch (DOMException dOMException) {
            Debug.warning((Object[])new Object[]{dOMException});
        }
        return null;
    }

    public static String loadProjectType(DataObjectContext dataObjectContext) {
        Node node;
        try {
            node = DocumentLoad.getRootNode(IOSupport.getDesignFile(dataObjectContext));
        }
        catch (IOException iOException) {
            throw Debug.error((Object[])new Object[]{iOException});
        }
        return DocumentLoad.getAttributeValue(node, "projectType");
    }
}

