/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.io;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public final class IOUtils {
    public static void runInAWTNoBlocking(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void runInAWTBlocking(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                ErrorManager.getDefault().notify((Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManager.getDefault().notify((Throwable)invocationTargetException);
            }
        }
    }

    public static JComponent createLoadingPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(NbBundle.getMessage(IOUtils.class, (String)"DISP_LoadingDocument"));
        jLabel.setFont(new Font("Dialog", 1, 16));
        Color color = jPanel.getBackground();
        Color color2 = color.darker();
        if (color2.equals(color)) {
            color2 = color.brighter();
        }
        jLabel.setForeground(color2);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 0, new Insets(16, 16, 16, 16), 0, 0));
        return jPanel;
    }
}

