/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.model.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactoryManager;
import org.netbeans.modules.cnd.model.tasks.OpenedEditors;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsmFileTaskFactory {
    private final Map<FileObject, CsmFile> fobj2csm = new HashMap<FileObject, CsmFile>();
    private final Map<CsmFile, PhaseRunner> csm2task = new HashMap<CsmFile, PhaseRunner>();
    private final ProgressListener progressListener = new ProgressListener();
    private final ModelListener modelListener = new ModelListener();
    private static final int DELAY = 500;
    private static final int IMMEDIATELY = 0;
    private static RequestProcessor WORKER = new RequestProcessor("CsmFileTaskFactory", 1);

    protected CsmFileTaskFactory() {
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)this.progressListener);
        CsmListeners.getDefault().addModelListener((CsmModelListener)this.modelListener);
    }

    protected abstract PhaseRunner createTask(FileObject var1);

    protected abstract Collection<FileObject> getFileObjects();

    protected final void fileObjectsChanged() {
        final ArrayList<FileObject> arrayList = new ArrayList<FileObject>(this.getFileObjects());
        final long l = Math.round(100.0 * Math.random());
        final String string = this.getClass().getName();
        if (OpenedEditors.SHOW_TIME) {
            System.err.println("CsmFileTaskFactory: POST worker " + l);
        }
        WORKER.post(new Runnable(){

            public void run() {
                long l2 = System.currentTimeMillis();
                if (OpenedEditors.SHOW_TIME) {
                    System.err.println("CsmFileTaskFactory: RUN worker " + l + " [" + string + "]");
                }
                CsmFileTaskFactory.this.stateChangedImpl(arrayList);
                if (OpenedEditors.SHOW_TIME) {
                    System.err.println("CsmFileTaskFactory: DONE worker " + l + " after " + (System.currentTimeMillis() - l2) + "ms.");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stateChangedImpl(List<FileObject> list) {
        HashMap<CsmFile, PhaseRunner> hashMap = new HashMap<CsmFile, PhaseRunner>();
        HashMap<CsmFile, PhaseRunner> hashMap2 = new HashMap<CsmFile, PhaseRunner>();
        Iterator iterator = this;
        synchronized (iterator) {
            CsmFile csmFile;
            Map.Entry entry = new ArrayList<FileObject>(list);
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(this.fobj2csm.keySet());
            entry.removeAll(this.fobj2csm.keySet());
            arrayList.removeAll(list);
            for (FileObject fileObject : arrayList) {
                csmFile = this.fobj2csm.remove(fileObject);
                if (csmFile == null) continue;
                hashMap.put(csmFile, this.csm2task.remove(csmFile));
            }
            Iterator iterator2 = entry.iterator();
            while (iterator2.hasNext()) {
                FileObject fileObject;
                fileObject = (FileObject)iterator2.next();
                if (fileObject == null || !fileObject.isValid() || (csmFile = CsmUtilities.getCsmFile((FileObject)fileObject, (boolean)false)) == null) continue;
                PhaseRunner phaseRunner = this.createTask(fileObject);
                hashMap2.put(csmFile, phaseRunner);
                this.fobj2csm.put(fileObject, csmFile);
                this.csm2task.put(csmFile, phaseRunner);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (OpenedEditors.SHOW_TIME) {
                System.err.println("CFTF: removing " + ((CsmFile)entry.getKey()).getAbsolutePath());
            }
            if (entry == null || entry.getValue() == null) continue;
            this.post((PhaseRunner)entry.getValue(), (CsmFile)entry.getKey(), PhaseRunner.Phase.CLEANUP, 0);
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            if (OpenedEditors.SHOW_TIME) {
                System.err.println("CFTF: adding " + ((CsmFile)entry.getKey()).getAbsolutePath());
            }
            this.post((PhaseRunner)entry.getValue(), (CsmFile)entry.getKey(), ((CsmFile)entry.getKey()).isParsed() ? PhaseRunner.Phase.PARSED : PhaseRunner.Phase.INIT, 500);
        }
    }

    public final synchronized void reschedule(FileObject fileObject) throws IllegalArgumentException {
        CsmFile csmFile = this.fobj2csm.get(fileObject);
        if (csmFile == null) {
            return;
        }
        this.runTask(csmFile, PhaseRunner.Phase.PARSED, 500);
    }

    private final void runTask(CsmFile csmFile, PhaseRunner.Phase phase, int n) {
        PhaseRunner phaseRunner = this.csm2task.get(csmFile);
        if (phaseRunner != null) {
            if (!phaseRunner.isValid()) {
                FileObject fileObject = CsmUtilities.getFileObject((CsmFile)csmFile);
                phaseRunner = this.createTask(fileObject);
                assert (phaseRunner.isValid());
                this.csm2task.put(csmFile, phaseRunner);
            }
            this.post(phaseRunner, csmFile, phase, n);
        }
    }

    private final void post(PhaseRunner phaseRunner, CsmFile csmFile, PhaseRunner.Phase phase, int n) {
        WORKER.post((Runnable)new CsmSafeRunnable(CsmFileTaskFactory.getRunnable(phaseRunner, phase), csmFile), n);
    }

    private static final Runnable getRunnable(final PhaseRunner phaseRunner, final PhaseRunner.Phase phase) {
        return new Runnable(){

            public void run() {
                phaseRunner.run(phase);
            }
        };
    }

    protected static PhaseRunner lazyRunner() {
        return new PhaseRunner(){

            public void run(PhaseRunner.Phase phase) {
            }

            public boolean isValid() {
                return true;
            }
        };
    }

    static {
        CsmFileTaskFactoryManager.ACCESSOR = new CsmFileTaskFactoryManager.Accessor(){

            public void fireChangeEvent(CsmFileTaskFactory csmFileTaskFactory) {
                csmFileTaskFactory.fileObjectsChanged();
            }
        };
    }

    private static final class CsmSafeRunnable
    implements Runnable {
        private CsmFile file;
        private Runnable run;

        public CsmSafeRunnable(Runnable runnable, CsmFile csmFile) {
            this.run = runnable;
            this.file = csmFile;
        }

        public void run() {
            if (this.file.isValid()) {
                this.run.run();
            }
        }
    }

    public static interface PhaseRunner {
        public void run(Phase var1);

        public boolean isValid();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Phase {
            INIT,
            PARSING_STARTED,
            PARSED,
            CLEANUP;

        }
    }

    private class ModelListener
    implements CsmModelListener {
        private ModelListener() {
        }

        public void projectOpened(CsmProject csmProject) {
        }

        public void projectClosed(CsmProject csmProject) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(CsmChangeEvent csmChangeEvent) {
            for (CsmFile csmFile : csmChangeEvent.getRemovedFiles()) {
                if (CsmFileTaskFactory.this.csm2task.get(csmFile) == null) continue;
                ModelListener modelListener = this;
                synchronized (modelListener) {
                    CsmFileTaskFactory.this.runTask(csmFile, PhaseRunner.Phase.CLEANUP, 0);
                    CsmFileTaskFactory.this.csm2task.put(csmFile, CsmFileTaskFactory.lazyRunner());
                }
            }
            if (!csmChangeEvent.getNewFiles().isEmpty()) {
                CsmFileTaskFactory.this.fileObjectsChanged();
            }
        }
    }

    private class ProgressListener
    extends CsmProgressAdapter {
        private ProgressListener() {
        }

        public void fileParsingFinished(CsmFile csmFile) {
            CsmFileTaskFactory.this.runTask(csmFile, PhaseRunner.Phase.PARSED, 0);
        }

        public void fileParsingStarted(CsmFile csmFile) {
            CsmFileTaskFactory.this.runTask(csmFile, PhaseRunner.Phase.PARSING_STARTED, 0);
        }
    }
}

