/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.model.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.OpenedEditors;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CaretAwareCsmFileTaskFactory
extends CsmFileTaskFactory {
    private static final int DEFAULT_RESCHEDULE_TIMEOUT = 300;
    private static final RequestProcessor WORKER = new RequestProcessor("CaretAwareCsmFileTaskFactory worker");
    private int timeout;
    private Map<JTextComponent, ComponentListener> component2Listener = new HashMap<JTextComponent, ComponentListener>();
    private static Map<FileObject, Integer> file2LastPosition = new WeakHashMap<FileObject, Integer>();

    public CaretAwareCsmFileTaskFactory() {
        OpenedEditors.getDefault().addChangeListener(new ChangeListenerImpl());
        this.timeout = 300;
    }

    public List<FileObject> getFileObjects() {
        List<FileObject> list = OpenedEditors.filterSupportedFiles(OpenedEditors.getDefault().getVisibleEditorsFiles());
        return list;
    }

    public static synchronized int getLastPosition(FileObject fileObject) {
        if (fileObject == null) {
            throw new NullPointerException("Cannot pass null file!");
        }
        Integer n = file2LastPosition.get(fileObject);
        if (n == null) {
            return 0;
        }
        return n;
    }

    static synchronized void setLastPosition(FileObject fileObject, int n) {
        file2LastPosition.put(fileObject, n);
    }

    private class ComponentListener
    implements CaretListener {
        private JTextComponent component;
        private final RequestProcessor.Task rescheduleTask;

        public ComponentListener(JTextComponent jTextComponent) {
            this.component = jTextComponent;
            this.rescheduleTask = WORKER.create(new Runnable(){

                public void run() {
                    FileObject fileObject = OpenedEditors.getFileObject(ComponentListener.this.component);
                    if (fileObject != null) {
                        CaretAwareCsmFileTaskFactory.setLastPosition(fileObject, ComponentListener.this.component.getCaretPosition());
                        CaretAwareCsmFileTaskFactory.this.reschedule(fileObject);
                    }
                }
            });
        }

        public void caretUpdate(CaretEvent caretEvent) {
            FileObject fileObject = OpenedEditors.getFileObject(this.component);
            if (fileObject != null) {
                CaretAwareCsmFileTaskFactory.setLastPosition(fileObject, this.component.getCaretPosition());
                this.rescheduleTask.schedule(CaretAwareCsmFileTaskFactory.this.timeout);
            }
        }
    }

    private class ChangeListenerImpl
    implements ChangeListener {
        private ChangeListenerImpl() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ArrayList<JTextComponent> arrayList = new ArrayList<JTextComponent>(OpenedEditors.getDefault().getVisibleEditors());
            ArrayList arrayList2 = new ArrayList(CaretAwareCsmFileTaskFactory.this.component2Listener.keySet());
            arrayList.removeAll(CaretAwareCsmFileTaskFactory.this.component2Listener.keySet());
            arrayList2.removeAll(OpenedEditors.getDefault().getVisibleEditors());
            for (JTextComponent jTextComponent : arrayList2) {
                jTextComponent.removeCaretListener((CaretListener)CaretAwareCsmFileTaskFactory.this.component2Listener.remove(jTextComponent));
            }
            for (JTextComponent jTextComponent : arrayList) {
                ComponentListener componentListener = new ComponentListener(jTextComponent);
                jTextComponent.addCaretListener(componentListener);
                CaretAwareCsmFileTaskFactory.this.component2Listener.put(jTextComponent, componentListener);
                CaretAwareCsmFileTaskFactory.setLastPosition(OpenedEditors.getFileObject(jTextComponent), jTextComponent.getCaretPosition());
            }
            CaretAwareCsmFileTaskFactory.this.fileObjectsChanged();
        }
    }
}

