/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsmSelect {
    private static CsmSelect DEFAULT = new Default();

    public abstract CsmFilterBuilder getFilterBuilder();

    public abstract Iterator<CsmMacro> getMacros(CsmFile var1, CsmFilter var2);

    public abstract Iterator<CsmInclude> getIncludes(CsmFile var1, CsmFilter var2);

    public abstract Iterator<CsmOffsetableDeclaration> getDeclarations(CsmFile var1, CsmFilter var2);

    public abstract Iterator<CsmVariable> getStaticVariables(CsmFile var1, CsmFilter var2);

    public abstract Iterator<CsmFunction> getStaticFunctions(CsmFile var1, CsmFilter var2);

    public abstract Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespace var1, CsmFilter var2);

    public abstract Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespaceDefinition var1, CsmFilter var2);

    public abstract Iterator<CsmMember> getClassMembers(CsmClass var1, CsmFilter var2);

    protected CsmSelect() {
    }

    public static synchronized CsmSelect getDefault() {
        return DEFAULT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Default
    extends CsmSelect {
        private final Lookup.Result<CsmSelect> res = Lookup.getDefault().lookupResult(CsmSelect.class);
        private static final boolean FIX_SERVICE = true;
        private CsmSelect fixedSelector;

        Default() {
        }

        private CsmSelect getService() {
            CsmSelect csmSelect = this.fixedSelector;
            if (csmSelect == null) {
                Iterator iterator = this.res.allInstances().iterator();
                if (iterator.hasNext()) {
                    CsmSelect csmSelect2;
                    csmSelect = csmSelect2 = (CsmSelect)iterator.next();
                }
                if (csmSelect != null) {
                    this.fixedSelector = csmSelect;
                }
            }
            return csmSelect;
        }

        @Override
        public CsmFilterBuilder getFilterBuilder() {
            CsmSelect csmSelect = this.getService();
            if (csmSelect != null) {
                return csmSelect.getFilterBuilder();
            }
            return null;
        }

        @Override
        public Iterator<CsmMacro> getMacros(CsmFile csmFile, CsmFilter csmFilter) {
            CsmSelect csmSelect = this.getService();
            if (csmSelect != null) {
                return csmSelect.getMacros(csmFile, csmFilter);
            }
            return null;
        }

        @Override
        public Iterator<CsmInclude> getIncludes(CsmFile csmFile, CsmFilter csmFilter) {
            CsmSelect csmSelect = this.getService();
            if (csmSelect != null) {
                return csmSelect.getIncludes(csmFile, csmFilter);
            }
            return null;
        }

        @Override
        public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespace csmNamespace, CsmFilter csmFilter) {
            CsmSelect csmSelect = this.getService();
            if (csmSelect != null) {
                return csmSelect.getDeclarations(csmNamespace, csmFilter);
            }
            return null;
        }

        @Override
        public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmFile csmFile, CsmFilter csmFilter) {
            CsmSelect csmSelect = this.getService();
            if (csmSelect != null) {
                return csmSelect.getDeclarations(csmFile, csmFilter);
            }
            return null;
        }

        @Override
        public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmNamespaceDefinition csmNamespaceDefinition, CsmFilter csmFilter) {
            CsmSelect csmSelect = this.getService();
            if (csmSelect != null) {
                return csmSelect.getDeclarations(csmNamespaceDefinition, csmFilter);
            }
            return null;
        }

        @Override
        public Iterator<CsmMember> getClassMembers(CsmClass csmClass, CsmFilter csmFilter) {
            CsmSelect csmSelect = this.getService();
            if (csmSelect != null) {
                return csmSelect.getClassMembers(csmClass, csmFilter);
            }
            return null;
        }

        @Override
        public Iterator<CsmVariable> getStaticVariables(CsmFile csmFile, CsmFilter csmFilter) {
            CsmSelect csmSelect = this.getService();
            if (csmSelect != null) {
                return csmSelect.getStaticVariables(csmFile, csmFilter);
            }
            return null;
        }

        @Override
        public Iterator<CsmFunction> getStaticFunctions(CsmFile csmFile, CsmFilter csmFilter) {
            CsmSelect csmSelect = this.getService();
            if (csmSelect != null) {
                return csmSelect.getStaticFunctions(csmFile, csmFilter);
            }
            return null;
        }
    }

    public static interface CsmFilterBuilder {
        public CsmFilter createKindFilter(CsmDeclaration.Kind[] var1);

        public CsmFilter createNameFilter(String var1, boolean var2, boolean var3, boolean var4);

        public CsmFilter createOffsetFilter(int var1, int var2);

        public CsmFilter createCompoundFilter(CsmFilter var1, CsmFilter var2);

        public CsmFilter createNameFilter(NameAcceptor var1);
    }

    public static interface NameAcceptor {
        public boolean accept(CharSequence var1);
    }

    public static interface CsmFilter {
    }
}

