/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.modules.debugger.jpda.expr.Assert2;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.Evaluator;
import org.netbeans.modules.debugger.jpda.expr.Expression2;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ReturnVariableImpl;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluatorVisitor
extends TreePathScanner<Mirror, EvaluationContext> {
    private static final Logger loggerMethod = Logger.getLogger("org.netbeans.modules.debugger.jpda.invokeMethod");
    private static final Logger loggerValue = Logger.getLogger("org.netbeans.modules.debugger.jpda.getValue");
    private Type newArrayType;
    private Expression2 expression;
    private static final String BRACKETS = "[][][][][][][][][][][][][][][][][][][][]";

    public EvaluatorVisitor(Expression2 expression2) {
        this.expression = expression2;
    }

    @Override
    public Mirror visitAnnotation(AnnotationTree annotationTree, EvaluationContext evaluationContext) {
        return null;
    }

    @Override
    public Mirror visitMethodInvocation(MethodInvocationTree methodInvocationTree, EvaluationContext evaluationContext) {
        Mirror mirror;
        Object object;
        Object object2;
        Object object3;
        ArrayList<Type> arrayList;
        Object object4;
        Object object5;
        Element element;
        Object object6;
        String string;
        Iterable<TypeMirror> iterable;
        if (!evaluationContext.canInvokeMethods()) {
            Assert2.error(methodInvocationTree, "calleeException", new UnsupportedOperationException(), evaluationContext);
        }
        if (loggerMethod.isLoggable(Level.FINE)) {
            loggerMethod.fine("STARTED : " + methodInvocationTree + " in thread " + evaluationContext.getFrame().thread());
        }
        Mirror mirror2 = null;
        Boolean bl = null;
        ExpressionTree expressionTree = methodInvocationTree.getMethodSelect();
        TreePath treePath = this.getCurrentPath();
        if (expressionTree.getKind() == Tree.Kind.MEMBER_SELECT) {
            iterable = (MemberSelectTree)expressionTree;
            mirror2 = iterable.getExpression().accept(this, evaluationContext);
            string = iterable.getIdentifier().toString();
            if (mirror2 == null) {
                Assert2.error((Tree)methodInvocationTree, "methodCallOnNull", string);
            }
            if (treePath != null) {
                object6 = TreePath.getPath(treePath, (Tree)((Object)iterable));
                if (object6 == null) {
                    object6 = treePath;
                }
                element = evaluationContext.getTrees().getElement((TreePath)object6);
            } else {
                element = null;
            }
        } else if (treePath != null) {
            iterable = TreePath.getPath(treePath, (Tree)methodInvocationTree);
            if (iterable == null) {
                iterable = treePath;
            }
            element = evaluationContext.getTrees().getElement((TreePath)iterable);
            string = element.getSimpleName().toString();
        } else {
            element = null;
            string = expressionTree.toString();
        }
        iterable = null;
        object6 = null;
        if (element != null) {
            object5 = element.asType();
            object4 = object5.getKind();
            if (object4 == TypeKind.ERROR) {
                element = null;
            } else {
                if (object4 != TypeKind.EXECUTABLE) {
                    Assert2.error(methodInvocationTree, "noSuchMethod", element.getSimpleName().toString(), element.getEnclosingElement().getSimpleName().toString());
                }
                arrayList = (ExecutableElement)element;
                object3 = (ExecutableType)object5;
                iterable = object3.getParameterTypes();
                bl = arrayList.getModifiers().contains((Object)Modifier.STATIC);
                object2 = arrayList.getEnclosingElement();
                if (object2.getKind() == ElementKind.CLASS) {
                    object = (TypeElement)object2;
                    object6 = ElementUtilities.getBinaryName((TypeElement)object);
                }
            }
        }
        object5 = methodInvocationTree.getArguments();
        object4 = new ArrayList(object5.size());
        arrayList = object5.iterator();
        while (arrayList.hasNext()) {
            object3 = (ExpressionTree)arrayList.next();
            object2 = object3.accept(this, evaluationContext);
            if (!(object2 instanceof Value)) {
                Assert2.error(object3, "Not a value");
            }
            object4.add((Value)object2);
        }
        arrayList = null;
        if (element == null) {
            arrayList = new ArrayList<Type>(object4.size());
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (Value)object3.next();
                if (object2 == null) {
                    arrayList.add(evaluationContext.getDebugger().getVirtualMachine().classesByName("java.lang.Object").get(0));
                    continue;
                }
                arrayList.add(object2.type());
            }
        }
        if (bl == null) {
            if (mirror2 instanceof ClassType || mirror2 instanceof ArrayType) {
                object2 = (ReferenceType)mirror2;
                object3 = null;
                bl = Boolean.TRUE;
            } else if (mirror2 instanceof ObjectReference) {
                object3 = (ObjectReference)mirror2;
                object2 = (ReferenceType)object3.type();
            } else {
                object3 = evaluationContext.getFrame().thisObject();
                object2 = evaluationContext.getFrame().location().declaringType();
            }
        } else if (bl.booleanValue()) {
            object3 = null;
            if (mirror2 instanceof ClassType || mirror2 instanceof ArrayType) {
                object2 = (ReferenceType)mirror2;
            } else if (mirror2 instanceof ObjectReference) {
                object2 = (ReferenceType)((ObjectReference)mirror2).type();
            } else {
                object2 = evaluationContext.getFrame().location().declaringType();
                if (object6 != null && (object = this.findEnclosingType((ReferenceType)object2, (String)object6)) != null) {
                    object2 = object;
                }
            }
        } else {
            if (mirror2 != null) {
                if (mirror2 instanceof ClassType) {
                    Assert2.error((Tree)methodInvocationTree, "invokeInstanceMethodAsStatic", string);
                    object3 = null;
                    object2 = null;
                } else {
                    object3 = (ObjectReference)mirror2;
                    object2 = object3.referenceType();
                }
            } else {
                object3 = evaluationContext.getFrame().thisObject();
                object2 = object3.referenceType();
                if (object6 != null && (object = this.findEnclosingType((ReferenceType)object2, (String)object6)) != null && (mirror = this.findEnclosingObject(methodInvocationTree, (ObjectReference)object3, (ReferenceType)object, null, string)) != null) {
                    object2 = mirror.referenceType();
                }
            }
            if (object3 == null) {
                Assert2.error((Tree)methodInvocationTree, "methodCallOnNull", string);
            }
        }
        if (object2 instanceof ArrayType) {
            Assert2.error(methodInvocationTree, "methOnArray");
            return null;
        }
        object = (ClassType)object2;
        mirror = EvaluatorVisitor.getConcreteMethodAndReportProblems(methodInvocationTree, (ReferenceType)object2, string, null, iterable, arrayList);
        return this.invokeMethod(methodInvocationTree, (Method)mirror, bl, (ClassType)object, (ObjectReference)object3, (List<Value>)object4, evaluationContext);
    }

    private static Method getConcreteMethodAndReportProblems(Tree tree, ReferenceType referenceType, String string, String string2, List<? extends TypeMirror> list, List<? extends Type> list2) {
        Method method;
        try {
            method = list != null ? EvaluatorVisitor.getConcreteMethod(referenceType, string, string2, list) : EvaluatorVisitor.getConcreteMethod2(referenceType, string, list2);
        }
        catch (UnsuitableArgumentsException unsuitableArgumentsException) {
            StringBuilder stringBuilder = new StringBuilder("(");
            if (list != null) {
                for (TypeMirror typeMirror : list) {
                    if (stringBuilder.length() > 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(((Object)typeMirror).toString());
                }
            } else {
                for (Type type : list2) {
                    if (stringBuilder.length() > 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(type.name());
                }
            }
            stringBuilder.append(")");
            if ("<init>".equals(string)) {
                Assert2.error(tree, "noSuchConstructorWithArgs", referenceType.name(), stringBuilder.toString());
            }
            if (stringBuilder.length() == 2) {
                Assert2.error(tree, "noSuchMethod", string + stringBuilder, referenceType.name());
            } else {
                Assert2.error(tree, "noSuchMethodWithArgs", string, referenceType.name(), stringBuilder.toString());
            }
            method = null;
        }
        if (method == null) {
            Assert2.error(tree, "noSuchMethod", string, referenceType.name());
        }
        return method;
    }

    private static Method getConcreteMethod(ReferenceType referenceType, String string, List<? extends TypeMirror> list) throws UnsuitableArgumentsException {
        return EvaluatorVisitor.getConcreteMethod(referenceType, string, null, list);
    }

    private static Method getConcreteMethod(ReferenceType referenceType, String string, String string2, List<? extends TypeMirror> list) throws UnsuitableArgumentsException {
        List<Method> list2 = referenceType.methodsByName(string);
        String string3 = EvaluatorVisitor.createSignature(string2, list);
        boolean bl = "<init>".equals(string);
        for (Method method : list2) {
            if (method.isAbstract() || bl && !((Object)referenceType).equals(method.declaringType()) || !EvaluatorVisitor.egualMethodSignatures(method.signature(), string3)) continue;
            return method;
        }
        if (list2.size() > 0) {
            throw new UnsuitableArgumentsException();
        }
        return null;
    }

    private static Method getConcreteMethod2(ReferenceType referenceType, String string, List<? extends Type> list) throws UnsuitableArgumentsException {
        List<Method> list2 = referenceType.methodsByName(string);
        ArrayList<Method> arrayList = new ArrayList<Method>();
        boolean bl = "<init>".equals(string);
        for (Method method : list2) {
            if (method.isAbstract() || bl && !((Object)referenceType).equals(method.declaringType())) continue;
            try {
                if (EvaluatorVisitor.equalTypes(method.argumentTypes(), list)) {
                    return method;
                }
                if (!EvaluatorVisitor.acceptTypes(method.argumentTypes(), list)) continue;
                arrayList.add(method);
            }
            catch (ClassNotLoadedException classNotLoadedException) {
            }
            catch (ObjectCollectedException objectCollectedException) {}
        }
        if (arrayList.size() == 0) {
            if (list2.size() > 0) {
                throw new UnsuitableArgumentsException();
            }
            return null;
        }
        return (Method)arrayList.get(0);
    }

    private static boolean equalTypes(List<? extends Type> list, List<? extends Type> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (list.get(i).equals(list2.get(i)) || EvaluatorVisitor.unboxType(list.get(i)).equals(EvaluatorVisitor.unboxType(list2.get(i)))) continue;
            return false;
        }
        return true;
    }

    private static boolean acceptTypes(List<? extends Type> list, List<? extends Type> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Type type;
            Type type2 = EvaluatorVisitor.unboxType(list.get(i));
            if (type2.equals(type = EvaluatorVisitor.unboxType(list2.get(i))) || EvaluatorVisitor.extendsType(type, type2)) continue;
            return false;
        }
        return true;
    }

    private static boolean extendsType(Type type, Type type2) {
        if (type2 instanceof ReferenceType && type instanceof ReferenceType) {
            return EvaluatorVisitor.extendsType((ReferenceType)type, (ReferenceType)type2);
        }
        if (type2 instanceof PrimitiveType && type instanceof PrimitiveType) {
            return EvaluatorVisitor.extendsType((PrimitiveType)type, (PrimitiveType)type2);
        }
        return false;
    }

    private static boolean extendsType(ReferenceType referenceType, ReferenceType referenceType2) {
        if (referenceType2 instanceof InterfaceType) {
            List<InterfaceType> list;
            if (referenceType instanceof ClassType) {
                list = ((ClassType)referenceType).allInterfaces();
            } else if (referenceType instanceof InterfaceType) {
                list = ((InterfaceType)referenceType).superinterfaces();
            } else {
                return false;
            }
            return list.contains(referenceType2);
        }
        if (referenceType2 instanceof ClassType) {
            if (referenceType instanceof ClassType) {
                ClassType classType = ((ClassType)referenceType).superclass();
                if (classType != null) {
                    if (classType.equals(referenceType2)) {
                        return true;
                    }
                    return EvaluatorVisitor.extendsType(classType, referenceType2);
                }
                return false;
            }
            return false;
        }
        if (referenceType2 instanceof ArrayType) {
            if (referenceType instanceof ArrayType) {
                try {
                    Type type = ((ArrayType)referenceType).componentType();
                    Type type2 = ((ArrayType)referenceType2).componentType();
                    return EvaluatorVisitor.extendsType(type, type2);
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    return false;
                }
            }
            return false;
        }
        throw new IllegalStateException("Unknown ReferenceType: " + referenceType2);
    }

    private static boolean extendsType(PrimitiveType primitiveType, PrimitiveType primitiveType2) {
        if (primitiveType2 instanceof ShortType) {
            return primitiveType2 instanceof ByteType || primitiveType2 instanceof ShortType;
        }
        if (primitiveType2 instanceof IntegerType) {
            return primitiveType2 instanceof ByteType || primitiveType2 instanceof ShortType || primitiveType2 instanceof IntegerType;
        }
        if (primitiveType2 instanceof LongType) {
            return primitiveType2 instanceof ByteType || primitiveType2 instanceof ShortType || primitiveType2 instanceof IntegerType || primitiveType2 instanceof LongType;
        }
        if (primitiveType2 instanceof FloatType) {
            return !(primitiveType2 instanceof BooleanType) && !(primitiveType2 instanceof CharType) && !(primitiveType2 instanceof DoubleType);
        }
        if (primitiveType2 instanceof DoubleType) {
            return !(primitiveType2 instanceof BooleanType) && !(primitiveType2 instanceof CharType);
        }
        return false;
    }

    private static Type unboxType(Type type) {
        if (type instanceof ClassType) {
            String string = ((ClassType)type).name();
            if (string.equals("java.lang.Boolean")) {
                type = type.virtualMachine().mirrorOf(true).type();
            } else if (string.equals("java.lang.Byte")) {
                type = type.virtualMachine().mirrorOf((byte)10).type();
            } else if (string.equals("java.lang.Character")) {
                type = type.virtualMachine().mirrorOf('a').type();
            } else if (string.equals("java.lang.Integer")) {
                type = type.virtualMachine().mirrorOf(10).type();
            } else if (string.equals("java.lang.Long")) {
                type = type.virtualMachine().mirrorOf(10L).type();
            } else if (string.equals("java.lang.Short")) {
                type = type.virtualMachine().mirrorOf((short)10).type();
            } else if (string.equals("java.lang.Float")) {
                type = type.virtualMachine().mirrorOf(10.0f).type();
            } else if (string.equals("java.lang.Double")) {
                type = type.virtualMachine().mirrorOf(10.0).type();
            }
        }
        return type;
    }

    private static boolean egualMethodSignatures(String string, String string2) {
        int n = string.lastIndexOf(")");
        if (n > 0) {
            string = string.substring(0, n);
        }
        if ((n = string2.lastIndexOf(")")) > 0) {
            string2 = string2.substring(0, n);
        }
        return string.equals(string2);
    }

    private static String createSignature(String string, List<? extends TypeMirror> list) {
        StringBuilder stringBuilder = new StringBuilder("(");
        if (string != null) {
            stringBuilder.append(string);
        }
        for (TypeMirror typeMirror : list) {
            String string2 = EvaluatorVisitor.getTypeName(typeMirror);
            stringBuilder.append(EvaluatorVisitor.getSignature(string2));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static String getTypeName(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.ARRAY) {
            return EvaluatorVisitor.getTypeName(((javax.lang.model.type.ArrayType)typeMirror).getComponentType()) + "[]";
        }
        if (typeMirror.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typeVariable = (TypeVariable)typeMirror;
            return EvaluatorVisitor.getTypeName(typeVariable.getUpperBound());
        }
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            return ((DeclaredType)typeMirror).asElement().toString();
        }
        return ((Object)typeMirror).toString();
    }

    private static String getSignature(String string) {
        if (string.equals("boolean")) {
            return "Z";
        }
        if (string.equals("byte")) {
            return "B";
        }
        if (string.equals("char")) {
            return "C";
        }
        if (string.equals("short")) {
            return "S";
        }
        if (string.equals("int")) {
            return "I";
        }
        if (string.equals("long")) {
            return "J";
        }
        if (string.equals("float")) {
            return "F";
        }
        if (string.equals("double")) {
            return "D";
        }
        if (string.endsWith("[]")) {
            return "[" + EvaluatorVisitor.getSignature(string.substring(0, string.length() - 2));
        }
        return "L" + string.replace('.', '/') + ";";
    }

    private static ReferenceType getClassType(Tree tree, TypeMirror typeMirror, EvaluationContext evaluationContext) {
        String string = ElementUtilities.getBinaryName((TypeElement)((TypeElement)((DeclaredType)typeMirror).asElement()));
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        List<ReferenceType> list = virtualMachine.classesByName(string);
        if (list.size() == 0) {
            Assert2.error(tree, "unknownType", string);
        }
        return list.get(0);
    }

    private boolean instanceOf(Type type, Type type2) {
        if (type == null) {
            return false;
        }
        if (type.equals(type2)) {
            return true;
        }
        if (type2 instanceof ArrayType) {
            Type type3;
            Type type4;
            if (!(type instanceof ArrayType)) {
                return false;
            }
            ArrayType arrayType = (ArrayType)type;
            ArrayType arrayType2 = (ArrayType)type2;
            try {
                type4 = arrayType.componentType();
                type3 = arrayType2.componentType();
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                return false;
            }
            return this.instanceOf(type4, type3);
        }
        if (type instanceof ClassType) {
            ClassType classType = (ClassType)type;
            if (type2 instanceof InterfaceType) {
                List<InterfaceType> list = classType.allInterfaces();
                for (InterfaceType interfaceType : list) {
                    if (!interfaceType.equals(type2)) continue;
                    return true;
                }
                return false;
            }
            do {
                if ((classType = classType.superclass()) != null) continue;
                return false;
            } while (!classType.equals(type2));
            return true;
        }
        if (type instanceof InterfaceType) {
            InterfaceType interfaceType = (InterfaceType)type;
            if (type2 instanceof InterfaceType) {
                List<InterfaceType> list = interfaceType.superinterfaces();
                for (InterfaceType interfaceType2 : list) {
                    if (!interfaceType2.equals(type2)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public Mirror visitAssert(AssertTree assertTree, EvaluationContext evaluationContext) {
        Assert2.error(assertTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitAssignment(AssignmentTree assignmentTree, EvaluationContext evaluationContext) {
        Mirror mirror = assignmentTree.getVariable().accept(this, evaluationContext);
        Mirror mirror2 = assignmentTree.getExpression().accept(this, evaluationContext);
        Value value = (Value)mirror2;
        this.setToMirror(assignmentTree.getVariable(), value, evaluationContext);
        return value;
    }

    @Override
    public Mirror visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, EvaluationContext evaluationContext) {
        Mirror mirror = compoundAssignmentTree.getVariable().accept(this, evaluationContext);
        Mirror mirror2 = compoundAssignmentTree.getExpression().accept(this, evaluationContext);
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        Tree.Kind kind = compoundAssignmentTree.getKind();
        if (mirror instanceof BooleanValue) {
            boolean bl = ((BooleanValue)mirror).value();
            boolean bl2 = ((BooleanValue)mirror2).value();
            switch (kind) {
                case AND_ASSIGNMENT: {
                    bl &= bl2;
                    break;
                }
                case OR_ASSIGNMENT: {
                    bl |= bl2;
                    break;
                }
                case XOR_ASSIGNMENT: {
                    bl ^= bl2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown assignment: " + (Object)((Object)kind) + " of " + compoundAssignmentTree);
                }
            }
            BooleanValue booleanValue = virtualMachine.mirrorOf(bl);
            this.setToMirror(compoundAssignmentTree.getVariable(), booleanValue, evaluationContext);
            return booleanValue;
        }
        if (mirror instanceof DoubleValue) {
            double d = ((DoubleValue)mirror).value();
            double d2 = ((PrimitiveValue)mirror2).doubleValue();
            switch (kind) {
                case DIVIDE_ASSIGNMENT: {
                    d /= d2;
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    d -= d2;
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    d *= d2;
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    d += d2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown assignment: " + (Object)((Object)kind) + " of " + compoundAssignmentTree);
                }
            }
            DoubleValue doubleValue = virtualMachine.mirrorOf(d);
            this.setToMirror(compoundAssignmentTree.getVariable(), doubleValue, evaluationContext);
            return doubleValue;
        }
        if (mirror instanceof FloatValue) {
            float f = ((FloatValue)mirror).value();
            float f2 = ((PrimitiveValue)mirror2).floatValue();
            switch (kind) {
                case DIVIDE_ASSIGNMENT: {
                    f /= f2;
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    f -= f2;
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    f *= f2;
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    f += f2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown assignment: " + (Object)((Object)kind) + " of " + compoundAssignmentTree);
                }
            }
            FloatValue floatValue = virtualMachine.mirrorOf(f);
            this.setToMirror(compoundAssignmentTree.getVariable(), floatValue, evaluationContext);
            return floatValue;
        }
        if (mirror instanceof LongValue) {
            long l = ((LongValue)mirror).value();
            long l2 = ((PrimitiveValue)mirror2).longValue();
            switch (kind) {
                case AND_ASSIGNMENT: {
                    l &= l2;
                    break;
                }
                case DIVIDE_ASSIGNMENT: {
                    l /= l2;
                    break;
                }
                case LEFT_SHIFT_ASSIGNMENT: {
                    l <<= (int)l2;
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    l -= l2;
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    l *= l2;
                    break;
                }
                case OR_ASSIGNMENT: {
                    l |= l2;
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    l += l2;
                    break;
                }
                case REMAINDER_ASSIGNMENT: {
                    l %= l2;
                    break;
                }
                case RIGHT_SHIFT_ASSIGNMENT: {
                    l >>= (int)l2;
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                    l >>>= (int)l2;
                    break;
                }
                case XOR_ASSIGNMENT: {
                    l ^= l2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown assignment: " + (Object)((Object)kind) + " of " + compoundAssignmentTree);
                }
            }
            LongValue longValue = virtualMachine.mirrorOf(l);
            this.setToMirror(compoundAssignmentTree.getVariable(), longValue, evaluationContext);
            return longValue;
        }
        if (mirror instanceof IntegerValue) {
            int n = ((IntegerValue)mirror).value();
            int n2 = ((PrimitiveValue)mirror2).intValue();
            switch (kind) {
                case AND_ASSIGNMENT: {
                    n &= n2;
                    break;
                }
                case DIVIDE_ASSIGNMENT: {
                    n /= n2;
                    break;
                }
                case LEFT_SHIFT_ASSIGNMENT: {
                    n <<= n2;
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    n -= n2;
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    n *= n2;
                    break;
                }
                case OR_ASSIGNMENT: {
                    n |= n2;
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    n += n2;
                    break;
                }
                case REMAINDER_ASSIGNMENT: {
                    n %= n2;
                    break;
                }
                case RIGHT_SHIFT_ASSIGNMENT: {
                    n >>= n2;
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                    n >>>= n2;
                    break;
                }
                case XOR_ASSIGNMENT: {
                    n ^= n2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown assignment: " + (Object)((Object)kind) + " of " + compoundAssignmentTree);
                }
            }
            IntegerValue integerValue = virtualMachine.mirrorOf(n);
            this.setToMirror(compoundAssignmentTree.getVariable(), integerValue, evaluationContext);
            return integerValue;
        }
        if (mirror instanceof StringReference) {
            String string = ((StringReference)mirror).value();
            String string2 = ((StringReference)mirror2).value();
            switch (kind) {
                case PLUS_ASSIGNMENT: {
                    string = string + string2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown assignment: " + (Object)((Object)kind) + " of " + compoundAssignmentTree);
                }
            }
            StringReference stringReference = virtualMachine.mirrorOf(string);
            this.setToMirror(compoundAssignmentTree.getVariable(), stringReference, evaluationContext);
            return stringReference;
        }
        throw new IllegalStateException("Unknown assignment var type: " + mirror);
    }

    @Override
    public Mirror visitBinary(BinaryTree binaryTree, EvaluationContext evaluationContext) {
        boolean bl;
        Mirror mirror = binaryTree.getLeftOperand().accept(this, evaluationContext);
        Mirror mirror2 = binaryTree.getRightOperand().accept(this, evaluationContext);
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        Tree.Kind kind = binaryTree.getKind();
        if (mirror instanceof ObjectReference) {
            mirror = EvaluatorVisitor.unboxIfCan(binaryTree, (ObjectReference)mirror, evaluationContext);
        }
        if (mirror2 instanceof ObjectReference) {
            mirror2 = EvaluatorVisitor.unboxIfCan(binaryTree, (ObjectReference)mirror2, evaluationContext);
        }
        if (mirror instanceof BooleanValue && mirror2 instanceof BooleanValue) {
            boolean bl2;
            boolean bl3 = ((BooleanValue)mirror).booleanValue();
            boolean bl4 = ((BooleanValue)mirror2).booleanValue();
            switch (kind) {
                case AND: {
                    bl2 = bl3 & bl4;
                    break;
                }
                case CONDITIONAL_AND: {
                    bl2 = bl3 && bl4;
                    break;
                }
                case CONDITIONAL_OR: {
                    bl2 = bl3 || bl4;
                    break;
                }
                case EQUAL_TO: {
                    bl2 = bl3 == bl4;
                    break;
                }
                case NOT_EQUAL_TO: {
                    bl2 = bl3 != bl4;
                    break;
                }
                case OR: {
                    bl2 = bl3 | bl4;
                    break;
                }
                case XOR: {
                    bl2 = bl3 ^ bl4;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled binary tree: " + binaryTree);
                }
            }
            return virtualMachine.mirrorOf(bl2);
        }
        boolean bl5 = mirror instanceof PrimitiveValue && !(mirror instanceof BooleanValue);
        boolean bl6 = bl = mirror2 instanceof PrimitiveValue && !(mirror2 instanceof BooleanValue);
        if (bl5 && bl) {
            if (mirror instanceof DoubleValue || mirror2 instanceof DoubleValue) {
                double d = ((PrimitiveValue)mirror).doubleValue();
                double d2 = ((PrimitiveValue)mirror2).doubleValue();
                double d3 = 0.0;
                boolean bl7 = false;
                boolean bl8 = true;
                switch (kind) {
                    case DIVIDE: {
                        d3 = d / d2;
                        bl8 = false;
                        break;
                    }
                    case MINUS: {
                        d3 = d - d2;
                        bl8 = false;
                        break;
                    }
                    case MULTIPLY: {
                        d3 = d * d2;
                        bl8 = false;
                        break;
                    }
                    case PLUS: {
                        d3 = d + d2;
                        bl8 = false;
                        break;
                    }
                    case EQUAL_TO: {
                        bl7 = d == d2;
                        break;
                    }
                    case GREATER_THAN: {
                        bl7 = d > d2;
                        break;
                    }
                    case GREATER_THAN_EQUAL: {
                        bl7 = d >= d2;
                        break;
                    }
                    case LESS_THAN: {
                        bl7 = d < d2;
                        break;
                    }
                    case LESS_THAN_EQUAL: {
                        bl7 = d <= d2;
                        break;
                    }
                    case NOT_EQUAL_TO: {
                        bl7 = d != d2;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled binary tree: " + binaryTree);
                    }
                }
                if (bl8) {
                    return virtualMachine.mirrorOf(bl7);
                }
                return virtualMachine.mirrorOf(d3);
            }
            if (mirror instanceof FloatValue || mirror2 instanceof FloatValue) {
                float f = ((PrimitiveValue)mirror).floatValue();
                float f2 = ((PrimitiveValue)mirror2).floatValue();
                float f3 = 0.0f;
                boolean bl9 = false;
                boolean bl10 = true;
                switch (kind) {
                    case DIVIDE: {
                        f3 = f / f2;
                        bl10 = false;
                        break;
                    }
                    case MINUS: {
                        f3 = f - f2;
                        bl10 = false;
                        break;
                    }
                    case MULTIPLY: {
                        f3 = f * f2;
                        bl10 = false;
                        break;
                    }
                    case PLUS: {
                        f3 = f + f2;
                        bl10 = false;
                        break;
                    }
                    case EQUAL_TO: {
                        bl9 = f == f2;
                        break;
                    }
                    case GREATER_THAN: {
                        bl9 = f > f2;
                        break;
                    }
                    case GREATER_THAN_EQUAL: {
                        bl9 = f >= f2;
                        break;
                    }
                    case LESS_THAN: {
                        bl9 = f < f2;
                        break;
                    }
                    case LESS_THAN_EQUAL: {
                        bl9 = f <= f2;
                        break;
                    }
                    case NOT_EQUAL_TO: {
                        bl9 = f != f2;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled binary tree: " + binaryTree);
                    }
                }
                if (bl10) {
                    return virtualMachine.mirrorOf(bl9);
                }
                return virtualMachine.mirrorOf(f3);
            }
            if (mirror instanceof LongValue || mirror2 instanceof LongValue) {
                long l = ((PrimitiveValue)mirror).longValue();
                long l2 = ((PrimitiveValue)mirror2).longValue();
                long l3 = 0L;
                boolean bl11 = false;
                boolean bl12 = false;
                switch (kind) {
                    case DIVIDE: {
                        l3 = l / l2;
                        break;
                    }
                    case MINUS: {
                        l3 = l - l2;
                        break;
                    }
                    case MULTIPLY: {
                        l3 = l * l2;
                        break;
                    }
                    case PLUS: {
                        l3 = l + l2;
                        break;
                    }
                    case REMAINDER: {
                        l3 = l % l2;
                        break;
                    }
                    case LEFT_SHIFT: {
                        l3 = l << (int)l2;
                        break;
                    }
                    case RIGHT_SHIFT: {
                        l3 = l >> (int)l2;
                        break;
                    }
                    case UNSIGNED_RIGHT_SHIFT: {
                        l3 = l >>> (int)l2;
                        break;
                    }
                    case AND: {
                        l3 = l & l2;
                        break;
                    }
                    case OR: {
                        l3 = l | l2;
                        break;
                    }
                    case XOR: {
                        l3 = l ^ l2;
                        break;
                    }
                    case EQUAL_TO: {
                        bl11 = l == l2;
                        bl12 = true;
                        break;
                    }
                    case GREATER_THAN: {
                        bl11 = l > l2;
                        bl12 = true;
                        break;
                    }
                    case GREATER_THAN_EQUAL: {
                        bl11 = l >= l2;
                        bl12 = true;
                        break;
                    }
                    case LESS_THAN: {
                        bl11 = l < l2;
                        bl12 = true;
                        break;
                    }
                    case LESS_THAN_EQUAL: {
                        bl11 = l <= l2;
                        bl12 = true;
                        break;
                    }
                    case NOT_EQUAL_TO: {
                        bl11 = l != l2;
                        bl12 = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled binary tree: " + binaryTree);
                    }
                }
                if (bl12) {
                    return virtualMachine.mirrorOf(bl11);
                }
                return virtualMachine.mirrorOf(l3);
            }
            int n = ((PrimitiveValue)mirror).intValue();
            int n2 = ((PrimitiveValue)mirror2).intValue();
            int n3 = 0;
            boolean bl13 = false;
            boolean bl14 = false;
            switch (kind) {
                case DIVIDE: {
                    n3 = n / n2;
                    break;
                }
                case MINUS: {
                    n3 = n - n2;
                    break;
                }
                case MULTIPLY: {
                    n3 = n * n2;
                    break;
                }
                case PLUS: {
                    n3 = n + n2;
                    break;
                }
                case REMAINDER: {
                    n3 = n % n2;
                    break;
                }
                case LEFT_SHIFT: {
                    n3 = n << n2;
                    break;
                }
                case RIGHT_SHIFT: {
                    n3 = n >> n2;
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT: {
                    n3 = n >>> n2;
                    break;
                }
                case AND: {
                    n3 = n & n2;
                    break;
                }
                case OR: {
                    n3 = n | n2;
                    break;
                }
                case XOR: {
                    n3 = n ^ n2;
                    break;
                }
                case EQUAL_TO: {
                    bl13 = n == n2;
                    bl14 = true;
                    break;
                }
                case GREATER_THAN: {
                    bl13 = n > n2;
                    bl14 = true;
                    break;
                }
                case GREATER_THAN_EQUAL: {
                    bl13 = n >= n2;
                    bl14 = true;
                    break;
                }
                case LESS_THAN: {
                    bl13 = n < n2;
                    bl14 = true;
                    break;
                }
                case LESS_THAN_EQUAL: {
                    bl13 = n <= n2;
                    bl14 = true;
                    break;
                }
                case NOT_EQUAL_TO: {
                    bl13 = n != n2;
                    bl14 = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled binary tree: " + binaryTree);
                }
            }
            if (bl14) {
                return virtualMachine.mirrorOf(bl13);
            }
            return virtualMachine.mirrorOf(n3);
        }
        if ((mirror == null || mirror instanceof StringReference) && (mirror2 == null || mirror2 instanceof StringReference) && kind == Tree.Kind.PLUS) {
            String string = mirror == null ? null : ((StringReference)mirror).value();
            String string2 = mirror2 == null ? null : ((StringReference)mirror2).value();
            switch (kind) {
                case PLUS: {
                    return virtualMachine.mirrorOf(string + string2);
                }
            }
            throw new IllegalStateException("Unhandled binary tree: " + binaryTree);
        }
        if ((mirror instanceof StringReference || mirror2 instanceof StringReference) && kind == Tree.Kind.PLUS) {
            String string = mirror instanceof StringReference ? ((StringReference)mirror).value() : this.toString(binaryTree, mirror, evaluationContext);
            String string3 = mirror2 instanceof StringReference ? ((StringReference)mirror2).value() : this.toString(binaryTree, mirror2, evaluationContext);
            return virtualMachine.mirrorOf(string + string3);
        }
        switch (kind) {
            case EQUAL_TO: {
                return virtualMachine.mirrorOf(mirror == mirror2 || mirror != null && mirror.equals(mirror2));
            }
            case NOT_EQUAL_TO: {
                return virtualMachine.mirrorOf(mirror == null && mirror2 != null || mirror != null && !mirror.equals(mirror2));
            }
        }
        throw new IllegalStateException("Unhandled binary tree: " + binaryTree);
    }

    @Override
    public Mirror visitBlock(BlockTree blockTree, EvaluationContext evaluationContext) {
        Assert2.error(blockTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitBreak(BreakTree breakTree, EvaluationContext evaluationContext) {
        Assert2.error(breakTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitCase(CaseTree caseTree, EvaluationContext evaluationContext) {
        Assert2.error(caseTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitCatch(CatchTree catchTree, EvaluationContext evaluationContext) {
        Assert2.error(catchTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitClass(ClassTree classTree, EvaluationContext evaluationContext) {
        Assert2.error(classTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitConditionalExpression(ConditionalExpressionTree conditionalExpressionTree, EvaluationContext evaluationContext) {
        Mirror mirror = conditionalExpressionTree.getCondition().accept(this, evaluationContext);
        if (!(mirror instanceof BooleanValue)) {
            throw new IllegalStateException("Condition must be boolean: " + conditionalExpressionTree.getCondition());
        }
        boolean bl = ((BooleanValue)mirror).value();
        if (bl) {
            return conditionalExpressionTree.getTrueExpression().accept(this, evaluationContext);
        }
        return conditionalExpressionTree.getFalseExpression().accept(this, evaluationContext);
    }

    @Override
    public Mirror visitContinue(ContinueTree continueTree, EvaluationContext evaluationContext) {
        Assert2.error(continueTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitDoWhileLoop(DoWhileLoopTree doWhileLoopTree, EvaluationContext evaluationContext) {
        Assert2.error(doWhileLoopTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitErroneous(ErroneousTree erroneousTree, EvaluationContext evaluationContext) {
        Assert2.error(erroneousTree, "errorneous");
        return null;
    }

    @Override
    public Mirror visitExpressionStatement(ExpressionStatementTree expressionStatementTree, EvaluationContext evaluationContext) {
        return expressionStatementTree.getExpression().accept(this, evaluationContext);
    }

    @Override
    public Mirror visitEnhancedForLoop(EnhancedForLoopTree enhancedForLoopTree, EvaluationContext evaluationContext) {
        Assert2.error(enhancedForLoopTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitForLoop(ForLoopTree forLoopTree, EvaluationContext evaluationContext) {
        Assert2.error(forLoopTree, "unsupported");
        return null;
    }

    private Mirror getIdentifierByName(IdentifierTree identifierTree, EvaluationContext evaluationContext) {
        Mirror mirror;
        Comparable<ReferenceType> comparable;
        String string = identifierTree.getName().toString();
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        List<ReferenceType> list = virtualMachine.classesByName(string);
        if (list.size() > 0) {
            return list.get(0);
        }
        if (string.equals("this")) {
            return evaluationContext.getFrame().thisObject();
        }
        if (string.equals("super") && (comparable = evaluationContext.getFrame().location().declaringType()) instanceof ClassType) {
            ClassType classType = ((ClassType)comparable).superclass();
            ObjectReference objectReference = evaluationContext.getFrame().thisObject();
            if (objectReference == null) {
                return classType;
            }
            return objectReference;
        }
        comparable = evaluationContext.getFrame().location().declaringType().fieldByName(string);
        if (comparable != null) {
            if (comparable.isStatic()) {
                evaluationContext.getVariables().put(identifierTree, new EvaluationContext.VariableInfo((Field)comparable));
                return comparable.declaringType().getValue((Field)comparable);
            }
            mirror = evaluationContext.getFrame().thisObject();
            if (mirror != null) {
                evaluationContext.getVariables().put(identifierTree, new EvaluationContext.VariableInfo((Field)comparable, (ObjectReference)mirror));
                return mirror.getValue((Field)comparable);
            }
        }
        try {
            mirror = evaluationContext.getFrame().visibleVariableByName(string);
            if (mirror == null) {
                Field field;
                ObjectReference objectReference = evaluationContext.getFrame().thisObject();
                if (objectReference != null && (field = objectReference.referenceType().fieldByName("val$" + string)) != null) {
                    Value value = objectReference.getValue(field);
                    evaluationContext.getVariables().put(identifierTree, new EvaluationContext.VariableInfo(field, objectReference));
                    return value;
                }
                Assert2.error((Tree)identifierTree, "unknownVariable", string);
            }
            evaluationContext.getVariables().put(identifierTree, new EvaluationContext.VariableInfo((com.sun.jdi.LocalVariable)mirror));
            return evaluationContext.getFrame().getValue((com.sun.jdi.LocalVariable)mirror);
        }
        catch (AbsentInformationException absentInformationException) {
            Assert2.error((Tree)identifierTree, "unknownType", string);
            return null;
        }
    }

    @Override
    public Mirror visitIdentifier(IdentifierTree identifierTree, EvaluationContext evaluationContext) {
        Object object;
        String string = identifierTree.getName().toString();
        if (this.expression.classReplaced().equals(string)) {
            ReferenceType referenceType = evaluationContext.getFrame().location().declaringType();
            JPDAClassType jPDAClassType = evaluationContext.getDebugger().getClassType(referenceType);
            return ((JDIVariable)jPDAClassType.classObject()).getJDIValue();
        }
        if (this.expression.returnReplaced().equals(string)) {
            ThreadReference threadReference = evaluationContext.getFrame().thread();
            JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)evaluationContext.getDebugger().getThread(threadReference);
            ReturnVariableImpl returnVariableImpl = jPDAThreadImpl.getReturnVariable();
            if (returnVariableImpl != null) {
                return returnVariableImpl.getJDIValue();
            }
            return null;
        }
        TreePath treePath = this.getCurrentPath();
        Element element = null;
        if (treePath != null) {
            object = TreePath.getPath(treePath, (Tree)identifierTree);
            if (object == null) {
                object = this.getCurrentPath();
            }
            if ((element = evaluationContext.getTrees().getElement((TreePath)object)) instanceof TypeElement && ((TypeElement)element).asType() instanceof ErrorType) {
                treePath = null;
            }
        }
        if (treePath == null) {
            return this.getIdentifierByName(identifierTree, evaluationContext);
        }
        switch (element.getKind()) {
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                object = (TypeElement)element;
                String string2 = ElementUtilities.getBinaryName((TypeElement)object);
                VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
                if (virtualMachine == null) {
                    return null;
                }
                List<ReferenceType> list = virtualMachine.classesByName(string2);
                if (list.size() > 0) {
                    return list.get(0);
                }
                Assert2.error((Tree)identifierTree, "unknownType", string2);
            }
            case ENUM_CONSTANT: {
                return this.getEnumConstant(identifierTree, (VariableElement)element, evaluationContext);
            }
            case FIELD: {
                Comparable<Field> comparable;
                Comparable<Field> comparable2;
                Object object2;
                VariableElement variableElement = (VariableElement)element;
                String string3 = variableElement.getSimpleName().toString();
                if (string3.equals("this")) {
                    return evaluationContext.getFrame().thisObject();
                }
                if (string3.equals("super") && (object2 = evaluationContext.getFrame().location().declaringType()) instanceof ClassType) {
                    ClassType classType = ((ClassType)object2).superclass();
                    ObjectReference objectReference = evaluationContext.getFrame().thisObject();
                    if (objectReference == null) {
                        return classType;
                    }
                    return objectReference;
                }
                object2 = variableElement.getEnclosingElement();
                String string4 = null;
                if (object2.getKind() == ElementKind.CLASS) {
                    comparable2 = (TypeElement)object2;
                    string4 = ElementUtilities.getBinaryName((TypeElement)((Object)comparable2));
                }
                comparable2 = evaluationContext.getFrame().location().declaringType();
                if (string4 != null && (comparable = this.findEnclosingType((ReferenceType)comparable2, string4)) != null) {
                    comparable2 = comparable;
                }
                if ((comparable = comparable2.fieldByName(string3)) == null) {
                    Assert2.error((Tree)identifierTree, "unknownVariable", string3);
                }
                if (comparable.isStatic()) {
                    evaluationContext.getVariables().put(identifierTree, new EvaluationContext.VariableInfo((Field)comparable));
                    return comparable2.getValue((Field)comparable);
                }
                ObjectReference objectReference = evaluationContext.getFrame().thisObject();
                if (objectReference != null) {
                    ObjectReference objectReference2;
                    if (comparable.isPrivate()) {
                        objectReference2 = this.findEnclosingObject(identifierTree, objectReference, (ReferenceType)comparable2, comparable.name(), null);
                        if (objectReference2 != null) {
                            objectReference = objectReference2;
                        }
                    } else if (!this.instanceOf(objectReference.referenceType(), (Type)((Object)comparable2)) && (objectReference2 = this.findEnclosingObject(identifierTree, objectReference, (ReferenceType)comparable2, comparable.name(), null)) != null) {
                        objectReference = objectReference2;
                    }
                    evaluationContext.getVariables().put(identifierTree, new EvaluationContext.VariableInfo((Field)comparable, objectReference));
                    try {
                        return objectReference.getValue((Field)comparable);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Logger.getLogger(this.getClass().getName()).severe("field = " + comparable + ", thisObject = " + objectReference);
                        throw illegalArgumentException;
                    }
                }
                Assert2.error((Tree)identifierTree, "accessInstanceVariableFromStaticContext", string3);
                throw new IllegalStateException("No current instance available.");
            }
            case LOCAL_VARIABLE: 
            case EXCEPTION_PARAMETER: {
                VariableElement variableElement = (VariableElement)element;
                String string5 = variableElement.getSimpleName().toString();
                try {
                    com.sun.jdi.LocalVariable localVariable = evaluationContext.getFrame().visibleVariableByName(string5);
                    if (localVariable == null) {
                        Field field;
                        ObjectReference objectReference = evaluationContext.getFrame().thisObject();
                        if (objectReference != null && (field = objectReference.referenceType().fieldByName("val$" + string5)) != null) {
                            Value value = objectReference.getValue(field);
                            evaluationContext.getVariables().put(identifierTree, new EvaluationContext.VariableInfo(field, objectReference));
                            return value;
                        }
                        Assert2.error((Tree)identifierTree, "unknownVariable", string5);
                    }
                    evaluationContext.getVariables().put(identifierTree, new EvaluationContext.VariableInfo(localVariable));
                    return evaluationContext.getFrame().getValue(localVariable);
                }
                catch (AbsentInformationException absentInformationException) {
                    return (Value)Assert2.error((Tree)identifierTree, "unknownVariable", string5);
                }
            }
            case PARAMETER: {
                VariableElement variableElement = (VariableElement)element;
                String string6 = variableElement.getSimpleName().toString();
                StackFrame stackFrame = evaluationContext.getFrame();
                try {
                    com.sun.jdi.LocalVariable localVariable = stackFrame.visibleVariableByName(string6);
                    if (localVariable == null) {
                        Field field;
                        ObjectReference objectReference = stackFrame.thisObject();
                        if (objectReference != null && (field = objectReference.referenceType().fieldByName("val$" + string6)) != null) {
                            Value value = objectReference.getValue(field);
                            evaluationContext.getVariables().put(identifierTree, new EvaluationContext.VariableInfo(field, objectReference));
                            return value;
                        }
                        Assert2.error((Tree)identifierTree, "unknownVariable", string6);
                    }
                    evaluationContext.getVariables().put(identifierTree, new EvaluationContext.VariableInfo(localVariable));
                    return stackFrame.getValue(localVariable);
                }
                catch (AbsentInformationException absentInformationException) {
                    try {
                        LocalVariable[] localVariableArray = new CallStackFrameImpl((JPDAThreadImpl)evaluationContext.getDebugger().getThread(stackFrame.thread()), stackFrame, 0, evaluationContext.getDebugger()).getMethodArguments();
                        if (localVariableArray != null) {
                            for (LocalVariable localVariable : localVariableArray) {
                                if (!string6.equals(localVariable.getName())) continue;
                                return ((JDIVariable)localVariable).getJDIValue();
                            }
                        }
                    }
                    catch (NativeMethodException nativeMethodException) {
                        // empty catch block
                    }
                    return (Value)Assert2.error((Tree)identifierTree, "unknownVariable", string6);
                }
            }
            case PACKAGE: {
                return (Value)Assert2.error(identifierTree, "notExpression");
            }
        }
        throw new UnsupportedOperationException("Not supported element kind:" + (Object)((Object)element.getKind()) + " Tree = '" + identifierTree + "'");
    }

    private ReferenceType findEnclosingType(ReferenceType referenceType, String string) {
        if (referenceType.name().equals(string)) {
            return referenceType;
        }
        List<ReferenceType> list = referenceType.virtualMachine().classesByName(string);
        if (list.size() == 1) {
            return list.get(0);
        }
        for (ReferenceType referenceType2 : list) {
            if (!this.isNestedOf(referenceType2, referenceType)) continue;
            return referenceType2;
        }
        return null;
    }

    private boolean isNestedOf(ReferenceType referenceType, ReferenceType referenceType2) {
        if (((Object)referenceType).equals(referenceType2)) {
            return true;
        }
        for (ReferenceType referenceType3 : referenceType.nestedTypes()) {
            if (!this.isNestedOf(referenceType3, referenceType2)) continue;
            return true;
        }
        return false;
    }

    private ObjectReference findEnclosingObject(Tree tree, ObjectReference objectReference, ReferenceType referenceType, String string, String string2) {
        if (this.instanceOf(objectReference.referenceType(), referenceType)) {
            return objectReference;
        }
        if (((ReferenceType)objectReference.type()).isStatic()) {
            if (string != null) {
                Assert2.error(tree, "accessInstanceVariableFromStaticContext", string);
            }
            if (string2 != null) {
                Assert2.error(tree, "invokeInstanceMethodAsStatic", string2);
            }
            return null;
        }
        Field field = null;
        for (int i = 0; i < 9 && (field = objectReference.referenceType().fieldByName("this$" + i)) == null; ++i) {
        }
        if (field == null) {
            return null;
        }
        objectReference = (ObjectReference)objectReference.getValue(field);
        return this.findEnclosingObject(tree, objectReference, referenceType, string, string2);
    }

    @Override
    public Mirror visitIf(IfTree ifTree, EvaluationContext evaluationContext) {
        Assert2.error(ifTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitImport(ImportTree importTree, EvaluationContext evaluationContext) {
        Assert2.error(importTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitArrayAccess(ArrayAccessTree arrayAccessTree, EvaluationContext evaluationContext) {
        int n;
        Mirror mirror = arrayAccessTree.getExpression().accept(this, evaluationContext);
        if (mirror == null) {
            Assert2.error((Tree)arrayAccessTree, "arrayIsNull", arrayAccessTree.getExpression());
        }
        Mirror mirror2 = arrayAccessTree.getIndex().accept(this, evaluationContext);
        if (!(mirror instanceof ArrayReference)) {
            Assert2.error((Tree)arrayAccessTree, "notArrayType", arrayAccessTree.getExpression());
        }
        if (!(mirror2 instanceof PrimitiveValue)) {
            Assert2.error((Tree)arrayAccessTree, "arraySizeBadType", mirror2);
        }
        if ((n = ((PrimitiveValue)mirror2).intValue()) >= ((ArrayReference)mirror).length()) {
            Assert2.error(arrayAccessTree, "arrayIndexOutOfBounds", mirror, n);
        }
        return ((ArrayReference)mirror).getValue(n);
    }

    @Override
    public Mirror visitLabeledStatement(LabeledStatementTree labeledStatementTree, EvaluationContext evaluationContext) {
        Assert2.error(labeledStatementTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitLiteral(LiteralTree literalTree, EvaluationContext evaluationContext) {
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        Object object = literalTree.getValue();
        if (object instanceof Boolean) {
            return virtualMachine.mirrorOf((Boolean)object);
        }
        if (object instanceof Byte) {
            return virtualMachine.mirrorOf((Byte)object);
        }
        if (object instanceof Character) {
            return virtualMachine.mirrorOf(((Character)object).charValue());
        }
        if (object instanceof Double) {
            return virtualMachine.mirrorOf((Double)object);
        }
        if (object instanceof Float) {
            return virtualMachine.mirrorOf(((Float)object).floatValue());
        }
        if (object instanceof Integer) {
            return virtualMachine.mirrorOf((Integer)object);
        }
        if (object instanceof Long) {
            return virtualMachine.mirrorOf((Long)object);
        }
        if (object instanceof Short) {
            return virtualMachine.mirrorOf((Short)object);
        }
        if (object instanceof String) {
            StringReference stringReference = virtualMachine.mirrorOf((String)object);
            ClassType classType = (ClassType)virtualMachine.classesByName("java.lang.String").get(0);
            try {
                List<Value> list = Collections.emptyList();
                return this.invokeMethod(literalTree, classType.methodsByName("intern").get(0), false, classType, stringReference, list, evaluationContext);
            }
            catch (Exception exception) {
                return stringReference;
            }
        }
        if (object == null) {
            return null;
        }
        throw new UnsupportedOperationException("Unsupported value: " + object);
    }

    @Override
    public Mirror visitMethod(MethodTree methodTree, EvaluationContext evaluationContext) {
        Assert2.error(methodTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitModifiers(ModifiersTree modifiersTree, EvaluationContext evaluationContext) {
        Assert2.error(modifiersTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitNewArray(NewArrayTree newArrayTree, EvaluationContext evaluationContext) {
        Type type;
        Tree tree = newArrayTree.getType();
        if (tree == null) {
            if (this.newArrayType == null) {
                throw new IllegalStateException("No type info for " + newArrayTree);
            }
            type = this.newArrayType;
        } else {
            type = (Type)newArrayTree.getType().accept(this, evaluationContext);
        }
        List<? extends ExpressionTree> list = newArrayTree.getDimensions();
        int n = list.size();
        if (n > 0) {
            int[] nArray = new int[n];
            ArrayType[] arrayTypeArray = new ArrayType[n];
            String string = type.name() + "[]";
            for (int i = 0; i < n; ++i) {
                nArray[i] = ((PrimitiveValue)list.get(n - 1 - i).accept(this, evaluationContext)).intValue();
                List<ReferenceType> list2 = type.virtualMachine().classesByName(string);
                if (list2.size() == 0) {
                    Assert2.error((Tree)newArrayTree, "unknownType", string);
                }
                arrayTypeArray[i] = (ArrayType)list2.get(0);
                string = string + "[]";
            }
            return this.constructNewArray(arrayTypeArray, nArray, n - 1);
        }
        List<? extends ExpressionTree> list3 = newArrayTree.getInitializers();
        return this.constructNewArray(newArrayTree, type, list3, evaluationContext);
    }

    private ArrayReference constructNewArray(ArrayType[] arrayTypeArray, int[] nArray, int n) {
        ArrayReference arrayReference = arrayTypeArray[n].newInstance(nArray[n]);
        if (n > 0) {
            ArrayList<ArrayReference> arrayList = new ArrayList<ArrayReference>(nArray[n]);
            for (int i = 0; i < nArray[n]; ++i) {
                ArrayReference arrayReference2 = this.constructNewArray(arrayTypeArray, nArray, n - 1);
                arrayList.add(arrayReference2);
            }
            try {
                arrayReference.setValues(arrayList);
            }
            catch (InvalidTypeException invalidTypeException) {
                throw new IllegalStateException("ArrayType " + arrayTypeArray[n] + " can not have " + arrayList + " elements.");
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                throw new IllegalStateException(new InvalidExpressionException((Throwable)classNotLoadedException));
            }
        }
        return arrayReference;
    }

    private ArrayReference constructNewArray(NewArrayTree newArrayTree, Type type, List<? extends ExpressionTree> list, EvaluationContext evaluationContext) {
        Object object;
        int n;
        int n2 = list.size();
        ArrayList<Value> arrayList = new ArrayList<Value>(n2);
        for (n = 0; n < n2; ++n) {
            object = list.get(n);
            this.newArrayType = this.getSubArrayType(newArrayTree, type);
            Value value = (Value)object.accept(this, evaluationContext);
            arrayList.add(value);
        }
        n = 1;
        object = this.getArrayType(newArrayTree, type, n).newInstance(n2);
        this.autoboxElements(newArrayTree, type, arrayList, evaluationContext);
        try {
            object.setValues(arrayList);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new IllegalStateException("ArrayType " + this.getArrayType(newArrayTree, type, n) + " can not have " + arrayList + " elements.");
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)classNotLoadedException));
        }
        return object;
    }

    private ArrayType getArrayType(NewArrayTree newArrayTree, Type type, int n) {
        String string;
        if (n < BRACKETS.length() / 2) {
            string = type.name() + BRACKETS.substring(0, 2 * n);
        } else {
            string = type.name() + BRACKETS;
            for (int i = BRACKETS.length() / 2; i < n; ++i) {
                string = string + "[]";
            }
        }
        List<ReferenceType> list = type.virtualMachine().classesByName(string);
        if (list.size() == 0) {
            Assert2.error((Tree)newArrayTree, "unknownType", string);
        }
        return (ArrayType)list.get(0);
    }

    private Type getSubArrayType(Tree tree, Type type) {
        String string = type.name();
        if (string.endsWith("[]")) {
            List<ReferenceType> list;
            if (!(string = string.substring(0, string.length() - 2)).endsWith("[]") && (list = this.getPrimitiveType(string, type.virtualMachine())) != null) {
                return list;
            }
            list = type.virtualMachine().classesByName(string);
            if (list.size() == 0) {
                Assert2.error(tree, "unknownType", string);
            }
            type = (Type)list.get(0);
        }
        return type;
    }

    private Type getPrimitiveType(String string, VirtualMachine virtualMachine) {
        if (string.equals(Boolean.TYPE.getName())) {
            return virtualMachine.mirrorOf(true).type();
        }
        if (string.equals(Byte.TYPE.getName())) {
            return virtualMachine.mirrorOf((byte)0).type();
        }
        if (string.equals(Character.TYPE.getName())) {
            return virtualMachine.mirrorOf('a').type();
        }
        if (string.equals(Double.TYPE.getName())) {
            return virtualMachine.mirrorOf(0.0).type();
        }
        if (string.equals(Float.TYPE.getName())) {
            return virtualMachine.mirrorOf(0.0f).type();
        }
        if (string.equals(Integer.TYPE.getName())) {
            return virtualMachine.mirrorOf(0).type();
        }
        if (string.equals(Long.TYPE.getName())) {
            return virtualMachine.mirrorOf(0L).type();
        }
        if (string.equals(Short.TYPE.getName())) {
            return virtualMachine.mirrorOf((short)0).type();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Mirror visitNewClass(NewClassTree newClassTree, EvaluationContext evaluationContext) {
        Object object;
        Object object2;
        Object object32;
        Object incompatibleThreadStateException;
        Object object4;
        Object object7;
        TypeMirror typeMirror;
        Object object8;
        Object object9;
        TreePath treePath = this.getCurrentPath();
        if (treePath != null) {
            object9 = TreePath.getPath(treePath, (Tree)newClassTree);
            if (object9 == null) {
                object9 = treePath;
            }
            if ((object8 = evaluationContext.getTrees().getElement((TreePath)object9)) == null) {
                Assert2.error((Tree)newClassTree, "unknownType", newClassTree.getIdentifier());
            }
            if (object8.asType().getKind() == TypeKind.ERROR) {
                typeMirror = null;
            } else {
                if (object8.getKind() != ElementKind.CONSTRUCTOR) {
                    throw new IllegalStateException("Element " + object8 + " is of " + (Object)((Object)object8.getKind()) + " kind. Tree = " + newClassTree);
                }
                object7 = (ExecutableElement)object8;
                typeMirror = object7.asType();
            }
        } else {
            typeMirror = null;
        }
        object9 = newClassTree.getIdentifier();
        object8 = object9.accept(this, evaluationContext);
        object7 = (ClassType)object8;
        List<? extends ExpressionTree> list = newClassTree.getArguments();
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (ExpressionTree object62 : list) {
            object4 = object62.accept(this, evaluationContext);
            if (!(object4 instanceof Value)) {
                Assert2.error(object62, "Not a value");
            }
            arrayList.add((Value)object4);
        }
        Object object10 = null;
        Object var11_12 = null;
        object4 = null;
        if (typeMirror != null) {
            object10 = ((ExecutableType)typeMirror).getParameterTypes();
            incompatibleThreadStateException = evaluationContext.getFrame().thisObject();
            if (incompatibleThreadStateException != null) {
                object32 = ((ReferenceType)incompatibleThreadStateException.type()).nestedTypes();
                object2 = object32.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (object.isStatic() || !((Object)object).equals(object7)) continue;
                    arrayList.add(0, incompatibleThreadStateException);
                    String string = incompatibleThreadStateException.type().signature();
                }
            }
        } else {
            object4 = new ArrayList(arrayList.size());
            for (Object object32 : arrayList) {
                if (object32 == null) {
                    object4.add(evaluationContext.getDebugger().getVirtualMachine().classesByName("java.lang.Object").get(0));
                    continue;
                }
                object4.add(object32.type());
            }
            incompatibleThreadStateException = evaluationContext.getFrame().thisObject();
            if (incompatibleThreadStateException != null) {
                object32 = ((ReferenceType)incompatibleThreadStateException.type()).nestedTypes();
                object2 = object32.iterator();
                while (object2.hasNext()) {
                    object = (ReferenceType)object2.next();
                    if (object.isStatic() || !((Object)object).equals(object7)) continue;
                    arrayList.add(0, incompatibleThreadStateException);
                    object4.add(0, incompatibleThreadStateException.type());
                }
            }
        }
        try {
            void var11_13;
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("STARTED : " + object7 + "." + "<init>" + " (" + arrayList + ") in thread " + evaluationContext.getFrame().thread());
            }
            evaluationContext.methodToBeInvoked();
            incompatibleThreadStateException = EvaluatorVisitor.getConcreteMethodAndReportProblems(newClassTree, (ReferenceType)object7, "<init>", (String)var11_13, (List<? extends TypeMirror>)object10, (List<? extends Type>)object4);
            object32 = object7.newInstance(evaluationContext.getFrame().thread(), (Method)incompatibleThreadStateException, arrayList, 1);
            return object32;
        }
        catch (InvalidTypeException invocationException) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)invocationException));
        }
        catch (ClassNotLoadedException unsupportedOperationException) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)unsupportedOperationException));
        }
        catch (IncompatibleThreadStateException objectCollectedException) {
            object32 = new InvalidExpressionException((Throwable)objectCollectedException);
            object32.initCause((Throwable)objectCollectedException);
            throw new IllegalStateException((Throwable)object32);
        }
        catch (InvocationException invocationException) {
            object32 = new InvocationExceptionTranslated(invocationException, evaluationContext.getDebugger());
            object2 = new InvalidExpressionException(object32);
            object2.initCause(object32);
            throw new IllegalStateException((Throwable)object2);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object32 = new InvalidExpressionException((Throwable)unsupportedOperationException);
            object32.initCause((Throwable)unsupportedOperationException);
            throw new IllegalStateException((Throwable)object32);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new IllegalStateException(new InvalidExpressionException(NbBundle.getMessage(Evaluator.class, (String)"CTL_EvalError_collected")));
        }
        finally {
            try {
                evaluationContext.methodInvokeDone();
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException2) {
                InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException2);
                invalidExpressionException.initCause((Throwable)incompatibleThreadStateException2);
                throw new IllegalStateException(invalidExpressionException);
            }
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("FINISHED: " + object7 + "." + "<init>" + " (" + arrayList + ") in thread " + evaluationContext.getFrame().thread());
            }
        }
    }

    @Override
    public Mirror visitParenthesized(ParenthesizedTree parenthesizedTree, EvaluationContext evaluationContext) {
        return parenthesizedTree.getExpression().accept(this, evaluationContext);
    }

    @Override
    public Mirror visitReturn(ReturnTree returnTree, EvaluationContext evaluationContext) {
        Assert2.error(returnTree, "unsupported");
        return null;
    }

    private Value getEnumConstant(Tree tree, VariableElement variableElement, EvaluationContext evaluationContext) {
        String string = variableElement.getSimpleName().toString();
        ReferenceType referenceType = EvaluatorVisitor.getClassType(tree, variableElement.asType(), evaluationContext);
        Method method = referenceType.methodsByName("valueOf").get(0);
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        StringReference stringReference = virtualMachine.mirrorOf(string);
        Value value = this.invokeMethod(tree, method, true, (ClassType)referenceType, null, Collections.singletonList(stringReference), evaluationContext);
        return value;
    }

    @Override
    public Mirror visitMemberSelect(MemberSelectTree memberSelectTree, EvaluationContext evaluationContext) {
        Object object;
        TreePath treePath = this.getCurrentPath();
        Element element = null;
        if (treePath != null) {
            object = TreePath.getPath(treePath, (Tree)memberSelectTree);
            if (object == null) {
                object = treePath;
            }
            if ((element = evaluationContext.getTrees().getElement((TreePath)object)) instanceof TypeElement && ((TypeElement)element).asType() instanceof ErrorType) {
                treePath = null;
            }
        }
        if (treePath == null) {
            List<ReferenceType> list;
            Mirror mirror;
            object = memberSelectTree.getExpression().accept(this, evaluationContext);
            String string = memberSelectTree.getIdentifier().toString();
            if (object instanceof ClassType) {
                mirror = (ClassType)object;
                if (string.equals("this")) {
                    list = evaluationContext.getFrame().thisObject();
                    while (list != null && !((Object)((ReferenceType)list.type())).equals(mirror)) {
                        ReferenceType referenceType = (ReferenceType)list.type();
                        Field field = referenceType.fieldByName("this$0");
                        if (field != null) {
                            list = (ObjectReference)list.getValue(field);
                            continue;
                        }
                        list = null;
                    }
                    if (list == null) {
                        Assert2.error((Tree)memberSelectTree, "unknownOuterClass", mirror.name());
                    } else {
                        return list;
                    }
                }
                if (string.equals("class")) {
                    return mirror.classObject();
                }
                list = mirror.fieldByName(string);
                if (list != null) {
                    return mirror.getValue((Field)((Object)list));
                }
            } else if (object instanceof InterfaceType) {
                if (string.equals("class")) {
                    return ((InterfaceType)object).classObject();
                }
            } else if (object instanceof ObjectReference) {
                if (object instanceof ArrayReference && "length".equals(string)) {
                    return object.virtualMachine().mirrorOf(((ArrayReference)object).length());
                }
                mirror = ((ObjectReference)object).referenceType();
                list = mirror.fieldByName(string);
                if (list != null) {
                    return ((ObjectReference)object).getValue((Field)((Object)list));
                }
            }
            if (object == null) {
                Assert2.error((Tree)memberSelectTree, "fieldOnNull", string);
            }
            if ((mirror = evaluationContext.getDebugger().getVirtualMachine()) == null) {
                return null;
            }
            list = mirror.classesByName(string);
            if (list.size() == 0) {
                Assert2.error((Tree)memberSelectTree, "unknownType", string);
            }
            return (Mirror)list.get(0);
        }
        switch (element.getKind()) {
            case ENUM_CONSTANT: {
                return this.getEnumConstant(memberSelectTree, (VariableElement)element, evaluationContext);
            }
            case FIELD: {
                object = (VariableElement)element;
                String string = object.getSimpleName().toString();
                Mirror mirror = memberSelectTree.getExpression().accept(this, evaluationContext);
                if (mirror instanceof ClassType) {
                    Mirror mirror2;
                    ClassType classType = (ClassType)mirror;
                    if (string.equals("this")) {
                        mirror2 = evaluationContext.getFrame().thisObject();
                        while (mirror2 != null && !((Object)((ReferenceType)mirror2.type())).equals(classType)) {
                            ReferenceType referenceType = (ReferenceType)mirror2.type();
                            Field field = referenceType.fieldByName("this$0");
                            if (field != null) {
                                mirror2 = (ObjectReference)mirror2.getValue(field);
                                continue;
                            }
                            mirror2 = null;
                        }
                        if (mirror2 == null) {
                            Assert2.error((Tree)memberSelectTree, "unknownOuterClass", classType.name());
                        } else {
                            return mirror2;
                        }
                    }
                    if (string.equals("class")) {
                        return classType.classObject();
                    }
                    mirror2 = classType.fieldByName(string);
                    if (!mirror2.isStatic()) {
                        Assert2.error((Tree)memberSelectTree, "accessInstanceVariableFromStaticContext", string);
                        return null;
                    }
                    if (mirror2 != null) {
                        return classType.getValue((Field)mirror2);
                    }
                    Assert2.error((Tree)memberSelectTree, "unknownField", string);
                    return null;
                }
                if (mirror instanceof InterfaceType) {
                    InterfaceType interfaceType = (InterfaceType)mirror;
                    if (string.equals("class")) {
                        return interfaceType.classObject();
                    }
                    Field field = interfaceType.fieldByName(string);
                    if (field != null) {
                        return interfaceType.getValue(field);
                    }
                    Assert2.error((Tree)memberSelectTree, "unknownField", string);
                    return null;
                }
                if (mirror instanceof ObjectReference) {
                    if (mirror instanceof ArrayReference && "length".equals(string)) {
                        return mirror.virtualMachine().mirrorOf(((ArrayReference)mirror).length());
                    }
                    ReferenceType referenceType = ((ObjectReference)mirror).referenceType();
                    Field field = referenceType.fieldByName(string);
                    if (field != null) {
                        return ((ObjectReference)mirror).getValue(field);
                    }
                    Assert2.error((Tree)memberSelectTree, "unknownField", string);
                    return null;
                }
                if (mirror == null) {
                    Assert2.error((Tree)memberSelectTree, "fieldOnNull", string);
                }
                throw new IllegalArgumentException("Wrong expression value: " + mirror);
            }
            case CLASS: 
            case INTERFACE: {
                TypeElement typeElement = (TypeElement)element;
                String string = ElementUtilities.getBinaryName((TypeElement)typeElement);
                VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
                if (virtualMachine == null) {
                    return null;
                }
                List<ReferenceType> list = virtualMachine.classesByName(string);
                if (list.size() == 0) {
                    Assert2.error((Tree)memberSelectTree, "unknownType", string);
                }
                return list.get(0);
            }
            case PACKAGE: {
                return (Value)Assert2.error(memberSelectTree, "notExpression");
            }
        }
        throw new UnsupportedOperationException("Not supported yet. Tree = '" + memberSelectTree + "', element kind = " + (Object)((Object)element.getKind()));
    }

    @Override
    public Mirror visitEmptyStatement(EmptyStatementTree emptyStatementTree, EvaluationContext evaluationContext) {
        Assert2.error(emptyStatementTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitSwitch(SwitchTree switchTree, EvaluationContext evaluationContext) {
        Assert2.error(switchTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitSynchronized(SynchronizedTree synchronizedTree, EvaluationContext evaluationContext) {
        Assert2.error(synchronizedTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitThrow(ThrowTree throwTree, EvaluationContext evaluationContext) {
        Assert2.error(throwTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitCompilationUnit(CompilationUnitTree compilationUnitTree, EvaluationContext evaluationContext) {
        Assert2.error(compilationUnitTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitTry(TryTree tryTree, EvaluationContext evaluationContext) {
        Assert2.error(tryTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, EvaluationContext evaluationContext) {
        return parameterizedTypeTree.getType().accept(this, evaluationContext);
    }

    @Override
    public Mirror visitArrayType(ArrayTypeTree arrayTypeTree, EvaluationContext evaluationContext) {
        Type type = (Type)arrayTypeTree.getType().accept(this, evaluationContext);
        if (type == null) {
            return null;
        }
        String string = type.name() + "[]";
        List<ReferenceType> list = type.virtualMachine().classesByName(string);
        if (list.size() > 0) {
            return list.get(0);
        }
        Assert2.error((Tree)arrayTypeTree, "unknownType", string);
        return null;
    }

    @Override
    public Mirror visitTypeCast(TypeCastTree typeCastTree, EvaluationContext evaluationContext) {
        ExpressionTree expressionTree = typeCastTree.getExpression();
        Mirror mirror = expressionTree.accept(this, evaluationContext);
        if (mirror == null) {
            return null;
        }
        Tree tree = typeCastTree.getType();
        Mirror mirror2 = tree.accept(this, evaluationContext);
        if (mirror instanceof PrimitiveValue) {
            PrimitiveValue primitiveValue = (PrimitiveValue)mirror;
            if (primitiveValue instanceof BooleanValue) {
                Assert2.assertAssignable(mirror2, BooleanType.class, typeCastTree, "castToBooleanRequired", primitiveValue, mirror2);
                return primitiveValue;
            }
            Assert2.assertNotAssignable(mirror2, BooleanType.class, typeCastTree, "castFromBooleanRequired", primitiveValue, mirror2);
            VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
            if (virtualMachine == null) {
                return null;
            }
            if (mirror2 instanceof ByteType) {
                return virtualMachine.mirrorOf(primitiveValue.byteValue());
            }
            if (mirror2 instanceof CharType) {
                return virtualMachine.mirrorOf(primitiveValue.charValue());
            }
            if (mirror2 instanceof DoubleType) {
                return virtualMachine.mirrorOf(primitiveValue.doubleValue());
            }
            if (mirror2 instanceof FloatType) {
                return virtualMachine.mirrorOf(primitiveValue.floatValue());
            }
            if (mirror2 instanceof IntegerType) {
                return virtualMachine.mirrorOf(primitiveValue.intValue());
            }
            if (mirror2 instanceof LongType) {
                return virtualMachine.mirrorOf(primitiveValue.longValue());
            }
            return virtualMachine.mirrorOf(primitiveValue.shortValue());
        }
        if (!this.instanceOf(((ObjectReference)mirror).type(), (Type)mirror2)) {
            Assert2.error(typeCastTree, "castError", ((ObjectReference)mirror).type(), mirror2);
        }
        return mirror;
    }

    @Override
    public Mirror visitPrimitiveType(PrimitiveTypeTree primitiveTypeTree, EvaluationContext evaluationContext) {
        TypeKind typeKind = primitiveTypeTree.getPrimitiveTypeKind();
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        switch (typeKind) {
            case BOOLEAN: {
                return virtualMachine.mirrorOf(true).type();
            }
            case BYTE: {
                return virtualMachine.mirrorOf((byte)0).type();
            }
            case CHAR: {
                return virtualMachine.mirrorOf('a').type();
            }
            case DOUBLE: {
                return virtualMachine.mirrorOf(0.0).type();
            }
            case FLOAT: {
                return virtualMachine.mirrorOf(0.0f).type();
            }
            case INT: {
                return virtualMachine.mirrorOf(0).type();
            }
            case LONG: {
                return virtualMachine.mirrorOf(0L).type();
            }
            case SHORT: {
                return virtualMachine.mirrorOf((short)0).type();
            }
        }
        throw new IllegalStateException("Tree = " + primitiveTypeTree);
    }

    @Override
    public Mirror visitTypeParameter(TypeParameterTree typeParameterTree, EvaluationContext evaluationContext) {
        Assert2.error(typeParameterTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitInstanceOf(InstanceOfTree instanceOfTree, EvaluationContext evaluationContext) {
        Mirror mirror = instanceOfTree.getExpression().accept(this, evaluationContext);
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        if (mirror == null) {
            return virtualMachine.mirrorOf(false);
        }
        Assert2.assertAssignable(mirror, ObjectReference.class, instanceOfTree, "instanceOfLeftOperandNotAReference", mirror);
        ReferenceType referenceType = ((ObjectReference)mirror).referenceType();
        Type type = (Type)instanceOfTree.getType().accept(this, evaluationContext);
        return virtualMachine.mirrorOf(this.instanceOf(referenceType, type));
    }

    @Override
    public Mirror visitUnary(UnaryTree unaryTree, EvaluationContext evaluationContext) {
        Mirror mirror = unaryTree.getExpression().accept(this, evaluationContext);
        VirtualMachine virtualMachine = evaluationContext.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        Tree.Kind kind = unaryTree.getKind();
        if (mirror instanceof BooleanValue) {
            boolean bl = ((BooleanValue)mirror).value();
            switch (kind) {
                case LOGICAL_COMPLEMENT: {
                    bl = !bl;
                    break;
                }
                default: {
                    throw new IllegalStateException("Tree = " + unaryTree);
                }
            }
            return virtualMachine.mirrorOf(bl);
        }
        if (mirror instanceof ByteValue) {
            byte by = ((ByteValue)mirror).value();
            switch (kind) {
                case BITWISE_COMPLEMENT: {
                    int n = ~by;
                    return virtualMachine.mirrorOf(n);
                }
                case POSTFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(by - 1), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(by + 1), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    by = (byte)(by - 1);
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(by), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    by = (byte)(by + 1);
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(by), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    byte by2 = -by;
                    return virtualMachine.mirrorOf((int)by2);
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Tree = " + unaryTree);
                }
            }
            return virtualMachine.mirrorOf(by);
        }
        if (mirror instanceof CharValue) {
            char c = ((CharValue)mirror).value();
            switch (kind) {
                case BITWISE_COMPLEMENT: {
                    int n = ~c;
                    return virtualMachine.mirrorOf(n);
                }
                case POSTFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(c - '\u0001'), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(c + '\u0001'), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    c = (char)(c - '\u0001');
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(c), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    c = (char)(c + '\u0001');
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(c), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    char c2 = -c;
                    return virtualMachine.mirrorOf((int)c2);
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Tree = " + unaryTree);
                }
            }
            return virtualMachine.mirrorOf(c);
        }
        if (mirror instanceof ShortValue) {
            short s = ((ShortValue)mirror).value();
            switch (kind) {
                case BITWISE_COMPLEMENT: {
                    int n = ~s;
                    return virtualMachine.mirrorOf(n);
                }
                case POSTFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(s - 1), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(s + 1), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    s = (short)(s - 1);
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(s), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    s = (short)(s + 1);
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(s), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    short s2 = -s;
                    return virtualMachine.mirrorOf((int)s2);
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Tree = " + unaryTree);
                }
            }
            return virtualMachine.mirrorOf(s);
        }
        if (mirror instanceof IntegerValue) {
            int n = ((IntegerValue)mirror).value();
            switch (kind) {
                case BITWISE_COMPLEMENT: {
                    n ^= 0xFFFFFFFF;
                    break;
                }
                case POSTFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(n - 1), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(n + 1), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(--n), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(++n), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    n = -n;
                    break;
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Tree = " + unaryTree);
                }
            }
            return virtualMachine.mirrorOf(n);
        }
        if (mirror instanceof LongValue) {
            long l = ((LongValue)mirror).value();
            switch (kind) {
                case BITWISE_COMPLEMENT: {
                    l ^= 0xFFFFFFFFFFFFFFFFL;
                    break;
                }
                case POSTFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(l - 1L), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(l + 1L), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(--l), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(++l), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    l = -l;
                    break;
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Tree = " + unaryTree);
                }
            }
            return virtualMachine.mirrorOf(l);
        }
        if (mirror instanceof DoubleValue) {
            double d = ((DoubleValue)mirror).value();
            switch (kind) {
                case POSTFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(d - 1.0), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(d + 1.0), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(d -= 1.0), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(d += 1.0), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    d = -d;
                    break;
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Tree = " + unaryTree);
                }
            }
            return virtualMachine.mirrorOf(d);
        }
        if (mirror instanceof FloatValue) {
            float f = ((FloatValue)mirror).value();
            switch (kind) {
                case POSTFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(f - 1.0f), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(f + 1.0f), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(f -= 1.0f), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    this.setToMirror(unaryTree.getExpression(), virtualMachine.mirrorOf(f += 1.0f), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    f = -f;
                    break;
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Tree = " + unaryTree);
                }
            }
            return virtualMachine.mirrorOf(f);
        }
        throw new IllegalStateException("Bad expression type: " + mirror);
    }

    @Override
    public Mirror visitVariable(VariableTree variableTree, EvaluationContext evaluationContext) {
        Assert2.error(variableTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitWhileLoop(WhileLoopTree whileLoopTree, EvaluationContext evaluationContext) {
        Assert2.error(whileLoopTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitWildcard(WildcardTree wildcardTree, EvaluationContext evaluationContext) {
        Assert2.error(wildcardTree, "unsupported");
        return null;
    }

    @Override
    public Mirror visitOther(Tree tree, EvaluationContext evaluationContext) {
        Assert2.error(tree, "unsupported");
        return null;
    }

    private void setToMirror(Tree tree, Value value, EvaluationContext evaluationContext) {
        EvaluationContext.VariableInfo variableInfo = evaluationContext.getVariables().get(tree);
        if (variableInfo == null) {
            throw new IllegalStateException("Unknown variable " + tree);
        }
        try {
            if (variableInfo.field != null) {
                if (variableInfo.fieldObject != null) {
                    variableInfo.fieldObject.setValue(variableInfo.field, value);
                } else {
                    ((ClassType)variableInfo.field.declaringType()).setValue(variableInfo.field, value);
                }
            } else {
                evaluationContext.getFrame().setValue(variableInfo.var, value);
            }
        }
        catch (InvalidTypeException invalidTypeException) {
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            // empty catch block
        }
    }

    private Value invokeMethod(Tree tree, Method method, Boolean bl, ClassType classType, ObjectReference value, List<Value> list, EvaluationContext evaluationContext) {
        if (!evaluationContext.canInvokeMethods()) {
            Assert2.error(tree, "calleeException", new UnsupportedOperationException(), evaluationContext);
        }
        ThreadReference threadReference = evaluationContext.getFrame().thread();
        try {
            Value value2;
            Value value3;
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("STARTED : " + value + "." + method + " (" + list + ") in thread " + threadReference);
            }
            evaluationContext.methodToBeInvoked();
            EvaluatorVisitor.autoboxArguments(method.argumentTypes(), list, threadReference);
            if (Boolean.TRUE.equals(bl)) {
                value3 = classType.invokeMethod(threadReference, method, list, 1);
            } else {
                if (classType != null) {
                    if (method.isPrivate()) {
                        value2 = this.findEnclosingObject(tree, (ObjectReference)value, classType, null, method.name());
                        if (value2 != null) {
                            value = value2;
                        }
                    } else if (!this.instanceOf(value.referenceType(), classType) && (value2 = this.findEnclosingObject(tree, (ObjectReference)value, classType, null, method.name())) != null) {
                        value = value2;
                    }
                }
                value3 = value.invokeMethod(threadReference, method, list, 1);
            }
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("   return = " + value3);
            }
            value2 = value3;
            return value2;
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)invalidTypeException));
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)classNotLoadedException));
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
            invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (InvocationException invocationException) {
            InvocationExceptionTranslated invocationExceptionTranslated = new InvocationExceptionTranslated(invocationException, evaluationContext.getDebugger());
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)((Object)invocationExceptionTranslated));
            invalidExpressionException.initCause((Throwable)((Object)invocationExceptionTranslated));
            throw new IllegalStateException(invocationException.getLocalizedMessage(), invalidExpressionException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)unsupportedOperationException);
            invalidExpressionException.initCause((Throwable)unsupportedOperationException);
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new IllegalStateException(new InvalidExpressionException(NbBundle.getMessage(Evaluator.class, (String)"CTL_EvalError_collected")));
        }
        finally {
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("FINISHED: " + value + "." + method + " (" + list + ") in thread " + threadReference);
            }
            try {
                evaluationContext.methodInvokeDone();
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
                invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
                throw new IllegalStateException(invalidExpressionException);
            }
        }
    }

    private static void autoboxArguments(List<Type> list, List<Value> list2, ThreadReference threadReference) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        if (list.size() != list2.size()) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Type type = list.get(i);
            Value value = list2.get(i);
            if (value instanceof ObjectReference && type instanceof PrimitiveType) {
                list2.set(i, EvaluatorVisitor.unbox((ObjectReference)value, (PrimitiveType)type, threadReference));
            }
            if (!(value instanceof PrimitiveValue) || !(type instanceof ReferenceType)) continue;
            list2.set(i, EvaluatorVisitor.box((PrimitiveValue)value, (ReferenceType)type, threadReference));
        }
    }

    private void autoboxElements(Tree tree, Type type, List<Value> list, EvaluationContext evaluationContext) {
        boolean bl = false;
        ThreadReference threadReference = null;
        try {
            Object object;
            int n;
            if (type instanceof PrimitiveType) {
                for (n = 0; n < list.size(); ++n) {
                    object = list.get(n);
                    if (!(object instanceof ObjectReference)) continue;
                    if (!bl) {
                        if (!evaluationContext.canInvokeMethods()) {
                            Assert2.error(tree, "calleeException", new UnsupportedOperationException(), evaluationContext);
                        }
                        threadReference = evaluationContext.getFrame().thread();
                        if (loggerMethod.isLoggable(Level.FINE)) {
                            loggerMethod.fine("STARTED : Unbox " + object + " in thread " + threadReference);
                        }
                        evaluationContext.methodToBeInvoked();
                        bl = true;
                    }
                    list.set(n, EvaluatorVisitor.unbox((ObjectReference)object, (PrimitiveType)type, threadReference));
                }
            } else if (type instanceof ReferenceType) {
                for (n = 0; n < list.size(); ++n) {
                    object = list.get(n);
                    if (!(object instanceof PrimitiveValue)) continue;
                    if (!bl) {
                        if (!evaluationContext.canInvokeMethods()) {
                            Assert2.error(tree, "calleeException", new UnsupportedOperationException(), evaluationContext);
                        }
                        threadReference = evaluationContext.getFrame().thread();
                        if (loggerMethod.isLoggable(Level.FINE)) {
                            loggerMethod.fine("STARTED : Autobox " + object + " in thread " + threadReference);
                        }
                        evaluationContext.methodToBeInvoked();
                        bl = true;
                    }
                    list.set(n, EvaluatorVisitor.box((PrimitiveValue)object, (ReferenceType)type, threadReference));
                }
            }
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)invalidTypeException));
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)classNotLoadedException));
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
            invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (InvocationException invocationException) {
            InvocationExceptionTranslated invocationExceptionTranslated = new InvocationExceptionTranslated(invocationException, evaluationContext.getDebugger());
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)((Object)invocationExceptionTranslated));
            invalidExpressionException.initCause((Throwable)((Object)invocationExceptionTranslated));
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)unsupportedOperationException);
            invalidExpressionException.initCause((Throwable)unsupportedOperationException);
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new IllegalStateException(new InvalidExpressionException(NbBundle.getMessage(Evaluator.class, (String)"CTL_EvalError_collected")));
        }
        finally {
            if (bl) {
                if (loggerMethod.isLoggable(Level.FINE)) {
                    loggerMethod.fine("FINISHED: Autobox/unbox in thread " + threadReference);
                }
                try {
                    evaluationContext.methodInvokeDone();
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
                    invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
                    throw new IllegalStateException(invalidExpressionException);
                }
            }
        }
    }

    private static void unboxMethodToBeCalled(Tree tree, Mirror mirror, EvaluationContext evaluationContext) {
        if (!evaluationContext.canInvokeMethods()) {
            Assert2.error(tree, "calleeException", new UnsupportedOperationException(), evaluationContext);
        }
        if (loggerMethod.isLoggable(Level.FINE)) {
            loggerMethod.fine("STARTED : Unbox " + mirror + " in thread " + evaluationContext.getFrame().thread());
        }
        evaluationContext.methodToBeInvoked();
    }

    private static Mirror unboxIfCan(Tree tree, ObjectReference objectReference, EvaluationContext evaluationContext) {
        String string = ((ReferenceType)objectReference.type()).name();
        boolean bl = false;
        try {
            if (string.equals(Boolean.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(tree, objectReference, evaluationContext);
                bl = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "booleanValue", evaluationContext.getFrame().thread());
                return primitiveValue;
            }
            if (string.equals(Byte.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(tree, objectReference, evaluationContext);
                bl = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "byteValue", evaluationContext.getFrame().thread());
                return primitiveValue;
            }
            if (string.equals(Character.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(tree, objectReference, evaluationContext);
                bl = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "charValue", evaluationContext.getFrame().thread());
                return primitiveValue;
            }
            if (string.equals(Short.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(tree, objectReference, evaluationContext);
                bl = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "shortValue", evaluationContext.getFrame().thread());
                return primitiveValue;
            }
            if (string.equals(Integer.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(tree, objectReference, evaluationContext);
                bl = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "intValue", evaluationContext.getFrame().thread());
                return primitiveValue;
            }
            if (string.equals(Long.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(tree, objectReference, evaluationContext);
                bl = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "longValue", evaluationContext.getFrame().thread());
                return primitiveValue;
            }
            if (string.equals(Float.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(tree, objectReference, evaluationContext);
                bl = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "floatValue", evaluationContext.getFrame().thread());
                return primitiveValue;
            }
            if (string.equals(Double.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(tree, objectReference, evaluationContext);
                bl = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(objectReference, "doubleValue", evaluationContext.getFrame().thread());
                return primitiveValue;
            }
            ObjectReference objectReference2 = objectReference;
            return objectReference2;
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)invalidTypeException));
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)classNotLoadedException));
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
            invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (InvocationException invocationException) {
            InvocationExceptionTranslated invocationExceptionTranslated = new InvocationExceptionTranslated(invocationException, evaluationContext.getDebugger());
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)((Object)invocationExceptionTranslated));
            invalidExpressionException.initCause((Throwable)((Object)invocationExceptionTranslated));
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)unsupportedOperationException);
            invalidExpressionException.initCause((Throwable)unsupportedOperationException);
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new IllegalStateException(new InvalidExpressionException(NbBundle.getMessage(Evaluator.class, (String)"CTL_EvalError_collected")));
        }
        finally {
            if (bl) {
                if (loggerMethod.isLoggable(Level.FINE)) {
                    loggerMethod.fine("FINISHED: unbox in thread " + evaluationContext.getFrame().thread());
                }
                try {
                    evaluationContext.methodInvokeDone();
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
                    invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
                    throw new IllegalStateException(invalidExpressionException);
                }
            }
        }
    }

    public static PrimitiveValue unbox(ObjectReference objectReference, PrimitiveType primitiveType, ThreadReference threadReference) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        if (primitiveType instanceof BooleanType) {
            return EvaluatorVisitor.invokeUnboxingMethod(objectReference, "booleanValue", threadReference);
        }
        if (primitiveType instanceof ByteType) {
            return EvaluatorVisitor.invokeUnboxingMethod(objectReference, "byteValue", threadReference);
        }
        if (primitiveType instanceof CharType) {
            return EvaluatorVisitor.invokeUnboxingMethod(objectReference, "charValue", threadReference);
        }
        if (primitiveType instanceof ShortType) {
            return EvaluatorVisitor.invokeUnboxingMethod(objectReference, "shortValue", threadReference);
        }
        if (primitiveType instanceof IntegerType) {
            return EvaluatorVisitor.invokeUnboxingMethod(objectReference, "intValue", threadReference);
        }
        if (primitiveType instanceof LongType) {
            return EvaluatorVisitor.invokeUnboxingMethod(objectReference, "longValue", threadReference);
        }
        if (primitiveType instanceof FloatType) {
            return EvaluatorVisitor.invokeUnboxingMethod(objectReference, "floatValue", threadReference);
        }
        if (primitiveType instanceof DoubleType) {
            return EvaluatorVisitor.invokeUnboxingMethod(objectReference, "doubleValue", threadReference);
        }
        throw new RuntimeException("Invalid type while unboxing: " + primitiveType.signature());
    }

    private static ReferenceType adjustBoxingType(ReferenceType referenceType, PrimitiveType primitiveType) {
        if (primitiveType instanceof BooleanType) {
            referenceType = referenceType.virtualMachine().classesByName(Boolean.class.getName()).get(0);
        } else if (primitiveType instanceof ByteType) {
            referenceType = referenceType.virtualMachine().classesByName(Byte.class.getName()).get(0);
        } else if (primitiveType instanceof CharType) {
            referenceType = referenceType.virtualMachine().classesByName(Character.class.getName()).get(0);
        } else if (primitiveType instanceof ShortType) {
            referenceType = referenceType.virtualMachine().classesByName(Short.class.getName()).get(0);
        } else if (primitiveType instanceof IntegerType) {
            referenceType = referenceType.virtualMachine().classesByName(Integer.class.getName()).get(0);
        } else if (primitiveType instanceof LongType) {
            referenceType = referenceType.virtualMachine().classesByName(Long.class.getName()).get(0);
        } else if (primitiveType instanceof FloatType) {
            referenceType = referenceType.virtualMachine().classesByName(Float.class.getName()).get(0);
        } else if (primitiveType instanceof DoubleType) {
            referenceType = referenceType.virtualMachine().classesByName(Double.class.getName()).get(0);
        }
        return referenceType;
    }

    public static ObjectReference box(PrimitiveValue primitiveValue, ReferenceType referenceType, ThreadReference threadReference) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        try {
            Method method = null;
            referenceType = EvaluatorVisitor.adjustBoxingType(referenceType, (PrimitiveType)primitiveValue.type());
            List<Method> list = referenceType.methodsByName("<init>");
            String string = "(" + primitiveValue.type().signature() + ")";
            for (Method method2 : list) {
                if (method2.isAbstract() || !EvaluatorVisitor.egualMethodSignatures(method2.signature(), string)) continue;
                method = method2;
            }
            if (method == null) {
                throw new RuntimeException("No constructor " + referenceType + " " + string);
            }
            return ((ClassType)referenceType).newInstance(threadReference, method, Arrays.asList(primitiveValue), 1);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw invalidTypeException;
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw classNotLoadedException;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw incompatibleThreadStateException;
        }
        catch (InvocationException invocationException) {
            throw invocationException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected exception while invoking boxing method", exception);
        }
    }

    private static PrimitiveValue invokeUnboxingMethod(ObjectReference objectReference, String string, ThreadReference threadReference) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        Method method = objectReference.referenceType().methodsByName(string).get(0);
        try {
            return (PrimitiveValue)objectReference.invokeMethod(threadReference, method, new ArrayList(0), 1);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw invalidTypeException;
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw classNotLoadedException;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw incompatibleThreadStateException;
        }
        catch (InvocationException invocationException) {
            throw invocationException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected exception while invoking unboxing method", exception);
        }
    }

    private String toString(Tree tree, Mirror mirror, EvaluationContext evaluationContext) {
        Method method;
        if (mirror instanceof PrimitiveValue) {
            PrimitiveValue primitiveValue = (PrimitiveValue)mirror;
            PrimitiveType primitiveType = (PrimitiveType)primitiveValue.type();
            if (primitiveType instanceof ByteType) {
                return Byte.toString(primitiveValue.byteValue());
            }
            if (primitiveType instanceof BooleanType) {
                return Boolean.toString(primitiveValue.booleanValue());
            }
            if (primitiveType instanceof CharType) {
                return Character.toString(primitiveValue.charValue());
            }
            if (primitiveType instanceof ShortType) {
                return Short.toString(primitiveValue.shortValue());
            }
            if (primitiveType instanceof IntegerType) {
                return Integer.toString(primitiveValue.intValue());
            }
            if (primitiveType instanceof LongType) {
                return Long.toString(primitiveValue.longValue());
            }
            if (primitiveType instanceof FloatType) {
                return Float.toString(primitiveValue.floatValue());
            }
            if (primitiveType instanceof DoubleType) {
                return Double.toString(primitiveValue.doubleValue());
            }
            throw new IllegalStateException("Unknown primitive type: " + primitiveType);
        }
        if (mirror == null) {
            return "" + null;
        }
        ObjectReference objectReference = (ObjectReference)mirror;
        List list = Collections.emptyList();
        try {
            method = EvaluatorVisitor.getConcreteMethod((ReferenceType)objectReference.type(), "toString", list);
        }
        catch (UnsuitableArgumentsException unsuitableArgumentsException) {
            throw new IllegalStateException(unsuitableArgumentsException);
        }
        ((ClassType)objectReference.type()).methodsByName("toString");
        List<Value> list2 = Collections.emptyList();
        Value value = this.invokeMethod(tree, method, false, null, objectReference, list2, evaluationContext);
        if (value instanceof StringReference) {
            return ((StringReference)value).value();
        }
        throw new IllegalStateException("Result of toString() call on " + objectReference + " is not a String, but: " + value);
    }

    private static final class UnsuitableArgumentsException
    extends Exception {
    }
}

