/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteType;
import com.sun.jdi.CharType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.LongType;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.modules.debugger.jpda.expr.Assert;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.EvaluationException;
import org.netbeans.modules.debugger.jpda.expr.Expression;
import org.netbeans.modules.debugger.jpda.expr.Identifier;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.expr.JavaParserVisitor;
import org.netbeans.modules.debugger.jpda.expr.Operators;
import org.netbeans.modules.debugger.jpda.expr.SimpleNode;
import org.netbeans.modules.debugger.jpda.expr.Token;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Evaluator
implements JavaParserVisitor {
    private static final boolean verbose = System.getProperty("netbeans.debugger.noInvokeMethods") != null;
    private static final Logger loggerMethod = Logger.getLogger("org.netbeans.modules.debugger.jpda.invokeMethod");
    private static final Logger loggerValue = Logger.getLogger("org.netbeans.modules.debugger.jpda.getValue");
    private Expression expression;
    private EvaluationContext evaluationContext;
    private VirtualMachine vm;
    private StackFrame frame;
    private ThreadReference frameThread;
    private int frameIndex;
    private SimpleNode currentNode;
    private String currentPackage;
    private Operators operators;
    private String brackets = "[[[[[[[[[[[[[[[[[[[";
    private static final String[] typeSignaturesSorted = new String[]{"Ljava/lang/Byte;", "B", "Ljava/lang/Character;", "C", "Ljava/lang/Short;", "S", "Ljava/lang/Integer;", "I", "Ljava/lang/Long;", "J", "Ljava/lang/Float;", "F", "Ljava/lang/Double;", "D"};

    Evaluator(Expression expression, EvaluationContext evaluationContext) {
        this.expression = expression;
        this.evaluationContext = evaluationContext;
    }

    public Value evaluate() throws EvaluationException, IncompatibleThreadStateException {
        this.frame = this.evaluationContext.getFrame();
        this.vm = this.evaluationContext.getFrame().virtualMachine();
        this.frameThread = this.frame.thread();
        this.frameIndex = this.indexOf(this.frameThread.frames(), this.frame);
        if (this.frameIndex == -1) {
            throw new IncompatibleThreadStateException("Thread does not contain current frame");
        }
        this.currentPackage = this.evaluationContext.getFrame().location().declaringType().name();
        int n = this.currentPackage.lastIndexOf(46);
        this.currentPackage = n > 0 ? this.currentPackage.substring(0, n + 1) : "";
        this.operators = new Operators(this.vm);
        SimpleNode simpleNode = this.expression.getRoot();
        return (Value)simpleNode.jjtAccept(this, null);
    }

    private int indexOf(List list, StackFrame stackFrame) {
        int n = list.size();
        Location location = stackFrame.location();
        for (int i = 0; i < n; ++i) {
            if (!((Object)location).equals(((StackFrame)list.get(i)).location())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object visit(SimpleNode simpleNode, Object object) throws EvaluationException {
        this.currentNode = simpleNode;
        switch (simpleNode.jjtGetID()) {
            case 8: {
                return this.visitResultType(simpleNode, object);
            }
            case 4: {
                return this.visitArrayInitializer(simpleNode, object);
            }
            case 40: {
                return this.visitArrayDimsAndInits(simpleNode, object);
            }
            case 39: {
                return this.visitAllocationExpression(simpleNode, object);
            }
            case 38: {
                return this.visitArgumentList(simpleNode, object);
            }
            case 37: {
                return this.visitArguments(simpleNode, object);
            }
            case 30: {
                return this.visitCastExpression(simpleNode, object);
            }
            case 29: {
                return this.visitPostfixExpression(simpleNode, object);
            }
            case 26: 
            case 27: {
                return this.visitPrefixExpression(simpleNode, object);
            }
            case 25: 
            case 28: {
                return this.visitUnaryExpression(simpleNode, object);
            }
            case 10: {
                return this.visitClassOrInterfaceType(simpleNode, object);
            }
            case 2: {
                return this.visitIdentifier(simpleNode, object);
            }
            case 7: {
                return this.visitPrimitiveType(simpleNode, object);
            }
            case 5: {
                return this.visitReferenceType(simpleNode, object);
            }
            case 9: {
                return this.visitName(simpleNode, object);
            }
            case 11: {
                return this.visitExpression(simpleNode, object);
            }
            case 31: {
                return this.visitPrimaryExpression(simpleNode, object);
            }
            case 32: {
                return this.visitPrimaryPrefix(simpleNode, object);
            }
            case 33: {
                return this.visitPrimarySuffix(simpleNode, object);
            }
            case 13: {
                return this.visitConditionalExpression(simpleNode, object);
            }
            case 14: 
            case 15: {
                return this.visitConditionalOrAndExpression(simpleNode, object);
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return this.visitBinaryExpression(simpleNode, object);
            }
            case 20: {
                return this.visitInstanceOfExpression(simpleNode, object);
            }
            case 34: {
                return this.visitLiteral(simpleNode, object);
            }
            case 35: {
                return this.visitBooleanLiteral(simpleNode, object);
            }
            case 36: {
                return null;
            }
        }
        return Assert.error(simpleNode, "unknownNonterminal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectReference primitiveClass(String string) throws IncompatibleThreadStateException {
        ReferenceType referenceType = this.resolveType("java.lang." + string.substring(0, 1).toUpperCase() + string.substring(1));
        try {
            if (loggerValue.isLoggable(Level.FINE)) {
                loggerValue.fine("STARTED : " + referenceType + ".getValue(" + referenceType.fieldByName("TYPE") + ")");
            }
            ObjectReference objectReference = (ObjectReference)referenceType.getValue(referenceType.fieldByName("TYPE"));
            return objectReference;
        }
        finally {
            if (loggerValue.isLoggable(Level.FINE)) {
                loggerValue.fine("FINISHED: " + referenceType + ".getValue(" + referenceType.fieldByName("TYPE") + ")");
            }
        }
    }

    private Object visitResultType(SimpleNode simpleNode, Object object) {
        try {
            if (simpleNode.getAttribute("void") != null) {
                return this.primitiveClass("void");
            }
            Type type = (Type)simpleNode.jjtGetChild(0).jjtAccept(this, object);
            if (type instanceof ReferenceType) {
                return type;
            }
            return this.primitiveClass(type.name());
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return Assert.error(simpleNode, "internalErrorResolvingType", "void");
        }
    }

    private Object visitArrayInitializer(SimpleNode simpleNode, Object object) {
        Object[] objectArray = new Object[simpleNode.jjtGetNumChildren()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = simpleNode.jjtGetChild(i).jjtAccept(this, object);
            if (objectArray[i] instanceof Value || objectArray[i] instanceof Object[]) continue;
            Assert.error(simpleNode, "invalidArrayInitializer", objectArray[i]);
        }
        return objectArray;
    }

    private Object visitArrayDimsAndInits(SimpleNode simpleNode, Object object) {
        Type type = (Type)object;
        int n = (Integer)simpleNode.getAttribute("dimensions");
        Object var5_5 = null;
        try {
            if (simpleNode.getAttribute("initializers") != null) {
                Object[] objectArray = (Object[])simpleNode.jjtGetChild(0).jjtAccept(this, object);
                return this.createArray(type, n, objectArray);
            }
            int n2 = simpleNode.jjtGetNumChildren();
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                Object object2 = simpleNode.jjtGetChild(i).jjtAccept(this, object);
                Assert.assertAssignable(object2, PrimitiveValue.class, simpleNode, "arraySizeBadType", object2);
                Assert.assertNotAssignable(object2, BooleanValue.class, simpleNode, "arraySizeBadType", object2);
                Assert.assertNotAssignable(object2, FloatValue.class, simpleNode, "arraySizeBadType", object2);
                Assert.assertNotAssignable(object2, DoubleValue.class, simpleNode, "arraySizeBadType", object2);
                nArray[i] = ((PrimitiveValue)object2).intValue();
            }
            return this.createArray(type, n, nArray, 0);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            Assert.error(simpleNode, "arrayCreateError", incompatibleThreadStateException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            Assert.error(simpleNode, "arrayCreateError", classNotLoadedException);
        }
        catch (InvalidTypeException invalidTypeException) {
            Assert.error(simpleNode, "arrayCreateError", invalidTypeException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return Assert.error(simpleNode, "calleeException", unsupportedOperationException);
        }
        return var5_5;
    }

    private String brackets(int n) {
        if (this.brackets.length() < n) {
            char[] cArray = new char[n];
            Arrays.fill(cArray, '[');
            this.brackets = new String(cArray);
        }
        return this.brackets.substring(0, n);
    }

    private ArrayReference createArray(Type type, int n, int[] nArray, int n2) throws IncompatibleThreadStateException, ClassNotLoadedException, InvalidTypeException {
        ArrayType arrayType = (ArrayType)this.resolveType(this.brackets(n) + type.signature());
        ArrayReference arrayReference = arrayType.newInstance(nArray[n2]);
        if (nArray.length > n2 + 1) {
            for (int i = 0; i < nArray[n2]; ++i) {
                arrayReference.setValue(i, (Value)this.createArray(type, n - 1, nArray, n2 + 1));
            }
        }
        return arrayReference;
    }

    private ArrayReference createArray(Type type, int n, Object[] objectArray) throws IncompatibleThreadStateException, ClassNotLoadedException, InvalidTypeException {
        ArrayType arrayType = (ArrayType)this.resolveType(this.brackets(n) + type.signature());
        ArrayReference arrayReference = arrayType.newInstance(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Object[]) {
                arrayReference.setValue(i, (Value)this.createArray(type, n - 1, (Object[])objectArray[i]));
                continue;
            }
            arrayReference.setValue(i, (Value)objectArray[i]);
        }
        return arrayReference;
    }

    private Object visitAllocationExpression(SimpleNode simpleNode, Object object) {
        Type type = (Type)simpleNode.jjtGetChild(0).jjtAccept(this, object);
        if (((SimpleNode)simpleNode.jjtGetChild(1)).jjtGetID() == 37) {
            if (type instanceof ClassType) {
                Identifier identifier = new Identifier(false, (ReferenceType)type, "<init>");
                return simpleNode.jjtGetChild(1).jjtAccept(this, identifier);
            }
            Assert.assertNotAssignable(type, InterfaceType.class, simpleNode, "instantiateInterface", type.name());
        }
        return simpleNode.jjtGetChild(1).jjtAccept(this, type);
    }

    private Object visitPrimitiveType(SimpleNode simpleNode, Object object) {
        Token token = (Token)simpleNode.getAttribute("token");
        switch (token.kind) {
            case 20: {
                return this.vm.mirrorOf(true).type();
            }
            case 25: {
                return this.vm.mirrorOf('a').type();
            }
            case 22: {
                return this.vm.mirrorOf((byte)0).type();
            }
            case 56: {
                return this.vm.mirrorOf((short)0).type();
            }
            case 45: {
                return this.vm.mirrorOf(0).type();
            }
            case 47: {
                return this.vm.mirrorOf(0L).type();
            }
            case 38: {
                return this.vm.mirrorOf(1.0f).type();
            }
            case 31: {
                return this.vm.mirrorOf(1.0).type();
            }
        }
        throw new RuntimeException("Unknown primitive type: " + token.image);
    }

    private Object visitCastExpression(SimpleNode simpleNode, Object object) {
        Object object2 = simpleNode.jjtGetChild(1).jjtAccept(this, object);
        if (object2 == null) {
            return null;
        }
        Type type = (Type)simpleNode.jjtGetChild(0).jjtAccept(this, object);
        if (object2 instanceof PrimitiveValue) {
            PrimitiveValue primitiveValue = (PrimitiveValue)object2;
            if (primitiveValue instanceof BooleanValue) {
                Assert.assertAssignable(type, BooleanType.class, simpleNode, "castToBooleanRequired", primitiveValue, type);
                return primitiveValue;
            }
            Assert.assertNotAssignable(type, BooleanType.class, simpleNode, "castFromBooleanRequired", primitiveValue, type);
            if (type instanceof ByteType) {
                return this.vm.mirrorOf(primitiveValue.byteValue());
            }
            if (type instanceof CharType) {
                return this.vm.mirrorOf(primitiveValue.charValue());
            }
            if (type instanceof DoubleType) {
                return this.vm.mirrorOf(primitiveValue.doubleValue());
            }
            if (type instanceof FloatType) {
                return this.vm.mirrorOf(primitiveValue.floatValue());
            }
            if (type instanceof IntegerType) {
                return this.vm.mirrorOf(primitiveValue.intValue());
            }
            if (type instanceof LongType) {
                return this.vm.mirrorOf(primitiveValue.longValue());
            }
            return this.vm.mirrorOf(primitiveValue.shortValue());
        }
        ObjectReference objectReference = (ObjectReference)object2;
        if (!this.instanceOf(objectReference.type(), type)) {
            Assert.error(simpleNode, "castError", objectReference.type(), type);
        }
        return object2;
    }

    private Object visitPostfixExpression(SimpleNode simpleNode, Object object) {
        Object object2 = simpleNode.jjtGetChild(0).jjtAccept(this, object);
        Assert.assertAssignable(object2, PrimitiveValue.class, simpleNode, "badOperandForPostfixOperator", object2);
        Assert.assertNotAssignable(object2, BooleanValue.class, simpleNode, "badOperandForPostfixOperator", object2);
        Token token = (Token)simpleNode.getAttribute("operator");
        try {
            return this.operators.evaluate(token, (PrimitiveValue)object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Assert.error(simpleNode, "postfixOperatorEvaluationError", token, illegalArgumentException);
        }
    }

    private Object visitPrefixExpression(SimpleNode simpleNode, Object object) {
        Object object2 = simpleNode.jjtGetChild(0).jjtAccept(this, object);
        Assert.assertAssignable(object2, PrimitiveValue.class, simpleNode, "badOperandForPrefixOperator", object2);
        Assert.assertNotAssignable(object2, BooleanValue.class, simpleNode, "badOperandForPrefixOperator", object2);
        Token token = (Token)simpleNode.getAttribute("operator");
        try {
            return this.operators.evaluate(token, (PrimitiveValue)object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Assert.error(simpleNode, "prefixOperatorEvaluationError", token, illegalArgumentException);
        }
    }

    private Object visitUnaryExpression(SimpleNode simpleNode, Object object) {
        Object object2 = simpleNode.jjtGetChild(0).jjtAccept(this, object);
        Assert.assertAssignable(object2, PrimitiveValue.class, simpleNode, "badOperandForUnaryOperator", object2);
        Token token = (Token)simpleNode.getAttribute("operator");
        try {
            return this.operators.evaluate(token, (PrimitiveValue)object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Assert.error(simpleNode, "unaryOperatorEvaluationError", token, illegalArgumentException);
        }
    }

    private Object visitIdentifier(SimpleNode simpleNode, Object object) {
        return ((Token)simpleNode.getAttribute((String)"token")).image;
    }

    private Object visitClassOrInterfaceType(SimpleNode simpleNode, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = simpleNode.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode simpleNode2;
            String string = (String)simpleNode.jjtGetChild(i).jjtAccept(this, object);
            stringBuffer.append('.');
            stringBuffer.append(string);
            if (i >= n - 1 || (simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i + 1)).jjtGetID() != 6) continue;
            ++i;
        }
        String string = stringBuffer.substring(1);
        try {
            return this.resolveType(string);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return Assert.error(simpleNode, "internalErrorResolvingType", string);
        }
    }

    private ReferenceType resolveType(String string) throws IncompatibleThreadStateException {
        String string2;
        ReferenceType referenceType;
        if (string.charAt(0) == '[') {
            referenceType = this.getClass(string);
            if (referenceType != null) {
                return referenceType;
            }
            Assert.error(this.currentNode, "unknownType", string);
        }
        if ((referenceType = this.getClass(string2 = this.frame.location().declaringType().name() + "$" + string)) != null) {
            return referenceType;
        }
        int n = string.lastIndexOf(46);
        if (n == -1 ? (referenceType = this.getClass(this.currentPackage + string)) != null : (referenceType = this.getClass(string)) != null) {
            return referenceType;
        }
        if (n != -1) {
            string2 = string.substring(0, n) + "$" + string.substring(n + 1);
            if (string2.indexOf(46) == -1) {
                string2 = this.currentPackage + string2;
            }
            if ((referenceType = this.getClass(string2)) != null) {
                return referenceType;
            }
        }
        List<String> list = this.evaluationContext.getImports();
        for (String string3 : list) {
            String string4;
            int n2;
            String string5 = string3.substring((n2 = string3.lastIndexOf(46)) + 1);
            if (!string5.equals("*") && !string5.equals(string) || (referenceType = this.getClass(string4 = string3.substring(0, n2 + 1) + string)) == null) continue;
            return referenceType;
        }
        Assert.error(this.currentNode, "unknownType", string);
        return null;
    }

    private ReferenceType getClass(String string) throws IncompatibleThreadStateException {
        List<ReferenceType> list = this.vm.classesByName(string);
        if (list.size() != 0) {
            return list.get(0);
        }
        return null;
    }

    private Object visitReferenceType(SimpleNode simpleNode, Object object) {
        Type type = (Type)simpleNode.jjtGetChild(0).jjtAccept(this, object);
        int n = (Integer)simpleNode.getAttribute("arrayCount");
        if (n > 0) {
            try {
                return this.resolveType(this.brackets(n) + type.signature().replace('/', '.'));
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                Assert.error(simpleNode, "internalError");
            }
        }
        return type;
    }

    private Object visitInstanceOfExpression(SimpleNode simpleNode, Object object) {
        Object object2 = simpleNode.jjtGetChild(0).jjtAccept(this, object);
        if (object2 == null) {
            return this.vm.mirrorOf(false);
        }
        Assert.assertAssignable(object2, ObjectReference.class, simpleNode, "instanceOfLeftOperandNotAReference", object2);
        ReferenceType referenceType = ((ObjectReference)object2).referenceType();
        ReferenceType referenceType2 = (ReferenceType)simpleNode.jjtGetChild(1).jjtAccept(this, object);
        return this.vm.mirrorOf(this.instanceOf(referenceType, referenceType2));
    }

    private boolean instanceOf(Type type, Type type2) {
        if (type == null) {
            return false;
        }
        if (type.equals(type2)) {
            return true;
        }
        if (type2 instanceof ArrayType) {
            Type type3;
            Type type4;
            if (!(type instanceof ArrayType)) {
                return false;
            }
            ArrayType arrayType = (ArrayType)type;
            ArrayType arrayType2 = (ArrayType)type2;
            try {
                type4 = arrayType.componentType();
                type3 = arrayType2.componentType();
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                return false;
            }
            return this.instanceOf(type4, type3);
        }
        if (type instanceof ClassType) {
            ClassType classType = (ClassType)type;
            if (type2 instanceof InterfaceType) {
                List<InterfaceType> list = classType.allInterfaces();
                for (InterfaceType interfaceType : list) {
                    if (!interfaceType.equals(type2)) continue;
                    return true;
                }
                return false;
            }
            do {
                if ((classType = classType.superclass()) != null) continue;
                return false;
            } while (!classType.equals(type2));
            return true;
        }
        return false;
    }

    private Object visitConditionalOrAndExpression(SimpleNode simpleNode, Object object) {
        Token token = (Token)simpleNode.getAttribute("operator");
        int n = simpleNode.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Object object2 = simpleNode.jjtGetChild(i).jjtAccept(this, object);
            Assert.assertAssignable(object2, BooleanValue.class, simpleNode, "conditionalOrAndBooleanOperandRequired", object2);
            boolean bl = ((BooleanValue)object2).booleanValue();
            if ((token.kind != 103 || !bl) && (token.kind != 104 || bl)) continue;
            return object2;
        }
        return this.vm.mirrorOf(token.kind == 104);
    }

    private Object visitConditionalExpression(SimpleNode simpleNode, Object object) {
        Object object2 = simpleNode.jjtGetChild(0).jjtAccept(this, object);
        Assert.assertAssignable(object2, BooleanValue.class, simpleNode, "conditionalQuestionMarkBooleanOperandRequired", object2);
        boolean bl = ((BooleanValue)object2).booleanValue();
        if (bl) {
            return simpleNode.jjtGetChild(1).jjtAccept(this, object);
        }
        return simpleNode.jjtGetChild(2).jjtAccept(this, object);
    }

    private Object visitBooleanLiteral(SimpleNode simpleNode, Object object) {
        Token token = (Token)simpleNode.getAttribute("token");
        return this.vm.mirrorOf(token.kind == 66);
    }

    private Object visitName(SimpleNode simpleNode, Object object) {
        Object[] objectArray = simpleNode.getAttributes("token");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append('.');
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.substring(1);
    }

    private Object visitPrimaryPrefix(SimpleNode simpleNode, Object object) {
        if (simpleNode.jjtGetNumChildren() == 0) {
            ObjectReference objectReference = this.frame.thisObject();
            if (objectReference == null) {
                Assert.error(simpleNode, "thisObjectUnavailable");
            }
            if (simpleNode.getAttribute("this") != null) {
                return objectReference;
            }
            String string = (String)simpleNode.getAttribute("qualifier");
            String string2 = (String)simpleNode.getAttribute("identifier");
            return new Identifier(objectReference, string2, string);
        }
        SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
        switch (simpleNode2.jjtGetID()) {
            case 34: {
                return this.visit(simpleNode2, object);
            }
            case 11: {
                return this.visit(simpleNode2, object);
            }
            case 9: {
                Mirror mirror;
                String string = (String)this.visit(simpleNode2, object);
                if (string.indexOf(46) == -1) {
                    return new Identifier(true, this.frame.thisObject(), this.frame.location().declaringType(), string);
                }
                int n = string.indexOf(46);
                String string3 = string.substring(0, n);
                ObjectReference objectReference = null;
                try {
                    mirror = this.evaluateVariable(new Identifier(true, this.frame.thisObject(), this.frame.location().declaringType(), string3));
                    Assert.assertAssignable(mirror, ObjectReference.class, simpleNode, "objectReferenceRequiredOnDereference", mirror);
                    objectReference = (ObjectReference)mirror;
                }
                catch (EvaluationException evaluationException) {
                    // empty catch block
                }
                mirror = null;
                if (objectReference == null) {
                    while (true) {
                        try {
                            mirror = this.resolveType(string3);
                            break;
                        }
                        catch (EvaluationException evaluationException) {
                        }
                        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                            Assert.error(simpleNode, "internalError");
                        }
                        n = string.indexOf(46, n + 1);
                        if (n == -1) break;
                        string3 = string.substring(0, n);
                    }
                    if (mirror == null) {
                        Assert.error(simpleNode, "unknownType", string);
                    }
                }
                while (true) {
                    int n2;
                    int n3 = n2 = string.indexOf(46, n + 1);
                    if (n2 == -1) {
                        n2 = string.length();
                    }
                    Identifier identifier = objectReference != null ? new Identifier(false, objectReference, string.substring(n + 1, n2)) : new Identifier(false, (ReferenceType)mirror, string.substring(n + 1, n2));
                    if (n3 == -1) {
                        return identifier;
                    }
                    Value value = this.evaluateVariable(identifier);
                    Assert.assertAssignable(value, ObjectReference.class, simpleNode, "objectReferenceRequiredOnDereference", value);
                    objectReference = (ObjectReference)value;
                    n = n2;
                }
            }
            case 8: {
                Object object2 = simpleNode2.jjtAccept(this, object);
                if (object2 instanceof ReferenceType) {
                    return ((ReferenceType)object2).classObject();
                }
                return object2;
            }
        }
        return simpleNode2.jjtAccept(this, object);
    }

    private Object visitArgumentList(SimpleNode simpleNode, Object object) {
        int n = simpleNode.jjtGetNumChildren();
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            Object object2 = simpleNode.jjtGetChild(i).jjtAccept(this, object);
            if (object2 != null) {
                Assert.assertAssignable(object2, Value.class, simpleNode, "badArgument", object2);
            }
            valueArray[i] = (Value)object2;
        }
        return valueArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object visitArguments(SimpleNode var1_1, Object var2_2) {
        block88: {
            block87: {
                block86: {
                    block83: {
                        block81: {
                            block84: {
                                Assert.assertAssignable(var2_2, Identifier.class, var1_1, "argumentsBadSyntax", var2_2);
                                var3_3 = (Identifier)var2_2;
                                var4_4 = var1_1.jjtGetNumChildren() > 0 ? (Value[])var1_1.jjtGetChild(0).jjtAccept(this, null) : new Value[]{};
                                try {
                                    var5_5 = this.getConcreteMethod(var3_3, var4_4);
                                }
                                catch (UnsupportedOperationException var6_6) {
                                    return Assert.error(var1_1, "calleeException", var6_6, var3_3);
                                }
                                if (var5_5.instanceContext == null) break block83;
                                try {
                                    block80: {
                                        try {
                                            if (Evaluator.verbose) {
                                                throw new UnsupportedOperationException(NbBundle.getMessage(Evaluator.class, (String)"CTL_UnsupportedOperationException"));
                                            }
                                            if (!this.evaluationContext.canInvokeMethods()) {
                                                var6_7 = Assert.error(var1_1, "calleeException", new UnsupportedOperationException(), var3_3);
                                                var8_15 = null;
                                                break block80;
                                            }
                                            this.evaluationContext.methodToBeInvoked();
                                            if (Evaluator.loggerMethod.isLoggable(Level.FINE)) {
                                                Evaluator.loggerMethod.fine("STARTED : " + var5_5.instanceContext + "." + var5_5.method + " (" + var5_5.args + ") in thread " + this.frameThread);
                                            }
                                            var6_8 = var5_5.instanceContext.invokeMethod(this.frameThread, var5_5.method, var5_5.args, 3);
                                            break block81;
                                        }
                                        catch (InvalidTypeException var6_9) {
                                            Assert.error(var1_1, "callException", var6_9, var3_3);
                                            var8_17 = null;
                                            if (Evaluator.loggerMethod.isLoggable(Level.FINE)) {
                                                Evaluator.loggerMethod.fine("FINISHED: " + var5_5.instanceContext + "." + var5_5.method + " (" + var5_5.args + ") in thread " + this.frameThread);
                                            }
                                            try {
                                                this.evaluationContext.methodInvokeDone();
                                            }
                                            catch (IncompatibleThreadStateException var9_23) {
                                                var10_37 = new InvalidExpressionException((Throwable)var9_23);
                                                var10_37.initCause((Throwable)var9_23);
                                                throw new IllegalStateException(var10_37);
                                            }
                                            try {
                                                this.frame = this.frameThread.frame(this.frameIndex);
                                            }
                                            catch (IncompatibleThreadStateException var9_24) {
                                                Assert.error(var1_1, "callException", var9_24, var3_3);
                                            }
                                            break block83;
                                        }
                                        catch (ClassNotLoadedException var6_10) {
                                            Assert.error(var1_1, "callException", var6_10, var3_3);
                                            var8_17 = null;
                                            if (Evaluator.loggerMethod.isLoggable(Level.FINE)) {
                                                Evaluator.loggerMethod.fine("FINISHED: " + var5_5.instanceContext + "." + var5_5.method + " (" + var5_5.args + ") in thread " + this.frameThread);
                                            }
                                            try {}
                                            catch (IncompatibleThreadStateException var9_25) {
                                                var10_38 = new InvalidExpressionException((Throwable)var9_25);
                                                var10_38.initCause((Throwable)var9_25);
                                                throw new IllegalStateException(var10_38);
                                            }
                                            this.evaluationContext.methodInvokeDone();
                                            ** try [egrp 4[TRYBLOCK] [20 : 485->505)] { 
lbl64:
                                            // 1 sources

                                            this.frame = this.frameThread.frame(this.frameIndex);
lbl66:
                                            // 1 sources

                                            catch (IncompatibleThreadStateException var9_26) {
                                                Assert.error(var1_1, "callException", var9_26, var3_3);
                                            }
                                            break block83;
                                        }
                                        catch (IncompatibleThreadStateException var6_11) {
                                            Assert.error(var1_1, "callException", var6_11, var3_3);
                                            var8_17 = null;
                                            if (Evaluator.loggerMethod.isLoggable(Level.FINE)) {
                                                Evaluator.loggerMethod.fine("FINISHED: " + var5_5.instanceContext + "." + var5_5.method + " (" + var5_5.args + ") in thread " + this.frameThread);
                                            }
                                            try {}
                                            catch (IncompatibleThreadStateException var9_27) {
                                                var10_39 = new InvalidExpressionException((Throwable)var9_27);
                                                var10_39.initCause((Throwable)var9_27);
                                                throw new IllegalStateException(var10_39);
                                            }
                                            this.evaluationContext.methodInvokeDone();
                                            ** try [egrp 4[TRYBLOCK] [20 : 485->505)] { 
lbl86:
                                            // 1 sources

                                            this.frame = this.frameThread.frame(this.frameIndex);
lbl88:
                                            // 1 sources

                                            catch (IncompatibleThreadStateException var9_28) {
                                                Assert.error(var1_1, "callException", var9_28, var3_3);
                                            }
                                            break block83;
                                        }
                                        catch (InvocationException var6_12) {
                                            Assert.error(var1_1, "calleeException", var6_12, var3_3);
                                            var8_17 = null;
                                            if (Evaluator.loggerMethod.isLoggable(Level.FINE)) {
                                                Evaluator.loggerMethod.fine("FINISHED: " + var5_5.instanceContext + "." + var5_5.method + " (" + var5_5.args + ") in thread " + this.frameThread);
                                            }
                                            try {}
                                            catch (IncompatibleThreadStateException var9_29) {
                                                var10_40 = new InvalidExpressionException((Throwable)var9_29);
                                                var10_40.initCause((Throwable)var9_29);
                                                throw new IllegalStateException(var10_40);
                                            }
                                            this.evaluationContext.methodInvokeDone();
                                            ** try [egrp 4[TRYBLOCK] [20 : 485->505)] { 
lbl108:
                                            // 1 sources

                                            this.frame = this.frameThread.frame(this.frameIndex);
lbl110:
                                            // 1 sources

                                            catch (IncompatibleThreadStateException var9_30) {
                                                Assert.error(var1_1, "callException", var9_30, var3_3);
                                            }
                                            break block83;
                                        }
                                        catch (UnsupportedOperationException var6_13) {
                                            this.evaluationContext.setCanInvokeMethods(false);
                                            Assert.error(var1_1, "calleeException", var6_13, var3_3);
                                            var8_17 = null;
                                            if (Evaluator.loggerMethod.isLoggable(Level.FINE)) {
                                                Evaluator.loggerMethod.fine("FINISHED: " + var5_5.instanceContext + "." + var5_5.method + " (" + var5_5.args + ") in thread " + this.frameThread);
                                            }
                                            try {}
                                            catch (IncompatibleThreadStateException var9_31) {
                                                var10_41 = new InvalidExpressionException((Throwable)var9_31);
                                                var10_41.initCause((Throwable)var9_31);
                                                throw new IllegalStateException(var10_41);
                                            }
                                            this.evaluationContext.methodInvokeDone();
                                            ** try [egrp 4[TRYBLOCK] [20 : 485->505)] { 
lbl131:
                                            // 1 sources

                                            this.frame = this.frameThread.frame(this.frameIndex);
lbl133:
                                            // 1 sources

                                            catch (IncompatibleThreadStateException var9_32) {
                                                Assert.error(var1_1, "callException", var9_32, var3_3);
                                            }
                                            break block83;
                                        }
                                    }
                                    if (!Evaluator.loggerMethod.isLoggable(Level.FINE)) break block84;
                                    Evaluator.loggerMethod.fine("FINISHED: " + var5_5.instanceContext + "." + var5_5.method + " (" + var5_5.args + ") in thread " + this.frameThread);
                                }
                                catch (Throwable var7_43) {
                                    var8_18 = null;
                                    if (Evaluator.loggerMethod.isLoggable(Level.FINE)) {
                                        Evaluator.loggerMethod.fine("FINISHED: " + var5_5.instanceContext + "." + var5_5.method + " (" + var5_5.args + ") in thread " + this.frameThread);
                                    }
                                    try {}
                                    catch (IncompatibleThreadStateException var9_33) {
                                        var10_42 = new InvalidExpressionException((Throwable)var9_33);
                                        var10_42.initCause((Throwable)var9_33);
                                        throw new IllegalStateException(var10_42);
                                    }
                                    this.evaluationContext.methodInvokeDone();
                                    ** try [egrp 4[TRYBLOCK] [20 : 485->505)] { 
lbl155:
                                    // 1 sources

                                    this.frame = this.frameThread.frame(this.frameIndex);
                                    throw var7_43;
lbl157:
                                    // 1 sources

                                    catch (IncompatibleThreadStateException var9_34) {
                                        Assert.error(var1_1, "callException", var9_34, var3_3);
                                    }
                                    throw var7_43;
                                }
                            }
                            try {}
                            catch (IncompatibleThreadStateException var9_19) {
                                var10_35 = new InvalidExpressionException((Throwable)var9_19);
                                var10_35.initCause((Throwable)var9_19);
                                throw new IllegalStateException(var10_35);
                            }
                            this.evaluationContext.methodInvokeDone();
                            ** try [egrp 4[TRYBLOCK] [20 : 485->505)] { 
lbl171:
                            // 1 sources

                            this.frame = this.frameThread.frame(this.frameIndex);
                            return var6_7;
lbl173:
                            // 1 sources

                            catch (IncompatibleThreadStateException var9_20) {
                                Assert.error(var1_1, "callException", var9_20, var3_3);
                            }
                            return var6_7;
                        }
                        var8_16 = null;
                        if (Evaluator.loggerMethod.isLoggable(Level.FINE)) {
                            Evaluator.loggerMethod.fine("FINISHED: " + var5_5.instanceContext + "." + var5_5.method + " (" + var5_5.args + ") in thread " + this.frameThread);
                        }
                        try {}
                        catch (IncompatibleThreadStateException var9_21) {
                            var10_36 = new InvalidExpressionException((Throwable)var9_21);
                            var10_36.initCause((Throwable)var9_21);
                            throw new IllegalStateException(var10_36);
                        }
                        this.evaluationContext.methodInvokeDone();
                        try {}
                        catch (IncompatibleThreadStateException var9_22) {
                            Assert.error(var1_1, "callException", var9_22, var3_3);
                            return var6_8;
                        }
                        this.frame = this.frameThread.frame(this.frameIndex);
                        return var6_8;
                    }
                    if (var5_5.typeContext instanceof ClassType == false) return Assert.error(var1_1, "noSuchMethod", var3_3);
                    var6_14 = (ClassType)var5_5.typeContext;
                    try {
                        try {
                            if (var5_5.method.isConstructor()) {
                                if (Evaluator.verbose) {
                                    throw new UnsupportedOperationException(NbBundle.getMessage(Evaluator.class, (String)"CTL_UnsupportedOperationException"));
                                }
                                try {
                                    var7_44 = var6_14.newInstance(this.frameThread, var5_5.method, var5_5.args, 1);
                                }
                                catch (UnsupportedOperationException var7_45) {
                                    var8_17 = Assert.error(var1_1, "calleeException", var7_45, var3_3);
                                    var12_55 = null;
                                    try {
                                        this.evaluationContext.methodInvokeDone();
                                    }
                                    catch (IncompatibleThreadStateException var13_67) {
                                        var14_88 = new InvalidExpressionException((Throwable)var13_67);
                                        var14_88.initCause((Throwable)var13_67);
                                        throw new IllegalStateException(var14_88);
                                    }
                                    try {
                                        this.frame = this.frameThread.frame(this.frameIndex);
                                        return var8_17;
                                    }
                                    catch (IncompatibleThreadStateException var13_68) {
                                        Assert.error(var1_1, "callException", var13_68, var3_3);
                                    }
                                    return var8_17;
                                }
                                var12_54 = null;
                                break block86;
                            }
                            if (Evaluator.verbose) {
                                throw new UnsupportedOperationException(NbBundle.getMessage(Evaluator.class, (String)"CTL_UnsupportedOperationException"));
                            }
                            if (!this.evaluationContext.canInvokeMethods()) {
                                var7_46 = Assert.error(var1_1, "calleeException", new UnsupportedOperationException(), var3_3);
                                break block87;
                            }
                            this.evaluationContext.methodToBeInvoked();
                            var7_47 = var6_14.invokeMethod(this.frameThread, var5_5.method, var5_5.args, 1);
                            break block88;
                        }
                        catch (InvalidTypeException var7_48) {
                            Assert.error(var1_1, "callException", var7_48, var3_3);
                            var12_58 = null;
                            try {}
                            catch (IncompatibleThreadStateException var13_73) {
                                var14_91 = new InvalidExpressionException((Throwable)var13_73);
                                var14_91.initCause((Throwable)var13_73);
                                throw new IllegalStateException(var14_91);
                            }
                            this.evaluationContext.methodInvokeDone();
                            try {}
                            catch (IncompatibleThreadStateException var13_74) {
                                Assert.error(var1_1, "callException", var13_74, var3_3);
                                return Assert.error(var1_1, "noSuchMethod", var3_3);
                            }
                            this.frame = this.frameThread.frame(this.frameIndex);
                            return Assert.error(var1_1, "noSuchMethod", var3_3);
                        }
                        catch (ClassNotLoadedException var7_49) {
                            Assert.error(var1_1, "callException", var7_49, var3_3);
                            var12_59 = null;
                            try {}
                            catch (IncompatibleThreadStateException var13_75) {
                                var14_92 = new InvalidExpressionException((Throwable)var13_75);
                                var14_92.initCause((Throwable)var13_75);
                                throw new IllegalStateException(var14_92);
                            }
                            this.evaluationContext.methodInvokeDone();
                            try {}
                            catch (IncompatibleThreadStateException var13_76) {
                                Assert.error(var1_1, "callException", var13_76, var3_3);
                                return Assert.error(var1_1, "noSuchMethod", var3_3);
                            }
                            this.frame = this.frameThread.frame(this.frameIndex);
                            return Assert.error(var1_1, "noSuchMethod", var3_3);
                        }
                        catch (IncompatibleThreadStateException var7_50) {
                            Assert.error(var1_1, "callException", var7_50, var3_3);
                            var12_60 = null;
                            try {}
                            catch (IncompatibleThreadStateException var13_77) {
                                var14_93 = new InvalidExpressionException((Throwable)var13_77);
                                var14_93.initCause((Throwable)var13_77);
                                throw new IllegalStateException(var14_93);
                            }
                            this.evaluationContext.methodInvokeDone();
                            try {}
                            catch (IncompatibleThreadStateException var13_78) {
                                Assert.error(var1_1, "callException", var13_78, var3_3);
                                return Assert.error(var1_1, "noSuchMethod", var3_3);
                            }
                            this.frame = this.frameThread.frame(this.frameIndex);
                            return Assert.error(var1_1, "noSuchMethod", var3_3);
                        }
                        catch (InvocationException var7_51) {
                            Assert.error(var1_1, "calleeException", var7_51, var3_3);
                            var12_61 = null;
                            try {}
                            catch (IncompatibleThreadStateException var13_79) {
                                var14_94 = new InvalidExpressionException((Throwable)var13_79);
                                var14_94.initCause((Throwable)var13_79);
                                throw new IllegalStateException(var14_94);
                            }
                            this.evaluationContext.methodInvokeDone();
                            try {}
                            catch (IncompatibleThreadStateException var13_80) {
                                Assert.error(var1_1, "callException", var13_80, var3_3);
                                return Assert.error(var1_1, "noSuchMethod", var3_3);
                            }
                            this.frame = this.frameThread.frame(this.frameIndex);
                            return Assert.error(var1_1, "noSuchMethod", var3_3);
                        }
                        catch (IllegalArgumentException var7_52) {
                            Assert.error(var1_1, "callException", var7_52, var3_3);
                            var12_62 = null;
                            try {}
                            catch (IncompatibleThreadStateException var13_81) {
                                var14_95 = new InvalidExpressionException((Throwable)var13_81);
                                var14_95.initCause((Throwable)var13_81);
                                throw new IllegalStateException(var14_95);
                            }
                            this.evaluationContext.methodInvokeDone();
                            try {}
                            catch (IncompatibleThreadStateException var13_82) {
                                Assert.error(var1_1, "callException", var13_82, var3_3);
                                return Assert.error(var1_1, "noSuchMethod", var3_3);
                            }
                            this.frame = this.frameThread.frame(this.frameIndex);
                            return Assert.error(var1_1, "noSuchMethod", var3_3);
                        }
                        catch (UnsupportedOperationException var7_53) {
                            this.evaluationContext.setCanInvokeMethods(false);
                            Assert.error(var1_1, "calleeException", var7_53, var3_3);
                            var12_63 = null;
                            try {}
                            catch (IncompatibleThreadStateException var13_83) {
                                var14_96 = new InvalidExpressionException((Throwable)var13_83);
                                var14_96.initCause((Throwable)var13_83);
                                throw new IllegalStateException(var14_96);
                            }
                            this.evaluationContext.methodInvokeDone();
                            try {}
                            catch (IncompatibleThreadStateException var13_84) {
                                Assert.error(var1_1, "callException", var13_84, var3_3);
                                return Assert.error(var1_1, "noSuchMethod", var3_3);
                            }
                            this.frame = this.frameThread.frame(this.frameIndex);
                            return Assert.error(var1_1, "noSuchMethod", var3_3);
                        }
                    }
                    catch (Throwable var11_98) {
                        var12_64 = null;
                        try {}
                        catch (IncompatibleThreadStateException var13_85) {
                            var14_97 = new InvalidExpressionException((Throwable)var13_85);
                            var14_97.initCause((Throwable)var13_85);
                            throw new IllegalStateException(var14_97);
                        }
                        this.evaluationContext.methodInvokeDone();
                        ** try [egrp 9[TRYBLOCK] [58 : 882->902)] { 
lbl372:
                        // 1 sources

                        this.frame = this.frameThread.frame(this.frameIndex);
                        throw var11_98;
lbl374:
                        // 1 sources

                        catch (IncompatibleThreadStateException var13_86) {
                            Assert.error(var1_1, "callException", var13_86, var3_3);
                        }
                        throw var11_98;
                    }
                }
                try {}
                catch (IncompatibleThreadStateException var13_65) {
                    var14_87 = new InvalidExpressionException((Throwable)var13_65);
                    var14_87.initCause((Throwable)var13_65);
                    throw new IllegalStateException(var14_87);
                }
                this.evaluationContext.methodInvokeDone();
                try {}
                catch (IncompatibleThreadStateException var13_66) {
                    Assert.error(var1_1, "callException", var13_66, var3_3);
                    return var7_44;
                }
                this.frame = this.frameThread.frame(this.frameIndex);
                return var7_44;
            }
            var12_56 = null;
            try {}
            catch (IncompatibleThreadStateException var13_69) {
                var14_89 = new InvalidExpressionException((Throwable)var13_69);
                var14_89.initCause((Throwable)var13_69);
                throw new IllegalStateException(var14_89);
            }
            this.evaluationContext.methodInvokeDone();
            ** try [egrp 9[TRYBLOCK] [58 : 882->902)] { 
lbl405:
            // 1 sources

            this.frame = this.frameThread.frame(this.frameIndex);
            return var7_46;
lbl407:
            // 1 sources

            catch (IncompatibleThreadStateException var13_70) {
                Assert.error(var1_1, "callException", var13_70, var3_3);
            }
            return var7_46;
        }
        var12_57 = null;
        try {}
        catch (IncompatibleThreadStateException var13_71) {
            var14_90 = new InvalidExpressionException((Throwable)var13_71);
            var14_90.initCause((Throwable)var13_71);
            throw new IllegalStateException(var14_90);
        }
        this.evaluationContext.methodInvokeDone();
        try {}
        catch (IncompatibleThreadStateException var13_72) {
            Assert.error(var1_1, "callException", var13_72, var3_3);
            return var7_47;
        }
        this.frame = this.frameThread.frame(this.frameIndex);
        return var7_47;
    }

    private boolean isAccessible(TypeComponent typeComponent) {
        int n;
        if (typeComponent.isPublic()) {
            return true;
        }
        ReferenceType referenceType = this.frame.location().declaringType();
        ReferenceType referenceType2 = typeComponent.declaringType();
        if (typeComponent.isPrivate()) {
            if (((Object)referenceType).equals(referenceType2)) {
                return true;
            }
            return this.isNested(referenceType2, referenceType) || this.isNested(referenceType, referenceType2);
        }
        String string = referenceType.name();
        String string2 = referenceType2.name();
        int n2 = string.lastIndexOf(46);
        if (n2 * (n = string2.lastIndexOf(46)) < 0) {
            return false;
        }
        if (n2 + n == -2) {
            return true;
        }
        if (string.substring(0, n2).equals(string2.substring(0, n))) {
            return true;
        }
        if (typeComponent.isProtected()) {
            return this.instanceOf(referenceType, referenceType2);
        }
        return false;
    }

    private boolean isNested(ReferenceType referenceType, ReferenceType referenceType2) {
        List<ReferenceType> list = referenceType.nestedTypes();
        for (ReferenceType referenceType3 : list) {
            if (!((Object)referenceType3).equals(referenceType2) && !this.isNested(referenceType3, referenceType2)) continue;
            return true;
        }
        return false;
    }

    private MethodCall getConcreteMethod(Identifier identifier, Value[] valueArray) {
        Object object;
        Object object2;
        List<Method> list;
        ReferenceType accessible = identifier.typeContext;
        ObjectReference objectReference = identifier.instanceContext;
        if (identifier.superQualifier != null) {
            if (!(identifier.typeContext instanceof ClassType)) {
                Assert.error(this.currentNode, "superUsedOnNonClass", identifier);
            }
            if (identifier.superQualifier.length() > 0) {
                objectReference = this.getEnclosingObject(identifier.instanceContext, identifier.superQualifier);
                Assert.assertNotNull(objectReference, this.currentNode, "notEnclosingType", identifier);
            }
            list = (ClassType)objectReference.referenceType();
            accessible = list.superclass();
        }
        if (identifier.typeContext == null) {
            Assert.error(this.currentNode, "methodCallOnNull", identifier.identifier);
        }
        list = Evaluator.getMethodsByName(accessible, identifier.identifier);
        ReferenceType referenceType = accessible;
        ObjectReference objectReference2 = objectReference;
        while (list.size() == 0) {
            object2 = accessible.fieldByName("this$0");
            if (object2 == null) {
                accessible = referenceType;
                objectReference = objectReference2;
                break;
            }
            if (loggerValue.isLoggable(Level.FINE)) {
                loggerValue.fine("STARTED : " + objectReference + ".getValue(" + object2 + ")");
            }
            objectReference = (ObjectReference)objectReference.getValue((Field)object2);
            if (loggerValue.isLoggable(Level.FINE)) {
                loggerValue.fine("FINISHED: getValue(" + object2 + ") = " + objectReference);
            }
            accessible = objectReference.referenceType();
            list = Evaluator.getMethodsByName(accessible, identifier.identifier);
        }
        if (identifier.localContext && list.size() == 0) {
            object2 = this.staticImportsIterator(identifier.identifier);
            while (object2.hasNext()) {
                object = object2.next();
                try {
                    ReferenceType exception = this.resolveType((String)object);
                    list = Evaluator.getMethodsByName(exception, identifier.identifier);
                    if (list.size() <= 0) continue;
                    accessible = exception;
                    objectReference = null;
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        object2 = new ArrayList();
        for (Method method : list) {
            List<Value> list2;
            if (!this.isAccessible(method)) continue;
            List<Type> list3 = null;
            try {
                list3 = method.argumentTypes();
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                continue;
            }
            catch (ObjectCollectedException objectCollectedException) {
                continue;
            }
            if (valueArray.length == 0 && "<init>".equals(identifier.identifier) && list3.size() == 1 && this.frame.thisObject() != null && list3.get(0).equals(this.frame.location().declaringType())) {
                valueArray = new Value[]{this.frame.thisObject()};
            }
            if ((list2 = this.prepareArguments(valueArray, list3)) == null) continue;
            object2.add((MethodCall)new MethodCall(accessible, objectReference, method, list2));
        }
        Assert.assertNonEmpty(object2, this.currentNode, "noSuchMethod", identifier);
        object = this.mostSpecific((List<MethodCall>)object2, valueArray);
        Assert.assertNotNull(object, this.currentNode, "ambigousMethod", identifier);
        object = this.findConcrete((MethodCall)object);
        return object;
    }

    private static List<Method> getMethodsByName(ReferenceType referenceType, String string) {
        if (referenceType instanceof ArrayType) {
            referenceType = referenceType.classObject().referenceType();
            if ("toString".equals(string)) {
                referenceType = ((ClassType)referenceType).superclass();
            }
        }
        List<Method> list = referenceType.methodsByName(string);
        return list;
    }

    private MethodCall mostSpecific(List<MethodCall> list, Value[] valueArray) {
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        MethodCall methodCall = null;
        int n = Integer.MAX_VALUE;
        for (MethodCall methodCall2 : list) {
            List<Type> list2 = null;
            try {
                list2 = methodCall2.method.argumentTypes();
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                continue;
            }
            catch (ObjectCollectedException objectCollectedException) {
                continue;
            }
            int n2 = this.conversionsCount(list2, valueArray);
            if (n2 == 0) {
                return methodCall2;
            }
            if (n2 == n) {
                return null;
            }
            if (n2 >= n) continue;
            n = n2;
            methodCall = methodCall2;
        }
        return methodCall;
    }

    private int conversionsCount(List list, Value[] valueArray) {
        int n = 0;
        int n2 = 0;
        for (Type type : list) {
            if (valueArray[n] != null && !this.representSameType(type, valueArray[n].type())) {
                ++n2;
            }
            ++n;
        }
        return n2;
    }

    private boolean representSameType(Type type, Type type2) {
        String string;
        String string2 = type.signature();
        if (string2.equals(string = type2.signature())) {
            return true;
        }
        if (string2.length() == 1 && string.length() == 1 || string2.length() > 1 && string.length() > 1) {
            return false;
        }
        String string3 = string2.length() == 1 ? string2 : string;
        String string4 = string2.length() > 1 ? string2 : string;
        return this.wrapperSignature(string3.charAt(0)).equals(string4);
    }

    private MethodCall findConcrete(MethodCall methodCall) {
        Method method;
        ReferenceType referenceType;
        if (methodCall.method.isAbstract() && (referenceType = methodCall.instanceContext.referenceType()) instanceof ClassType && (method = ((ClassType)referenceType).concreteMethodByName(methodCall.method.name(), methodCall.method.signature())) != null) {
            methodCall.method = method;
            methodCall.typeContext = referenceType;
        }
        return methodCall;
    }

    private List<Value> prepareArguments(Value[] valueArray, List list) {
        Type type;
        boolean bl;
        try {
            bl = list.size() > 0 && list.get(list.size() - 1) instanceof ArrayType && (valueArray.length == 0 || valueArray[valueArray.length - 1] == null || this.isConvertible(((ArrayType)list.get(list.size() - 1)).componentType(), valueArray[valueArray.length - 1]));
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            return null;
        }
        if (bl ? valueArray.length < list.size() - 1 : valueArray.length != list.size()) {
            return null;
        }
        ArrayList<Value> arrayList = new ArrayList<Value>();
        int n = 0;
        Object object = list.iterator();
        while (object.hasNext()) {
            type = (Type)object.next();
            if (!bl || object.hasNext()) {
                if (!this.isConvertible(type, valueArray[n])) {
                    return null;
                }
                arrayList.add(this.boxUnboxIfNeeded(valueArray[n], type));
            }
            ++n;
        }
        if (bl) {
            object = (ArrayType)list.get(list.size() - 1);
            if (valueArray.length != list.size() - 1) {
                type = null;
                try {
                    type = object.componentType();
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    return null;
                }
                if (valueArray.length == list.size()) {
                    if (valueArray[valueArray.length - 1] != null && !object.equals(valueArray[valueArray.length - 1].type()) && !this.isConvertible(type, valueArray[valueArray.length - 1])) {
                        return null;
                    }
                    arrayList.add(this.boxUnboxIfNeeded(valueArray[valueArray.length - 1], type));
                } else if (valueArray.length > list.size()) {
                    for (int i = list.size() - 1; i < valueArray.length; ++i) {
                        if (!this.isConvertible(type, valueArray[i])) {
                            return null;
                        }
                        arrayList.add(this.boxUnboxIfNeeded(valueArray[i], type));
                    }
                }
            }
        }
        return arrayList;
    }

    private Value boxUnboxIfNeeded(Value value, Type type) {
        if (value instanceof ObjectReference && type instanceof PrimitiveType) {
            return this.unbox((ObjectReference)value, type);
        }
        if (value instanceof PrimitiveValue && type instanceof ClassType) {
            return this.box((PrimitiveValue)value, (ClassType)type);
        }
        return value;
    }

    private ObjectReference box(PrimitiveValue primitiveValue, ClassType classType) {
        try {
            if (classType instanceof Object) {
                classType = this.wrapperType((PrimitiveType)primitiveValue.type());
            }
            return this.newInstance(classType, new Value[]{primitiveValue});
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected exception while invoking boxing method", exception);
        }
    }

    private ClassType wrapperType(PrimitiveType primitiveType) throws IncompatibleThreadStateException {
        char c = primitiveType.signature().charAt(0);
        return (ClassType)this.resolveType(this.wrapperClassname(c));
    }

    private String wrapperSignature(char c) {
        switch (c) {
            case 'Z': {
                return "Ljava/lang/Boolean;";
            }
            case 'B': {
                return "Ljava/lang/Byte;";
            }
            case 'C': {
                return "Ljava/lang/Character;";
            }
            case 'S': {
                return "Ljava/lang/Short;";
            }
            case 'I': {
                return "Ljava/lang/Integer;";
            }
            case 'J': {
                return "Ljava/lang/Long;";
            }
            case 'F': {
                return "Ljava/lang/Float;";
            }
            case 'D': {
                return "Ljava/lang/Double;";
            }
        }
        throw new RuntimeException();
    }

    private String wrapperClassname(char c) {
        switch (c) {
            case 'Z': {
                return "java.lang.Boolean";
            }
            case 'B': {
                return "java.lang.Byte";
            }
            case 'C': {
                return "java.lang.Character";
            }
            case 'S': {
                return "java.lang.Short";
            }
            case 'I': {
                return "java.lang.Integer";
            }
            case 'J': {
                return "java.lang.Long";
            }
            case 'F': {
                return "java.lang.Float";
            }
            case 'D': {
                return "java.lang.Double";
            }
        }
        throw new RuntimeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectReference newInstance(ClassType classType, Value[] valueArray) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
        ObjectReference objectReference;
        MethodCall methodCall = this.getConcreteMethod(new Identifier(classType, "<init>"), valueArray);
        try {
            objectReference = classType.newInstance(this.frameThread, methodCall.method, methodCall.args, 1);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.frame = this.frameThread.frame(this.frameIndex);
            throw throwable;
        }
        this.frame = this.frameThread.frame(this.frameIndex);
        return objectReference;
    }

    private PrimitiveValue unbox(ObjectReference objectReference, Type type) {
        if (type instanceof BooleanType) {
            return this.invokeUnboxingMethod(objectReference, "booleanValue");
        }
        if (type instanceof ByteType) {
            return this.invokeUnboxingMethod(objectReference, "byteValue");
        }
        if (type instanceof CharType) {
            return this.invokeUnboxingMethod(objectReference, "charValue");
        }
        if (type instanceof ShortType) {
            return this.invokeUnboxingMethod(objectReference, "shortValue");
        }
        if (type instanceof IntegerType) {
            return this.invokeUnboxingMethod(objectReference, "intValue");
        }
        if (type instanceof LongType) {
            return this.invokeUnboxingMethod(objectReference, "longValue");
        }
        if (type instanceof FloatType) {
            return this.invokeUnboxingMethod(objectReference, "floatValue");
        }
        if (type instanceof DoubleType) {
            return this.invokeUnboxingMethod(objectReference, "doubleValue");
        }
        throw new RuntimeException("Invalid type while unboxing: " + type.signature());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PrimitiveValue invokeUnboxingMethod(ObjectReference objectReference, String string) {
        PrimitiveValue primitiveValue;
        Method method = objectReference.referenceType().methodsByName(string).get(0);
        try {
            try {
                if (verbose) {
                    throw new UnsupportedOperationException(NbBundle.getMessage(Evaluator.class, (String)"CTL_UnsupportedOperationException"));
                }
                if (!this.evaluationContext.canInvokeMethods()) {
                    throw new UnsupportedOperationException();
                }
                this.evaluationContext.methodToBeInvoked();
                if (loggerMethod.isLoggable(Level.FINE)) {
                    loggerMethod.fine("STARTED : " + objectReference + "." + method + " () in thread " + this.frameThread);
                }
                primitiveValue = (PrimitiveValue)objectReference.invokeMethod(this.frameThread, method, new ArrayList(0), 1);
                Object var6_7 = null;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.evaluationContext.setCanInvokeMethods(false);
                throw new RuntimeException("Unexpected exception while invoking unboxing method", unsupportedOperationException);
            }
            catch (Exception exception) {
                throw new RuntimeException("Unexpected exception while invoking unboxing method", exception);
            }
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("FINISHED: " + objectReference + "." + method + " () in thread " + this.frameThread);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("FINISHED: " + objectReference + "." + method + " () in thread " + this.frameThread);
            }
            try {
                this.evaluationContext.methodInvokeDone();
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
                invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
                throw new IllegalStateException(invalidExpressionException);
            }
            try {
                this.frame = this.frameThread.frame(this.frameIndex);
                throw throwable;
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                throw new RuntimeException("Unexpected exception while invoking unboxing method", incompatibleThreadStateException);
            }
        }
        try {}
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
            invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
            throw new IllegalStateException(invalidExpressionException);
        }
        this.evaluationContext.methodInvokeDone();
        try {}
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw new RuntimeException("Unexpected exception while invoking unboxing method", incompatibleThreadStateException);
        }
        this.frame = this.frameThread.frame(this.frameIndex);
        return primitiveValue;
    }

    private boolean isConvertible(Type type, Value value) {
        if (value == null) {
            return type instanceof ReferenceType;
        }
        String string = value.type().signature();
        String string2 = type.signature();
        if (string2.equals(string)) {
            return true;
        }
        if (string2.length() == 1) {
            if (string2.equals("Z")) {
                return string.equals("Ljava/lang/Boolean;");
            }
            for (int i = 0; i < typeSignaturesSorted.length; ++i) {
                if (string.equals(typeSignaturesSorted[i])) {
                    return true;
                }
                if (!string2.equals(typeSignaturesSorted[i])) continue;
                return false;
            }
            return false;
        }
        if (string2.equals("Ljava/lang/Object;")) {
            return true;
        }
        if (string.length() == 1) {
            if (string.equals("Z")) {
                return string2.equals("Ljava/lang/Boolean;");
            }
            for (int i = 0; i < typeSignaturesSorted.length; ++i) {
                if (!string.equals(typeSignaturesSorted[i])) continue;
                for (int j = i - 1; j < typeSignaturesSorted.length; ++j) {
                    if (!string2.equals(typeSignaturesSorted[j])) continue;
                    return true;
                }
                return false;
            }
        }
        return this.instanceOf(value.type(), type);
    }

    private Object visitPrimarySuffix(SimpleNode simpleNode, Object object) {
        Token token = (Token)simpleNode.getAttribute("token");
        if (token == null) {
            return simpleNode.jjtGetChild(0).jjtAccept(this, object);
        }
        switch (token.kind) {
            case 79: {
                object = this.resolveVariable(object);
                Assert.assertAssignable(object, ObjectReference.class, simpleNode, "identifierNotAReference", object);
                return new Identifier(false, (ObjectReference)object, token.image);
            }
            case 86: {
                object = this.resolveVariable(object);
                Assert.assertAssignable(object, ArrayReference.class, simpleNode, "notarray", object, token);
                Object object2 = simpleNode.jjtGetChild(0).jjtAccept(this, object);
                Assert.assertAssignable(object2, PrimitiveValue.class, simpleNode, "arrayIndexNAN", object, object2);
                Assert.assertNotAssignable(object2, BooleanValue.class, simpleNode, "arrayIndexNAN", object, object2);
                int n = ((PrimitiveValue)object2).intValue();
                ArrayReference arrayReference = (ArrayReference)object;
                Assert.assertLess(n, arrayReference.length(), simpleNode, "arrayIndexOutOfBounds", arrayReference, new Integer(n));
                return arrayReference.getValue(n);
            }
            case 59: 
            case 62: {
                Identifier identifier = (Identifier)object;
                if (!this.vm.canGetSyntheticAttribute()) {
                    Assert.error(simpleNode, "unknownType", identifier.identifier);
                }
                ObjectReference objectReference = this.getEnclosingObject(this.frame.thisObject(), identifier.identifier);
                Assert.assertNotNull(objectReference, simpleNode, "unknownType", identifier.identifier);
                return objectReference;
            }
        }
        return Assert.error(simpleNode, "internalError");
    }

    private ObjectReference getEnclosingObject(ObjectReference objectReference, String string) {
        boolean bl;
        block0: do {
            bl = true;
            List<Field> list = objectReference.referenceType().allFields();
            for (Field field : list) {
                ClassType classType;
                if (!field.isSynthetic() || !field.name().startsWith("this$")) continue;
                if (loggerValue.isLoggable(Level.FINE)) {
                    loggerValue.fine("STARTED : " + objectReference + ".getValue(" + field + ")");
                }
                objectReference = (ObjectReference)objectReference.getValue(field);
                if (loggerValue.isLoggable(Level.FINE)) {
                    loggerValue.fine("FINISHED: getValue(" + field + ") = " + objectReference);
                }
                if ((classType = (ClassType)objectReference.referenceType()).name().endsWith(string)) {
                    return objectReference;
                }
                bl = false;
                continue block0;
            }
        } while (!bl);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Value evaluateVariable(Identifier identifier) {
        Object object;
        Object object2;
        Object object3;
        if (identifier.localContext) {
            try {
                object3 = this.frame.visibleVariableByName(identifier.identifier);
                if (object3 != null) {
                    return this.frame.getValue((com.sun.jdi.LocalVariable)object3);
                }
            }
            catch (AbsentInformationException absentInformationException) {
                try {
                    object2 = new CallStackFrameImpl((JPDAThreadImpl)this.evaluationContext.getDebugger().getThread(this.frame.thread()), this.frame, 0, this.evaluationContext.getDebugger()).getMethodArguments();
                    if (object2 != null) {
                        object = object2;
                        int n = ((LocalVariable[])object).length;
                        for (int i = 0; i < n; ++i) {
                            Object object4 = object[i];
                            if (!identifier.identifier.equals(object4.getName())) continue;
                            return ((JDIVariable)object4).getJDIValue();
                        }
                    }
                }
                catch (NativeMethodException nativeMethodException) {
                    // empty catch block
                }
            }
        }
        if (identifier.instanceContext != null) {
            object3 = identifier.typeContext.fieldByName(identifier.identifier);
            if (object3 != null) {
                try {
                    if (loggerValue.isLoggable(Level.FINE)) {
                        loggerValue.fine("STARTED : " + identifier.instanceContext + ".getValue(" + object3 + ")");
                    }
                    object2 = identifier.instanceContext.getValue((Field)object3);
                    Object var9_15 = null;
                    if (!loggerValue.isLoggable(Level.FINE)) return object2;
                    loggerValue.fine("FINISHED : " + identifier.instanceContext + ".getValue(" + object3 + ")");
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var9_16 = null;
                    if (loggerValue.isLoggable(Level.FINE)) {
                        loggerValue.fine("FINISHED : " + identifier.instanceContext + ".getValue(" + object3 + ")");
                    }
                    throw throwable;
                }
            }
            if (identifier.instanceContext instanceof ArrayReference && identifier.identifier.equals("length")) {
                return this.vm.mirrorOf(((ArrayReference)identifier.instanceContext).length());
            }
        }
        if (identifier.typeContext != null) {
            object3 = identifier.typeContext.fieldByName(identifier.identifier);
            try {
                if (object3 != null) {
                    try {
                        if (loggerValue.isLoggable(Level.FINE)) {
                            loggerValue.fine("STARTED : " + identifier.typeContext + ".getValue(" + object3 + ")");
                        }
                        object2 = identifier.typeContext.getValue((Field)object3);
                        Object var11_18 = null;
                        if (!loggerValue.isLoggable(Level.FINE)) return object2;
                        loggerValue.fine("FINISHED : " + identifier.typeContext + ".getValue(" + object3 + ")");
                        return object2;
                    }
                    catch (Throwable throwable) {
                        Object var11_19 = null;
                        if (loggerValue.isLoggable(Level.FINE)) {
                            loggerValue.fine("FINISHED : " + identifier.typeContext + ".getValue(" + object3 + ")");
                        }
                        throw throwable;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assert.error(this.currentNode, "accessInstanceVariableFromStaticContext", identifier);
            }
        }
        if (identifier.instanceContext != null && (object3 = identifier.typeContext.fieldByName("val$" + identifier.identifier)) != null) {
            try {
                if (loggerValue.isLoggable(Level.FINE)) {
                    loggerValue.fine("STARTED : " + identifier.instanceContext + ".getValue(" + object3 + ")");
                }
                object2 = identifier.instanceContext.getValue((Field)object3);
                Object var13_21 = null;
                if (!loggerValue.isLoggable(Level.FINE)) return object2;
                loggerValue.fine("FINISHED: " + identifier.instanceContext + ".getValue(" + object3 + ")");
                return object2;
            }
            catch (Throwable throwable) {
                Object var13_22 = null;
                if (loggerValue.isLoggable(Level.FINE)) {
                    loggerValue.fine("FINISHED: " + identifier.instanceContext + ".getValue(" + object3 + ")");
                }
                throw throwable;
            }
        }
        if (identifier.instanceContext != null && (object3 = identifier.typeContext.fieldByName("this$0")) != null) {
            if (loggerValue.isLoggable(Level.FINE)) {
                loggerValue.fine("STARTED : " + identifier.instanceContext + ".getValue(" + object3 + ")");
            }
            object2 = (ObjectReference)identifier.instanceContext.getValue((Field)object3);
            if (loggerValue.isLoggable(Level.FINE)) {
                loggerValue.fine("FINISHED: " + identifier.instanceContext + ".getValue(" + object3 + ") = " + object2);
            }
            if (object2 != null && (object = object2.referenceType().fieldByName(identifier.identifier)) != null) {
                try {
                    if (loggerValue.isLoggable(Level.FINE)) {
                        loggerValue.fine("STARTED : " + object2 + ".getValue(" + object + ")");
                    }
                    Value value = object2.getValue((Field)object);
                    Object var15_24 = null;
                    if (!loggerValue.isLoggable(Level.FINE)) return value;
                    loggerValue.fine("FINISHED: " + object2 + ".getValue(" + object + ")");
                    return value;
                }
                catch (Throwable throwable) {
                    Object var15_25 = null;
                    if (loggerValue.isLoggable(Level.FINE)) {
                        loggerValue.fine("FINISHED: " + object2 + ".getValue(" + object + ")");
                    }
                    throw throwable;
                }
            }
        }
        object3 = this.staticImportsIterator(identifier.identifier);
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            try {
                object = this.resolveType((String)object2);
                Field field = object.fieldByName(identifier.identifier);
                if (field == null) continue;
                try {
                    if (loggerValue.isLoggable(Level.FINE)) {
                        loggerValue.fine("STARTED : " + object + ".getValue(" + field + ")");
                    }
                    Value value = object.getValue(field);
                    Object var17_27 = null;
                    if (!loggerValue.isLoggable(Level.FINE)) return value;
                    loggerValue.fine("FINISHED: " + object + ".getValue(" + field + ")");
                    return value;
                }
                catch (Throwable throwable) {
                    Object var17_28 = null;
                    if (loggerValue.isLoggable(Level.FINE)) {
                        loggerValue.fine("FINISHED: " + object + ".getValue(" + field + ")");
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
            }
        }
        if (this.expression.classReplaced().equals(identifier.identifier)) {
            object3 = this.frame.location().declaringType();
            object2 = this.evaluationContext.getDebugger().getClassType((ReferenceType)object3);
            return ((JDIVariable)object2.classObject()).getJDIValue();
        }
        if (!this.expression.returnReplaced().equals(identifier.identifier)) {
            return (Value)Assert.error(this.currentNode, "unknownVariable", identifier);
        }
        object3 = this.frame.thread();
        object2 = (JPDAThreadImpl)this.evaluationContext.getDebugger().getThread((ThreadReference)object3);
        object = ((JPDAThreadImpl)object2).getReturnVariable();
        if (object != null) {
            return object.getJDIValue();
        }
        return null;
    }

    private Iterator<String> staticImportsIterator(String string) {
        return this.iterator(this.evaluationContext.getStaticImports(), string);
    }

    private Iterator<String> iterator(List<String> list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            int n;
            String string3 = string2.substring((n = string2.lastIndexOf(46)) + 1);
            if (!string3.equals("*") && !string3.equals(string)) continue;
            arrayList.add(string2.substring(0, n));
        }
        return arrayList.iterator();
    }

    private Value resolveVariable(Object object) {
        if (object == null || object instanceof Value) {
            return (Value)object;
        }
        Identifier identifier = (Identifier)object;
        return this.evaluateVariable(identifier);
    }

    private Object visitPrimaryExpression(SimpleNode simpleNode, Object object) {
        int n = simpleNode.jjtGetNumChildren();
        Object object2 = simpleNode.jjtGetChild(0).jjtAccept(this, object);
        for (int i = 1; i < n; ++i) {
            object2 = simpleNode.jjtGetChild(i).jjtAccept(this, object2);
        }
        if (object2 instanceof Identifier) {
            Identifier identifier = (Identifier)object2;
            return this.evaluateVariable(identifier);
        }
        return object2;
    }

    private Object visitExpression(SimpleNode simpleNode, Object object) {
        int n = simpleNode.jjtGetNumChildren();
        if (n == 1) {
            return simpleNode.jjtGetChild(0).jjtAccept(this, object);
        }
        return simpleNode.jjtGetChild(2).jjtAccept(this, object);
    }

    private Object visitLiteral(SimpleNode simpleNode, Object object) {
        Token token = (Token)simpleNode.getAttribute("token");
        if (token == null) {
            return simpleNode.jjtGetChild(0).jjtAccept(this, object);
        }
        try {
            switch (token.kind) {
                case 71: {
                    String string = token.image.toLowerCase();
                    boolean bl = string.endsWith("l");
                    if (bl) {
                        string = string.substring(0, string.length() - 1);
                    }
                    long l = string.startsWith("0x") ? Long.parseLong(string.substring(2), 16) : (string.length() > 1 && string.charAt(0) == '0' ? Long.parseLong(string.substring(1), 8) : Long.parseLong(string));
                    if (bl) {
                        return this.vm.mirrorOf(l);
                    }
                    if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                        Assert.error(simpleNode, "integerLiteralTooBig", string);
                    } else {
                        return this.vm.mirrorOf((int)l);
                    }
                }
                case 75: {
                    char c = token.image.charAt(token.image.length() - 1);
                    if (c == 'f' || c == 'F') {
                        return this.vm.mirrorOf(Float.parseFloat(token.image));
                    }
                    return this.vm.mirrorOf(Double.parseDouble(token.image));
                }
                case 78: {
                    return this.vm.mirrorOf(this.resolveString(token.image.substring(1, token.image.length() - 1)));
                }
                case 77: {
                    return this.vm.mirrorOf(this.resolveString(token.image.substring(1, token.image.length() - 1)).charAt(0));
                }
            }
            return Assert.error(simpleNode, "unknownLiteralType", token.image);
        }
        catch (NumberFormatException numberFormatException) {
            return Assert.error(simpleNode, "badFormatOfIntegerLiteral", token.image);
        }
    }

    private String resolveString(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c;
            if (string.charAt(i) != '\\') {
                string2 = string2 + string.charAt(i);
                continue;
            }
            switch (string.charAt(++i)) {
                case 'b': {
                    c = '\b';
                    break;
                }
                case 't': {
                    c = '\t';
                    break;
                }
                case 'n': {
                    c = '\n';
                    break;
                }
                case 'f': {
                    c = '\f';
                    break;
                }
                case 'r': {
                    c = '\r';
                    break;
                }
                case '\"': {
                    c = '\"';
                    break;
                }
                case '\'': {
                    c = '\'';
                    break;
                }
                case '\\': {
                    c = '\\';
                    break;
                }
                default: {
                    c = '\u0000';
                    while (i < string.length() && string.charAt(i) >= '0' && string.charAt(i) <= '7' && c * 8 + string.charAt(i) - 48 < 256) {
                        c = (char)(c * 8 + (string.charAt(i) - 48));
                        ++i;
                    }
                    --i;
                }
            }
            string2 = string2 + c;
        }
        return string2;
    }

    private Object visitBinaryExpression(SimpleNode simpleNode, Object object) {
        Object[] objectArray = simpleNode.getAttributes("operator");
        int n = simpleNode.jjtGetNumChildren();
        Value value = (Value)simpleNode.jjtGetChild(0).jjtAccept(this, object);
        for (int i = 1; i < n; ++i) {
            Value value2 = (Value)simpleNode.jjtGetChild(i).jjtAccept(this, object);
            try {
                value = this.operators.evaluate(value, (Token)objectArray[i - 1], value2);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Assert.error(simpleNode, "evaluateError", value, ((Token)objectArray[i - 1]).image, value2);
            }
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Value invokeVirtual(ObjectReference objectReference, Method method, ThreadReference threadReference, List<Value> list) throws InvalidExpressionException {
        if (verbose) {
            throw new UnsupportedOperationException(NbBundle.getMessage(Evaluator.class, (String)"CTL_UnsupportedOperationException"));
        }
        try {
            Value value;
            try {
                if (loggerMethod.isLoggable(Level.FINE)) {
                    loggerMethod.fine("STARTED : " + objectReference + "." + method + " (" + list + ") in thread " + threadReference);
                }
                Value value2 = objectReference.invokeMethod(threadReference, method, list, 1);
                if (loggerMethod.isLoggable(Level.FINE)) {
                    loggerMethod.fine("   return = " + value2);
                }
                value = value2;
                Object var7_15 = null;
            }
            catch (InvalidTypeException invalidTypeException) {
                throw new InvalidExpressionException((Throwable)invalidTypeException);
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                throw new InvalidExpressionException((Throwable)classNotLoadedException);
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
                invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
                throw invalidExpressionException;
            }
            catch (InvocationException invocationException) {
                InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)invocationException);
                invalidExpressionException.initCause((Throwable)invocationException);
                throw invalidExpressionException;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)unsupportedOperationException);
                invalidExpressionException.initCause((Throwable)unsupportedOperationException);
                throw invalidExpressionException;
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw new InvalidExpressionException(NbBundle.getMessage(Evaluator.class, (String)"CTL_EvalError_collected"));
            }
            if (!loggerMethod.isLoggable(Level.FINE)) return value;
            loggerMethod.fine("FINISHED: " + objectReference + "." + method + " (" + list + ") in thread " + threadReference);
            return value;
        }
        catch (Throwable throwable) {
            Object var7_16 = null;
            if (!loggerMethod.isLoggable(Level.FINE)) throw throwable;
            loggerMethod.fine("FINISHED: " + objectReference + "." + method + " (" + list + ") in thread " + threadReference);
            throw throwable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodCall {
        ReferenceType typeContext;
        ObjectReference instanceContext;
        Method method;
        List<Value> args;

        public MethodCall(ReferenceType referenceType, ObjectReference objectReference, Method method, List<Value> list) {
            this.typeContext = referenceType;
            this.instanceContext = objectReference;
            this.method = method;
            this.args = list;
        }
    }
}

