/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ExceptionBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.FieldBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.LineBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.MethodBreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.PersistenceManager;
import org.netbeans.modules.debugger.jpda.breakpoints.ThreadBreakpointImpl;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.RequestProcessor;

public class BreakpointsEngineListener
extends LazyActionsManagerListener
implements PropertyChangeListener,
DebuggerManagerListener {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.breakpoints");
    private JPDADebuggerImpl debugger;
    private SourcePath engineContext;
    private boolean started = false;
    private Session session;
    private BreakpointsReader breakpointsReader;
    private HashMap<Breakpoint, BreakpointImpl> breakpointToImpl = new HashMap();

    public BreakpointsEngineListener(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
        this.engineContext = (SourcePath)contextProvider.lookupFirst(null, SourcePath.class);
        this.session = (Session)contextProvider.lookupFirst(null, Session.class);
        this.debugger.addPropertyChangeListener("state", this);
        this.breakpointsReader = PersistenceManager.findBreakpointsReader();
    }

    protected void destroy() {
        this.debugger.removePropertyChangeListener("state", this);
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.removeBreakpointImpls();
    }

    public String[] getProperties() {
        return new String[]{"asd"};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.debugger.getState() == 2) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.createBreakpointImpls();
            DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        }
        if (this.debugger.getState() == 4) {
            this.removeBreakpointImpls();
            this.started = false;
            DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        }
    }

    public void actionPerformed(Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void breakpointAdded(final Breakpoint breakpoint) {
        final boolean[] blArray = new boolean[]{false};
        if (Thread.holdsLock(this.debugger.LOCK)) {
            this.createBreakpointImpl(breakpoint);
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ((BreakpointsEngineListener)BreakpointsEngineListener.this).debugger.LOCK;
                synchronized (object) {
                    boolean[] blArray2 = blArray;
                    synchronized (blArray) {
                        blArray[0] = true;
                        blArray.notify();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        BreakpointsEngineListener.this.createBreakpointImpl(breakpoint);
                    }
                }
            }
        });
        if (EventQueue.isDispatchThread()) return;
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            if (blArray[0]) return;
            try {
                blArray.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void breakpointRemoved(final Breakpoint breakpoint) {
        final boolean[] blArray = new boolean[]{false};
        if (Thread.holdsLock(this.debugger.LOCK)) {
            this.removeBreakpointImpl(breakpoint);
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ((BreakpointsEngineListener)BreakpointsEngineListener.this).debugger.LOCK;
                synchronized (object) {
                    boolean[] blArray2 = blArray;
                    synchronized (blArray) {
                        blArray[0] = true;
                        blArray.notify();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        BreakpointsEngineListener.this.removeBreakpointImpl(breakpoint);
                    }
                }
            }
        });
        if (EventQueue.isDispatchThread()) return;
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            if (blArray[0]) return;
            try {
                blArray.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
    }

    public void engineRemoved(DebuggerEngine debuggerEngine) {
    }

    private void createBreakpointImpls() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        int n = breakpointArray.length;
        for (int i = 0; i < n; ++i) {
            this.createBreakpointImpl(breakpointArray[i]);
        }
    }

    private void removeBreakpointImpls() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        int n = breakpointArray.length;
        for (int i = 0; i < n; ++i) {
            this.removeBreakpointImpl(breakpointArray[i]);
        }
    }

    public void fixBreakpointImpls() {
        Iterator<BreakpointImpl> iterator = this.breakpointToImpl.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().fixed();
        }
    }

    private synchronized void createBreakpointImpl(Breakpoint breakpoint) {
        if (this.breakpointToImpl.containsKey(breakpoint)) {
            return;
        }
        if (breakpoint instanceof LineBreakpoint) {
            this.breakpointToImpl.put(breakpoint, new LineBreakpointImpl((LineBreakpoint)breakpoint, this.breakpointsReader, this.debugger, this.session, this.engineContext));
        } else if (breakpoint instanceof ExceptionBreakpoint) {
            this.breakpointToImpl.put(breakpoint, new ExceptionBreakpointImpl((ExceptionBreakpoint)breakpoint, this.debugger, this.session));
        } else if (breakpoint instanceof MethodBreakpoint) {
            this.breakpointToImpl.put(breakpoint, new MethodBreakpointImpl((MethodBreakpoint)breakpoint, this.debugger, this.session));
        } else if (breakpoint instanceof FieldBreakpoint) {
            this.breakpointToImpl.put(breakpoint, new FieldBreakpointImpl((FieldBreakpoint)breakpoint, this.debugger, this.session));
        } else if (breakpoint instanceof ThreadBreakpoint) {
            this.breakpointToImpl.put(breakpoint, new ThreadBreakpointImpl((ThreadBreakpoint)breakpoint, this.debugger, this.session));
        } else if (breakpoint instanceof ClassLoadUnloadBreakpoint) {
            this.breakpointToImpl.put(breakpoint, new ClassBreakpointImpl((ClassLoadUnloadBreakpoint)breakpoint, this.debugger, this.session));
        }
        logger.finer("BreakpointsEngineListener: created impl " + this.breakpointToImpl.get(breakpoint) + " for " + breakpoint);
    }

    private synchronized void removeBreakpointImpl(Breakpoint breakpoint) {
        BreakpointImpl breakpointImpl = this.breakpointToImpl.get(breakpoint);
        if (breakpointImpl == null) {
            return;
        }
        logger.finer("BreakpointsEngineListener: removed impl " + breakpointImpl + " for " + breakpoint);
        breakpointImpl.remove();
        this.breakpointToImpl.remove(breakpoint);
    }
}

