/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.actions.CompoundSmartSteppingListener;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.actions.StepActionProvider;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class StepIntoNextMethodActionProvider
extends JPDADebuggerActionProvider
implements Executor,
PropertyChangeListener {
    private static final Logger smartLogger = Logger.getLogger("org.netbeans.modules.debugger.jpda.smartstepping");
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.jdievents");
    private StepRequest stepRequest;
    private String position;
    private int depth;
    private ContextProvider contextProvider;
    private boolean smartSteppingStepOut;
    private StepActionProvider stepActionProvider;
    private SmartSteppingFilter smartSteppingFilter;
    private CompoundSmartSteppingListener compoundSmartSteppingListener;

    public StepIntoNextMethodActionProvider(ContextProvider contextProvider) {
        super((JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class)));
        this.contextProvider = contextProvider;
        this.getSmartSteppingFilterImpl().addPropertyChangeListener((PropertyChangeListener)this);
        SourcePath sourcePath = (SourcePath)contextProvider.lookupFirst(null, SourcePath.class);
        sourcePath.addPropertyChangeListener(this);
        Map map = (Map)contextProvider.lookupFirst(null, Map.class);
        if (map != null) {
            this.smartSteppingStepOut = map.containsKey("SS_ACTION_STEPOUT");
        }
        this.setProviderToDisableOnLazyAction(this);
    }

    public Set getActions() {
        return new HashSet<Object>(Arrays.asList("stepIntoNextMethod"));
    }

    public void doAction(Object object) {
        this.runAction();
    }

    public void postAction(Object object, final Runnable runnable) {
        this.doLazyAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    StepIntoNextMethodActionProvider.this.runAction();
                    Object var2_1 = null;
                    runnable.run();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    runnable.run();
                    throw throwable;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAction() {
        Object object = this.getDebuggerImpl().LOCK;
        synchronized (object) {
            smartLogger.finer("STEP INTO NEXT METHOD.");
            JPDAThread jPDAThread = this.getDebuggerImpl().getCurrentThread();
            if (jPDAThread == null || !jPDAThread.isSuspended()) {
                smartLogger.finer("Can not step into next method! Thread " + jPDAThread + " not suspended!");
                return;
            }
            JPDAThreadImpl jPDAThreadImpl = this.setStepRequest(1);
            this.position = jPDAThread.getClassName() + '.' + jPDAThread.getMethodName() + ':' + jPDAThread.getLineNumber(null);
            this.depth = jPDAThread.getStackDepth();
            logger.fine("JDI Request (action step into next method): " + this.stepRequest);
            if (this.stepRequest == null) {
                return;
            }
            ((JPDAThreadImpl)jPDAThread).setInStep(true, this.stepRequest);
            try {
                if (jPDAThreadImpl == null) {
                    this.getDebuggerImpl().resume();
                } else {
                    this.getDebuggerImpl().resumeCurrentThread();
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                ErrorManager.getDefault().notify(256, ErrorManager.getDefault().annotate((Throwable)vMDisconnectedException, NbBundle.getMessage(StepIntoNextMethodActionProvider.class, (String)"VMDisconnected")));
            }
        }
    }

    protected void checkEnabled(int n) {
        Iterator iterator = this.getActions().iterator();
        while (iterator.hasNext()) {
            this.setEnabled(iterator.next(), n == 3 && this.getDebuggerImpl().getCurrentThread() != null);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "exclusionPatterns") {
            if (propertyChangeEvent.getOldValue() != null) {
                smartLogger.finer("Exclusion patterns removed. Removing step requests.");
                JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread();
                if (jPDAThreadImpl != null) {
                    ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
                    this.removeStepRequests(threadReference);
                }
            } else {
                if (smartLogger.isLoggable(Level.FINER)) {
                    if (this.stepRequest == null) {
                        smartLogger.finer("Exclusion patterns has been added");
                    } else {
                        smartLogger.finer("Add exclusion patterns: " + propertyChangeEvent.getNewValue());
                    }
                }
                this.addPatternsToRequest(((Set)propertyChangeEvent.getNewValue()).toArray(new String[((Set)propertyChangeEvent.getNewValue()).size()]));
            }
        } else if (propertyChangeEvent.getPropertyName() == "sourceRoots") {
            smartLogger.finer("Source roots changed");
            JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread();
            if (jPDAThreadImpl != null) {
                ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
                this.removeStepRequests(threadReference);
            }
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exec(Event event) {
        StepRequest stepRequest = (StepRequest)event.request();
        JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getThread(stepRequest.thread());
        jPDAThreadImpl.setInStep(false, null);
        JPDAThreadImpl jPDAThreadImpl2 = null;
        Object object = this.getDebuggerImpl().LOCK;
        synchronized (object) {
            if (this.stepRequest != null) {
                this.stepRequest.disable();
            }
            LocatableEvent locatableEvent = (LocatableEvent)event;
            ThreadReference threadReference = locatableEvent.thread();
            try {
                if (threadReference.frame(0).location().method().isSynthetic()) {
                    jPDAThreadImpl2 = this.setStepRequest(1);
                    return true;
                }
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                // empty catch block
            }
            JPDAThread jPDAThread = this.getDebuggerImpl().getThread(threadReference);
            boolean bl = this.getCompoundSmartSteppingListener().stopHere(this.contextProvider, jPDAThread, this.getSmartSteppingFilterImpl());
            if (bl) {
                String string = jPDAThread.getClassName() + '.' + jPDAThread.getMethodName() + ':' + jPDAThread.getLineNumber(null);
                int n = jPDAThread.getStackDepth();
                if (this.position.equals(string) && this.depth == n) {
                    bl = false;
                    jPDAThreadImpl2 = this.setStepRequest(1);
                    return true;
                }
            }
            if (bl) {
                this.removeStepRequests(locatableEvent.thread());
            } else {
                smartLogger.finer(" => do next step.");
                if (this.smartSteppingStepOut) {
                    jPDAThreadImpl2 = this.setStepRequest(3);
                } else if (this.stepRequest != null) {
                    try {
                        this.stepRequest.enable();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        this.getDebuggerImpl().getOperator().unregister(this.stepRequest);
                        this.stepRequest = null;
                        return true;
                    }
                } else {
                    jPDAThreadImpl2 = this.setStepRequest(1);
                }
            }
            if (smartLogger.isLoggable(Level.FINER) && bl) {
                smartLogger.finer("FINISH IN CLASS " + jPDAThread.getClassName() + " ********");
            }
            return !bl;
        }
    }

    public void removed(EventRequest eventRequest) {
        StepRequest stepRequest = (StepRequest)eventRequest;
        JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getThread(stepRequest.thread());
        jPDAThreadImpl.setInStep(false, null);
    }

    private StepActionProvider getStepActionProvider() {
        if (this.stepActionProvider == null) {
            List list = this.contextProvider.lookup(null, ActionsProvider.class);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!(list.get(i) instanceof StepActionProvider)) continue;
                this.stepActionProvider = (StepActionProvider)list.get(i);
            }
        }
        return this.stepActionProvider;
    }

    protected void removeStepRequests(ThreadReference threadReference) {
        super.removeStepRequests(threadReference);
        this.stepRequest = null;
        smartLogger.finer("removing all patterns, all step requests.");
    }

    private JPDAThreadImpl setStepRequest(int n) {
        JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread();
        ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
        this.removeStepRequests(threadReference);
        VirtualMachine virtualMachine = this.getDebuggerImpl().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        this.stepRequest = virtualMachine.eventRequestManager().createStepRequest(threadReference, -2, n);
        this.getDebuggerImpl().getOperator().register(this.stepRequest, this);
        int n2 = this.getDebuggerImpl().getSuspend();
        this.stepRequest.setSuspendPolicy(n2);
        if (smartLogger.isLoggable(Level.FINER)) {
            smartLogger.finer("Set step request(" + n + ") and patterns: ");
        }
        this.addPatternsToRequest(this.getSmartSteppingFilterImpl().getExclusionPatterns());
        try {
            this.stepRequest.enable();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            this.getDebuggerImpl().getOperator().unregister(this.stepRequest);
            this.stepRequest = null;
            return null;
        }
        if (n2 == 1) {
            return jPDAThreadImpl;
        }
        return null;
    }

    private SmartSteppingFilter getSmartSteppingFilterImpl() {
        if (this.smartSteppingFilter == null) {
            this.smartSteppingFilter = (SmartSteppingFilter)this.contextProvider.lookupFirst(null, SmartSteppingFilter.class);
        }
        return this.smartSteppingFilter;
    }

    private CompoundSmartSteppingListener getCompoundSmartSteppingListener() {
        if (this.compoundSmartSteppingListener == null) {
            this.compoundSmartSteppingListener = (CompoundSmartSteppingListener)((Object)this.contextProvider.lookupFirst(null, CompoundSmartSteppingListener.class));
        }
        return this.compoundSmartSteppingListener;
    }

    private void addPatternsToRequest(String[] stringArray) {
        if (this.stepRequest == null) {
            return;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.stepRequest.addClassExclusionFilter(stringArray[i]);
            smartLogger.finer("   add pattern: " + stringArray[i]);
        }
    }
}

