/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.Accessible;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.breakpoints.MethodBreakpointImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPDAStepImpl
extends JPDAStep
implements Executor {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.step");
    private EditorContext.Operation[] currentOperations;
    private EditorContext.Operation lastOperation;
    private MethodExitBreakpointListener lastMethodExitBreakpointListener;
    private Set<BreakpointRequest> operationBreakpoints;
    private StepRequest boundaryStepRequest;
    private Session session;

    public JPDAStepImpl(JPDADebugger jPDADebugger, Session session, int n, int n2) {
        super(jPDADebugger, n, n2);
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStep(JPDAThread jPDAThread) {
        JPDADebuggerImpl jPDADebuggerImpl = (JPDADebuggerImpl)this.debugger;
        JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)jPDAThread;
        VirtualMachine virtualMachine = jPDADebuggerImpl.getVirtualMachine();
        if (virtualMachine == null) {
            return;
        }
        SourcePath sourcePath = ((JPDADebuggerImpl)this.debugger).getEngineContext();
        boolean[] blArray = new boolean[]{false};
        Object object = ((JPDADebuggerImpl)this.debugger).LOCK;
        synchronized (object) {
            JPDAThread jPDAThread2 = jPDAThread;
            synchronized (jPDAThread2) {
                ((JPDAThreadImpl)jPDAThread).waitUntilMethodInvokeDone();
                EventRequestManager eventRequestManager = virtualMachine.eventRequestManager();
                List<StepRequest> list = eventRequestManager.stepRequests();
                eventRequestManager.deleteEventRequests(list);
                for (StepRequest stepRequest : list) {
                    jPDADebuggerImpl.getOperator().unregister(stepRequest);
                }
                int n = this.getSize();
                boolean bl = false;
                logger.log(Level.FINE, "Step " + (n == 10 ? "operation" : "line") + " " + (this.getDepth() == 1 ? "into" : (this.getDepth() == 2 ? "over" : "out")) + " in thread " + jPDAThread.getName());
                if (n == 10 && !(bl = this.addOperationStep(jPDAThreadImpl, false, sourcePath, blArray))) {
                    n = -2;
                    logger.log(Level.FINE, "Operation step changed to line step");
                }
                if (!bl) {
                    StepRequest stepRequest = virtualMachine.eventRequestManager().createStepRequest(jPDAThreadImpl.getThreadReference(), n, this.getDepth());
                    stepRequest.addCountFilter(1);
                    jPDADebuggerImpl.getOperator().register(stepRequest, this);
                    stepRequest.setSuspendPolicy(this.debugger.getSuspend());
                    try {
                        stepRequest.enable();
                        jPDAThreadImpl.setInStep(true, stepRequest);
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        jPDADebuggerImpl.getOperator().unregister(stepRequest);
                        stepRequest = null;
                    }
                }
            }
        }
        if (blArray[0]) {
            jPDADebuggerImpl.setStoppedStateNoContinue(jPDAThreadImpl.getThreadReference());
        }
    }

    private boolean addOperationStep(JPDAThreadImpl jPDAThreadImpl, boolean bl, SourcePath sourcePath, boolean[] blArray) {
        EditorContext.Operation operation;
        int n;
        MethodBreakpoint methodBreakpoint;
        Object object;
        VirtualMachine virtualMachine;
        EditorContext.Operation operation2;
        StackFrame stackFrame;
        ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
        try {
            stackFrame = threadReference.frame(0);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return false;
        }
        Location location = stackFrame.location();
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        String string = session == null ? null : session.getCurrentLanguage();
        String string2 = sourcePath.getURL(location, string);
        ExpressionPool expressionPool = ((JPDADebuggerImpl)this.debugger).getExpressionPool();
        ExpressionPool.Expression expression = expressionPool.getExpressionAt(location, string2);
        if (expression == null) {
            return false;
        }
        EditorContext.Operation[] operationArray = expression.getOperations();
        int n2 = -1;
        int n3 = (int)location.codeIndex();
        if (n3 <= operationArray[0].getBytecodeIndex()) {
            if (!bl) {
                jPDAThreadImpl.clearLastOperations();
            }
            if (!operationArray[0].equals((Object)jPDAThreadImpl.getCurrentOperation()) && (n2 = expression.findNextOperationIndex(n3 - 1)) >= 0 && operationArray[n2].getBytecodeIndex() == n3) {
                jPDAThreadImpl.setCurrentOperation(operationArray[n2]);
                if (bl) {
                    return false;
                }
                if (!this.getHidden()) {
                    blArray[0] = true;
                }
                return true;
            }
        }
        if ((operation2 = jPDAThreadImpl.getCurrentOperation()) != null) {
            virtualMachine = null;
            object = jPDAThreadImpl.getLastOperations();
            if (object != null && object.size() > 0) {
                virtualMachine = object.get(object.size() - 1);
            }
            if (virtualMachine == operation2) {
                methodBreakpoint = operationArray;
                n = ((EditorContext.Operation[])methodBreakpoint).length;
                for (int i = 0; i < n; ++i) {
                    operation = methodBreakpoint[i];
                    if (operation.getBytecodeIndex() != n3) continue;
                    jPDAThreadImpl.setCurrentOperation(operation);
                    if (!this.getHidden()) {
                        blArray[0] = true;
                    }
                    return true;
                }
            }
        }
        this.lastOperation = operation2;
        virtualMachine = location.virtualMachine();
        if (this.lastOperation != null && (object = this.lastOperation.getMethodName()) != null && MethodBreakpointImpl.canGetMethodReturnValues(virtualMachine)) {
            methodBreakpoint = MethodBreakpoint.create((String)this.lastOperation.getMethodClassType(), (String)object);
            methodBreakpoint.setClassFilters(JPDAStepImpl.createClassFilters(virtualMachine, this.lastOperation.getMethodClassType(), (String)object));
            methodBreakpoint.setThreadFilters(this.debugger, new JPDAThread[]{jPDAThreadImpl});
            methodBreakpoint.setBreakpointType(2);
            methodBreakpoint.setHidden(true);
            methodBreakpoint.setSuspend(0);
            this.lastMethodExitBreakpointListener = new MethodExitBreakpointListener(methodBreakpoint);
            methodBreakpoint.addJPDABreakpointListener((JPDABreakpointListener)this.lastMethodExitBreakpointListener);
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)methodBreakpoint);
        }
        jPDAThreadImpl.holdLastOperations(true);
        if (n2 < 0) {
            object = expression.findNextOperationLocations(n3);
        } else {
            methodBreakpoint = expression.getLocations();
            object = new ExpressionPool.OperationLocation[]{new ExpressionPool.OperationLocation(operationArray[n2], (Location)methodBreakpoint[n2], n2)};
        }
        boolean bl2 = false;
        if (object != null) {
            this.operationBreakpoints = new HashSet<BreakpointRequest>();
            for (n = 0; n < ((ExpressionPool.OperationLocation[])object).length; ++n) {
                Location location2 = object[n].getLocation();
                if (object[n].getIndex() < 0) {
                    bl2 = true;
                    operation = new EditorContext.Operation[operationArray.length + 1];
                    System.arraycopy(operationArray, 0, operation, 0, operationArray.length);
                    operation[operationArray.length] = object[n].getOperation();
                    operationArray = operation;
                }
                operation = virtualMachine.eventRequestManager().createBreakpointRequest(location2);
                this.operationBreakpoints.add((BreakpointRequest)operation);
                ((JPDADebuggerImpl)this.debugger).getOperator().register((EventRequest)operation, this);
                operation.setSuspendPolicy(this.debugger.getSuspend());
                operation.addThreadFilter(threadReference);
                operation.putProperty("thread", threadReference);
                operation.enable();
                jPDAThreadImpl.setInStep(true, (EventRequest)operation);
            }
        } else if (bl) {
            return false;
        }
        this.boundaryStepRequest = virtualMachine.eventRequestManager().createStepRequest(threadReference, -2, 2);
        if (bl2) {
            this.boundaryStepRequest.addCountFilter(2);
        } else {
            this.boundaryStepRequest.addCountFilter(1);
        }
        ((JPDADebuggerImpl)this.debugger).getOperator().register(this.boundaryStepRequest, this);
        this.boundaryStepRequest.setSuspendPolicy(this.debugger.getSuspend());
        try {
            this.boundaryStepRequest.enable();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            ((JPDADebuggerImpl)this.debugger).getOperator().unregister(this.boundaryStepRequest);
            this.boundaryStepRequest = null;
            return false;
        }
        this.currentOperations = operationArray;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exec(Event event) {
        JPDAThreadImpl jPDAThreadImpl;
        this.stepDone(event.request());
        SourcePath sourcePath = ((JPDADebuggerImpl)this.debugger).getEngineContext();
        boolean bl = false;
        boolean[] blArray = new boolean[]{false};
        JPDADebuggerImpl jPDADebuggerImpl = (JPDADebuggerImpl)this.debugger;
        Object object = jPDADebuggerImpl.LOCK;
        synchronized (object) {
            int n;
            Variable variable;
            jPDAThreadImpl = (JPDAThreadImpl)jPDADebuggerImpl.getCurrentThread();
            VirtualMachine virtualMachine = jPDADebuggerImpl.getVirtualMachine();
            if (virtualMachine == null) {
                return false;
            }
            if (this.lastMethodExitBreakpointListener != null) {
                variable = this.lastMethodExitBreakpointListener.getReturnValue();
                this.lastMethodExitBreakpointListener.destroy();
                this.lastMethodExitBreakpointListener = null;
                this.lastOperation.setReturnValue(variable);
            }
            if (this.lastOperation != null) {
                jPDAThreadImpl.addLastOperation(this.lastOperation);
            }
            variable = null;
            boolean bl2 = false;
            if (this.currentOperations != null) {
                if (event.request() instanceof BreakpointRequest) {
                    long l = ((BreakpointRequest)event.request()).location().codeIndex();
                    for (n = 0; n < this.currentOperations.length; ++n) {
                        if ((long)this.currentOperations[n].getBytecodeIndex() != l) continue;
                        variable = this.currentOperations[n];
                        break;
                    }
                } else {
                    bl2 = true;
                }
                this.currentOperations = null;
            }
            jPDAThreadImpl.setCurrentOperation((EditorContext.Operation)variable);
            EventRequestManager eventRequestManager = virtualMachine.eventRequestManager();
            EventRequest eventRequest = event.request();
            eventRequestManager.deleteEventRequest(eventRequest);
            jPDADebuggerImpl.getOperator().unregister(eventRequest);
            this.removed(eventRequest);
            n = this.debugger.getSuspend();
            if (bl2) {
                bl = this.addOperationStep(jPDAThreadImpl, true, sourcePath, blArray);
            }
            if (!bl && event.request() instanceof StepRequest && this.shouldNotStopHere(event)) {
                return true;
            }
        }
        if (bl) {
            if (blArray[0]) {
                jPDADebuggerImpl.setStoppedStateNoContinue(jPDAThreadImpl.getThreadReference());
            }
            return true;
        }
        this.firePropertyChange("exec", null, null);
        if (this.getHidden()) {
            return true;
        }
        jPDAThreadImpl.holdLastOperations(false);
        return false;
    }

    @Override
    public void removed(EventRequest eventRequest) {
        JPDADebuggerImpl jPDADebuggerImpl;
        VirtualMachine virtualMachine;
        this.stepDone(eventRequest);
        if (this.lastMethodExitBreakpointListener != null) {
            this.lastMethodExitBreakpointListener.destroy();
            this.lastMethodExitBreakpointListener = null;
        }
        if ((virtualMachine = (jPDADebuggerImpl = (JPDADebuggerImpl)this.debugger).getVirtualMachine()) == null) {
            return;
        }
        EventRequestManager eventRequestManager = virtualMachine.eventRequestManager();
        if (this.operationBreakpoints != null) {
            for (BreakpointRequest breakpointRequest : this.operationBreakpoints) {
                eventRequestManager.deleteEventRequest(breakpointRequest);
                jPDADebuggerImpl.getOperator().unregister(breakpointRequest);
            }
            this.operationBreakpoints = null;
        }
        if (this.boundaryStepRequest != null) {
            eventRequestManager.deleteEventRequest(this.boundaryStepRequest);
            jPDADebuggerImpl.getOperator().unregister(this.boundaryStepRequest);
        }
    }

    private void stepDone(EventRequest eventRequest) {
        JPDAThreadImpl jPDAThreadImpl;
        if (eventRequest instanceof StepRequest) {
            StepRequest stepRequest = (StepRequest)eventRequest;
            jPDAThreadImpl = (JPDAThreadImpl)((JPDADebuggerImpl)this.debugger).getThread(stepRequest.thread());
        } else {
            ThreadReference threadReference = (ThreadReference)eventRequest.getProperty("thread");
            jPDAThreadImpl = threadReference != null ? (JPDAThreadImpl)((JPDADebuggerImpl)this.debugger).getThread(threadReference) : null;
        }
        if (jPDAThreadImpl != null) {
            jPDAThreadImpl.setInStep(false, null);
        }
    }

    private static String[] createClassFilters(VirtualMachine virtualMachine, String string, String string2) {
        return JPDAStepImpl.createClassFilters(virtualMachine, string, string2, new ArrayList<String>()).toArray(new String[0]);
    }

    private static List<String> createClassFilters(VirtualMachine virtualMachine, String string, String string2, List<String> list) {
        List<ReferenceType> list2 = virtualMachine.classesByName(string);
        for (ReferenceType referenceType : list2) {
            Accessible accessible;
            List<Method> list3 = referenceType.methodsByName(string2);
            boolean bl = list3.isEmpty();
            Object object = list3.iterator();
            while (object.hasNext()) {
                accessible = object.next();
                if (!list.contains(referenceType.name())) {
                    list.add(referenceType.name());
                }
                if (accessible.isStatic()) continue;
                bl = true;
            }
            if (!bl || !(referenceType instanceof ClassType) || (accessible = (object = (ClassType)referenceType).superclass()) == null) continue;
            JPDAStepImpl.createClassFilters(virtualMachine, accessible.name(), string2, list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldNotStopHere(Event event) {
        JPDADebuggerImpl jPDADebuggerImpl = (JPDADebuggerImpl)this.debugger;
        Object object = jPDADebuggerImpl.LOCK;
        synchronized (object) {
            ThreadReference threadReference;
            block16: {
                LocatableEvent locatableEvent = (LocatableEvent)event;
                String string = locatableEvent.location().declaringType().name();
                threadReference = locatableEvent.thread();
                try {
                    if (!threadReference.frame(0).location().method().isSynthetic()) break block16;
                    VirtualMachine virtualMachine = jPDADebuggerImpl.getVirtualMachine();
                    if (virtualMachine == null) {
                        return false;
                    }
                    StepRequest stepRequest = virtualMachine.eventRequestManager().createStepRequest(threadReference, -2, this.getDepth());
                    stepRequest.addCountFilter(1);
                    jPDADebuggerImpl.getOperator().register(stepRequest, this);
                    stepRequest.setSuspendPolicy(this.debugger.getSuspend());
                    try {
                        stepRequest.enable();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        jPDADebuggerImpl.getOperator().unregister(stepRequest);
                    }
                    return true;
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    ErrorManager.getDefault().notify((Throwable)incompatibleThreadStateException);
                }
            }
            JPDAThread jPDAThread = jPDADebuggerImpl.getThread(threadReference);
            if (jPDADebuggerImpl.stopHere(jPDAThread)) {
                return false;
            }
            VirtualMachine virtualMachine = jPDADebuggerImpl.getVirtualMachine();
            if (virtualMachine == null) {
                return false;
            }
            Map map = (Map)this.session.lookupFirst(null, Map.class);
            int n = map != null && map.containsKey("SS_ACTION_STEPOUT") ? 3 : 1;
            StepRequest stepRequest = virtualMachine.eventRequestManager().createStepRequest(threadReference, -2, n);
            if (logger.isLoggable(Level.FINE)) {
                try {
                    logger.fine("Can not stop at " + threadReference.frame(0) + ", smart-stepping. Submitting step = " + stepRequest + "; depth = " + n);
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    logger.throwing(this.getClass().getName(), "shouldNotStopHere", incompatibleThreadStateException);
                }
            }
            String[] stringArray = jPDADebuggerImpl.getSmartSteppingFilter().getExclusionPatterns();
            for (int i = 0; i < stringArray.length; ++i) {
                stepRequest.addClassExclusionFilter(stringArray[i]);
                logger.finer("   add pattern: " + stringArray[i]);
            }
            jPDADebuggerImpl.getOperator().register(stepRequest, this);
            stepRequest.setSuspendPolicy(this.debugger.getSuspend());
            try {
                stepRequest.enable();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                jPDADebuggerImpl.getOperator().unregister(stepRequest);
            }
            return true;
        }
    }

    public static final class MethodExitBreakpointListener
    implements JPDABreakpointListener {
        private MethodBreakpoint mb;
        private Variable returnValue;

        public MethodExitBreakpointListener(MethodBreakpoint methodBreakpoint) {
            this.mb = methodBreakpoint;
        }

        public void breakpointReached(JPDABreakpointEvent jPDABreakpointEvent) {
            this.returnValue = jPDABreakpointEvent.getVariable();
        }

        public Variable getReturnValue() {
            return this.returnValue;
        }

        public void destroy() {
            this.mb.removeJPDABreakpointListener((JPDABreakpointListener)this);
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.mb);
        }
    }
}

