/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.spi.debugger.jpda.EditorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionPool {
    private static final boolean IS_JDK_16 = !System.getProperty("java.version").startsWith("1.5");
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.step");
    private Map<ExpressionLocation, Expression> expressions = new HashMap<ExpressionLocation, Expression>();

    ExpressionPool() {
    }

    public synchronized Expression getExpressionAt(Location location, String string) {
        ExpressionLocation expressionLocation = new ExpressionLocation(location.method(), location.lineNumber());
        if (!this.expressions.containsKey(expressionLocation)) {
            Expression expression = this.createExpressionAt(location, string);
            this.expressions.put(expressionLocation, expression);
        }
        return this.expressions.get(expressionLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUnusedExpressions(ThreadReference threadReference) {
        Object object = this;
        synchronized (object) {
            if (this.expressions.size() == 0) {
                return;
            }
        }
        try {
            object = threadReference.frames();
            ExpressionPool expressionPool = this;
            synchronized (expressionPool) {
                Iterator<ExpressionLocation> iterator = this.expressions.keySet().iterator();
                while (iterator.hasNext()) {
                    ExpressionLocation expressionLocation = iterator.next();
                    Method method = expressionLocation.getMethod();
                    int n = expressionLocation.getLine();
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        StackFrame stackFrame = (StackFrame)iterator2.next();
                        if (!((Object)method).equals(stackFrame.location().method())) continue;
                        method = null;
                        break;
                    }
                    if (method == null) continue;
                    iterator.remove();
                }
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
    }

    private Expression createExpressionAt(Location location, String string) {
        List<Location> list;
        Object object;
        if (!location.virtualMachine().canGetBytecodes()) {
            return null;
        }
        ReferenceType referenceType = location.declaringType();
        Method method = location.method();
        byte[] byArray = method.bytecodes();
        byte[] byArray2 = new byte[]{};
        String string2 = System.getProperty("java.version");
        if (IS_JDK_16) {
            try {
                object = referenceType.getClass().getMethod("constantPool", new Class[0]);
                try {
                    byArray2 = (byte[])((java.lang.reflect.Method)object).invoke((Object)referenceType, new Object[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        object = byArray2;
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        String string3 = session == null ? null : session.getCurrentLanguage();
        int n = location.lineNumber(string3);
        try {
            list = method.allLineLocations(string3, null);
        }
        catch (AbsentInformationException absentInformationException) {
            logger.log(Level.FINE, absentInformationException.getLocalizedMessage());
            return null;
        }
        EditorContext.Operation[] operationArray = EditorContextBridge.getContext().getOperations(string, n, new EditorContext.BytecodeProvider((byte[])object, byArray, list, string3){
            final /* synthetic */ byte[] val$theConstantPool;
            final /* synthetic */ byte[] val$bytecodes;
            final /* synthetic */ List val$methodLocations;
            final /* synthetic */ String val$language;
            {
                this.val$theConstantPool = byArray;
                this.val$bytecodes = byArray2;
                this.val$methodLocations = list;
                this.val$language = string;
            }

            public byte[] constantPool() {
                return this.val$theConstantPool;
            }

            public byte[] byteCodes() {
                return this.val$bytecodes;
            }

            public int[] indexAtLines(int n, int n2) {
                return ExpressionPool.getIndexesAtLines(this.val$methodLocations, this.val$language, n, n2, this.val$bytecodes.length);
            }
        });
        if (operationArray == null) {
            logger.log(Level.FINE, "Unsuccessfull bytecode matching.");
            return null;
        }
        if (operationArray.length == 0) {
            return null;
        }
        Location[] locationArray = new Location[operationArray.length];
        for (int i = 0; i < operationArray.length; ++i) {
            int n2 = operationArray[i].getBytecodeIndex();
            locationArray[i] = method.locationOfCodeIndex(n2);
            if (locationArray[i] != null) continue;
            logger.log(Level.FINE, "Location of the operation not found.");
            return null;
        }
        Expression expression = new Expression(new ExpressionLocation(method, n), operationArray, locationArray);
        return expression;
    }

    private static int[] getIndexesAtLines(List<Location> list, String string, int n, int n2, int n3) {
        Location location;
        int n4 = 0;
        int n5 = list.get(0).lineNumber(string);
        while ((location = ExpressionPool.getLocationOfLine(list, string, n - n4++)) == null && n - (n4 - 1) >= n5) {
        }
        int n6 = n2 > n - (n4 - 1) ? 0 : 1;
        n -= n4 - 1;
        n2 += n6;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int n7 = -1;
        for (Location location2 : list) {
            int n8 = location2.lineNumber(string);
            if (n7 == -1 && n <= n8 && n8 < n2) {
                n7 = (int)location2.codeIndex();
                continue;
            }
            if (n7 < 0) continue;
            arrayList.add(new int[]{n7, (int)location2.codeIndex()});
            n7 = -1;
        }
        if (arrayList.size() == 0) {
            if (n7 >= 0) {
                return new int[]{n7, n3};
            }
            return null;
        }
        if (arrayList.size() == 1) {
            return (int[])arrayList.get(0);
        }
        Object object = new int[2 * arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[2 * i] = ((int[])arrayList.get(i))[0];
            object[2 * i + 1] = ((int[])arrayList.get(i))[1];
        }
        return object;
    }

    private static Location getLocationOfLine(List<Location> list, String string, int n) {
        for (Location location : list) {
            if (location.lineNumber(string) != n) continue;
            return location;
        }
        return null;
    }

    public static final class OperationLocation {
        private EditorContext.Operation op;
        private Location loc;
        private int index;

        OperationLocation(EditorContext.Operation operation, Location location, int n) {
            this.op = operation;
            this.loc = location;
            this.index = n;
        }

        public EditorContext.Operation getOperation() {
            return this.op;
        }

        public Location getLocation() {
            return this.loc;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static final class ExpressionLocation {
        private Method method;
        private int line;

        public ExpressionLocation(Method method, int n) {
            this.method = method;
            this.line = n;
        }

        public Method getMethod() {
            return this.method;
        }

        public int getLine() {
            return this.line;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ExpressionLocation)) {
                return false;
            }
            return ((ExpressionLocation)object).line == this.line && ((Object)((ExpressionLocation)object).method).equals(this.method);
        }

        public int hashCode() {
            return ((Object)this.method).hashCode() + this.line;
        }
    }

    public static final class Expression {
        private ExpressionLocation location;
        private EditorContext.Operation[] operations;
        private Location[] locations;

        Expression(ExpressionLocation expressionLocation, EditorContext.Operation[] operationArray, Location[] locationArray) {
            this.location = expressionLocation;
            this.operations = operationArray;
            this.locations = locationArray;
        }

        public EditorContext.Operation[] getOperations() {
            return this.operations;
        }

        public Location[] getLocations() {
            return this.locations;
        }

        public int findNextOperationIndex(int n) {
            for (int i = 0; i < this.operations.length; ++i) {
                int n2 = this.operations[i].getBytecodeIndex();
                if (n2 <= n) continue;
                return i;
            }
            return -1;
        }

        int[] findNextOperationIndexes(int n) {
            for (int i = 0; i < this.operations.length; ++i) {
                List list;
                int n2 = this.operations[i].getBytecodeIndex();
                if (n2 == n && !(list = this.operations[i].getNextOperations()).isEmpty()) {
                    int n3 = list.size();
                    int[] nArray = new int[n3];
                    for (int j = 0; j < n3; ++j) {
                        int n4;
                        EditorContext.Operation operation = (EditorContext.Operation)list.get(j);
                        for (n4 = 0; n4 < this.operations.length && operation != this.operations[n4]; ++n4) {
                        }
                        nArray[j] = n4 < this.operations.length ? n4 : -1;
                    }
                    return nArray;
                }
                if (n2 <= n) continue;
                return new int[]{i};
            }
            return null;
        }

        OperationLocation[] findNextOperationLocations(int n) {
            for (int i = 0; i < this.operations.length; ++i) {
                List list;
                int n2 = this.operations[i].getBytecodeIndex();
                if (n2 == n && !(list = this.operations[i].getNextOperations()).isEmpty()) {
                    int n3 = list.size();
                    OperationLocation[] operationLocationArray = new OperationLocation[n3];
                    for (int j = 0; j < n3; ++j) {
                        int n4;
                        EditorContext.Operation operation = (EditorContext.Operation)list.get(j);
                        for (n4 = 0; n4 < this.operations.length && operation != this.operations[n4]; ++n4) {
                        }
                        if (n4 < this.operations.length) {
                            operationLocationArray[j] = new OperationLocation(this.operations[n4], this.locations[n4], n4);
                            continue;
                        }
                        int n5 = operation.getBytecodeIndex();
                        Location location = this.location.getMethod().locationOfCodeIndex(n5);
                        if (location == null) {
                            logger.log(Level.FINE, "Location of the operation not found.");
                            return null;
                        }
                        operationLocationArray[j] = new OperationLocation(operation, location, -1);
                    }
                    return operationLocationArray;
                }
                if (n2 <= n) continue;
                return new OperationLocation[]{new OperationLocation(this.operations[i], this.locations[i], i)};
            }
            return null;
        }
    }
}

