/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.style.StylerUtils;
import org.springframework.ui.ModelMap;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.DefaultSessionAttributeStore;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.bind.support.SimpleSessionStatus;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.multiaction.InternalPathMethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.MethodNameResolver;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.support.WebContentGenerator;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public class AnnotationMethodHandlerAdapter
extends WebContentGenerator
implements HandlerAdapter {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private MethodNameResolver methodNameResolver = new InternalPathMethodNameResolver();
    private SessionAttributeStore sessionAttributeStore = new DefaultSessionAttributeStore();
    private WebBindingInitializer webBindingInitializer;
    private final Map<Class<?>, HandlerMethodResolver> methodResolverCache = new ConcurrentHashMap();
    private final Map<Class<?>, Set<String>> sessionAttributeNames = new ConcurrentHashMap();

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.urlPathHelper.setAlwaysUseFullPath(alwaysUseFullPath);
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlPathHelper.setUrlDecode(urlDecode);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        Assert.notNull((Object)urlPathHelper, (String)"UrlPathHelper must not be null");
        this.urlPathHelper = urlPathHelper;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public void setMethodNameResolver(MethodNameResolver methodNameResolver) {
        this.methodNameResolver = methodNameResolver;
    }

    public void setWebBindingInitializer(WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    public void setSessionAttributeStore(SessionAttributeStore sessionAttributeStore) {
        Assert.notNull((Object)sessionAttributeStore, (String)"SessionAttributeStore must not be null");
        this.sessionAttributeStore = sessionAttributeStore;
    }

    public boolean supports(Object handler) {
        return this.getMethodResolver(handler).hasHandlerMethods();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        ModelAndView mav;
        block12: {
            ServletWebRequest webRequest;
            Set<String> sessionAttrNames;
            SessionAttributes sessionAttributes;
            ModelMap implicitModel;
            block13: {
                implicitModel = new ModelMap();
                sessionAttributes = handler.getClass().getAnnotation(SessionAttributes.class);
                sessionAttrNames = null;
                if (sessionAttributes != null) {
                    this.checkAndPrepare(request, response, 0, false);
                    sessionAttrNames = this.sessionAttributeNames.get(handler.getClass());
                    if (sessionAttrNames == null) {
                        Map<Class<?>, Set<String>> map = this.sessionAttributeNames;
                        synchronized (map) {
                            sessionAttrNames = this.sessionAttributeNames.get(handler.getClass());
                            if (sessionAttrNames == null) {
                                sessionAttrNames = Collections.synchronizedSet(new HashSet(4));
                                this.sessionAttributeNames.put(handler.getClass(), sessionAttrNames);
                            }
                        }
                    }
                } else {
                    this.checkAndPrepare(request, response, false);
                }
                webRequest = new ServletWebRequest(request);
                HandlerMethodResolver methodResolver = this.getMethodResolver(handler);
                Method handlerMethod = methodResolver.resolveHandlerMethod(request);
                ArgumentsResolver argResolver = new ArgumentsResolver(methodResolver.getInitBinderMethods());
                for (Method attributeMethod : methodResolver.getModelAttributeMethods()) {
                    Object[] args = argResolver.resolveArguments(handler, attributeMethod, request, response, (WebRequest)webRequest, implicitModel, sessionAttrNames);
                    ReflectionUtils.makeAccessible((Method)attributeMethod);
                    Object attrValue = ReflectionUtils.invokeMethod((Method)attributeMethod, (Object)handler, (Object[])args);
                    String attrName = attributeMethod.getAnnotation(ModelAttribute.class).value();
                    if ("".equals(attrName)) {
                        implicitModel.addAttribute(attrValue);
                        continue;
                    }
                    implicitModel.addAttribute(attrName, attrValue);
                }
                Object[] args = argResolver.resolveArguments(handler, handlerMethod, request, response, (WebRequest)webRequest, implicitModel, sessionAttrNames);
                ReflectionUtils.makeAccessible((Method)handlerMethod);
                Object result = ReflectionUtils.invokeMethod((Method)handlerMethod, (Object)handler, (Object[])args);
                mav = argResolver.getModelAndView(handlerMethod, result, implicitModel);
                if (sessionAttributes == null) break block12;
                if (!argResolver.isProcessingComplete()) break block13;
                if (sessionAttrNames == null) break block12;
                for (String attrName : sessionAttrNames) {
                    this.sessionAttributeStore.cleanupAttribute((WebRequest)webRequest, attrName);
                }
                break block12;
            }
            Map model = mav != null ? mav.getModel() : implicitModel;
            HashSet<Object> sessionAttributeSet = new HashSet<Object>();
            sessionAttributeSet.addAll(Arrays.asList(sessionAttributes.value()));
            sessionAttributeSet.addAll(Arrays.asList(sessionAttributes.types()));
            for (Map.Entry entry : new HashSet(model.entrySet())) {
                String attrName = (String)entry.getKey();
                Object attrValue = entry.getValue();
                if (!sessionAttributeSet.contains(attrName) && (attrValue == null || !sessionAttributeSet.contains(attrValue.getClass()))) continue;
                sessionAttrNames.add(attrName);
                this.sessionAttributeStore.storeAttribute((WebRequest)webRequest, attrName, attrValue);
                String bindingResultKey = BindingResult.MODEL_KEY_PREFIX + attrName;
                if (mav == null || model.containsKey(bindingResultKey)) continue;
                ServletRequestDataBinder binder = new ServletRequestDataBinder(attrValue, attrName);
                if (this.webBindingInitializer != null) {
                    this.webBindingInitializer.initBinder((WebDataBinder)binder, (WebRequest)webRequest);
                }
                mav.addObject(bindingResultKey, binder.getBindingResult());
            }
        }
        return mav;
    }

    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    private HandlerMethodResolver getMethodResolver(Object handler) {
        HandlerMethodResolver resolver = this.methodResolverCache.get(handler.getClass());
        if (resolver == null) {
            resolver = new HandlerMethodResolver(handler.getClass());
            this.methodResolverCache.put(handler.getClass(), resolver);
        }
        return resolver;
    }

    private static class RequestMappingInfo {
        public String[] paths = new String[0];
        public RequestMethod[] methods = new RequestMethod[0];
        public String[] params = new String[0];

        private RequestMappingInfo() {
        }

        public boolean isEmpty() {
            return this.paths.length == 0 && this.methods.length == 0 && this.params.length == 0;
        }

        public boolean equals(Object obj) {
            RequestMappingInfo other = (RequestMappingInfo)obj;
            return this.paths.equals(other.paths) && this.methods.equals(other.methods) && this.params.equals(other.params);
        }

        public int hashCode() {
            return Arrays.hashCode(this.paths) * 29 + Arrays.hashCode(this.methods) * 31 + Arrays.hashCode(this.params);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArgumentsResolver {
        private final Set<Method> initBinderMethods;
        private final SimpleSessionStatus sessionStatus = new SimpleSessionStatus();
        private boolean responseArgumentUsed = false;

        public ArgumentsResolver(Set<Method> initBinderMethods) {
            this.initBinderMethods = initBinderMethods;
        }

        public Object[] resolveArguments(Object handler, Method handlerMethod, HttpServletRequest request, HttpServletResponse response, WebRequest webRequest, ModelMap implicitModel, Set<String> sessionAttrNames) throws ServletException, IOException {
            SessionAttributes sessionAttributes = handler.getClass().getAnnotation(SessionAttributes.class);
            HashSet<Object> sessionAttributeSet = null;
            if (sessionAttributes != null) {
                sessionAttributeSet = new HashSet<Object>();
                sessionAttributeSet.addAll(Arrays.asList(sessionAttributes.value()));
                sessionAttributeSet.addAll(Arrays.asList(sessionAttributes.types()));
            }
            SimpleTypeConverter converter = new SimpleTypeConverter();
            Object[] args = new Object[handlerMethod.getParameterTypes().length];
            String[] paramNames = null;
            boolean paramNamesResolved = false;
            for (int i = 0; i < args.length; ++i) {
                Object bindObject;
                MethodParameter param = new MethodParameter(handlerMethod, i);
                args[i] = this.resolveStandardArgument(param.getParameterType(), request, response, webRequest);
                if (args[i] == null) {
                    if (param.getParameterType().isInstance(implicitModel)) {
                        args[i] = implicitModel;
                    } else if (param.getParameterType().isInstance(this.sessionStatus)) {
                        args[i] = this.sessionStatus;
                    }
                }
                if (args[i] != null) continue;
                boolean isParam = false;
                String paramName = "";
                boolean paramRequired = false;
                String attrName = ClassUtils.getShortNameAsProperty((Class)param.getParameterType());
                Annotation[] paramAnns = (Annotation[])param.getParameterAnnotations();
                for (int j = 0; j < paramAnns.length; ++j) {
                    ModelAttribute attr;
                    Annotation paramAnn = paramAnns[j];
                    if (RequestParam.class.isInstance(paramAnn)) {
                        RequestParam requestParam = (RequestParam)paramAnn;
                        isParam = true;
                        paramName = requestParam.value();
                        paramRequired = requestParam.required();
                        break;
                    }
                    if (!ModelAttribute.class.isInstance(paramAnn) || "".equals((attr = (ModelAttribute)paramAnn).value())) continue;
                    attrName = attr.value();
                }
                if (isParam || BeanUtils.isSimpleProperty((Class)param.getParameterType())) {
                    if ("".equals(paramName)) {
                        if (!paramNamesResolved) {
                            LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
                            paramNames = discoverer.getParameterNames(handlerMethod);
                            paramNamesResolved = true;
                        }
                        if (paramNames == null) {
                            throw new IllegalStateException("No parameter specified for @RequestParam argument of type [" + param.getParameterType().getName() + "], and no parameter name " + "information found in class file either.");
                        }
                        paramName = paramNames[i];
                    }
                    String[] paramValue = null;
                    if (request instanceof MultipartHttpServletRequest) {
                        paramValue = ((MultipartHttpServletRequest)request).getFile(paramName);
                    }
                    if (paramValue == null) {
                        paramValue = request.getParameterValues(paramName);
                    }
                    if (paramValue == null && paramRequired) {
                        throw new MissingServletRequestParameterException(paramName, param.getParameterType().getName());
                    }
                    args[i] = converter.convertIfNecessary((Object)paramValue, param.getParameterType());
                    continue;
                }
                if (sessionAttributeSet != null && (sessionAttributeSet.contains(attrName) || sessionAttributeSet.contains(param.getParameterType())) && !implicitModel.containsKey((Object)attrName)) {
                    HttpSession session = request.getSession(false);
                    if (session == null) {
                        throw new HttpSessionRequiredException("No session found - session required for attribute '" + attrName + "'");
                    }
                    Object sessionAttr = AnnotationMethodHandlerAdapter.this.sessionAttributeStore.retrieveAttribute(webRequest, attrName);
                    if (sessionAttr == null) {
                        throw new HttpSessionRequiredException("Session attribute '" + attrName + "' required - not found in session");
                    }
                    sessionAttrNames.add(attrName);
                    implicitModel.addAttribute(attrName, sessionAttr);
                }
                if ((bindObject = implicitModel.get((Object)attrName)) == null) {
                    bindObject = BeanUtils.instantiateClass((Class)param.getParameterType());
                }
                ServletRequestDataBinder binder = new ServletRequestDataBinder(bindObject, attrName);
                if (AnnotationMethodHandlerAdapter.this.webBindingInitializer != null) {
                    AnnotationMethodHandlerAdapter.this.webBindingInitializer.initBinder((WebDataBinder)binder, webRequest);
                }
                for (Method initBinderMethod : this.initBinderMethods) {
                    String[] targetNames = initBinderMethod.getAnnotation(InitBinder.class).value();
                    if (targetNames.length != 0 && !Arrays.asList(targetNames).contains(attrName)) continue;
                    Class<?>[] initBinderParams = initBinderMethod.getParameterTypes();
                    Object[] initBinderArgs = new Object[initBinderParams.length];
                    for (int j = 0; j < initBinderArgs.length; ++j) {
                        initBinderArgs[j] = this.resolveStandardArgument(initBinderParams[j], request, response, webRequest);
                        if (initBinderArgs[j] != null || !initBinderParams[j].isInstance(binder)) continue;
                        initBinderArgs[j] = binder;
                    }
                    ReflectionUtils.makeAccessible((Method)initBinderMethod);
                    Object attrValue = ReflectionUtils.invokeMethod((Method)initBinderMethod, (Object)handler, (Object[])initBinderArgs);
                    if (attrValue == null) continue;
                    throw new IllegalStateException("InitBinder methods must not have a return value: " + initBinderMethod);
                }
                binder.bind((ServletRequest)request);
                args[i] = bindObject;
                implicitModel.putAll(binder.getBindingResult().getModel());
                if (args.length > i + 1 && Errors.class.isAssignableFrom(handlerMethod.getParameterTypes()[i + 1])) {
                    args[i + 1] = binder.getBindingResult();
                    ++i;
                    continue;
                }
                binder.closeNoCatch();
            }
            return args;
        }

        private Object resolveStandardArgument(Class<?> parameterType, HttpServletRequest request, HttpServletResponse response, WebRequest webRequest) throws IOException {
            if (parameterType.isInstance(request)) {
                return request;
            }
            if (parameterType.isInstance(response)) {
                this.responseArgumentUsed = true;
                return response;
            }
            if (HttpSession.class.isAssignableFrom(parameterType)) {
                return request.getSession();
            }
            if (WebRequest.class.isAssignableFrom(parameterType)) {
                return webRequest;
            }
            if (Locale.class.equals(parameterType)) {
                return RequestContextUtils.getLocale(request);
            }
            if (InputStream.class.equals(parameterType)) {
                return request.getInputStream();
            }
            if (Reader.class.equals(parameterType)) {
                return request.getReader();
            }
            if (OutputStream.class.equals(parameterType)) {
                this.responseArgumentUsed = true;
                return response.getOutputStream();
            }
            if (Writer.class.equals(parameterType)) {
                this.responseArgumentUsed = true;
                return response.getWriter();
            }
            return null;
        }

        public boolean isProcessingComplete() {
            return this.sessionStatus.isComplete();
        }

        public ModelAndView getModelAndView(Method handlerMethod, Object returnValue, ModelMap implicitModel) {
            if (returnValue instanceof ModelAndView) {
                ModelAndView mav = (ModelAndView)returnValue;
                mav.getModelMap().mergeAttributes((Map)implicitModel);
                return mav;
            }
            if (returnValue instanceof Map) {
                return new ModelAndView().addAllObjects((Map)implicitModel).addAllObjects((Map)returnValue);
            }
            if (returnValue instanceof String) {
                return new ModelAndView((String)returnValue).addAllObjects((Map)implicitModel);
            }
            if (returnValue == null) {
                if (!this.responseArgumentUsed) {
                    return new ModelAndView().addAllObjects((Map)implicitModel);
                }
                return null;
            }
            if (!BeanUtils.isSimpleProperty(returnValue.getClass())) {
                String attrName = handlerMethod.getAnnotation(ModelAttribute.class).value();
                ModelAndView mav = new ModelAndView().addAllObjects((Map)implicitModel);
                if ("".equals(attrName)) {
                    return mav.addObject(returnValue);
                }
                return mav.addObject(attrName, returnValue);
            }
            throw new IllegalArgumentException("Invalid handler method return value: " + returnValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HandlerMethodResolver {
        private final Set<Method> handlerMethods = new LinkedHashSet<Method>();
        private final Set<Method> initBinderMethods = new LinkedHashSet<Method>();
        private final Set<Method> modelAttributeMethods = new LinkedHashSet<Method>();

        public HandlerMethodResolver(Class<?> handlerType) {
            ReflectionUtils.doWithMethods(handlerType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) {
                    if (method.isAnnotationPresent(RequestMapping.class)) {
                        HandlerMethodResolver.this.handlerMethods.add(method);
                    } else if (method.isAnnotationPresent(InitBinder.class)) {
                        HandlerMethodResolver.this.initBinderMethods.add(method);
                    } else if (method.isAnnotationPresent(ModelAttribute.class)) {
                        HandlerMethodResolver.this.modelAttributeMethods.add(method);
                    }
                }
            });
        }

        public Method resolveHandlerMethod(HttpServletRequest request) throws ServletException {
            String lookupPath = AnnotationMethodHandlerAdapter.this.urlPathHelper.getLookupPathForRequest(request);
            LinkedHashMap<RequestMappingInfo, Method> targetHandlerMethods = new LinkedHashMap<RequestMappingInfo, Method>();
            LinkedHashMap<RequestMappingInfo, String> targetPathMatches = new LinkedHashMap<RequestMappingInfo, String>();
            String resolvedMethodName = null;
            for (Method handlerMethod : this.handlerMethods) {
                Method oldMappedMethod;
                RequestMappingInfo mappingInfo = new RequestMappingInfo();
                Object mapping = handlerMethod.getAnnotation(RequestMapping.class);
                mappingInfo.paths = mapping.value();
                mappingInfo.methods = mapping.method();
                mappingInfo.params = mapping.params();
                boolean match = false;
                if (mappingInfo.paths.length > 0) {
                    for (String mappedPath : mappingInfo.paths) {
                        if (!mappedPath.equals(lookupPath) && !AnnotationMethodHandlerAdapter.this.pathMatcher.match(mappedPath, lookupPath)) continue;
                        if (this.checkParameters(request, mappingInfo)) {
                            match = true;
                            targetPathMatches.put(mappingInfo, mappedPath);
                            continue;
                        }
                        break;
                    }
                } else {
                    match = this.checkParameters(request, mappingInfo);
                    if (match && mappingInfo.methods.length == 0 && mappingInfo.params.length == 0 && resolvedMethodName != null && !resolvedMethodName.equals(handlerMethod.getName())) {
                        match = false;
                    }
                }
                if (!match || (oldMappedMethod = targetHandlerMethods.put(mappingInfo, handlerMethod)) == null || oldMappedMethod == handlerMethod) continue;
                if (AnnotationMethodHandlerAdapter.this.methodNameResolver != null && resolvedMethodName == null && mappingInfo.isEmpty()) {
                    resolvedMethodName = AnnotationMethodHandlerAdapter.this.methodNameResolver.getHandlerMethodName(request);
                    if (!resolvedMethodName.equals(oldMappedMethod.getName())) {
                        oldMappedMethod = null;
                    }
                    if (!resolvedMethodName.equals(handlerMethod.getName())) {
                        if (oldMappedMethod != null) {
                            targetHandlerMethods.put(mappingInfo, oldMappedMethod);
                            oldMappedMethod = null;
                        } else {
                            targetHandlerMethods.remove(mappingInfo);
                        }
                    }
                }
                if (oldMappedMethod == null) continue;
                throw new IllegalStateException("Ambiguous handler methods mapped for HTTP path '" + lookupPath + "': {" + oldMappedMethod + ", " + handlerMethod + "}. If you intend to handle the same path in multiple methods, then factor " + "them out into a dedicated handler class with that path mapped at the type level!");
            }
            if (targetHandlerMethods.size() == 1) {
                return (Method)targetHandlerMethods.values().iterator().next();
            }
            if (!targetHandlerMethods.isEmpty()) {
                Object bestMappingMatch = null;
                String bestPathMatch = null;
                for (Object mapping : targetHandlerMethods.keySet()) {
                    String mappedPath = (String)targetPathMatches.get(mapping);
                    if (bestMappingMatch == null) {
                        bestMappingMatch = mapping;
                        bestPathMatch = mappedPath;
                        continue;
                    }
                    if ((mappedPath == null || bestPathMatch != null && !mappedPath.equals(lookupPath) && bestPathMatch.length() >= mappedPath.length()) && (bestMappingMatch.methods.length != 0 || mapping.methods.length <= 0) && bestMappingMatch.params.length >= mapping.params.length) continue;
                    bestMappingMatch = mapping;
                    bestPathMatch = mappedPath;
                }
                return (Method)targetHandlerMethods.get(bestMappingMatch);
            }
            throw new IllegalStateException("No matching handler method found for servlet request: path '" + lookupPath + "', method '" + request.getMethod() + "', parameters " + StylerUtils.style((Object)request.getParameterMap()));
        }

        private boolean checkParameters(HttpServletRequest request, RequestMappingInfo mapping) {
            String[] params;
            if (mapping.methods.length > 0) {
                boolean match = false;
                for (RequestMethod requestMethod : mapping.methods) {
                    if (!requestMethod.toString().equals(request.getMethod().toUpperCase())) continue;
                    match = true;
                }
                if (!match) {
                    return false;
                }
            }
            if ((params = mapping.params).length > 0) {
                for (String string : params) {
                    int separator = string.indexOf(61);
                    if (separator == -1) {
                        if (WebUtils.hasSubmitParameter((ServletRequest)request, (String)string)) continue;
                        return false;
                    }
                    String key = string.substring(0, separator);
                    String value = string.substring(separator + 1);
                    if (value.equals(request.getParameter(key))) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean hasHandlerMethods() {
            return !this.handlerMethods.isEmpty();
        }

        public Set<Method> getInitBinderMethods() {
            return this.initBinderMethods;
        }

        public Set<Method> getModelAttributeMethods() {
            return this.modelAttributeMethods;
        }
    }
}

