/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import org.jruby.util.ByteList;
import org.jvyamlb.Positionable;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.PositionedScalarNode;
import org.jvyamlb.nodes.PositionedSequenceNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.StructureItem;
import org.netbeans.modules.gsf.api.StructureScanner;
import org.netbeans.modules.languages.yaml.YamlParserResult;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlScanner
implements StructureScanner {
    public List<? extends StructureItem> scan(CompilationInfo compilationInfo) {
        YamlParserResult yamlParserResult = (YamlParserResult)compilationInfo.getEmbeddedResult("text/x-yaml", 0);
        if (yamlParserResult != null) {
            return yamlParserResult.getItems();
        }
        return Collections.emptyList();
    }

    List<? extends StructureItem> scanStructure(YamlParserResult yamlParserResult) {
        Node node = yamlParserResult.getObject();
        if (node != null) {
            return new YamlStructureItem(node, null, 0).getNestedItems();
        }
        return Collections.emptyList();
    }

    public Map<String, List<OffsetRange>> folds(CompilationInfo compilationInfo) {
        YamlParserResult yamlParserResult = (YamlParserResult)compilationInfo.getEmbeddedResult("text/x-yaml", 0);
        if (yamlParserResult == null) {
            return Collections.emptyMap();
        }
        List<? extends StructureItem> list = yamlParserResult.getItems();
        if (list.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, List<OffsetRange>> hashMap = new HashMap<String, List<OffsetRange>>();
        ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>();
        hashMap.put("codeblocks", arrayList);
        BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
        for (StructureItem structureItem : list) {
            try {
                this.addBlocks(baseDocument, arrayList, structureItem);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                break;
            }
        }
        return hashMap;
    }

    private void addBlocks(BaseDocument baseDocument, List<OffsetRange> list, StructureItem structureItem) throws BadLocationException {
        int n = (int)structureItem.getPosition();
        int n2 = (int)structureItem.getEndPosition();
        int n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        if (n >= n2 || n3 == Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2)) {
            return;
        }
        list.add(new OffsetRange(n3, n2));
        for (StructureItem structureItem2 : structureItem.getNestedItems()) {
            int n4 = (int)structureItem2.getPosition();
            int n5 = (int)structureItem2.getEndPosition();
            if (n4 < n || n5 > n2) continue;
            this.addBlocks(baseDocument, list, structureItem2);
        }
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(false, false, 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class YamlStructureItem
    implements StructureItem,
    Comparable<YamlStructureItem> {
        private final String name;
        private List<YamlStructureItem> children;
        private final Node node;
        private final long begin;
        private final long end;
        private final int depth;

        YamlStructureItem(Node node, String string, int n, long l, long l2) {
            this.node = node;
            this.name = string;
            this.begin = l;
            this.end = l2;
            this.depth = n;
        }

        YamlStructureItem(Node node, String string, int n) {
            this(node, string, n, ((Positionable)node).getRange().start.offset, ((Positionable)node).getRange().end.offset);
        }

        public String getName() {
            return this.name;
        }

        public String getSortText() {
            return this.getName();
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            String string = this.getName();
            try {
                return XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                Exceptions.printStackTrace((Throwable)charConversionException);
                return string;
            }
        }

        public ElementHandle getElementHandle() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.ATTRIBUTE;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return this.getNestedItems().size() == 0;
        }

        public List<? extends StructureItem> getNestedItems() {
            if (this.children == null) {
                if (this.depth > 20) {
                    this.children = Collections.emptyList();
                    return this.children;
                }
                Object object = this.node.getValue();
                if (object instanceof Map) {
                    this.children = new ArrayList<YamlStructureItem>();
                    Map map = (Map)object;
                    Set set = map.entrySet();
                    for (Map.Entry entry : set) {
                        List list;
                        Object object2;
                        PositionedSequenceNode positionedSequenceNode;
                        Object k = entry.getKey();
                        if (k instanceof PositionedSequenceNode) {
                            Object object3;
                            Object object4;
                            Object object52;
                            positionedSequenceNode = (PositionedSequenceNode)k;
                            object2 = positionedSequenceNode.getValue();
                            assert (object2 instanceof List);
                            list = (List)object2;
                            for (Object object52 : list) {
                                object4 = object52.getValue();
                                if (object4 instanceof List || object4 instanceof Map) {
                                    this.children.add(new YamlStructureItem((Node)object52, "list item", this.depth + 1));
                                    continue;
                                }
                                object3 = object4.toString();
                                this.children.add(new YamlStructureItem((Node)object52, (String)object3, this.depth + 1));
                            }
                            Iterator<Object> iterator = entry.getValue();
                            if (!(iterator instanceof PositionedSequenceNode)) continue;
                            positionedSequenceNode = (PositionedSequenceNode)iterator;
                            object2 = positionedSequenceNode.getValue();
                            assert (object2 instanceof List);
                            list = (List)object2;
                            object52 = list.iterator();
                            while (object52.hasNext()) {
                                object4 = (Node)object52.next();
                                object3 = object4.getValue();
                                if (object3 instanceof List || object3 instanceof Map) {
                                    this.children.add(new YamlStructureItem((Node)object4, "list item", this.depth + 1));
                                    continue;
                                }
                                String string = object3.toString();
                                this.children.add(new YamlStructureItem((Node)object4, string, this.depth + 1));
                            }
                            continue;
                        }
                        assert (k instanceof PositionedScalarNode);
                        positionedSequenceNode = (PositionedScalarNode)k;
                        object2 = positionedSequenceNode.getValue().toString();
                        list = (Node)entry.getValue();
                        int n = ((Positionable)list).getRange().end.offset;
                        if (list.getValue() instanceof ByteList && ((ByteList)list.getValue()).length() == 0) {
                            n = positionedSequenceNode.getRange().end.offset;
                        }
                        this.children.add(new YamlStructureItem((Node)list, (String)object2, this.depth + 1, positionedSequenceNode.getRange().start.offset, n));
                    }
                    Collections.sort(this.children);
                } else if (object instanceof List) {
                    this.children = new ArrayList<YamlStructureItem>();
                    List list = (List)object;
                    for (Node node : list) {
                        Object object6 = node.getValue();
                        if (object6 instanceof List || object6 instanceof Map) {
                            this.children.add(new YamlStructureItem(node, "list item", this.depth + 1));
                            continue;
                        }
                        String string = object6.toString();
                        this.children.add(new YamlStructureItem(node, string, this.depth + 1));
                    }
                } else {
                    this.children = Collections.emptyList();
                }
            }
            return this.children;
        }

        public long getPosition() {
            return this.begin;
        }

        public long getEndPosition() {
            return this.end;
        }

        public ImageIcon getCustomIcon() {
            return null;
        }

        @Override
        public int compareTo(YamlStructureItem yamlStructureItem) {
            return (int)(this.begin - yamlStructureItem.begin);
        }
    }
}

