/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.gsf.api.CodeCompletionContext;
import org.netbeans.modules.gsf.api.CodeCompletionHandler;
import org.netbeans.modules.gsf.api.CodeCompletionResult;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.CompletionProposal;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.ParameterInfo;
import org.netbeans.modules.gsf.spi.DefaultCompletionResult;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlCompletion
implements CodeCompletionHandler {
    private String refcard;
    private static final String[] YAML_KEYS = new String[]{"? ", "Key indicator.", ": ", "Value indicator.", "- ", "Nested series entry indicator.", ", ", "Separate in-line branch entries.", "[]", "Surround in-line series branch.", "{}", "Surround in-line keyed branch.", "'", "Surround in-line unescaped scalar", "\"", "Surround in-line escaped scalar", "|", "Block scalar indicator.", ">", "Folded scalar indicator.", "-", "Strip chomp modifier ('|-' or '>-').", "+", "Keep chomp modifier ('|+' or '>+').", "&", "Anchor property.", "*", "Alias indicator.", "!", "Non-specific tag", "!foo", "Primary", "!!foo", "Secondary", "!h!foo", "Requires \"%TAG !h! <prefix>\"", "!<foo>", "Verbatim tag (always means \"foo\").", "%", "Directive indicator.", "---", "Document header.", "...", "Document terminator.", "#", "Throwaway comment indicator.", "`@", "Both reserved for future use.", "=", "Default \"value\" mapping key.", "<<", "Merge keys from another mapping.", "!!map", "{ Hash table, dictionary, mapping }", "!!seq", "{ List, array, tuple, vector, sequence }", "!!str", "Unicode string", "!!set", "{ cherries, plums, apples }", "!!omap", "[ one: 1, two: 2 ]"};
    private static ImageIcon keywordIcon;

    private boolean startsWith(String string, String string2, boolean bl) {
        if (string2.length() == 0) {
            return true;
        }
        return bl ? string.startsWith(string2) : string.toLowerCase().startsWith(string2.toLowerCase());
    }

    public CodeCompletionResult complete(CodeCompletionContext codeCompletionContext) {
        KeywordItem keywordItem;
        String string;
        String string2;
        int n;
        ArrayList<KeywordItem> arrayList = new ArrayList<KeywordItem>();
        boolean bl = codeCompletionContext.isCaseSensitive();
        String string3 = codeCompletionContext.getPrefix();
        if (string3 == null) {
            string3 = "";
        }
        int n2 = codeCompletionContext.getCaretOffset();
        int n3 = YAML_KEYS.length;
        for (n = 0; n < n3; n += 2) {
            string2 = YAML_KEYS[n];
            string = YAML_KEYS[n + 1];
            if (!this.startsWith(string2, string3, bl)) continue;
            keywordItem = new KeywordItem(string2, string, n2, Integer.toString(10000 + n));
            arrayList.add(keywordItem);
        }
        if (arrayList.size() == 0) {
            n3 = YAML_KEYS.length;
            for (n = 0; n < n3; n += 2) {
                string2 = YAML_KEYS[n];
                string = YAML_KEYS[n + 1];
                keywordItem = new KeywordItem(string2, string, n2, Integer.toString(10000 + n));
                arrayList.add(keywordItem);
            }
        }
        DefaultCompletionResult defaultCompletionResult = new DefaultCompletionResult(arrayList, false);
        defaultCompletionResult.setFilterable(false);
        return defaultCompletionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String document(CompilationInfo compilationInfo, ElementHandle elementHandle) {
        if (this.refcard == null) {
            this.refcard = "";
            BufferedInputStream bufferedInputStream = null;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                int n;
                bufferedInputStream = new BufferedInputStream(YamlCompletion.class.getResourceAsStream("refcard.html"));
                while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
                    stringBuilder.append((char)n);
                }
                if (stringBuilder.length() > 0) {
                    this.refcard = stringBuilder.toString();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                try {
                    if (bufferedInputStream != null) {
                        ((InputStream)bufferedInputStream).close();
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return this.refcard.length() > 0 ? this.refcard : null;
    }

    public ElementHandle resolveLink(String string, ElementHandle elementHandle) {
        return null;
    }

    public String getPrefix(CompilationInfo compilationInfo, int n, boolean bl) {
        if (n > 0) {
            try {
                return compilationInfo.getDocument().getText(n - 1, 1);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return null;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent jTextComponent, String string) {
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String string, CompilationInfo compilationInfo, int n, String string2, Map map) {
        return null;
    }

    public Set<String> getApplicableTemplates(CompilationInfo compilationInfo, int n, int n2) {
        return Collections.emptySet();
    }

    public ParameterInfo parameters(CompilationInfo compilationInfo, int n, CompletionProposal completionProposal) {
        return ParameterInfo.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeywordItem
    implements CompletionProposal,
    ElementHandle {
        private int anchor;
        private static final String YAML_KEYWORD = "org/netbeans/modules/languages/yaml/yaml_files_16.png";
        private final String keyword;
        private final String description;
        private final String sort;

        KeywordItem(String string, String string2, int n, String string3) {
            this.keyword = string;
            this.description = string2;
            this.anchor = n;
            this.sort = string3;
        }

        public String getName() {
            return this.keyword;
        }

        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            if (this.description != null) {
                htmlFormatter.appendHtml(this.description);
                return htmlFormatter.getText();
            }
            return null;
        }

        public ImageIcon getIcon() {
            if (keywordIcon == null) {
                keywordIcon = new ImageIcon(Utilities.loadImage((String)YAML_KEYWORD));
            }
            return keywordIcon;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public ElementHandle getElement() {
            return this;
        }

        public boolean isSmart() {
            return false;
        }

        public int getAnchorOffset() {
            return this.anchor;
        }

        public String getInsertPrefix() {
            return this.keyword;
        }

        public String getSortText() {
            return this.sort;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.name(ElementKind.KEYWORD, true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(ElementKind.KEYWORD, false);
            return htmlFormatter.getText();
        }

        public String getCustomInsertTemplate() {
            return null;
        }

        public List<String> getInsertParams() {
            return null;
        }

        public String[] getParamListDelimiters() {
            return null;
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return "text/x-yaml";
        }

        public String getIn() {
            return null;
        }

        public boolean signatureEquals(ElementHandle elementHandle) {
            return false;
        }
    }
}

