/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.modules.refactoring.spi.impl.CheckNode;
import org.netbeans.modules.refactoring.spi.impl.RefactoringPanel;
import org.openide.awt.HtmlRenderer;
import org.openide.util.NbBundle;

public class CheckRenderer
extends JPanel
implements TreeCellRenderer {
    protected JCheckBox check;
    protected HtmlRenderer.Renderer renderer = HtmlRenderer.createRenderer();
    private static Dimension checkDim;
    static Rectangle checkBounds;
    private Component stringDisplayer = new JLabel(" ");

    public CheckRenderer(boolean bl) {
        this.setLayout(null);
        if (bl) {
            this.check = null;
        } else {
            this.check = new JCheckBox();
            this.add(this.check);
            Color color = UIManager.getColor("Tree.textBackground");
            if (color == null) {
                color = Color.WHITE;
            }
            this.check.setBackground(color);
            Dimension dimension = this.check.getPreferredSize();
            this.check.setPreferredSize(checkDim);
        }
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        CheckNode checkNode = (CheckNode)object;
        this.stringDisplayer = this.renderer.getTreeCellRendererComponent(jTree, (Object)this.getNodeText(checkNode), bl, bl2, bl3, n, bl4);
        this.renderer.setIcon(checkNode.getIcon());
        this.stringDisplayer.setEnabled(!checkNode.isDisabled());
        String string = checkNode.getToolTip();
        if (string != null) {
            this.setToolTipText("<html>" + checkNode.getToolTip() + "</html>");
        }
        if (this.stringDisplayer.getBackground() == null) {
            this.stringDisplayer.setBackground(jTree.getBackground());
        }
        if (this.stringDisplayer.getForeground() == null) {
            this.stringDisplayer.setForeground(jTree.getForeground());
        }
        if (this.check != null) {
            this.check.setSelected(checkNode.isSelected());
            this.check.setEnabled(!checkNode.isDisabled());
        }
        return this;
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.check == null ? new Dimension(0, 0) : this.check.getSize();
        Dimension dimension2 = this.stringDisplayer == null ? new Dimension(0, 0) : this.stringDisplayer.getPreferredSize();
        boolean bl = false;
        int n = 0;
        if (dimension.height >= dimension2.height) {
            n = (dimension.height - dimension2.height) / 2;
        }
        if (this.check != null) {
            this.check.setBounds(0, 0, dimension.width, dimension.height);
            this.check.paint(graphics);
        }
        if (this.stringDisplayer != null) {
            int n2 = n - 2;
            this.stringDisplayer.setBounds(dimension.width, n2, dimension2.width, this.getHeight() - 1);
            graphics.translate(dimension.width, n);
            this.stringDisplayer.paint(graphics);
            graphics.translate(-dimension.width, -n);
        }
    }

    private String getNodeText(CheckNode checkNode) {
        int n;
        String string = checkNode.getLabel() == null ? NbBundle.getMessage(CheckRenderer.class, (String)"LBL_NotAvailable") : checkNode.getLabel();
        string = "<html>" + string;
        if (checkNode.needsRefresh()) {
            string = string + " - " + NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_NeedsRefresh");
        }
        if ((n = (string = string + "</html>").indexOf("<br>")) != -1) {
            return string.substring(0, n) + "</html>";
        }
        return string;
    }

    public Dimension getPreferredSize() {
        if (this.stringDisplayer != null) {
            this.stringDisplayer.setFont(this.getFont());
        }
        Dimension dimension = this.check == null ? null : this.check.getPreferredSize();
        dimension = dimension == null ? new Dimension(0, CheckRenderer.checkDim.height) : dimension;
        Dimension dimension2 = this.stringDisplayer == null ? null : this.stringDisplayer.getPreferredSize();
        dimension2 = dimension2 == null ? new Dimension(0, 0) : dimension2;
        return new Dimension(dimension.width + dimension2.width, dimension.height < dimension2.height ? dimension2.height : dimension.height);
    }

    public void doLayout() {
        Dimension dimension = this.check == null ? new Dimension(0, 0) : this.check.getPreferredSize();
        Dimension dimension2 = this.stringDisplayer == null ? new Dimension(0, 0) : this.stringDisplayer.getPreferredSize();
        int n = 0;
        int n2 = 0;
        if (dimension.height < dimension2.height) {
            n = (dimension2.height - dimension.height) / 2;
        } else {
            n2 = (dimension.height - dimension2.height) / 2;
        }
        if (this.check != null) {
            this.check.setLocation(0, n);
            this.check.setBounds(0, n, dimension.width, dimension.height);
            if (checkBounds == null) {
                checkBounds = this.check.getBounds();
            }
        }
    }

    public static Rectangle getCheckBoxRectangle() {
        return (Rectangle)checkBounds.clone();
    }

    static {
        Dimension dimension = new JCheckBox().getPreferredSize();
        checkDim = new Dimension(dimension.width, dimension.height - 5);
    }
}

