/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.common.gtk;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.soa.mapper.common.gtk.BasicCanvasController;
import org.netbeans.modules.soa.mapper.common.gtk.DefaultCanvasPalette;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvas;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasController;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasModel;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasObjectFactory;
import org.netbeans.modules.soa.mapper.common.gtk.PaletteButton;
import org.netbeans.modules.soa.mapper.common.util.SbynStrings;
import org.netbeans.modules.soa.mapper.common.util.SbynSwingUtil;

public class BasicGrapher {
    private static final String DEFAULT_CANVAS_FACTORY = "com.stc.egate.gui.common.gtk.jgo.JGoCanvasObjectFactory";
    protected static HashMap mConfigData = new HashMap();
    protected static ICanvasObjectFactory mFactory = null;
    private static final Logger mTheLogger = Logger.getLogger(BasicGrapher.class.getName());
    protected HashMap mClassNameToIconMap = new HashMap();
    protected HashMap mClassNameToButtonMap = new HashMap();
    protected JComponent mTop = this.createTopComponent();
    protected ICanvasModel mModel = null;
    protected ICanvas mCanvas = null;
    protected DefaultCanvasPalette mPalette = null;
    protected BasicCanvasController mController = null;

    public BasicGrapher(String string) {
        this.mModel = this.createModel();
        this.mCanvas = this.createCanvas();
        if (this.mModel != null) {
            this.mCanvas.setModel(this.mModel);
        }
        this.mPalette = this.createPalette();
        this.initLayout();
        this.mController = this.createController();
    }

    public BasicGrapher(BasicGrapher basicGrapher) {
        this.mModel = basicGrapher.getModel();
        this.mCanvas = this.createCanvas();
        if (this.mModel != null) {
            this.mCanvas.setModel(this.mModel);
        }
        this.mPalette = this.createPalette();
        this.initLayout();
        this.mController = this.createController();
    }

    protected void initLayout() {
        this.mTop.setLayout(new BorderLayout());
        if (this.mPalette != null) {
            this.mTop.add((Component)this.mPalette, "North");
        }
        if (this.mCanvas.getUIComponent() != null) {
            this.mTop.add(this.mCanvas.getUIComponent(), "Center");
        }
    }

    protected JComponent createTopComponent() {
        return new JPanel();
    }

    protected DefaultCanvasPalette createPalette() {
        return new DefaultCanvasPalette();
    }

    protected ICanvasModel createModel() {
        return mFactory.createCanvasModel(null);
    }

    protected ICanvas createCanvas() {
        return mFactory.createCanvas(null);
    }

    protected BasicCanvasController createController() {
        return new BasicCanvasController(this.mCanvas);
    }

    public JComponent getTopComponent() {
        return this.mTop;
    }

    protected ICanvas getCanvas() {
        return this.mCanvas;
    }

    protected ICanvasModel getModel() {
        return this.mModel;
    }

    public void setCanvasController(ICanvasController iCanvasController) {
        this.mCanvas.setCanvasController(iCanvasController);
        iCanvasController.setCanvas(this.mCanvas);
    }

    public void initPalette(String string, String string2) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
        List list = this.createButtons(resourceBundle, string2);
        this.mPalette.addButtons(list);
    }

    protected List createButtons(ResourceBundle resourceBundle, String string) {
        ArrayList<List> arrayList = new ArrayList<List>();
        String string2 = this.getLocalizedString(resourceBundle, string);
        String[] stringArray = SbynStrings.tokenize(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(this.createButton(resourceBundle, stringArray[i]));
        }
        return arrayList;
    }

    protected String getLocalizedString(ResourceBundle resourceBundle, String string) {
        String string2 = "";
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            mTheLogger.log(Level.SEVERE, missingResourceException.getMessage(), missingResourceException);
        }
        return string2;
    }

    protected List createButton(ResourceBundle resourceBundle, String string) {
        Object object;
        mTheLogger.finest("Creating button " + string);
        String string2 = "PALETTE_BUTTON." + string;
        String string3 = this.getLocalizedString(resourceBundle, string2 + ".withRuleIcon");
        String string4 = this.getLocalizedString(resourceBundle, string2 + ".icon");
        Icon icon = SbynSwingUtil.getIcon(string4);
        String string5 = this.getLocalizedString(resourceBundle, string2 + ".toolTip");
        String string6 = this.getLocalizedString(resourceBundle, string2 + ".draggable");
        String string7 = this.getLocalizedString(resourceBundle, string2 + ".defaultName");
        String string8 = this.getLocalizedString(resourceBundle, string2 + ".componentClassName");
        String string9 = this.getLocalizedString(resourceBundle, string2 + ".actionListener");
        String string10 = this.getLocalizedString(resourceBundle, string2 + ".mouseListener");
        String string11 = this.getLocalizedString(resourceBundle, string2 + ".isGroup");
        String string12 = this.getLocalizedString(resourceBundle, string2 + ".labelIcon");
        String[] stringArray = SbynStrings.tokenize(this.getLocalizedString(resourceBundle, string2 + ".margin"), ",");
        String string13 = this.getLocalizedString(resourceBundle, string2 + ".componentPopup");
        String string14 = this.getLocalizedString(resourceBundle, string2 + ".canvasNodeAction");
        String string15 = this.getLocalizedString(resourceBundle, string2 + ".controlNode");
        String string16 = this.getLocalizedString(resourceBundle, string2 + ".controlNodeJComponent");
        String string17 = this.getLocalizedString(resourceBundle, string2 + ".key");
        Insets insets = null;
        if (stringArray.length == 4) {
            insets = new Insets(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
        }
        String[] stringArray2 = SbynStrings.tokenize(this.getLocalizedString(resourceBundle, string2 + ".upperMargin"), ",");
        String[] stringArray3 = SbynStrings.tokenize(this.getLocalizedString(resourceBundle, string2 + ".lowerMargin"), ",");
        Component component = null;
        Component component2 = null;
        int n = 0;
        int n2 = 0;
        if (stringArray2.length == 2) {
            n = Integer.parseInt(stringArray2[0]);
            n2 = Integer.parseInt(stringArray2[1]);
            component = Box.createRigidArea(new Dimension(n, n2));
        }
        if (stringArray3.length == 2) {
            n = Integer.parseInt(stringArray3[0]);
            n2 = Integer.parseInt(stringArray3[1]);
            component2 = Box.createRigidArea(new Dimension(n, n2));
        }
        this.mClassNameToIconMap.put(string8, icon);
        boolean bl = Boolean.valueOf(string6);
        PaletteButton paletteButton = new PaletteButton(icon, insets, string5);
        this.mClassNameToButtonMap.put(string8, paletteButton);
        paletteButton.setDraggable(bl);
        paletteButton.addData("defaultName", string7);
        paletteButton.addData("componentClassName", string8);
        paletteButton.addData("isGroup", string11);
        paletteButton.addData("icon", string4);
        paletteButton.addData("labelIcon", string12);
        paletteButton.addData("componentPopup", string13);
        String string18 = this.getLocalizedString(resourceBundle, string2 + ".componentAuxPopup");
        paletteButton.addData("componentAuxPopup", string18);
        paletteButton.addData("canvasNodeAction", string14);
        paletteButton.addData("controlNode", string15);
        paletteButton.addData("controlNodeJComponent", string16);
        paletteButton.addData("key", string17);
        if (string3 != null && string3.length() > 0) {
            object = SbynSwingUtil.getIcon(string3);
            paletteButton.addData("withRuleIcon", object);
        }
        object = new ArrayList();
        if (component != null) {
            object.add(component);
        }
        object.add(paletteButton);
        if (component2 != null) {
            object.add(component2);
        }
        return object;
    }

    protected Icon getIcon(String string) {
        return (Icon)this.mClassNameToIconMap.get(string);
    }

    protected void addNode(String string, String string2, Dimension dimension, Point point) {
        this.mCanvas.createCanvasNode(point, dimension, this.getIcon(string), string2);
    }

    static {
        try {
            Class<?> clazz = Class.forName(DEFAULT_CANVAS_FACTORY);
            Method method = clazz.getMethod("getInstance", null);
            mFactory = (ICanvasObjectFactory)method.invoke(clazz, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

