/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.palette;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JToolBar;
import org.netbeans.modules.soa.mapper.basicmapper.palette.MenuCategory;
import org.netbeans.modules.soa.mapper.common.ui.palette.IPaletteCategory;

public class MenuGroup
extends JToolBar {
    MenuCategory mActiveMenu;

    public MenuGroup() {
        this.setFloatable(false);
        this.setBorder(null);
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    public void addMenu(MenuCategory menuCategory) {
        this.insertMenu(this.getComponentCount(), menuCategory);
    }

    public void insertMenu(int n, MenuCategory menuCategory) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        menuCategory.setGroup(this);
        this.add(menuCategory, gridBagConstraints, n);
    }

    private void initMenu(MenuCategory menuCategory) {
        menuCategory.setBorder(null);
    }

    public void removeMenu(int n) {
        this.remove(n);
    }

    public void removeMenu(MenuCategory menuCategory) {
        this.remove(menuCategory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuCategory getNextMenu(MenuCategory menuCategory) {
        Object object = this.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (component != menuCategory) continue;
                if (i == this.getComponentCount() - 1) {
                    return (MenuCategory)this.getComponent(0);
                }
                return (MenuCategory)this.getComponent(i + 1);
            }
        }
        throw new IllegalArgumentException("The menu specified is not in this group.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuCategory getPreviousMenu(MenuCategory menuCategory) {
        Object object = this.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (component != menuCategory) continue;
                if (i == 0) {
                    return (MenuCategory)this.getComponent(this.getComponentCount() - 1);
                }
                return (MenuCategory)this.getComponent(i - 1);
            }
        }
        throw new IllegalArgumentException("The menu specified is not in this group.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuCategory findMenu(IPaletteCategory iPaletteCategory) {
        Object object = this.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof MenuCategory) || ((MenuCategory)component).getPaletteCategory() != iPaletteCategory) continue;
                return (MenuCategory)component;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        super.setEnabled(bl);
        Object object = this.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                component.setEnabled(bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveMenu(MenuCategory menuCategory) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.mActiveMenu != menuCategory && this.mActiveMenu != null && menuCategory != null) {
                this.mActiveMenu.hideButtonMenu();
            }
            this.mActiveMenu = menuCategory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuCategory getActiveMenu() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.mActiveMenu;
        }
    }
}

