/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.literal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapperLiteralUpdateEventInfo;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.IMapperCanvasView;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasMethoidNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralEditor;
import org.netbeans.modules.soa.mapper.common.basicmapper.literal.ILiteralUpdater;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoid;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;
import org.openide.windows.WindowManager;

public abstract class AbstractLiteralEditor
extends JWindow
implements ILiteralEditor {
    protected IMethoidNode mMethoidNode;
    protected IFieldNode mFieldNode;
    protected ICanvasFieldNode mCanvasFieldNode;
    protected ICanvasMethoidNode mCanvasMethoidNode;
    protected boolean isIgnoringFocusLostUpdate = false;
    protected ILiteralUpdater mUpdateListener;
    private ComponentListener mComponentListener;
    private boolean mClosed = false;
    private IBasicMapper mBasicMapper;
    private JComponent mEditorComponent;
    protected boolean mIsLiteralMethoid = false;

    public AbstractLiteralEditor(Window window, IBasicMapper iBasicMapper, IFieldNode iFieldNode, ILiteralUpdater iLiteralUpdater) {
        super(window);
        this.mBasicMapper = iBasicMapper;
        this.mFieldNode = iFieldNode;
        this.mUpdateListener = iLiteralUpdater;
        this.mMethoidNode = (IMethoidNode)iFieldNode.getGroupNode();
        IMethoid iMethoid = (IMethoid)this.mMethoidNode.getMethoidObject();
        this.mIsLiteralMethoid = iMethoid.isLiteral();
        IMapperCanvasView iMapperCanvasView = this.mBasicMapper.getMapperViewManager().getCanvasView();
        this.mCanvasMethoidNode = iMapperCanvasView.getCanvas().findCanvasMethoidNode(this.mMethoidNode);
        this.mCanvasFieldNode = iMapperCanvasView.getCanvas().findCanvasFieldNode(this.mFieldNode);
        Rectangle rectangle = this.mCanvasFieldNode.getBounding();
        Point point = iMapperCanvasView.getCanvasComponent().getLocationOnScreen();
        Point point2 = new Point(rectangle.x, rectangle.y);
        iMapperCanvasView.getCanvas().convertDocToView(point2);
        point2.x += point.x + 1;
        point2.y += point.y + 1;
        this.setBackground(iMapperCanvasView.getViewComponent().getBackground());
        JPanel jPanel = new JPanel();
        jPanel.setBackground(iMapperCanvasView.getViewComponent().getBackground());
        jPanel.setLayout(new BorderLayout());
        this.setContentPane(jPanel);
        this.setLocation(point2);
        this.setSize(this.getInitialSize());
        this.initWindowListeners();
    }

    public void show() {
        super.show();
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AbstractLiteralEditor.this.toFront();
                        AbstractLiteralEditor.this.mEditorComponent.requestFocus();
                        AbstractLiteralEditor.this.mEditorComponent.addFocusListener(new FocusListener(){

                            public void focusGained(FocusEvent focusEvent) {
                            }

                            public void focusLost(FocusEvent focusEvent) {
                                if (!AbstractLiteralEditor.this.isIgnoringFocusLostUpdate) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            if (!AbstractLiteralEditor.this.isIgnoringFocusLostUpdate) {
                                                AbstractLiteralEditor.this.diposeAndUpdateLiteral();
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
        }).start();
    }

    protected final boolean isClosed() {
        return this.mClosed;
    }

    private void disposeMe() {
        this.setVisible(false);
        this.mClosed = true;
        WindowManager.getDefault().getMainWindow().removeComponentListener(this.mComponentListener);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractLiteralEditor.this.dispose();
            }
        });
    }

    public final void dispose() {
        super.dispose();
    }

    private void initWindowListeners() {
        this.mComponentListener = new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
                AbstractLiteralEditor.this.isIgnoringFocusLostUpdate = true;
                AbstractLiteralEditor.this.diposeAndUpdateLiteral();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                AbstractLiteralEditor.this.isIgnoringFocusLostUpdate = true;
                AbstractLiteralEditor.this.diposeAndUpdateLiteral();
            }

            public void componentResized(ComponentEvent componentEvent) {
                AbstractLiteralEditor.this.isIgnoringFocusLostUpdate = true;
                AbstractLiteralEditor.this.diposeAndUpdateLiteral();
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        };
        WindowManager.getDefault().getMainWindow().addComponentListener(this.mComponentListener);
    }

    protected void initializeLiteralComponent(IMapperCanvasView iMapperCanvasView, JComponent jComponent, JComponent jComponent2) {
        this.mEditorComponent = jComponent2;
        Color color = iMapperCanvasView.getViewComponent().getBackground();
        jComponent2.setBorder(null);
        jComponent.setBackground(color);
        jComponent2.setBackground(color);
        jComponent2.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "escape");
        jComponent2.getActionMap().put("escape", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractLiteralEditor.this.isIgnoringFocusLostUpdate = true;
                AbstractLiteralEditor.this.disposeMe();
            }
        });
        jComponent2.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "return");
        jComponent2.getActionMap().put("return", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractLiteralEditor.this.commitEdit();
            }
        });
    }

    protected void diposeAndUpdateLiteral() {
        this.disposeMe();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string = AbstractLiteralEditor.this.updateLiteral();
                if (string != null) {
                    AbstractLiteralEditor.this.fireLiteralUpdated(string);
                }
                IMapperCanvasView iMapperCanvasView = AbstractLiteralEditor.this.mBasicMapper.getMapperViewManager().getCanvasView();
                iMapperCanvasView.getCanvasComponent().requestFocus();
            }
        });
    }

    protected abstract Dimension getInitialSize();

    protected abstract String updateLiteral();

    protected void commitEdit() {
        this.isIgnoringFocusLostUpdate = true;
        this.diposeAndUpdateLiteral();
    }

    public ILiteralUpdater getUpdateListener() {
        return this.mUpdateListener;
    }

    private void fireLiteralUpdated(final String string) {
        Object object = this.mMethoidNode.getNodeObject();
        final IMethoid iMethoid = (IMethoid)this.mMethoidNode.getMethoidObject();
        this.mBasicMapper.updateFieldLiteral(new IBasicMapperLiteralUpdateEventInfo(){

            public ILiteralUpdater getLiteralUpdater() {
                return AbstractLiteralEditor.this.mUpdateListener;
            }

            public IMethoidNode getMethoidNode() {
                return AbstractLiteralEditor.this.mMethoidNode;
            }

            public IFieldNode getFieldNode() {
                return AbstractLiteralEditor.this.mFieldNode;
            }

            public String getNewValue() {
                return string;
            }

            public boolean isLiteralMethoid() {
                return iMethoid.isLiteral();
            }
        });
    }
}

