/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoSelection;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.AbstractCanvasMethoidNode;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasFieldNode;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasView;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicTitleBarUI;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.NetworkHighlightTraverser;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.util.AccessibleArea;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.util.GradientRectangle;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasNode;

public class BasicCanvasMethoidNode
extends AbstractCanvasMethoidNode {
    private Logger mLogger = Logger.getLogger(BasicCanvasMethoidNode.class.getName());
    private JGoRectangle mBorderRect;
    private int mFixedHeight;
    private int mFixedWidth;
    private BasicTitleBarUI mTitleBar;

    public BasicCanvasMethoidNode(IMethoidNode iMethoidNode) {
        super(iMethoidNode);
        this.mTitleBar = new BasicTitleBarUI(iMethoidNode.getMethoidName(), ((ImageIcon)iMethoidNode.getIcon()).getImage());
        this.mTitleBar.setSelectable(false);
        this.mTitleBar.setDraggable(false);
        this.mTitleBar.setResizable(false);
        this.mTitleBar.setSelectable(false);
        this.mTitleBar.resizeToMinimum();
        this.addObjectAtTail((JGoObject)this.mTitleBar);
        this.setSelectable(true);
        this.setDraggable(true);
        this.setResizable(false);
        this.setSelectable(true);
        this.setPickableBackground(true);
        this.mBorderRect = new GradientRectangle(this);
        this.mBorderRect.setSelectable(false);
        this.mBorderRect.setDraggable(false);
        this.mBorderRect.setResizable(false);
        this.addObjectAtHead((JGoObject)this.mBorderRect);
        super.expand();
        iMethoidNode.addPropertyChangeListener(new MethoidPropertyListener());
    }

    public boolean isInButton(Point point) {
        return this.mTitleBar.isInButton(point);
    }

    public void addNode(ICanvasNode iCanvasNode) {
        super.addNode(iCanvasNode);
        this.configNewChild(iCanvasNode);
    }

    public void insertNode(ICanvasNode iCanvasNode, int n) {
        super.insertNode(iCanvasNode, n);
        this.configNewChild(iCanvasNode);
    }

    public ICanvasNode collapse() {
        super.collapse();
        this.layoutChildren();
        this.changeAreaSize();
        this.mTitleBar.collapse();
        return this;
    }

    public ICanvasNode expand() {
        super.expand();
        this.layoutChildren();
        this.changeAreaSize();
        this.mTitleBar.expand();
        return this;
    }

    public void removeNode(ICanvasNode iCanvasNode) {
        super.removeNode(iCanvasNode);
        if (iCanvasNode instanceof JGoObject) {
            this.removeObject((JGoObject)iCanvasNode);
        }
        if (iCanvasNode instanceof ICanvasFieldNode) {
            ICanvasFieldNode iCanvasFieldNode = (ICanvasFieldNode)iCanvasNode;
            iCanvasFieldNode.getFieldNode().setGroupNode(null);
            Object object = iCanvasFieldNode.getConnectPointObject();
            if (object instanceof JGoObject) {
                this.removeObject((JGoObject)object);
            }
        }
    }

    protected void geometryChange(Rectangle rectangle) {
        if (rectangle.width == this.getWidth() && rectangle.height == this.getHeight()) {
            super.geometryChange(rectangle);
        } else {
            this.ensureBounding();
        }
        this.updatePortBounds();
    }

    private void updatePortBounds() {
        JGoListPosition jGoListPosition = this.getFirstObjectPos();
        while (jGoListPosition != null) {
            JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
            jGoListPosition = this.getNextObjectPos(jGoListPosition);
            if (jGoObject instanceof AccessibleArea && ((AccessibleArea)jGoObject).isBoundingRectInvalid() || !(jGoObject instanceof BasicCanvasFieldNode)) continue;
            ((BasicCanvasFieldNode)jGoObject).layoutPorts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layoutChildren() {
        List list = this.getModifiableNodeList();
        BasicTitleBarUI basicTitleBarUI = this.mTitleBar;
        JGoObject jGoObject = null;
        List list2 = list;
        synchronized (list2) {
            for (int i = 0; i < list.size(); ++i) {
                jGoObject = (JGoObject)list.get(i);
                if (this.isExpanded()) {
                    jGoObject.setSpotLocation(1, (JGoObject)basicTitleBarUI, 7);
                    jGoObject.setLocation(jGoObject.getLeft(), jGoObject.getTop() + 1);
                    jGoObject.setVisible(true);
                } else {
                    jGoObject.setSpotLocation(1, (JGoObject)basicTitleBarUI, 1);
                    jGoObject.setVisible(false);
                }
                if (jGoObject instanceof BasicCanvasFieldNode) {
                    BasicCanvasFieldNode basicCanvasFieldNode = (BasicCanvasFieldNode)jGoObject;
                    JGoPort jGoPort = (JGoPort)basicCanvasFieldNode.getConnectPointObject();
                    jGoPort.setSpotLocation(1, jGoObject, 1);
                }
                basicTitleBarUI = jGoObject;
            }
        }
    }

    public void changeAreaSize() {
        if (this.isExpanded()) {
            this.setBoundingRect(this.getLeft(), this.getTop(), this.mFixedWidth, this.mFixedHeight * (this.getModifiableNodeList().size() + 1));
        } else {
            this.setBoundingRect(this.getLeft(), this.getTop(), this.mFixedWidth, this.mFixedHeight);
        }
        Rectangle rectangle = this.computeBoundingRectWithoutPorts();
        this.mBorderRect.setBoundingRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle computeBoundingRectWithoutPorts() {
        Rectangle rectangle = null;
        JGoListPosition jGoListPosition = this.getFirstObjectPos();
        while (jGoListPosition != null) {
            JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
            jGoListPosition = this.getNextObjectPos(jGoListPosition);
            if (!(jGoObject instanceof AccessibleArea) || ((AccessibleArea)jGoObject).isBoundingRectInvalid()) continue;
            if (rectangle == null) {
                Rectangle rectangle2 = jGoObject.getBoundingRect();
                rectangle = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                continue;
            }
            rectangle.add(jGoObject.getBoundingRect());
        }
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureBounding() {
        boolean bl;
        int n;
        List list = this.getModifiableNodeList();
        int n2 = this.mTitleBar.getWidth();
        int n3 = this.mTitleBar.getHeight();
        JGoObject jGoObject = null;
        List list2 = list;
        synchronized (list2) {
            for (n = 0; n < list.size(); ++n) {
                jGoObject = (JGoObject)list.get(n);
                n2 = Math.max(n2, jGoObject.getWidth());
                n3 = Math.max(n3, jGoObject.getHeight());
            }
        }
        boolean bl2 = bl = n2 != this.mFixedWidth || n3 != this.mFixedHeight;
        if (bl) {
            this.mFixedWidth = n2;
            this.mFixedHeight = n3;
            this.mTitleBar.setSize(this.mFixedWidth, this.mFixedHeight);
            for (n = 0; n < list.size(); ++n) {
                jGoObject = (JGoObject)list.get(n);
                jGoObject.setSize(this.mFixedWidth, this.mFixedHeight);
            }
            this.layoutChildren();
            this.changeAreaSize();
        }
    }

    private void configNewChild(ICanvasNode iCanvasNode) {
        if (iCanvasNode instanceof JGoObject) {
            JGoObject jGoObject = (JGoObject)iCanvasNode;
            jGoObject.setSelectable(false);
            jGoObject.setDraggable(false);
            jGoObject.setResizable(false);
            jGoObject.setVisible(false);
            if (jGoObject instanceof JGoArea) {
                ((JGoArea)jGoObject).setSelectable(false);
            }
            this.addObjectAtTail(jGoObject);
            JGoPort jGoPort = null;
            if (iCanvasNode instanceof ICanvasFieldNode) {
                ICanvasFieldNode iCanvasFieldNode = (ICanvasFieldNode)iCanvasNode;
                iCanvasFieldNode.setContainer(this);
                jGoPort = (JGoPort)iCanvasFieldNode.getConnectPointObject();
                jGoPort.setVisible(false);
                this.bringObjectToFront((JGoObject)jGoPort);
            }
            if (jGoObject.getWidth() > this.mFixedWidth || jGoObject.getHeight() > this.mFixedHeight) {
                this.ensureBounding();
            } else {
                jGoObject.setBoundingRect(this.mTitleBar.getBoundingRect());
                this.layoutChildren();
                this.changeAreaSize();
            }
        }
    }

    public String getToolTipText(Point point) {
        JGoObject jGoObject = (JGoObject)this.getFieldNodeByPoint(point);
        if (jGoObject != null) {
            return jGoObject.getToolTipText();
        }
        if (this.mTitleBar.getBoundingRect().contains(point)) {
            return this.getMethoidNode().getToolTipText();
        }
        return null;
    }

    public void setTitle(String string) {
        this.mTitleBar.setTitle(string);
        this.ensureBounding();
    }

    public String getTitle() {
        return this.mTitleBar.getTitle();
    }

    public void setIcon(Icon icon) {
        this.mTitleBar.setTitleIcon(((ImageIcon)icon).getImage());
        this.ensureBounding();
    }

    public void setTitleBarColor(Color color) {
        this.mTitleBar.setTitleBarBackground(color);
    }

    public void resetTitleBarColor() {
        this.mTitleBar.resetTitleBarBackground();
    }

    public Color getTitleBarColor() {
        return this.mTitleBar.getTitleBarBackground();
    }

    protected void gainedSelection(JGoSelection jGoSelection) {
        super.gainedSelection(jGoSelection);
        if (this.getMapperCanvas().isPathHighlightingEnabled()) {
            new NetworkHighlightTraverser(true).visit(this);
        }
    }

    protected void lostSelection(JGoSelection jGoSelection) {
        super.lostSelection(jGoSelection);
        if (this.getMapperCanvas().isPathHighlightingEnabled()) {
            new NetworkHighlightTraverser(false).visit(this);
        }
    }

    private class MethoidPropertyListener
    implements PropertyChangeListener {
        private MethoidPropertyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("MapperGN.InsertNode")) {
                int n = 0;
                IMapperNode iMapperNode = BasicCanvasMethoidNode.this.getMethoidNode().getFirstNode();
                while (iMapperNode != null) {
                    if (iMapperNode == propertyChangeEvent.getNewValue()) {
                        ICanvasFieldNode iCanvasFieldNode = ((BasicCanvasView)BasicCanvasMethoidNode.this.getCanvas()).getCanvasObjectFactory().createFieldNode((IFieldNode)propertyChangeEvent.getNewValue());
                        BasicCanvasMethoidNode.this.insertNode(iCanvasFieldNode, n);
                        break;
                    }
                    ++n;
                    iMapperNode = BasicCanvasMethoidNode.this.getMethoidNode().getNextNode(iMapperNode);
                }
            } else if (propertyChangeEvent.getPropertyName().equals("MapperGN.RemoveNode")) {
                List list;
                List list2 = list = BasicCanvasMethoidNode.this.getModifiableNodeList();
                synchronized (list2) {
                    for (int i = 0; i < list.size(); ++i) {
                        ICanvasFieldNode iCanvasFieldNode = (ICanvasFieldNode)list.get(i);
                        if (iCanvasFieldNode.getFieldNode() != propertyChangeEvent.getOldValue()) continue;
                        BasicCanvasMethoidNode.this.removeNode(iCanvasFieldNode);
                        break;
                    }
                }
            } else if (propertyChangeEvent.getPropertyName().equals("MethoidNode.Name")) {
                BasicCanvasMethoidNode.this.setName(BasicCanvasMethoidNode.this.mMethoidNode.getMethoidName());
            } else if (!propertyChangeEvent.getPropertyName().equals("MethoidNode.ToolTip")) {
                if (propertyChangeEvent.getPropertyName().equals("MethoidNode.Icon")) {
                    BasicCanvasMethoidNode.this.setIcon(BasicCanvasMethoidNode.this.mMethoidNode.getIcon());
                } else if (propertyChangeEvent.getPropertyName().equals("MethoidNode.MethoidObject")) {
                    BasicCanvasMethoidNode.this.setName(BasicCanvasMethoidNode.this.mMethoidNode.getMethoidName());
                    BasicCanvasMethoidNode.this.setIcon(BasicCanvasMethoidNode.this.mMethoidNode.getIcon());
                    BasicCanvasMethoidNode.this.setTitle(BasicCanvasMethoidNode.this.mMethoidNode.getMethoidName());
                }
            }
        }
    }
}

