/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.text.Position;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.plugins.CsmRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmRenameRefactoringPlugin
extends CsmRefactoringPlugin {
    private final CsmObject startReferenceObject;
    private Collection overriddenByMethods = null;
    private Collection overridesMethods = null;
    private boolean doCheckName = true;
    private Collection<CsmObject> referencedObjects;
    private final RenameRefactoring refactoring;

    public CsmRenameRefactoringPlugin(RenameRefactoring renameRefactoring) {
        this.refactoring = renameRefactoring;
        this.startReferenceObject = (CsmObject)this.refactoring.getRefactoringSource().lookup(CsmObject.class);
        assert (this.startReferenceObject != null) : "no start reference";
    }

    private static final String getCannotRename(FileObject fileObject) {
        return new MessageFormat(NbBundle.getMessage(CsmRenameRefactoringPlugin.class, (String)"ERR_CannotRenameFile")).format(new Object[]{fileObject.getNameExt()});
    }

    @Override
    public Problem fastCheckParameters() {
        Problem problem = null;
        String string = this.refactoring.getNewName();
        String string2 = CsmRefactoringUtils.getSimpleText(this.startReferenceObject);
        if (string2.equals(string)) {
            problem = CsmRenameRefactoringPlugin.createProblem(problem, true, CsmRenameRefactoringPlugin.getString("ERR_NameNotChanged"));
            return problem;
        }
        if (!Utilities.isJavaIdentifier((String)string)) {
            String string3 = CsmRenameRefactoringPlugin.getString("ERR_InvalidIdentifier");
            String string4 = new MessageFormat(string3).format(new Object[]{string});
            problem = CsmRenameRefactoringPlugin.createProblem(problem, true, string4);
            return problem;
        }
        return problem;
    }

    @Override
    public Problem checkParameters() {
        return this.fastCheckParameters();
    }

    @Override
    public Problem preCheck() {
        Problem problem = null;
        this.fireProgressListenerStart(1, 5);
        if (this.referencedObjects == null) {
            this.initReferencedObjects(this.startReferenceObject);
            this.fireProgressListenerStep();
        }
        if ((problem = this.isResovledElement(this.startReferenceObject)) != null) {
            return problem;
        }
        CsmObject csmObject = CsmRefactoringUtils.getReferencedElement(this.startReferenceObject);
        problem = this.checkRenameInFile(problem, csmObject);
        this.fireProgressListenerStep();
        if (problem != null) {
            return problem;
        }
        if (CsmKindUtilities.isMethod((CsmObject)csmObject)) {
            Collection collection;
            this.fireProgressListenerStep();
            CsmMethod csmMethod = (CsmMethod)csmObject;
            if (CsmVirtualInfoQuery.getDefault().isVirtual(csmMethod) && (collection = CsmVirtualInfoQuery.getDefault().getOverridenMethods(csmMethod, true)).size() > 1) {
                Object object2;
                for (Object object2 : collection) {
                    problem = this.checkRenameInFile(problem, (CsmObject)object2);
                    CsmFunctionDefinition csmFunctionDefinition = object2.getDefinition();
                    if (csmFunctionDefinition == null || object2.equals(csmFunctionDefinition)) continue;
                    problem = this.checkRenameInFile(problem, (CsmObject)csmFunctionDefinition);
                }
                boolean bl = problem != null;
                object2 = bl ? CsmRenameRefactoringPlugin.getString("ERR_Overrides_Fatal") : CsmRenameRefactoringPlugin.getString("ERR_OverridesOrOverriden");
                problem = CsmRenameRefactoringPlugin.createProblem(problem, bl, (String)object2);
            }
        } else {
            this.fireProgressListenerStep();
        }
        this.fireProgressListenerStop();
        return problem;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (this.referencedObjects == null || this.referencedObjects.size() == 0) {
            return null;
        }
        HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
        CsmFile csmFile = this.getCsmFile(this.startReferenceObject);
        for (CsmObject csmObject : this.referencedObjects) {
            Collection<CsmProject> collection = CsmRefactoringUtils.getRelatedCsmProjects(csmObject, true);
            CsmProject[] csmProjectArray = collection.toArray(new CsmProject[collection.size()]);
            this.refactoring.getContext().add((Object)csmProjectArray);
            hashSet.addAll(this.getRelevantFiles(csmFile, csmObject, (AbstractRefactoring)this.refactoring));
        }
        this.fireProgressListenerStart(1, hashSet.size());
        this.createAndAddElements(hashSet, refactoringElementsBag, (AbstractRefactoring)this.refactoring);
        this.fireProgressListenerStop();
        return null;
    }

    @Override
    protected ModificationResult processFiles(Collection<CsmFile> collection) {
        ModificationResult modificationResult = null;
        for (CsmFile csmFile : collection) {
            if (this.cancelRequest) {
                return null;
            }
            if (modificationResult == null) {
                modificationResult = new ModificationResult(csmFile.getProject());
            }
            this.processFile(csmFile, modificationResult);
            this.fireProgressListenerStep();
        }
        return modificationResult;
    }

    private static final String getString(String string) {
        return NbBundle.getMessage(CsmRenameRefactoringPlugin.class, (String)string);
    }

    private Problem checkRenameInFile(Problem problem, CsmObject csmObject) {
        FileObject fileObject;
        if (CsmKindUtilities.isOffsetable((Object)csmObject) && (fileObject = CsmUtilities.getFileObject((CsmFile)((CsmOffsetable)csmObject).getContainingFile())) != null && (FileUtil.getArchiveFile((FileObject)fileObject) != null || !fileObject.canWrite())) {
            problem = CsmRenameRefactoringPlugin.createProblem(problem, true, CsmRenameRefactoringPlugin.getCannotRename(fileObject));
        }
        return problem;
    }

    private void initReferencedObjects(CsmObject csmObject) {
        CsmObject csmObject2 = CsmRefactoringUtils.getReferencedElement(csmObject);
        if (csmObject2 != null) {
            this.referencedObjects = new LinkedHashSet<CsmObject>();
            if (CsmKindUtilities.isClass((CsmObject)csmObject2)) {
                this.referencedObjects.addAll(this.getRenamingClassObjects((CsmClass)csmObject2));
            } else if (CsmKindUtilities.isConstructor((CsmObject)csmObject2) || CsmKindUtilities.isDestructor((CsmObject)csmObject2)) {
                CsmFunction csmFunction = (CsmFunction)csmObject2;
                CsmClass csmClass = CsmBaseUtilities.getFunctionClass((CsmFunction)csmFunction);
                if (csmClass != null) {
                    this.referencedObjects.addAll(this.getRenamingClassObjects(csmClass));
                }
            } else if (CsmKindUtilities.isMethod((CsmObject)csmObject2)) {
                CsmMethod csmMethod = (CsmMethod)csmObject2;
                this.referencedObjects.add((CsmObject)csmMethod);
                if (CsmVirtualInfoQuery.getDefault().isVirtual(csmMethod)) {
                    this.referencedObjects.addAll(CsmVirtualInfoQuery.getDefault().getOverridenMethods(csmMethod, true));
                    assert (!this.referencedObjects.isEmpty()) : "must be at least start object " + csmMethod;
                }
            } else {
                this.referencedObjects.add(csmObject2);
            }
        }
    }

    private Collection<? extends CsmObject> getRenamingClassObjects(CsmClass csmClass) {
        ArrayList<Object> arrayList = new ArrayList<Object>(5);
        if (csmClass != null) {
            arrayList.add(csmClass);
            for (CsmMember csmMember : csmClass.getMembers()) {
                if (CsmKindUtilities.isConstructor((CsmObject)csmMember)) {
                    arrayList.add(csmMember);
                    continue;
                }
                if (!CsmKindUtilities.isDestructor((CsmObject)csmMember)) continue;
                arrayList.add(csmMember);
            }
        }
        return arrayList;
    }

    private void processFile(CsmFile csmFile, ModificationResult modificationResult) {
        Object object;
        assert (this.referencedObjects != null && this.referencedObjects.size() > 0) : "method must be called for resolved element";
        FileObject fileObject = CsmUtilities.getFileObject((CsmFile)csmFile);
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (CsmObject csmObject : this.referencedObjects) {
            object = CsmReferenceRepository.getDefault().getReferences(csmObject, csmFile, CsmReferenceKind.ALL);
            linkedHashSet.addAll(object);
        }
        if (linkedHashSet.size() > 0) {
            CsmObject csmObject;
            ArrayList arrayList = new ArrayList(linkedHashSet);
            Collections.sort(arrayList, new Comparator<CsmReference>(){

                @Override
                public int compare(CsmReference csmReference, CsmReference csmReference2) {
                    return csmReference.getStartOffset() - csmReference2.getStartOffset();
                }
            });
            csmObject = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
            object = this.refactoring.getNewName();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                CsmReference csmReference = (CsmReference)iterator.next();
                String string = ((Object)csmReference.getText()).toString();
                String string2 = this.getDescription(csmReference, string);
                ModificationResult.Difference difference = this.rename(csmReference, (CloneableEditorSupport)csmObject, string, (String)object, string2);
                assert (difference != null);
                modificationResult.addDifference(fileObject, difference);
            }
        }
    }

    private String getDescription(CsmReference csmReference, String string) {
        String string2 = NbBundle.getMessage(CsmRenameRefactoringPlugin.class, (String)"UpdateRef", (Object)string);
        return string2;
    }

    private ModificationResult.Difference rename(CsmReference csmReference, CloneableEditorSupport cloneableEditorSupport, String string, String string2, String string3) {
        if (string == null) {
            string = ((Object)csmReference.getText()).toString();
        }
        if (string2 == null) {
            string2 = this.refactoring.getNewName();
        }
        assert (string != null);
        assert (string2 != null);
        PositionRef positionRef = cloneableEditorSupport.createPositionRef(csmReference.getStartOffset(), Position.Bias.Forward);
        PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(csmReference.getEndOffset(), Position.Bias.Backward);
        ModificationResult.Difference difference = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, (CsmObject)csmReference, positionRef, positionRef2, string, string2, string3);
        return difference;
    }
}

