/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionProgress;
import org.netbeans.modules.php.dbgp.StartActionProviderImpl;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpResponse;
import org.netbeans.modules.php.dbgp.packets.Reason;
import org.netbeans.modules.php.dbgp.packets.StackGetCommand;
import org.netbeans.modules.php.dbgp.packets.Status;
import org.netbeans.modules.php.dbgp.packets.StopCommand;
import org.w3c.dom.Node;

public class StatusResponse
extends DbgpResponse {
    private static final String REASON = "reason";
    private static final String STATUS = "status";

    StatusResponse(Node node) {
        super(node);
    }

    public Status getStatus() {
        String string = StatusResponse.getAttribute(this.getNode(), STATUS);
        return Status.forString(string);
    }

    public Reason getReason() {
        String string = StatusResponse.getAttribute(this.getNode(), REASON);
        return Reason.forString(string);
    }

    public void process(DebugSession debugSession, DbgpCommand dbgpCommand) {
        if (this.getStatus() == Status.BREAK && this.getReason() == Reason.OK) {
            StackGetCommand stackGetCommand = new StackGetCommand(debugSession.getTransactionId());
            debugSession.sendCommandLater(stackGetCommand);
            debugSession.getBridge().setSuspended(true);
            debugSession.getBridge().getThreadsModel().updateSession(debugSession);
        } else if ((this.getStatus() == Status.STOPPING || this.getStatus() == Status.STOPPED) && this.getReason() == Reason.OK) {
            StopCommand stopCommand = new StopCommand(debugSession.getTransactionId());
            debugSession.sendCommandLater(stopCommand);
            debugSession.stop();
            if (debugSession.getOptions().isDebugForFirstPageOnly()) {
                SessionProgress sessionProgress = SessionProgress.forSessionId(debugSession.getSessionId());
                if (sessionProgress != null) {
                    sessionProgress.cancel();
                }
            } else {
                StartActionProviderImpl.getInstance().start(debugSession);
            }
        }
    }
}

