/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.dbgp.ConversionUtils;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.StartActionProviderImpl;
import org.netbeans.modules.php.dbgp.models.ViewModelSupport;
import org.netbeans.modules.php.dbgp.packets.StatusCommand;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ThreadsModel
extends ViewModelSupport
implements TreeModel,
NodeModel,
NodeActionsProvider,
TableModel {
    private static final String RUNNING_STATE = "LBL_Running";
    private static final String SUSPENDED_STATE = "LBL_Suspended";
    private static final String INACTIVE_THREAD_STATE = "LBL_InactiveThreadState";
    private static final String ACTIVE_THREAD_STATE = "LBL_ActiveThreadState";
    private static final String THREAD_NAME = "LBL_ThreadName";
    public static final String CURRENT = "org/netbeans/modules/debugger/resources/threadsView/CurrentThread";
    public static final String RUNNING = "org/netbeans/modules/debugger/resources/threadsView/RunningThread";
    public static final String SUSPENDED = "org/netbeans/modules/debugger/resources/threadsView/SuspendedThread";
    private ContextProvider myProvider;

    public ThreadsModel(ContextProvider contextProvider) {
        this.myProvider = contextProvider;
    }

    public void clearModel() {
        this.update();
    }

    public Object getRoot() {
        return "Root";
    }

    public void update() {
        this.refresh();
    }

    public void updateSession(DebugSession debugSession) {
        this.updateThreadState(debugSession);
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            int n3;
            SessionId sessionId = this.getSessionId();
            if (sessionId == null) {
                return new Object[0];
            }
            DebugSession debugSession = ConversionUtils.toDebugSession(sessionId);
            int n4 = n3 = debugSession != null ? 1 : 0;
            if (n >= n3) {
                return new Object[0];
            }
            int n5 = Math.min(n2, n3);
            if (n == 0 && n2 == n3) {
                Object[] objectArray;
                if (debugSession != null) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = debugSession;
                } else {
                    objectArray = new Object[]{};
                }
                return objectArray;
            }
            ArrayList<DebugSession> arrayList = new ArrayList<DebugSession>();
            if (debugSession != null) {
                arrayList.add(debugSession);
            }
            List list = arrayList.subList(n, n5);
            return list.toArray(new Object[list.size()]);
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof DebugSession) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            SessionId sessionId = this.getSessionId();
            if (sessionId == null) {
                return 0;
            }
            return StartActionProviderImpl.getInstance().getSessions(sessionId).size();
        }
        throw new UnknownTypeException(object);
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object instanceof DebugSession) {
            DebugSession debugSession = (DebugSession)object;
            String string = this.getScriptName(debugSession);
            return NbBundle.getMessage(ThreadsModel.class, (String)THREAD_NAME, (Object)string);
        }
        if (object == "Root") {
            return "Root".toString();
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof DebugSession) {
            DebugSession debugSession = (DebugSession)object;
            if (debugSession.getBridge().isSuspended()) {
                return SUSPENDED;
            }
            if (this.isCurrent(debugSession)) {
                return CURRENT;
            }
            return RUNNING;
        }
        if (object == "Root") {
            return null;
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return null;
        }
        if (object instanceof DebugSession) {
            return ((DebugSession)object).getFileName();
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object instanceof DebugSession) {
            DebugSession debugSession = (DebugSession)object;
            SessionId sessionId = this.getSessionId();
            if (sessionId == null) {
                return;
            }
            DebugSession debugSession2 = StartActionProviderImpl.getInstance().getCurrentSession(sessionId);
            if (!debugSession.equals(debugSession2)) {
                Session session = this.getSession();
                StartActionProviderImpl.getInstance().setCurrentSession(session, debugSession);
                StatusCommand statusCommand = new StatusCommand(debugSession.getTransactionId());
                debugSession.sendCommandLater(statusCommand);
                this.updateThreadState(debugSession2);
                this.updateThreadState(debugSession);
            }
        }
        throw new UnknownTypeException(object);
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        return new Action[0];
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object == "Root") {
            return null;
        }
        if (object instanceof DebugSession) {
            DebugSession debugSession = (DebugSession)object;
            if (string == "ThreadSuspended") {
                return debugSession.getBridge().isSuspended();
            }
            if (string == "ThreadState") {
                String string2 = this.isCurrent(debugSession) ? ACTIVE_THREAD_STATE : INACTIVE_THREAD_STATE;
                String string3 = debugSession.getBridge().isSuspended() ? SUSPENDED_STATE : RUNNING_STATE;
                String string4 = NbBundle.getMessage(ThreadsModel.class, (String)string2, (Object)NbBundle.getMessage(ThreadsModel.class, (String)string3));
                return string4;
            }
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object == "Root" || object instanceof DebugSession) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        throw new UnknownTypeException(object);
    }

    private void updateThreadState(DebugSession debugSession) {
        this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)debugSession));
    }

    private String getScriptName(DebugSession debugSession) {
        SessionId sessionId = debugSession.getSessionId();
        if (sessionId == null) {
            return "";
        }
        String string = debugSession.getFileName();
        FileObject fileObject = sessionId.getFileObjectByRemote(string);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        return FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)fileObject);
    }

    private Session getSession() {
        return (Session)this.getContextProvider().lookupFirst(null, Session.class);
    }

    private SessionId getSessionId() {
        ContextProvider contextProvider = this.getContextProvider();
        if (contextProvider == null) {
            return null;
        }
        return (SessionId)contextProvider.lookupFirst(null, SessionId.class);
    }

    private ContextProvider getContextProvider() {
        return this.myProvider;
    }

    private boolean isCurrent(DebugSession debugSession) {
        SessionId sessionId = this.getSessionId();
        DebugSession debugSession2 = StartActionProviderImpl.getInstance().getCurrentSession(sessionId);
        return debugSession.equals(debugSession2);
    }
}

