/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.util.EventListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

public class LineBreakpoint
extends AbstractBreakpoint {
    private Line myLine;
    private FileRemoveListener myListener;
    private FileChangeListener myWeakListener;

    public LineBreakpoint(Line line) {
        this.myLine = line;
        this.myListener = new FileRemoveListener();
        FileObject fileObject = (FileObject)line.getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            this.myWeakListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this.myListener), (Object)fileObject);
            fileObject.addFileChangeListener(this.myWeakListener);
        }
    }

    public final void setValid(String string) {
        this.setValidity(Breakpoint.VALIDITY.VALID, string);
    }

    public final void setInvalid(String string) {
        this.setValidity(Breakpoint.VALIDITY.INVALID, string);
    }

    public Line getLine() {
        return this.myLine;
    }

    public int isTemp() {
        return 0;
    }

    public boolean isSessionRelated(DebugSession debugSession) {
        SessionId sessionId = debugSession.getSessionId();
        if (sessionId == null) {
            return false;
        }
        Project project = sessionId.getProject();
        if (project == null) {
            return false;
        }
        return project.equals(this.getProject());
    }

    public void removed() {
        FileObject fileObject = (FileObject)this.getLine().getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            fileObject.removeFileChangeListener(this.myWeakListener);
        }
    }

    private Project getProject() {
        Line line = this.getLine();
        if (line == null) {
            return null;
        }
        FileObject fileObject = (FileObject)line.getLookup().lookup(FileObject.class);
        if (fileObject == null) {
            return null;
        }
        return FileOwnerQuery.getOwner((FileObject)fileObject);
    }

    private class FileRemoveListener
    extends FileChangeAdapter {
        private FileRemoveListener() {
        }

        public void fileDeleted(FileEvent fileEvent) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)LineBreakpoint.this);
        }
    }
}

