/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.io.IOException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.php.dbgp.ConversionUtils;
import org.netbeans.modules.php.dbgp.DbgpEngineProvider;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.DebuggerOptions;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.packets.StatusCommand;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartActionProviderImpl {
    private static final String LOCALHOST = "localhost";
    private static final int PORT_RANGE = 100;
    private static final int TIMEOUT = 60000;
    private static final String PORT_OCCUPIED = "MSG_PortOccupied";
    private ServerThread myThread;
    private Set<DebugSession> mySessions = new HashSet<DebugSession>();
    private Map<Session, DebugSession> myCurrentSessions = new WeakHashMap<Session, DebugSession>();
    private static final StartActionProviderImpl INSTANCE = new StartActionProviderImpl();

    private StartActionProviderImpl() {
    }

    public static StartActionProviderImpl getInstance() {
        return INSTANCE;
    }

    public synchronized Semaphore start(DebugSession debugSession) {
        int n = debugSession.getOptions().getPort();
        this.myThread = new ServerThread(n, debugSession.getSessionId());
        RequestProcessor.getDefault().post((Runnable)this.myThread);
        return this.myThread.getSemaphore();
    }

    public synchronized DebugSession getSessionById(String string) {
        for (DebugSession debugSession : this.mySessions) {
            String string2;
            SessionId sessionId = debugSession.getSessionId();
            if (sessionId == null || !string.equals(string2 = sessionId.getId())) continue;
            return debugSession;
        }
        return null;
    }

    public synchronized DebugSession getCurrentSession(SessionId sessionId) {
        if (sessionId == null) {
            return null;
        }
        return ConversionUtils.toDebugSession(sessionId);
    }

    public synchronized Collection<DebugSession> getSessions(SessionId sessionId) {
        LinkedList<DebugSession> linkedList = new LinkedList<DebugSession>();
        for (DebugSession debugSession : this.mySessions) {
            if (!sessionId.equals(debugSession.getSessionId())) continue;
            linkedList.add(debugSession);
        }
        return linkedList;
    }

    public synchronized void stop(Session session) {
        SessionId sessionId = (SessionId)session.lookupFirst(null, SessionId.class);
        ArrayList<DebugSession> arrayList = new ArrayList<DebugSession>(this.mySessions);
        for (DebugSession debugSession : arrayList) {
            if (debugSession.getSessionId() != sessionId) continue;
            debugSession.stop();
            this.mySessions.remove(debugSession);
        }
        Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
        boolean bl = true;
        for (Session session2 : sessionArray) {
            if (session2.equals(session) || session2.lookupFirst(null, SessionId.class) == null) continue;
            bl = false;
        }
        if (bl) {
            this.myThread.stop();
        }
        this.stopEngines(session);
    }

    public synchronized void setCurrentSession(Session session, DebugSession debugSession) {
        this.myCurrentSessions.put(session, debugSession);
    }

    synchronized void attachDebugSession(Session session, DebugSession debugSession) {
        this.myCurrentSessions.put(session, debugSession);
        debugSession.getBridge().hideAnnotations();
        debugSession.getBridge().setSuspended(false);
        debugSession.getBridge().getThreadsModel().update();
    }

    synchronized void removeSession(DebugSession debugSession) {
        Collection<DebugSession> collection;
        Session session = (Session)debugSession.getBridge().getEngine().lookupFirst(null, Session.class);
        SessionId sessionId = debugSession.getSessionId();
        this.mySessions.remove(debugSession);
        if (sessionId != null && (collection = this.getSessions(sessionId)).size() > 0) {
            DebugSession debugSession2 = collection.iterator().next();
            this.setCurrentSession(session, debugSession2);
            StatusCommand statusCommand = new StatusCommand(debugSession2.getTransactionId());
            debugSession2.sendCommandLater(statusCommand);
        }
    }

    private synchronized void setupCurrentSession(DebugSession debugSession) {
        this.mySessions.add(debugSession);
    }

    private void stopEngines(Session session) {
        String[] stringArray;
        for (String string : stringArray = session.getSupportedLanguages()) {
            DebuggerEngine debuggerEngine = session.getEngineForLanguage(string);
            ((DbgpEngineProvider)((Object)debuggerEngine.lookupFirst(null, DebuggerEngineProvider.class))).getDestructor().killEngine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int findFreePort() {
        int n;
        for (int i = n = DebuggerOptions.getGlobalInstance().getPort(); i < n + 100; ++i) {
            Socket socket = null;
            try {
                socket = new Socket(LOCALHOST, i);
                this.closeTestSocket(socket);
                continue;
            }
            catch (ConnectException connectException) {
                int n2 = i;
                this.closeTestSocket(socket);
                return n2;
            }
            catch (IOException iOException) {
                this.closeTestSocket(socket);
                continue;
                {
                    catch (Throwable throwable) {
                        this.closeTestSocket(socket);
                        throw throwable;
                    }
                }
            }
        }
        return -1;
    }

    private void closeTestSocket(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class ServerThread
    implements Runnable {
        private Semaphore accepting;
        private int myPort;
        private ServerSocket myServer;
        private AtomicBoolean isStopped;
        private SessionId sessionId;

        ServerThread(int n, SessionId sessionId) {
            this.sessionId = sessionId;
            this.myPort = n;
            this.isStopped = new AtomicBoolean(false);
            this.accepting = new Semaphore(1);
            this.setAcceptingState(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!this.createServer()) {
                return;
            }
            while (!this.isStopped()) {
                Socket socket = null;
                try {
                    this.setAcceptingState(true);
                    socket = this.myServer.accept();
                }
                catch (SocketException socketException) {
                    this.logInforamtion(socketException);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (IOException iOException) {
                    this.log(iOException);
                }
                finally {
                    this.setAcceptingState(false);
                }
                if (this.isStopped.get() || socket == null) continue;
                DebugSession debugSession = (DebugSession)DebuggerManager.getDebuggerManager().getCurrentEngine().lookupFirst(null, DebugSession.class);
                assert (debugSession != null);
                debugSession.start(socket);
                StartActionProviderImpl.this.setupCurrentSession(debugSession);
                break;
            }
            this.closeSocket();
        }

        private void log(Exception exception) {
            Logger.getLogger(StartActionProviderImpl.class.getName()).log(Level.FINE, null, exception);
        }

        private void logInforamtion(SocketException socketException) {
            Logger.getLogger(StartActionProviderImpl.class.getName()).log(Level.FINE, null, socketException);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean createServer() {
            StartActionProviderImpl startActionProviderImpl = StartActionProviderImpl.this;
            synchronized (startActionProviderImpl) {
                try {
                    this.myServer = new ServerSocket(this.myPort);
                    this.myServer.setSoTimeout(60000);
                }
                catch (IOException iOException) {
                    String string = NbBundle.getMessage(StartActionProviderImpl.class, (String)StartActionProviderImpl.PORT_OCCUPIED);
                    string = MessageFormat.format(string, this.myPort);
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    this.log(iOException);
                    return false;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeSocket() {
            StartActionProviderImpl startActionProviderImpl = StartActionProviderImpl.this;
            synchronized (startActionProviderImpl) {
                if (this.myServer == null) {
                    return;
                }
                try {
                    if (!this.myServer.isClosed()) {
                        this.myServer.close();
                    }
                }
                catch (IOException iOException) {
                    this.log(iOException);
                }
            }
        }

        private void stop() {
            this.isStopped.set(true);
            this.closeSocket();
        }

        private boolean isStopped() {
            return this.isStopped.get();
        }

        private synchronized Semaphore getSemaphore() {
            return this.accepting;
        }

        private synchronized void setAcceptingState(boolean bl) {
            try {
                if (bl) {
                    this.getSemaphore().release();
                } else {
                    this.getSemaphore().acquire();
                }
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
        }
    }
}

